/*
 * Decompiled with CFR 0.152.
 */
package sum.kern;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import sum.kern.Bildschirm;
import sum.kern.Fenster;
import sum.kern.Schrift;

public class Stift {
    protected BasicStroke hatStroke;
    protected Bildschirm kenntPrivatschirm;
    protected static final int NORMALMODUS = 0;
    protected static final int RADIERMODUS = 1;
    protected static final int WECHSELMODUS = 2;
    protected double zStiftH = 0.0;
    protected double zStiftV = 0.0;
    protected boolean zHoch = true;
    protected double zWinkel = 0.0;
    protected int zSchreibModus = 0;

    public Stift() {
        this.kenntPrivatschirm = Bildschirm.hatPrivatschirm;
        this.hatStroke = new BasicStroke(1.0f, 0, 0);
        this.setzeStandard();
    }

    public Stift(Fenster pFenster) {
        this.kenntPrivatschirm = pFenster;
        this.hatStroke = new BasicStroke(1.0f, 0, 0);
        this.setzeStandard();
    }

    public void bewegeBis(double pH, double pV) {
        if (!this.zHoch) {
            this.zeichneLinie(pH, pV, this.zStiftH, this.zStiftV);
        }
        this.zStiftH = pH;
        this.zStiftV = pV;
    }

    public void bewegeUm(double pDistanz) {
        double w = this.zWinkel * Math.PI / 180.0;
        double x = this.zStiftH + pDistanz * Math.cos(w);
        double y = this.zStiftV - pDistanz * Math.sin(w);
        if (!this.zHoch) {
            this.zeichneLinie(this.zStiftH, this.zStiftV, x, y);
        }
        this.zStiftH = x;
        this.zStiftV = y;
    }

    public void dreheBis(double pWinkel) {
        this.zWinkel = pWinkel;
        while (this.zWinkel < 0.0) {
            this.zWinkel += 360.0;
        }
        while (this.zWinkel >= 720.0) {
            this.zWinkel -= 360.0;
        }
    }

    public void dreheZu(double pWohinH, double pWohinV) {
        if (pWohinH != this.zStiftH || pWohinV != this.zStiftV) {
            this.zWinkel = pWohinH == this.zStiftH ? (pWohinV > this.zStiftV ? 270.0 : 90.0) : (pWohinV == this.zStiftV ? (pWohinH > this.zStiftH ? 0.0 : 180.0) : (pWohinH > this.zStiftH ? Math.atan((pWohinV - this.zStiftV) / (this.zStiftH - pWohinH)) * 180.0 / Math.PI : Math.atan((pWohinV - this.zStiftV) / (this.zStiftH - pWohinH)) * 180.0 / Math.PI + 180.0));
        }
        while (this.zWinkel < 0.0) {
            this.zWinkel += 360.0;
        }
        while (this.zWinkel >= 720.0) {
            this.zWinkel -= 360.0;
        }
    }

    public void dreheUm(double pWinkel) {
        this.zWinkel += pWinkel;
        while (this.zWinkel < 0.0) {
            this.zWinkel += 360.0;
        }
        while (this.zWinkel >= 720.0) {
            this.zWinkel -= 360.0;
        }
    }

    public void schreibeText(String pText) {
        Graphics2D g = this.get2DGraphics(this.kenntPrivatschirm.g());
        if (g != null) {
            this.setzeZustand(g);
            g.drawString(pText, (float)this.zStiftH, (float)this.zStiftV);
            this.zStiftH += (double)g.getFontMetrics().stringWidth(pText);
        }
    }

    public void schreibeText(char pZeichen) {
        this.schreibeText("" + pZeichen);
    }

    public void schreibeZahl(int pZahl) {
        this.schreibeText("" + pZahl);
    }

    public void schreibeZahl(double pZahl) {
        this.schreibeText("" + pZahl);
    }

    public void hoch() {
        this.zHoch = true;
    }

    public void runter() {
        this.zHoch = false;
    }

    public boolean istUnten() {
        return !this.zHoch;
    }

    public void normal() {
        this.zSchreibModus = 0;
    }

    public void radiere() {
        this.zSchreibModus = 1;
    }

    public void wechsle() {
        this.zSchreibModus = 2;
    }

    public double hPosition() {
        return this.zStiftH;
    }

    public double vPosition() {
        return this.zStiftV;
    }

    public double winkel() {
        return this.zWinkel;
    }

    protected void zeichneLinie(double x1, double y1, double x2, double y2) {
        Graphics2D g = this.get2DGraphics(this.kenntPrivatschirm.g());
        if (g != null) {
            this.setzeZustand(g);
            g.draw(new Line2D.Double(x1, y1, x2, y2));
        }
    }

    public void zeichneRechteck(double pBreite, double pHoehe) {
        Graphics2D g = this.get2DGraphics(this.kenntPrivatschirm.g());
        if (g != null) {
            this.setzeZustand(g);
            g.draw(new Rectangle2D.Double(this.zStiftH, this.zStiftV, pBreite, pHoehe));
        }
    }

    public void zeichneKreis(double pRadius) {
        Graphics2D g = this.get2DGraphics(this.kenntPrivatschirm.g());
        if (g != null) {
            this.setzeZustand(g);
            g.draw(new Ellipse2D.Double(this.zStiftH - pRadius, this.zStiftV - pRadius, 2.0 * pRadius, 2.0 * pRadius));
        }
    }

    private void setzeStandard() {
        this.zStiftH = 0.0;
        this.zStiftV = 0.0;
        this.zHoch = true;
        this.zWinkel = 0.0;
        this.normal();
    }

    protected void setzeZustand(Graphics2D g) {
        if (this.zSchreibModus == 1) {
            g.setPaint(Bildschirm.hatPrivatschirm.hintergrundfarbe());
            g.setPaintMode();
        } else if (this.zSchreibModus == 0) {
            g.setPaint(Color.black);
            g.setPaintMode();
        } else {
            g.setPaint(Color.black);
            g.setXORMode(Bildschirm.hatPrivatschirm.hintergrundfarbe());
        }
        g.setFont(Schrift.STANDARDSCHRIFT);
    }

    protected Graphics2D get2DGraphics(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (g2d != null) {
            g2d.setStroke(this.hatStroke);
        }
        return g2d;
    }

    public void gibFrei() {
    }
}

