/*
 * Decompiled with CFR 0.152.
 */
package sum.multimedia;

import java.applet.Applet;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import quicktime.QTSession;
import quicktime.app.view.QTComponent;
import quicktime.app.view.QTFactory;
import quicktime.io.OpenMovieFile;
import quicktime.io.QTFile;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieController;
import quicktime.std.movies.media.DataRef;
import sum.ereignis.Bildschirm;

public class Film
extends Frame
implements Serializable {
    private Frame hatFrame = null;
    private Movie hatMovie;
    private MovieController hatController;
    private QTComponent hatQTC = null;
    private Applet kenntApplet;

    public Film(String pPfad) {
        this.ladeFilm(pPfad);
    }

    public Film(Applet pApplet) {
        this.kenntApplet = pApplet;
        this.ladeFilm();
    }

    public Film() {
        this.ladeFilm();
    }

    public boolean ladeFilm(String pPfad) {
        if (this.hatFrame == null) {
            this.hatFrame = new Frame("SuM-Film");
            this.hatFrame.addWindowListener(new FensterTester());
            try {
                QTSession.open();
            }
            catch (Exception e) {
                System.out.println(e.toString());
                System.exit(-9);
            }
        }
        try {
            if (this.kenntApplet == null) {
                DataRef urlMovie = new DataRef("file://" + pPfad);
                this.hatMovie = Movie.fromDataRef(urlMovie, 1);
            } else {
                QTFile qtf = new QTFile("file://" + pPfad);
                OpenMovieFile fis = OpenMovieFile.asRead(qtf);
                this.hatMovie = Movie.fromFile(fis);
            }
            this.hatController = new MovieController(this.hatMovie);
            if (this.hatQTC == null) {
                this.hatQTC = QTFactory.makeQTComponent(this.hatController);
                this.hatFrame.add(this.hatQTC.asComponent());
            } else {
                this.hatQTC.setMovieController(this.hatController);
            }
            this.hatFrame.pack();
            this.hatFrame.setVisible(true);
            this.hatQTC.asComponent().repaint();
            return true;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
    }

    public boolean ladeFilm() {
        FileDialog ladendialog = new FileDialog((Frame)Bildschirm.hatPrivatschirm, "Film laden", 0);
        ladendialog.setVisible(true);
        String dateiname = ladendialog.getFile();
        if (dateiname != null) {
            String pfadname = ladendialog.getDirectory();
            return this.ladeFilm(pfadname + dateiname);
        }
        return false;
    }

    private void schliessen() {
        QTSession.close();
        this.hatFrame.dispose();
        this.hatFrame = null;
        this.hatQTC = null;
        this.hatController = null;
        this.hatMovie = null;
    }

    public void gibFrei() {
    }

    private class FensterTester
    extends WindowAdapter {
        private FensterTester() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Film.this.schliessen();
        }
    }
}

