/*
 * Decompiled with CFR 0.152.
 */
package sum.multimedia;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RenderedImage;
import java.awt.image.ReplicateScaleFilter;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import sum.ereignis.Bildschirm;
import sum.ereignis.Ereignisanwendung;

public class Bild
extends JPanel
implements Serializable {
    private Image hatOriginal = null;
    private BufferedImage hatKopie = null;
    private String zGeklicktBearbeiter = "";
    private String zFokusErhaltenBearbeiter = "";
    private String zFokusVerlorenBearbeiter = "";
    private boolean zHatFocus = false;

    public Bild(double pLinks, double pOben, double pBreite, double pHoehe) {
        Bildschirm.hatPrivatschirm.privatPanel().add((Component)this, 0);
        this.setBackground(Color.black);
        this.addMouseListener(new BildReaktor());
        this.addKeyListener(new BildTastenReaktor());
        this.addFocusListener(new BildFokusReaktor());
        this.setzeGroesse(pBreite, pHoehe);
        this.setzePosition(pLinks, pOben);
        this.setOpaque(false);
        this.hatOriginal = new BufferedImage(new Double(pBreite).intValue(), new Double(pHoehe).intValue(), 2);
        this.bildPuffern();
        this.repaint();
    }

    public Bild(double pLinks, double pOben, double pBreite, double pHoehe, String pPfad) {
        Bildschirm.hatPrivatschirm.privatPanel().add((Component)this, 0);
        this.addMouseListener(new BildReaktor());
        this.addKeyListener(new BildTastenReaktor());
        this.addFocusListener(new BildFokusReaktor());
        this.setzeGroesse(pBreite, pHoehe);
        this.setzePosition(pLinks, pOben);
        this.ladeBild(pPfad);
        this.repaint();
    }

    public Bild(double pLinks, double pOben, double pBreite, double pHoehe, String pPfad, Applet pApplet) {
        Bildschirm.hatPrivatschirm.privatPanel().add((Component)this, 0);
        this.addMouseListener(new BildReaktor());
        this.addKeyListener(new BildTastenReaktor());
        this.addFocusListener(new BildFokusReaktor());
        this.ladeBild(pApplet, pPfad);
        this.setzeGroesse(pBreite, pHoehe);
        this.setzePosition(pLinks, pOben);
        this.repaint();
    }

    public Bild(double pLinks, double pOben, double pBreite, double pHoehe, Bild pBild) {
        Bildschirm.hatPrivatschirm.privatPanel().add((Component)this, 0);
        this.addMouseListener(new BildReaktor());
        this.addKeyListener(new BildTastenReaktor());
        this.addFocusListener(new BildFokusReaktor());
        this.setzeGroesse(pBreite, pHoehe);
        this.setzePosition(pLinks, pOben);
        this.hatOriginal = pBild.hatOriginal;
        this.bildPuffern();
        this.repaint();
    }

    public void setzeBearbeiterGeklickt(String pBearbeiter) {
        this.zGeklicktBearbeiter = pBearbeiter;
    }

    public void setzeBearbeiterFokusVerloren(String pBearbeiter) {
        this.zFokusVerlorenBearbeiter = pBearbeiter;
    }

    public void setzeBearbeiterFokusErhalten(String pBearbeiter) {
        this.zFokusErhaltenBearbeiter = pBearbeiter;
    }

    public boolean ladeBild(Applet pApplet, String pPfad) {
        MediaTracker mt = null;
        this.hatOriginal = pApplet.getImage(pApplet.getCodeBase(), pPfad);
        mt = new MediaTracker(Bildschirm.hatPrivatschirm);
        mt.addImage(this.hatOriginal, 0);
        try {
            mt.waitForAll();
            this.bildPuffern();
            return true;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
    }

    public boolean ladeBild(String pPfad) {
        MediaTracker mt = null;
        this.hatOriginal = Bildschirm.hatPrivatschirm.getToolkit().createImage(pPfad);
        mt = new MediaTracker(Bildschirm.hatPrivatschirm);
        mt.addImage(this.hatOriginal, 0);
        try {
            mt.waitForAll();
            this.bildPuffern();
            return true;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
    }

    public boolean ladeBild() {
        FileDialog ladendialog = new FileDialog((Frame)Bildschirm.hatPrivatschirm, "Bild laden", 0);
        ladendialog.setVisible(true);
        String dateiname = ladendialog.getFile();
        if (dateiname != null) {
            String pfadname = ladendialog.getDirectory();
            return this.ladeBild(pfadname + dateiname);
        }
        return false;
    }

    public boolean speichereBild(String pDatei) {
        File datei = new File(pDatei);
        try {
            ImageIO.write((RenderedImage)this.hatKopie, pDatei.substring(pDatei.length() - 3, pDatei.length()), datei);
            return true;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
    }

    public boolean speichereBild() {
        FileDialog speicherndialog = new FileDialog((Frame)Bildschirm.hatPrivatschirm, "Ton speichern", 1);
        speicherndialog.setVisible(true);
        String dateiname = speicherndialog.getFile();
        if (dateiname != null) {
            String pfadname = speicherndialog.getDirectory();
            return this.speichereBild(pfadname + dateiname);
        }
        return false;
    }

    public void setzeBild(Bild pBild) {
        this.hatOriginal = pBild.hatKopie;
        this.bildPuffern();
    }

    private void bildPuffern() {
        if (this.hatOriginal != null) {
            this.setSize(this.hatOriginal.getWidth(null), this.hatOriginal.getHeight(null));
            this.hatKopie = new BufferedImage(this.hatOriginal.getWidth(null), this.hatOriginal.getHeight(null), 2);
            Graphics2D graphics = this.hatKopie.createGraphics();
            graphics.drawImage(this.hatOriginal, 0, 0, this);
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.hatKopie != null) {
            ((Graphics2D)g).drawImage((Image)this.hatKopie, 0, 0, this);
        }
    }

    public void bildGeklickt() {
        Class[] formparas = new Class[1];
        Object[] meinBild = new Bild[1];
        if (this.zGeklicktBearbeiter.length() > 0) {
            try {
                Class<?> sumEreignis = Ereignisanwendung.hatSuMPrivateAnwendung.getClass();
                try {
                    Method methode = sumEreignis.getMethod(this.zGeklicktBearbeiter, null);
                    methode.invoke((Object)Ereignisanwendung.hatSuMPrivateAnwendung, null);
                }
                catch (InvocationTargetException e0) {
                    System.out.println("Fehler in Methode \"" + this.zGeklicktBearbeiter + "\" des Bilds: " + e0.getTargetException().toString());
                }
                catch (Exception e1) {
                    try {
                        formparas[0] = Bild.class;
                        Method methode = sumEreignis.getMethod(this.zGeklicktBearbeiter, formparas);
                        meinBild[0] = this;
                        methode.invoke((Object)Ereignisanwendung.hatSuMPrivateAnwendung, meinBild);
                    }
                    catch (InvocationTargetException e2) {
                        System.out.println("Fehler in Methode \"" + this.zGeklicktBearbeiter + "\" des Bilds: " + e2.getTargetException().toString());
                    }
                    catch (Exception e3) {
                        System.out.println("Fehler: Methode \"" + this.zGeklicktBearbeiter + "\" des Bilds nicht gefunden.");
                    }
                }
            }
            catch (Exception e4) {
                System.out.println("Bild: " + e4.toString());
            }
        }
    }

    public void bekommtFokus() {
        Class[] formparas = new Class[1];
        Object[] meinBild = new Bild[1];
        this.zHatFocus = true;
        if (this.zFokusErhaltenBearbeiter.length() > 0) {
            try {
                Class<?> sumEreignis = Ereignisanwendung.hatSuMPrivateAnwendung.getClass();
                try {
                    Method methode = sumEreignis.getMethod(this.zFokusErhaltenBearbeiter, null);
                    methode.invoke((Object)Ereignisanwendung.hatSuMPrivateAnwendung, null);
                }
                catch (InvocationTargetException e0) {
                    System.out.println("Fehler in Methode \"" + this.zFokusErhaltenBearbeiter + "\" des Bilds: " + e0.getTargetException().toString());
                }
                catch (Exception e1) {
                    try {
                        formparas[0] = Bild.class;
                        Method methode = sumEreignis.getMethod(this.zFokusErhaltenBearbeiter, formparas);
                        meinBild[0] = this;
                        methode.invoke((Object)Ereignisanwendung.hatSuMPrivateAnwendung, meinBild);
                    }
                    catch (InvocationTargetException e2) {
                        System.out.println("Fehler in Methode \"" + this.zFokusErhaltenBearbeiter + "\" des Bilds: " + e2.getTargetException().toString());
                    }
                    catch (Exception e3) {
                        System.out.println("Fehler: Methode \"" + this.zFokusErhaltenBearbeiter + "\" des Bilds nicht gefunden.");
                    }
                }
            }
            catch (Exception e4) {
                System.out.println("SuMAnwendung: " + e4.toString());
            }
        }
    }

    public void verliertFokus() {
        Class[] formparas = new Class[1];
        Object[] meinBild = new Bild[1];
        this.zHatFocus = false;
        if (this.zFokusVerlorenBearbeiter.length() > 0) {
            try {
                Class<?> sumEreignis = Ereignisanwendung.hatSuMPrivateAnwendung.getClass();
                try {
                    Method methode = sumEreignis.getMethod(this.zFokusVerlorenBearbeiter, null);
                    methode.invoke((Object)Ereignisanwendung.hatSuMPrivateAnwendung, null);
                }
                catch (InvocationTargetException e0) {
                    System.out.println("Fehler in Methode \"" + this.zFokusVerlorenBearbeiter + "\" des Bilds: " + e0.getTargetException().toString());
                }
                catch (Exception e1) {
                    try {
                        formparas[0] = Bild.class;
                        Method methode = sumEreignis.getMethod(this.zFokusVerlorenBearbeiter, formparas);
                        meinBild[0] = this;
                        methode.invoke((Object)Ereignisanwendung.hatSuMPrivateAnwendung, meinBild);
                    }
                    catch (InvocationTargetException e2) {
                        System.out.println("Fehler in Methode \"" + this.zFokusVerlorenBearbeiter + "\" des Bilds: " + e2.getTargetException().toString());
                    }
                    catch (Exception e3) {
                        System.out.println("Fehler: Methode \"" + this.zFokusVerlorenBearbeiter + "\" des Bilds nicht gefunden.");
                    }
                }
            }
            catch (Exception e4) {
                System.out.println("SuMAnwendung: " + e4.toString());
            }
        }
    }

    public void setzeGroesse(double pBreite, double pHoehe) {
        this.setSize((int)pBreite, (int)pHoehe);
        if (this.hatOriginal != null) {
            Image img;
            ReplicateScaleFilter groesseFilter = new ReplicateScaleFilter((int)pBreite, (int)pHoehe);
            FilteredImageSource imageprod = new FilteredImageSource(this.hatKopie.getSource(), groesseFilter);
            this.hatOriginal = img = this.createImage(imageprod);
            this.bildPuffern();
        }
    }

    public void setzePosition(double pWohinH, double pWohinV) {
        this.setLocation((int)pWohinH, (int)pWohinV);
        if (this.hatOriginal != null) {
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            Bildschirm.hatPrivatschirm.loescheAlles();
        }
    }

    public int links() {
        return this.getLocation().x;
    }

    public int oben() {
        return this.getLocation().y;
    }

    public int breite() {
        return this.getSize().width;
    }

    public int hoehe() {
        return this.getSize().height;
    }

    public void verstecke() {
        this.setVisible(false);
    }

    public void zeige() {
        this.setVisible(true);
    }

    public boolean istSichtbar() {
        return this.isVisible();
    }

    public void deaktiviere() {
        this.setEnabled(false);
    }

    public void aktiviere() {
        this.setEnabled(true);
    }

    public boolean istAktiv() {
        return this.isEnabled();
    }

    public boolean besitztFocus() {
        return this.zHatFocus;
    }

    public void setzeFocus() {
        this.requestFocus();
    }

    public void gibFrei() {
        Bildschirm.hatPrivatschirm.getLayeredPane().remove(this);
        Bildschirm.hatPrivatschirm.getLayeredPane().repaint();
    }

    public int rotanteil(int pH, int pV) {
        int rgba = this.hatKopie.getRGB(pH, pV);
        int rot = rgba >> 16 & 0xFF;
        return rot;
    }

    public int gruenanteil(int pH, int pV) {
        int rgba = this.hatKopie.getRGB(pH, pV);
        int gruen = rgba >> 8 & 0xFF;
        return gruen;
    }

    public int blauanteil(int pH, int pV) {
        int rgba = this.hatKopie.getRGB(pH, pV);
        int blau = rgba & 0xFF;
        return blau;
    }

    public int alphaanteil(int pH, int pV) {
        int rgba = this.hatKopie.getRGB(pH, pV);
        int alpha = rgba >> 24 & 0xFF;
        return alpha;
    }

    public void setzeRotanteil(int pH, int pV, int pRot) {
        int rgba = this.hatKopie.getRGB(pH, pV);
        int rot = pRot;
        int gruen = rgba >> 8 & 0xFF;
        int blau = rgba & 0xFF;
        int alpha = rgba >> 24 & 0xFF;
        rgba = alpha << 24 | rot << 16 | gruen << 8 | blau;
        this.hatKopie.setRGB(pH, pV, rgba);
    }

    public void setzeGruenanteil(int pH, int pV, int pGruen) {
        int rgba = this.hatKopie.getRGB(pH, pV);
        int gruen = pGruen;
        int rot = rgba >> 16 & 0xFF;
        gruen = pGruen;
        int blau = rgba & 0xFF;
        int alpha = rgba >> 24 & 0xFF;
        rgba = alpha << 24 | rot << 16 | gruen << 8 | blau;
        this.hatKopie.setRGB(pH, pV, rgba);
    }

    public void setzeBlauanteil(int pH, int pV, int pBlau) {
        int rgba = this.hatKopie.getRGB(pH, pV);
        int rot = rgba >> 16 & 0xFF;
        int gruen = rgba >> 8 & 0xFF;
        int blau = pBlau;
        int alpha = rgba >> 24 & 0xFF;
        rgba = alpha << 24 | rot << 16 | gruen << 8 | blau;
        this.hatKopie.setRGB(pH, pV, rgba);
    }

    public void setzeAlphaanteil(int pH, int pV, int pAlpha) {
        int rgba = this.hatKopie.getRGB(pH, pV);
        int rot = rgba >> 16 & 0xFF;
        int gruen = rgba >> 8 & 0xFF;
        int blau = rgba & 0xFF;
        int alpha = pAlpha;
        rgba = alpha << 24 | rot << 16 | gruen << 8 | blau;
        this.hatKopie.setRGB(pH, pV, rgba);
    }

    public void filter(ImageFilter pFilter) {
        Image img;
        FilteredImageSource imageprod = new FilteredImageSource(this.hatKopie.getSource(), pFilter);
        this.hatOriginal = img = this.createImage(imageprod);
        this.bildPuffern();
    }

    private class BildFokusReaktor
    implements FocusListener {
        private BildFokusReaktor() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Bild.this.bekommtFokus();
        }

        @Override
        public void focusLost(FocusEvent e) {
            Bild.this.verliertFokus();
        }
    }

    private class BildTastenReaktor
    implements KeyListener {
        private BildTastenReaktor() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                Bild.this.bildGeklickt();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private class BildReaktor
    extends MouseAdapter {
        private BildReaktor() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Bild.this.bildGeklickt();
        }
    }
}

