/*
 * Decompiled with CFR 0.152.
 */
package sum.generator;

import bluej.extensions.BPackage;
import bluej.extensions.BProject;
import bluej.extensions.BlueJ;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import sum.generator.KomponentenBeschreibung;
import sum.generator.KomponentenListe;
import sum.generator.KomponentenModell;
import sum.generator.SuMGeneratorAnwendung;
import sum.werkzeuge.Uhr;

public class Schreiber {
    public static final String METHODE = "//    Schreiben Sie hier den Text ihres Dienstes";
    public static final String A1 = "    ";
    public static final String A2 = "        ";
    public static final String A3 = "            ";
    public static final String K1 = "/**";
    public static final String K2 = " * ";
    public static final String K3 = " */";
    public static final String K4 = "//";
    public static final char N = '\n';
    private Uhr hatUhr;
    private BlueJ kenntBlueJ;
    private SuMGeneratorAnwendung kenntAnwendung;

    public Schreiber(BlueJ pBlueJ, SuMGeneratorAnwendung pAnwendung) {
        this.kenntBlueJ = pBlueJ;
        this.kenntAnwendung = pAnwendung;
        this.hatUhr = new Uhr();
    }

    public void schreibe(KomponentenListe pListe, File pVerzeichnis) {
        if (this.kenntBlueJ != null) {
            BProject blueJProject = this.kenntBlueJ.newProject(pVerzeichnis);
            this.schreibeXML(pListe, pVerzeichnis);
            this.schreibeSuMProgramm(pVerzeichnis);
            this.schreibeSuMApplet(pVerzeichnis);
            this.schreibeSuMAnwendung(pListe, pVerzeichnis);
            try {
                BPackage[] packageFeld = blueJProject.getPackages();
                BPackage blueJPackage = packageFeld[0];
                blueJPackage.reload();
            }
            catch (ProjectNotOpenException e) {
                System.out.println("Package-Problem: " + e.toString());
            }
            catch (PackageNotFoundException e) {
                System.out.println("Package-Problem: " + e.toString());
            }
        } else {
            pVerzeichnis.mkdir();
            this.schreibeXML(pListe, pVerzeichnis);
            this.schreibeSuMProgramm(pVerzeichnis);
            this.schreibeSuMApplet(pVerzeichnis);
            this.schreibeSuMAnwendung(pListe, pVerzeichnis);
        }
    }

    public void schreibeSuMProgramm(File pVerzeichnis) {
        FileWriter lFileWriter;
        try {
            lFileWriter = new FileWriter(new File(pVerzeichnis, "SuMProgramm.java"));
        }
        catch (IOException e) {
            throw new Error("Fehler: " + e.toString());
        }
        try {
            lFileWriter.write("public class SuMProgramm\n");
            lFileWriter.write("{\n");
            lFileWriter.write("    public static void main(String args[])\n");
            lFileWriter.write("    {\n");
            lFileWriter.write(A2 + this.kenntAnwendung.name() + " hat" + this.kenntAnwendung.name() + " = new " + this.kenntAnwendung.name() + "();" + '\n');
            lFileWriter.write("        hat" + this.kenntAnwendung.name() + ".fuehreAus();" + '\n');
            lFileWriter.write("    }\n\n");
            lFileWriter.write("}\n");
            lFileWriter.close();
        }
        catch (IOException e) {
            throw new Error("Fehler: " + e.toString());
        }
    }

    public void schreibeSuMApplet(File pVerzeichnis) {
        FileWriter lFileWriter;
        try {
            lFileWriter = new FileWriter(new File(pVerzeichnis, "SuMApplet.java"));
        }
        catch (IOException e) {
            throw new Error("Fehler: " + e.toString());
        }
        try {
            lFileWriter.write("import java.awt.*;\n");
            lFileWriter.write("import java.awt.event.*;\n");
            lFileWriter.write("import java.applet.Applet;\n\n");
            lFileWriter.write("public class SuMApplet extends Applet\n");
            lFileWriter.write("{\n");
            lFileWriter.write("    public SuMApplet()\n");
            lFileWriter.write("    {\n");
            lFileWriter.write(A2 + this.kenntAnwendung.name() + " hat" + this.kenntAnwendung.name() + " = new " + this.kenntAnwendung.name() + "();" + '\n');
            lFileWriter.write("        hat" + this.kenntAnwendung.name() + ".fuehreAus();" + '\n');
            lFileWriter.write("    }\n\n");
            lFileWriter.write("}\n");
            lFileWriter.close();
        }
        catch (IOException e) {
            throw new Error("Fehler: " + e.toString());
        }
    }

    public void schreibeSuMAnwendung(KomponentenListe pListe, File pVerzeichnis) {
        FileWriter lFileWriter;
        try {
            lFileWriter = new FileWriter(new File(pVerzeichnis, this.kenntAnwendung.name() + ".java"));
        }
        catch (IOException ex) {
            throw new Error("IO Error");
        }
        try {
            KomponentenModell lKomponente;
            int i;
            lFileWriter.write("/**\n");
            lFileWriter.write(" * Die Klasse " + this.kenntAnwendung.name() + " wurde automatisch erstellt: " + '\n');
            lFileWriter.write(" * \n");
            lFileWriter.write(" * @author \n");
            lFileWriter.write(" * @version " + this.hatUhr.datum() + '\n');
            lFileWriter.write(" */\n\n");
            lFileWriter.write("import sum.komponenten.*;\n");
            lFileWriter.write("import sum.werkzeuge.*;\n");
            lFileWriter.write("import sum.ereignis.*;\n\n");
            lFileWriter.write("public class " + this.kenntAnwendung.name() + " extends EBAnwendung" + '\n');
            lFileWriter.write("{\n");
            lFileWriter.write("    // Objekte\n");
            for (i = 0; i < pListe.groesse(); ++i) {
                lKomponente = pListe.komponenteAn(i);
                lFileWriter.write(lKomponente.objektText());
            }
            lFileWriter.write(10);
            lFileWriter.write("    // Attribute\n\n");
            lFileWriter.write(Schreiber.kommentarText("Konstruktor"));
            lFileWriter.write("    public " + this.kenntAnwendung.name() + "()" + '\n');
            lFileWriter.write("    {\n");
            lFileWriter.write("        //Initialisierung der Oberklasse\n");
            lFileWriter.write("        super(" + (this.kenntAnwendung.bildschirm().breite() - 185) + ", " + this.kenntAnwendung.bildschirm().hoehe() + ");" + '\n' + '\n');
            for (i = 0; i < pListe.groesse(); ++i) {
                lKomponente = pListe.komponenteAn(i);
                lFileWriter.write(lKomponente.initText());
            }
            lFileWriter.write("    }\n\n");
            for (i = 0; i < pListe.groesse(); ++i) {
                lKomponente = pListe.komponenteAn(i);
                lFileWriter.write(lKomponente.ereignisText());
            }
            lFileWriter.write("}\n");
            lFileWriter.close();
        }
        catch (IOException ex) {
            throw new Error("IO Error");
        }
    }

    public void schreibeXML(KomponentenListe pListe, File pVerzeichnis) {
        try {
            XStream lXStream = new XStream();
            ObjectOutputStream lEncoder = lXStream.createObjectOutputStream(new FileWriter(new File(pVerzeichnis, "SuMGenerator.xml")));
            Vector<Object> lListe = new Vector<Object>();
            lListe.addElement(this.kenntAnwendung.name());
            for (int i = 0; i < pListe.groesse(); ++i) {
                KomponentenModell lKomponente = pListe.komponenteAn(i);
                KomponentenBeschreibung lBeschreibung = new KomponentenBeschreibung(lKomponente);
                lListe.addElement(lBeschreibung);
            }
            lEncoder.writeObject(lListe);
            lEncoder.close();
        }
        catch (IOException ex) {
            throw new Error(ex.toString());
        }
    }

    public void lese(KomponentenListe pListe, File pDatei) {
        try {
            XStream lXStream = new XStream();
            ObjectInputStream lDecoder = lXStream.createObjectInputStream(new BufferedReader(new FileReader(pDatei)));
            Vector lListe = (Vector)lDecoder.readObject();
            this.kenntAnwendung.setzeName((String)lListe.firstElement());
            for (int i = 1; i < lListe.size(); ++i) {
                KomponentenBeschreibung lBeschreibung = (KomponentenBeschreibung)lListe.elementAt(i);
                KomponentenModell lKomponente = lBeschreibung.komponente();
                pListe.neueKomponente(lKomponente);
            }
            lDecoder.close();
        }
        catch (Exception ex) {
            throw new Error(ex.toString());
        }
    }

    public static String kommentarText(String pKommentar) {
        String lText = "/**\n * " + pKommentar + '\n' + K3 + '\n';
        return lText;
    }

    public static String methodenText(String pMethodenName) {
        String lText = "    public void " + pMethodenName + '\n' + A1 + "{" + '\n' + A2 + METHODE + '\n' + A1 + "}" + '\n' + '\n';
        return lText;
    }
}

