/*
 * Decompiled with CFR 0.152.
 */
package sum.ereignis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import sum.ereignis.Bildschirm;
import sum.ereignis.Schrift;

public class Stift {
    protected BasicStroke hatStroke = new BasicStroke(1.0f, 0, 0);
    protected static final int NORMALMODUS = 0;
    protected static final int RADIERMODUS = 1;
    protected static final int WECHSELMODUS = 2;
    protected double zStiftH = 0.0;
    protected double zStiftV = 0.0;
    protected boolean zHoch = true;
    protected double zWinkel = 0.0;
    protected int zSchreibModus = 0;

    public Stift() {
        this.setzeStandard();
    }

    public void bewegeBis(double d, double d2) {
        if (!this.zHoch) {
            this.zeichneLinie(d, d2, this.zStiftH, this.zStiftV);
        }
        this.zStiftH = d;
        this.zStiftV = d2;
    }

    public void bewegeUm(double d) {
        double d2 = this.zWinkel * Math.PI / 180.0;
        double d3 = this.zStiftH + d * Math.cos(d2);
        double d4 = this.zStiftV - d * Math.sin(d2);
        if (!this.zHoch) {
            this.zeichneLinie(this.zStiftH, this.zStiftV, d3, d4);
        }
        this.zStiftH = d3;
        this.zStiftV = d4;
    }

    public void dreheBis(double d) {
        this.zWinkel = d;
        while (this.zWinkel < 0.0) {
            this.zWinkel += 360.0;
        }
        while (this.zWinkel >= 720.0) {
            this.zWinkel -= 360.0;
        }
    }

    public void dreheZu(double d, double d2) {
        if (d != this.zStiftH || d2 != this.zStiftV) {
            this.zWinkel = d == this.zStiftH ? (d2 > this.zStiftV ? 270.0 : 90.0) : (d2 == this.zStiftV ? (d > this.zStiftH ? 0.0 : 180.0) : (d > this.zStiftH ? Math.atan((d2 - this.zStiftV) / (this.zStiftH - d)) * 180.0 / Math.PI : Math.atan((d2 - this.zStiftV) / (this.zStiftH - d)) * 180.0 / Math.PI + 180.0));
        }
        while (this.zWinkel < 0.0) {
            this.zWinkel += 360.0;
        }
        while (this.zWinkel >= 720.0) {
            this.zWinkel -= 360.0;
        }
    }

    public void dreheUm(double d) {
        this.zWinkel += d;
        while (this.zWinkel < 0.0) {
            this.zWinkel += 360.0;
        }
        while (this.zWinkel >= 720.0) {
            this.zWinkel -= 360.0;
        }
    }

    public void schreibeText(String string) {
        Graphics2D graphics2D = this.get2DGraphics(Bildschirm.hatPrivatPanel.getGraphics());
        this.setzeZustand(graphics2D);
        graphics2D.drawString(string, (int)this.zStiftH, (int)this.zStiftV);
        this.zStiftH += (double)graphics2D.getFontMetrics().stringWidth(string);
        Bildschirm.hatPrivatschirm.getToolkit().sync();
    }

    public void schreibeText(char c) {
        this.schreibeText(String.valueOf(c));
    }

    public void schreibeZahl(int n) {
        this.schreibeText(String.valueOf(n));
    }

    public void schreibeZahl(double d) {
        this.schreibeText(String.valueOf(d));
    }

    public void hoch() {
        this.zHoch = true;
    }

    public void runter() {
        this.zHoch = false;
    }

    public boolean istUnten() {
        return this.zHoch ^ true;
    }

    public void normal() {
        this.zSchreibModus = 0;
    }

    public void radiere() {
        this.zSchreibModus = 1;
    }

    public void wechsle() {
        this.zSchreibModus = 2;
    }

    public double hPosition() {
        return this.zStiftH;
    }

    public double vPosition() {
        return this.zStiftV;
    }

    public double winkel() {
        return this.zWinkel;
    }

    protected void zeichneLinie(double d, double d2, double d3, double d4) {
        Graphics2D graphics2D = this.get2DGraphics(Bildschirm.hatPrivatPanel.getGraphics());
        this.setzeZustand(graphics2D);
        graphics2D.draw(new Line2D.Double(d, d2, d3, d4));
        Bildschirm.hatPrivatschirm.getToolkit().sync();
    }

    public void zeichneRechteck(double d, double d2) {
        Graphics2D graphics2D = this.get2DGraphics(Bildschirm.hatPrivatPanel.getGraphics());
        this.setzeZustand(graphics2D);
        graphics2D.draw(new Rectangle2D.Double(this.zStiftH, this.zStiftV, d, d2));
        Bildschirm.hatPrivatschirm.getToolkit().sync();
    }

    public void zeichneKreis(double d) {
        Graphics2D graphics2D = this.get2DGraphics(Bildschirm.hatPrivatPanel.getGraphics());
        this.setzeZustand(graphics2D);
        graphics2D.draw(new Ellipse2D.Double(this.zStiftH - d, this.zStiftV - d, 2.0 * d, 2.0 * d));
        Bildschirm.hatPrivatschirm.getToolkit().sync();
    }

    private void setzeStandard() {
        this.zStiftH = 0.0;
        this.zStiftV = 0.0;
        this.zHoch = true;
        this.zWinkel = 0.0;
        this.normal();
    }

    protected void setzeZustand(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.zSchreibModus == 1) {
            graphics2D.setPaint(Bildschirm.hatPrivatschirm.hintergrundfarbe());
            graphics2D.setPaintMode();
        } else if (this.zSchreibModus == 0) {
            graphics2D.setPaint(Color.black);
            graphics2D.setPaintMode();
        } else {
            graphics2D.setPaint(Color.black);
            graphics2D.setXORMode(Bildschirm.hatPrivatschirm.hintergrundfarbe());
        }
        graphics2D.setFont(Schrift.STANDARDSCHRIFT);
    }

    protected Graphics2D get2DGraphics(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(this.hatStroke);
        return graphics2D;
    }

    public void gibFrei() {
    }
}

