/*
 * Decompiled with CFR 0.152.
 */
package sum.netz;

import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import sum.netz.Serververbindung;

public class Server
implements Serializable {
    private ServerSocket hatServerSocket;
    private Vector hatVerbindungen;
    private ServerSchleife hatSchleife;
    private boolean zMitNachrichten;
    private int zPort;
    private boolean zLaeuft;

    public Server(int pPortNr, boolean pTestModus) {
        try {
            this.hatServerSocket = new ServerSocket(pPortNr);
            this.zPort = pPortNr;
            this.zMitNachrichten = pTestModus;
            if (this.zMitNachrichten) {
                System.out.println("\u00d6ffne Server mit ServerSocket: " + this.hatServerSocket);
            }
            this.zLaeuft = true;
            this.hatVerbindungen = new Vector();
            this.hatSchleife = new ServerSchleife(this);
            this.hatSchleife.start();
        }
        catch (Exception fehler) {
            System.err.println("Fehler beim \u00d6ffnen der Server: " + fehler);
        }
    }

    public String toString() {
        return "Server von ServerSocket: " + this.hatServerSocket;
    }

    public void melde(String pMeldung) {
        System.out.println(pMeldung);
    }

    public int port() {
        return this.zPort;
    }

    public boolean mitProtokoll() {
        return this.zMitNachrichten;
    }

    protected Vector clientListe() {
        return this.hatVerbindungen;
    }

    public Serververbindung SerververbindungVonIP(String pClientIP) {
        for (int lNr = 0; lNr < this.hatVerbindungen.size(); ++lNr) {
            Serververbindung lSerververbindung = (Serververbindung)this.hatVerbindungen.elementAt(lNr);
            if (!lSerververbindung.partnerAdresse().equals(pClientIP)) continue;
            return lSerververbindung;
        }
        return null;
    }

    public Serververbindung SerververbindungVonIPUndPort(String pClientIP, int pPartnerPort) {
        for (int lNr = 0; lNr < this.hatVerbindungen.size(); ++lNr) {
            Serververbindung lSerververbindung = (Serververbindung)this.hatVerbindungen.elementAt(lNr);
            if (!lSerververbindung.partnerAdresse().equals(pClientIP) || lSerververbindung.partnerPort() != pPartnerPort) continue;
            return lSerververbindung;
        }
        return null;
    }

    public int zahlDerVerbindungen() {
        return this.hatVerbindungen.size();
    }

    public void sendeAnEinen(String pClientIP, String pText) {
        Serververbindung lSerververbindung = this.SerververbindungVonIP(pClientIP);
        if (lSerververbindung != null) {
            lSerververbindung.sende(pText);
        } else if (this.mitProtokoll()) {
            System.err.println("Fehler beim Senden: IP " + pClientIP + " nicht vorhanden.");
        }
    }

    public void sendeAnEinen(String pClientIP, int pPartnerPort, String pText) {
        Serververbindung lSerververbindung = this.SerververbindungVonIPUndPort(pClientIP, pPartnerPort);
        if (lSerververbindung != null) {
            lSerververbindung.sende(pText);
        } else if (this.mitProtokoll()) {
            System.err.println("Fehler beim Senden: IP " + pClientIP + " mit Port " + pPartnerPort + " nicht vorhanden.");
        }
    }

    public void sendeAnAlle(String pText) {
        for (int lNr = 0; lNr < this.hatVerbindungen.size(); ++lNr) {
            Serververbindung lSerververbindung = (Serververbindung)this.hatVerbindungen.elementAt(lNr);
            lSerververbindung.sende(pText);
        }
    }

    public void beendeVerbindung(String pClientIP) {
        if (this.SerververbindungVonIP(pClientIP) != null) {
            this.bearbeiteVerbindungsende(pClientIP);
        }
        this.schliesseVerbindung(pClientIP);
    }

    public void beendeVerbindung(String pClientIP, int pPartnerPort) {
        if (this.SerververbindungVonIPUndPort(pClientIP, pPartnerPort) != null) {
            this.bearbeiteVerbindungsende(pClientIP, pPartnerPort);
        }
        this.schliesseVerbindung(pClientIP, pPartnerPort);
    }

    protected void schliesseVerbindung(String pClientIP) {
        Serververbindung lSerververbindung = this.SerververbindungVonIP(pClientIP);
        if (lSerververbindung != null) {
            this.loescheVerbindung(lSerververbindung);
            lSerververbindung.gibFrei();
        } else if (this.mitProtokoll()) {
            System.err.println("Fehler beim Schlie\u00dfen der Verbindung: IP " + pClientIP + " nicht vorhanden.");
        }
    }

    protected void schliesseVerbindung(String pClientIP, int pPartnerPort) {
        Serververbindung lSerververbindung = this.SerververbindungVonIPUndPort(pClientIP, pPartnerPort);
        if (lSerververbindung != null) {
            this.loescheVerbindung(lSerververbindung);
            lSerververbindung.gibFrei();
        } else if (this.mitProtokoll()) {
            System.err.println("Fehler beim Schlie\u00dfen der Verbindung: IP " + pClientIP + " mit Port " + pPartnerPort + " nicht vorhanden.");
        }
    }

    protected void loescheVerbindung(Serververbindung pVerbindung) {
        for (int lNr = 0; lNr < this.hatVerbindungen.size(); ++lNr) {
            Serververbindung lSerververbindung = (Serververbindung)this.hatVerbindungen.elementAt(lNr);
            if (lSerververbindung != pVerbindung) continue;
            this.hatVerbindungen.removeElementAt(lNr);
        }
    }

    public void bearbeiteVerbindungsaufbau(String pClientIP) {
    }

    public void bearbeiteVerbindungsaufbau(String pClientIP, int pPartnerPort) {
    }

    public void bearbeiteNachricht(String pClientIP, String pNachricht) {
    }

    public void bearbeiteNachricht(String pClientIP, int pPartnerPort, String pNachricht) {
    }

    public void bearbeiteVerbindungsverlust(String pClientIP) {
    }

    public void bearbeiteVerbindungsverlust(String pClientIP, int pPartnerPort) {
    }

    public void bearbeiteVerbindungsende(String pClientIP) {
    }

    public void bearbeiteVerbindungsende(String pClientIP, int pPartnerPort) {
    }

    public Serververbindung neueSerververbindung() {
        return new Serververbindung();
    }

    public void gibFrei() {
        try {
            if (this.mitProtokoll()) {
                System.out.println("Schlie\u00dfe Server mit ServerSocket: " + this.hatServerSocket);
                System.out.println("");
            }
            this.zLaeuft = false;
            this.hatServerSocket.close();
            this.hatServerSocket = null;
        }
        catch (Exception fehler) {
            System.err.println("Fehler beim Schlie\u00dfen des Servers: " + fehler);
        }
    }

    private class ServerSchleife
    extends Thread
    implements Serializable {
        private Server kenntServer;

        public ServerSchleife(Server pServer) {
            this.kenntServer = pServer;
        }

        public void run() {
            while (Server.this.zLaeuft) {
                try {
                    Socket lClientSocket = this.kenntServer.hatServerSocket.accept();
                    Serververbindung lNeueSerververbindung = this.kenntServer.neueSerververbindung();
                    lNeueSerververbindung.initialisiere(lClientSocket, this.kenntServer.mitProtokoll(), this.kenntServer);
                    if (this.kenntServer.mitProtokoll()) {
                        System.out.println("Server baut neue Verbindung auf: " + lNeueSerververbindung);
                    }
                    this.kenntServer.clientListe().addElement(lNeueSerververbindung);
                    lNeueSerververbindung.start();
                }
                catch (Exception fehler) {
                    System.err.println("Fehler beim Erwarten einer Verbindung in Server: " + fehler);
                }
            }
        }
    }
}

