/*
 * Decompiled with CFR 0.152.
 */
package sum.ereignis;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import sum.ereignis.Ereignisanwendung;

public class Bildschirm
extends JFrame {
    public static Bildschirm hatPrivatschirm;
    private JPanel hatPanel;
    private Ereignisanwendung kenntEreignisanwendung;
    private Color zHintergrundfarbe = Color.white;
    private Image dbImage = null;
    private Graphics2D dbGraphics = null;
    private int zHoehe = 0;
    private int zBreite = 0;
    private boolean zHatFocus = true;
    private boolean zHatGezeichnet = false;
    private boolean zMitDoubleBuffering;

    public Bildschirm() {
        this(0, 0, -1, -1, "SuM-Fenster", false, false);
    }

    public Bildschirm(boolean pMitDoubleBuffering) {
        this(0, 0, -1, -1, "SuM-Fenster", false, pMitDoubleBuffering);
    }

    public Bildschirm(int pLinks, int pOben, int pBreite, int pHoehe) {
        this(pLinks, pOben, pBreite, pHoehe, "SuM-Fenster", false, false);
    }

    public Bildschirm(int pLinks, int pOben, int pBreite, int pHoehe, boolean pMitDoubleBuffering) {
        this(pLinks, pOben, pBreite, pHoehe, "SuM-Fenster", false, pMitDoubleBuffering);
    }

    public Bildschirm(int pBreite, int pHoehe) {
        this(0, 0, pBreite, pHoehe, "SuM-Fenster", false, false);
    }

    public Bildschirm(int pBreite, int pHoehe, boolean pMitDoubleBuffering) {
        this(0, 0, pBreite, pHoehe, "SuM-Fenster", false, pMitDoubleBuffering);
    }

    protected Bildschirm(int pLinks, int pOben, int pBreite, int pHoehe, String pName, boolean pAlsFenster, boolean pMitDoubleBuffering) {
        super(pName);
        if (!pAlsFenster) {
            hatPrivatschirm = this;
        }
        this.zMitDoubleBuffering = pMitDoubleBuffering;
        this.kenntEreignisanwendung = Ereignisanwendung.hatSuMPrivateAnwendung;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().startsWith("mac os")) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        this.setJMenuBar(new JMenuBar());
        this.hatPanel = (JPanel)this.getContentPane();
        this.hatPanel.setLayout(null);
        if (osName.toLowerCase().startsWith("mac os")) {
            this.hatPanel.setBounds(0, 0, 2000, 2000);
        } else {
            this.hatPanel.setBounds(0, 22, 2000, 2022);
        }
        this.hatPanel.setOpaque(true);
        this.addWindowListener(new FensterTester());
        this.addComponentListener(new GroesseTester());
        this.hatPanel.addMouseMotionListener(new MausBeweger());
        this.hatPanel.addMouseListener(new MausTaster());
        this.hatPanel.addKeyListener(new TastenTester());
        this.hatPanel.addFocusListener(new FokusReaktor());
        if (pBreite == -1) {
            Dimension dimension = this.getToolkit().getScreenSize();
            pBreite = dimension.width - 20;
            pHoehe = dimension.height - 60;
        }
        this.setBounds(pLinks, pOben, pBreite, pHoehe);
        this.setVisible(true);
        this.getJMenuBar().setVisible(true);
        this.fenstergroesseAnpassen();
        this.setSize(this.getWidth() - this.breite() + pBreite, this.getHeight() - this.hoehe() + pHoehe);
        if (this.zMitDoubleBuffering) {
            this.dbImage = this.createImage(this.getSize().width, this.getSize().height);
            this.dbGraphics = (Graphics2D)this.dbImage.getGraphics();
        }
        this.init2DGraphics();
        this.setzeFarbe(11);
        this.warte(1000L);
        this.hatPanel.requestFocus();
    }

    protected void init2DGraphics() {
        Graphics2D g2d = this.zMitDoubleBuffering ? this.dbGraphics : (Graphics2D)this.hatPanel.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    public JPanel privatPanel() {
        return this.hatPanel;
    }

    protected void merkeGroesse(int x, int y) {
        this.zBreite = x;
        this.zHoehe = y;
    }

    protected Graphics g() {
        if (this.zMitDoubleBuffering) {
            return this.dbGraphics;
        }
        return this.hatPanel.getGraphics();
    }

    public void paint(Graphics g) {
        if (this.dbImage != null) {
            g.drawImage(this.dbImage, 0, 0, this);
        } else {
            super.paint(g);
        }
        for (int i = 0; i < this.hatPanel.getComponentCount(); ++i) {
            Component komponente = this.hatPanel.getComponent(i);
            komponente.repaint();
        }
    }

    public void update(Graphics g) {
        super.update(g);
        if (this.zHatGezeichnet) {
            this.kenntEreignisanwendung.bearbeiteUpdate();
        } else if (this.isVisible() && this.kenntEreignisanwendung.fuehrtAus()) {
            this.zHatGezeichnet = true;
            this.loescheAlles();
        }
    }

    public void zeichneDich() {
        if (this.zMitDoubleBuffering) {
            this.hatPanel.getGraphics().drawImage(this.dbImage, 0, 0, this);
        }
        for (int i = 0; i < this.hatPanel.getComponentCount(); ++i) {
            Component komponente = this.hatPanel.getComponent(i);
            komponente.repaint();
        }
    }

    public boolean besitztFokus() {
        return this.zHatFocus;
    }

    public void setzeFokus() {
        this.hatPanel.requestFocus();
    }

    public void setzeFarbe(Color pFarbe) {
        if (this.zMitDoubleBuffering) {
            this.dbGraphics.setBackground(pFarbe);
            this.dbGraphics.clearRect(0, 0, 2000, 2000);
        } else {
            this.hatPanel.setBackground(pFarbe);
            this.hatPanel.getGraphics().clearRect(0, 0, 2000, 2000);
        }
        this.zHintergrundfarbe = pFarbe;
        this.hatPanel.paintImmediately(0, 0, 2000, 2000);
        this.hatPanel.validate();
        for (int i = 0; i < this.hatPanel.getComponentCount(); ++i) {
            Component komponente = this.hatPanel.getComponent(i);
            komponente.setBackground(pFarbe);
            komponente.repaint();
        }
    }

    public void setzeFarbe(int pFarbe) {
        if (pFarbe < 0) {
            pFarbe = 0;
        }
        switch (pFarbe %= 13) {
            case 0: {
                this.setzeFarbe(Color.black);
                break;
            }
            case 1: {
                this.setzeFarbe(Color.blue);
                break;
            }
            case 2: {
                this.setzeFarbe(Color.cyan);
                break;
            }
            case 3: {
                this.setzeFarbe(Color.darkGray);
                break;
            }
            case 4: {
                this.setzeFarbe(Color.gray);
                break;
            }
            case 5: {
                this.setzeFarbe(Color.green);
                break;
            }
            case 6: {
                this.setzeFarbe(Color.lightGray);
                break;
            }
            case 7: {
                this.setzeFarbe(Color.magenta);
                break;
            }
            case 8: {
                this.setzeFarbe(Color.orange);
                break;
            }
            case 9: {
                this.setzeFarbe(Color.pink);
                break;
            }
            case 10: {
                this.setzeFarbe(Color.red);
                break;
            }
            case 11: {
                this.setzeFarbe(Color.white);
                break;
            }
            case 12: {
                this.setzeFarbe(Color.yellow);
            }
        }
    }

    public void loescheAlles() {
        this.setzeFarbe(this.zHintergrundfarbe);
    }

    protected void warte(long zeit) {
        try {
            Thread.sleep(zeit);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public Color hintergrundfarbe() {
        return this.zHintergrundfarbe;
    }

    public void doUpdate(JComponent pKomponente) {
        pKomponente.paintImmediately(0, 0, pKomponente.getWidth(), pKomponente.getHeight());
        pKomponente.validate();
    }

    public int breite() {
        return this.zBreite;
    }

    public int hoehe() {
        return this.zHoehe;
    }

    public void verstecke() {
        this.setVisible(false);
    }

    public void zeige() {
        this.setVisible(true);
    }

    public void immerNachVorn() {
        this.setAlwaysOnTop(true);
    }

    public void nachVorn() {
        this.toFront();
    }

    public void nachHinten() {
        this.toBack();
    }

    public void gibFrei() {
        this.fensterZerstoeren();
    }

    private void fenstergroesseAnpassen() {
        this.merkeGroesse(this.hatPanel.getVisibleRect().width, this.hatPanel.getVisibleRect().height);
        if (this.zMitDoubleBuffering) {
            this.dbImage = this.createImage(this.getSize().width, this.getSize().height);
            this.dbGraphics = (Graphics2D)this.dbImage.getGraphics();
            this.init2DGraphics();
            this.setzeFarbe(this.zHintergrundfarbe);
        }
    }

    private void fensterZerstoeren() {
        this.kenntEreignisanwendung.halteAn();
        this.dispose();
    }

    private class FokusReaktor
    implements FocusListener {
        private FokusReaktor() {
        }

        public void focusGained(FocusEvent e) {
            if (Bildschirm.this.kenntEreignisanwendung != null && Bildschirm.this.kenntEreignisanwendung.fuehrtAus()) {
                Bildschirm.this.zHatFocus = true;
                Bildschirm.this.kenntEreignisanwendung.bearbeiteFokusErhalten();
            }
        }

        public void focusLost(FocusEvent e) {
            if (Bildschirm.this.kenntEreignisanwendung != null && Bildschirm.this.kenntEreignisanwendung.fuehrtAus()) {
                Bildschirm.this.zHatFocus = false;
                Bildschirm.this.kenntEreignisanwendung.bearbeiteFokusVerloren();
            }
        }
    }

    private class TastenTester
    extends KeyAdapter {
        private TastenTester() {
        }

        public void keyPressed(KeyEvent e) {
            if (Bildschirm.this.kenntEreignisanwendung != null && Bildschirm.this.kenntEreignisanwendung.fuehrtAus() && e.getKeyCode() != 17) {
                if (e.isActionKey() || e.getKeyCode() < 32 || e.getKeyCode() == 127) {
                    Bildschirm.this.kenntEreignisanwendung.bearbeiteTaste((char)(e.getKeyCode() + 500));
                } else {
                    Bildschirm.this.kenntEreignisanwendung.bearbeiteTaste(e.getKeyChar());
                }
            }
        }
    }

    private class MausTaster
    extends MouseAdapter {
        private MausTaster() {
        }

        public void mouseEntered(MouseEvent e) {
            if (Bildschirm.this.kenntEreignisanwendung != null && Bildschirm.this.kenntEreignisanwendung.fuehrtAus()) {
                Bildschirm.this.kenntEreignisanwendung.bearbeiteMausBewegt(e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            if (Bildschirm.this.kenntEreignisanwendung != null && Bildschirm.this.kenntEreignisanwendung.fuehrtAus()) {
                Bildschirm.this.kenntEreignisanwendung.bearbeiteMausDruck(e.getX(), e.getY());
                Bildschirm.this.hatPanel.requestFocus();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (Bildschirm.this.kenntEreignisanwendung != null && Bildschirm.this.kenntEreignisanwendung.fuehrtAus()) {
                if (e.getClickCount() > 1) {
                    Bildschirm.this.kenntEreignisanwendung.bearbeiteDoppelKlick(e.getX(), e.getY());
                } else {
                    Bildschirm.this.kenntEreignisanwendung.bearbeiteMausLos(e.getX(), e.getY());
                }
            }
        }
    }

    private class MausBeweger
    extends MouseMotionAdapter {
        private MausBeweger() {
        }

        public void mouseDragged(MouseEvent e) {
            if (Bildschirm.this.kenntEreignisanwendung != null && Bildschirm.this.kenntEreignisanwendung.fuehrtAus()) {
                Bildschirm.this.kenntEreignisanwendung.bearbeiteMausBewegt(e.getX(), e.getY());
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (Bildschirm.this.kenntEreignisanwendung != null && Bildschirm.this.kenntEreignisanwendung.fuehrtAus()) {
                Bildschirm.this.kenntEreignisanwendung.bearbeiteMausBewegt(e.getX(), e.getY());
            }
        }
    }

    private class GroesseTester
    extends ComponentAdapter {
        private GroesseTester() {
        }

        public void componentResized(ComponentEvent e) {
            Bildschirm.this.fenstergroesseAnpassen();
            e.getComponent().repaint();
        }

        public void componentMoved(ComponentEvent e) {
            e.getComponent().repaint();
        }
    }

    private class FensterTester
    extends WindowAdapter {
        private FensterTester() {
        }

        public void windowClosing(WindowEvent e) {
            Bildschirm.this.fensterZerstoeren();
        }
    }
}

