/*
 * Decompiled with CFR 0.152.
 */
package sum.kern;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import sum.kern.Eingabe;
import sum.werkzeuge.Textwerkzeug;

public class Bildschirm
extends JFrame {
    protected static Bildschirm hatPrivatschirm;
    protected Vector hatTastaturpuffer;
    private static JPanel hatPanel;
    private Image dbImage = null;
    private Graphics2D dbGraphics = null;
    private Color zHintergrundfarbe = Color.white;
    private int zHoehe = 0;
    private int zBreite = 0;
    private boolean zMitDoubleBuffering;
    protected boolean zTasteIstUnten = false;
    protected boolean zTasteIstDoppel = false;
    protected int zMausHatPositionX = 0;
    protected int zMausHatPositionY = 0;

    public Bildschirm() {
        this(0, 0, -1, -1, "SuM-Fenster", false, false);
    }

    public Bildschirm(boolean pMitDoubleBuffering) {
        this(0, 0, -1, -1, "SuM-Fenster", false, pMitDoubleBuffering);
    }

    public Bildschirm(int pLinks, int pOben, int pBreite, int pHoehe) {
        this(pLinks, pOben, pBreite, pHoehe, "SuM-Fenster", false, false);
    }

    public Bildschirm(int pLinks, int pOben, int pBreite, int pHoehe, boolean pMitDoubleBuffering) {
        this(pLinks, pOben, pBreite, pHoehe, "SuM-Fenster", false, pMitDoubleBuffering);
    }

    public Bildschirm(int pBreite, int pHoehe) {
        this(0, 0, pBreite, pHoehe, "SuM-Fenster", false, false);
    }

    public Bildschirm(int pBreite, int pHoehe, boolean pMitDoubleBuffering) {
        this(0, 0, pBreite, pHoehe, "SuM-Fenster", false, pMitDoubleBuffering);
    }

    protected Bildschirm(int pLinks, int pOben, int pBreite, int pHoehe, String pName, boolean pAlsFenster, boolean pMitDoubleBuffering) {
        super(pName);
        String osName;
        if (!pAlsFenster) {
            hatPrivatschirm = this;
        }
        if ((osName = System.getProperty("os.name")).toLowerCase().startsWith("mac os")) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        this.zMitDoubleBuffering = pMitDoubleBuffering;
        hatPanel = (JPanel)this.getContentPane();
        hatPanel.setLayout(null);
        hatPanel.setOpaque(true);
        this.addWindowListener(new FensterTester());
        this.addComponentListener(new GroesseTester());
        hatPanel.addMouseMotionListener(new MausBeweger());
        hatPanel.addMouseListener(new MausTaster());
        hatPanel.addKeyListener(new TastenTester());
        if (pBreite == -1) {
            Dimension dimension = this.getToolkit().getScreenSize();
            pBreite = dimension.width - 20;
            pHoehe = dimension.height - 60;
        }
        this.setBounds(pLinks, pOben, pBreite, pHoehe);
        this.hatTastaturpuffer = new Vector();
        this.setVisible(true);
        this.fenstergroesseAnpassen();
        this.setSize(this.getWidth() - this.breite() + pBreite, this.getHeight() - this.hoehe() + pHoehe);
        if (this.zMitDoubleBuffering) {
            this.dbImage = this.createImage(this.getSize().width, this.getSize().height);
            this.dbGraphics = (Graphics2D)this.dbImage.getGraphics();
        }
        this.init2DGraphics();
        this.setzeFarbe(11);
        this.zeichneDich();
        this.warte(1000L);
        hatPanel.requestFocus();
    }

    protected void init2DGraphics() {
        Graphics2D g2d = this.zMitDoubleBuffering ? this.dbGraphics : (Graphics2D)hatPanel.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    protected JPanel privatPanel() {
        return hatPanel;
    }

    protected void merkeGroesse(int x, int y) {
        this.zBreite = x;
        this.zHoehe = y;
    }

    public void nachVorn() {
        this.setAlwaysOnTop(true);
    }

    protected Graphics g() {
        if (this.zMitDoubleBuffering) {
            return this.dbGraphics;
        }
        return hatPanel.getGraphics();
    }

    @Override
    public void paint(Graphics g) {
        if (this.dbImage != null) {
            g.drawImage(this.dbImage, hatPanel.getX(), hatPanel.getY(), hatPanel);
        } else {
            super.paint(g);
        }
    }

    public void zeichneDich() {
        if (this.zMitDoubleBuffering) {
            hatPanel.getGraphics().drawImage(this.dbImage, hatPanel.getX(), hatPanel.getY(), hatPanel);
        }
    }

    public void setzeFarbe(Color pFarbe) {
        if (this.zMitDoubleBuffering) {
            this.dbGraphics.setBackground(pFarbe);
            this.dbGraphics.clearRect(0, 0, 2000, 2000);
        } else {
            hatPanel.setBackground(pFarbe);
            hatPanel.getGraphics().clearRect(0, 0, 2000, 2000);
        }
        this.zHintergrundfarbe = pFarbe;
        hatPanel.paintImmediately(hatPanel.getBounds());
        hatPanel.validate();
    }

    public void setzeFarbe(int pFarbe) {
        if (pFarbe < 0) {
            pFarbe = 0;
        }
        switch (pFarbe %= 13) {
            case 0: {
                this.setzeFarbe(Color.black);
                break;
            }
            case 1: {
                this.setzeFarbe(Color.blue);
                break;
            }
            case 2: {
                this.setzeFarbe(Color.cyan);
                break;
            }
            case 3: {
                this.setzeFarbe(Color.darkGray);
                break;
            }
            case 4: {
                this.setzeFarbe(Color.gray);
                break;
            }
            case 5: {
                this.setzeFarbe(Color.green);
                break;
            }
            case 6: {
                this.setzeFarbe(Color.lightGray);
                break;
            }
            case 7: {
                this.setzeFarbe(Color.magenta);
                break;
            }
            case 8: {
                this.setzeFarbe(Color.orange);
                break;
            }
            case 9: {
                this.setzeFarbe(Color.pink);
                break;
            }
            case 10: {
                this.setzeFarbe(Color.red);
                break;
            }
            case 11: {
                this.setzeFarbe(Color.white);
                break;
            }
            case 12: {
                this.setzeFarbe(Color.yellow);
            }
        }
    }

    public void loescheAlles() {
        this.setzeFarbe(this.zHintergrundfarbe);
    }

    protected void warte(long zeit) {
        try {
            Thread.sleep(zeit);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    protected Color hintergrundfarbe() {
        return this.zHintergrundfarbe;
    }

    public int breite() {
        return this.zBreite;
    }

    public int hoehe() {
        return this.zHoehe;
    }

    public String holeText() {
        Eingabe lEingabe = new Eingabe(this, "Gib einen Text ein.");
        return lEingabe.eingabe();
    }

    public double holeZahl() {
        Textwerkzeug lTW = new Textwerkzeug();
        Eingabe lEingabe = new Eingabe(this, "Gib eine Zahl ein.");
        String lText = lEingabe.eingabe();
        double lZahl = lTW.istZahl(lText) ? lTW.alsZahl(lText) : 0.0;
        return lZahl;
    }

    public int holeGanzeZahl() {
        Textwerkzeug lTW = new Textwerkzeug();
        Eingabe lEingabe = new Eingabe(this, "Gib eine ganze Zahl ein.");
        String lText = lEingabe.eingabe();
        int lZahl = lTW.istGanzeZahl(lText) ? lTW.alsGanzeZahl(lText) : 0;
        return lZahl;
    }

    public String holeText(String pMeldung) {
        Eingabe lEingabe = new Eingabe(this, pMeldung);
        return lEingabe.eingabe();
    }

    public double holeZahl(String pMeldung) {
        Textwerkzeug lTW = new Textwerkzeug();
        Eingabe lEingabe = new Eingabe(this, pMeldung);
        String lText = lEingabe.eingabe();
        double lZahl = lTW.istZahl(lText) ? lTW.alsZahl(lText) : 0.0;
        return lZahl;
    }

    public int holeGanzeZahl(String pMeldung) {
        Textwerkzeug lTW = new Textwerkzeug();
        Eingabe lEingabe = new Eingabe(this, pMeldung);
        String lText = lEingabe.eingabe();
        int lZahl = lTW.istGanzeZahl(lText) ? lTW.alsGanzeZahl(lText) : 0;
        return lZahl;
    }

    public void gibFrei() {
        this.setTitle("Das SuM-Programm ist beendet.");
        this.warte(1L);
        while (this.zTasteIstUnten) {
            this.warte(1L);
        }
        while (!this.zTasteIstUnten) {
            this.warte(1L);
        }
        this.fensterZerstoeren();
    }

    private void fenstergroesseAnpassen() {
        this.merkeGroesse(Bildschirm.hatPanel.getVisibleRect().width, Bildschirm.hatPanel.getVisibleRect().height);
        if (this.zMitDoubleBuffering) {
            this.dbImage = this.createImage(this.getSize().width, this.getSize().height);
            this.dbGraphics = (Graphics2D)this.dbImage.getGraphics();
            this.init2DGraphics();
            this.setzeFarbe(this.zHintergrundfarbe);
        }
    }

    private void fensterZerstoeren() {
        this.dispose();
        System.exit(0);
    }

    private void merkeUnten(boolean b) {
        this.zTasteIstUnten = b;
    }

    private void merkeXY(int x, int y) {
        this.zMausHatPositionX = x;
        this.zMausHatPositionY = y;
    }

    private void merkeDoppelklick(boolean b) {
        this.zTasteIstDoppel = b;
    }

    private void merkeDruck(int z) {
        this.hatTastaturpuffer.addElement(new Integer(z));
        if (z == 27) {
            this.dispose();
            System.exit(0);
        }
    }

    protected static void fehler(String pMeldung) {
        System.out.println(pMeldung);
        System.exit(0);
    }

    private class TastenTester
    extends KeyAdapter {
        private TastenTester() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() != 17) {
                if (e.isActionKey() || e.getKeyCode() < 32 || e.getKeyCode() == 127) {
                    Bildschirm.this.merkeDruck(e.getKeyCode() + 500);
                } else {
                    Bildschirm.this.merkeDruck(e.getKeyChar());
                }
            }
        }
    }

    private class MausTaster
    extends MouseAdapter {
        private MausTaster() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Bildschirm.this.merkeXY(e.getX(), e.getY());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Bildschirm.this.merkeXY(e.getX(), e.getY());
            Bildschirm.this.merkeUnten(true);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Bildschirm.this.merkeXY(e.getX(), e.getY());
            Bildschirm.this.merkeUnten(false);
            if (e.getClickCount() > 1) {
                Bildschirm.this.merkeDoppelklick(true);
            } else {
                Bildschirm.this.merkeDoppelklick(false);
            }
        }
    }

    private class MausBeweger
    extends MouseMotionAdapter {
        private MausBeweger() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Bildschirm.this.merkeXY(e.getX(), e.getY());
            Bildschirm.this.merkeUnten(true);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Bildschirm.this.merkeXY(e.getX(), e.getY());
            Bildschirm.this.merkeUnten(false);
        }
    }

    private class GroesseTester
    extends ComponentAdapter {
        private GroesseTester() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Bildschirm.this.fenstergroesseAnpassen();
        }
    }

    private class FensterTester
    extends WindowAdapter {
        private FensterTester() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Bildschirm.this.fensterZerstoeren();
        }
    }
}

