/*
 * Decompiled with CFR 0.152.
 */
package sum.transduktor;

import java.awt.Point;
import sum.transduktor.Direction;
import sum.transduktor.Edge;
import sum.transduktor.Guide;
import sum.transduktor.Node;
import sum.transduktor.Tourist;

class LoopGuide
implements Guide {
    Point goal;
    int state;
    double touristX;
    double touristY;
    Tourist tourist;
    Edge edge;
    Node destination;
    Direction dir;
    Direction tempdir;
    double tangle;
    double deltaAngle;
    int distance;
    static final int GOTOSTART = -1;
    static final int FIRSTLEG = 0;
    static final int ONARC = 1;
    static final int OFFARC = 2;
    static final int SCNDLEG = 3;
    static final int TONODE = 4;
    static final int FINISHED = 5;

    LoopGuide(Tourist t, Edge e) {
        this.tourist = t;
        this.edge = e;
        this.destination = this.edge.getSource();
        Point tp = t.getPosition();
        this.touristX = tp.x;
        this.touristY = tp.y;
        this.tangle = 0.0;
        this.state = -1;
        this.goal = this.edge.getStart();
        this.dir = new Direction(0, 0, 0, 0);
        this.tempdir = new Direction(0, 0, 0, 0);
        this.distance = this.edge.getDistance();
        this.deltaAngle = 2.0 / ((double)this.distance / 2.0);
    }

    public Point nextPosition() {
        Point tp = this.tourist.getPosition();
        if (tp.equals(this.goal)) {
            ++this.state;
            switch (this.state) {
                default: {
                    break;
                }
                case 0: {
                    this.goal = this.edge.getArcStart();
                    break;
                }
                case 1: {
                    this.goal = null;
                    Point p = this.edge.getArcCenter();
                    this.dir.set(this.edge.getArcCenter(), this.edge.getArcStart());
                    break;
                }
                case 2: {
                    if (this.goal.equals(tp)) {
                        ++this.state;
                        this.goal = this.edge.getEnd();
                        break;
                    }
                    this.goal = this.edge.getArcEnd();
                    break;
                }
                case 3: {
                    this.goal = this.edge.getEnd();
                    break;
                }
                case 4: {
                    this.goal = this.destination.getPosition();
                    break;
                }
                case 5: {
                    this.tourist.setOutput(this.edge.getOutput());
                    this.tourist.guideFinished();
                    this.tourist.setLocation(this.destination);
                    return tp;
                }
            }
        }
        if (this.state != 1) {
            this.dir.set(tp, this.goal);
            do {
                this.touristX += this.dir.x_dir;
                this.touristY += this.dir.y_dir;
            } while ((int)this.touristX == tp.x && (int)this.touristY == tp.y);
            tp.move((int)this.touristX, (int)this.touristY);
        } else {
            Point np = new Point(0, 0);
            do {
                this.tangle -= this.deltaAngle;
                this.dir.rotate(this.tangle, this.tempdir);
                Point ac = this.edge.getArcCenter();
                np.move(ac.x, ac.y);
                this.tempdir.translatePoint(np, this.distance / 2);
            } while (np.x == tp.x && np.y == tp.y);
            if (this.tangle < -Math.PI) {
                this.goal = new Point(np.x, np.y);
                this.touristX = np.x;
                this.touristY = np.y;
            }
            tp.move(np.x, np.y);
        }
        return tp;
    }
}

