/*
 * Decompiled with CFR 0.152.
 */
package sum.transduktor;

import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Event;
import java.awt.Frame;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.io.File;
import java.io.IOException;
import sum.transduktor.FSA;
import sum.transduktor.FilenameExtensionFilter;
import sum.transduktor.FiniteStateAutomaton;
import sum.transduktor.FixedFileDialog;
import sum.transduktor.FlexibleLabel;
import sum.transduktor.FsaEditListener;
import sum.transduktor.JifPanel;
import sum.transduktor.NoEdgeSelectedException;
import sum.transduktor.NoNodeSelectedException;
import sum.transduktor.OKDialog;
import sum.transduktor.RuleBasedLayout;

public class FsaEditPanel
extends Panel
implements FsaEditListener {
    FSA fs;
    FiniteStateAutomaton target;
    CardLayout cl;
    List edgeLabelIn;
    List nodeLabel;
    Button deleteNodeButton;
    Button deleteEdgeButton;
    Button loadButton;
    Button saveButton;
    Button clearButton;
    Button quitButton;
    Button digitButtonIn;
    Button lcButtonIn;
    Button ucButtonIn;
    Checkbox initialState;
    TextField stringField;

    public void fsaSelectionChanged() {
        this.cl.show(this, "File Panel");
    }

    public void fsaSelectionChanged(boolean initialValue, int name) {
        this.initialState.setState(initialValue);
        this.nodeLabel.select(name - 65);
        this.cl.show(this, "Node Panel");
    }

    public void fsaSelectionChanged(int[] symbolIndexes) {
        int si = 0;
        int i = 0;
        do {
            if (si < symbolIndexes.length && i == symbolIndexes[si]) {
                this.edgeLabelIn.select(i);
                ++si;
                continue;
            }
            this.edgeLabelIn.deselect(i);
        } while (++i < 94);
        this.cl.show(this, "Edge Panel");
    }

    public void fsaSelectedEdgeSymbolsChanged(int[] ai1) {
    }

    public void fsaEnteredRunState() {
        this.cl.show(this, "Blank Panel");
    }

    public void fsaSelectedEdgeSymbolChanged(int j, boolean flag1) {
    }

    public void setTargetFSA(FiniteStateAutomaton fsa) {
        this.target = fsa;
    }

    public boolean action(Event evt, Object what) {
        if (evt.target instanceof Checkbox) {
            if (evt.target == this.initialState) {
                try {
                    this.target.setSelectedNodeInitialState(this.initialState.getState());
                }
                catch (NoNodeSelectedException nnse) {
                    nnse.printStackTrace();
                }
                return true;
            }
        } else if (evt.target instanceof Button) {
            if (evt.target == this.deleteNodeButton) {
                this.target.removeComponent();
                return true;
            }
            if (evt.target == this.deleteEdgeButton) {
                this.target.removeComponent();
                return true;
            }
            if (evt.target == this.loadButton) {
                FixedFileDialog ffd = new FixedFileDialog((Frame)this.fs, "Lade Transduktor-Datei", 0);
                FilenameExtensionFilter fef = new FilenameExtensionFilter(".trd", true);
                ffd.setFilenameFilter(fef);
                ffd.setFile("*.trd");
                ffd.setVisible(true);
                String dir = ffd.getDirectory();
                String file = ffd.getFile();
                if (dir != null && file != null && fef.accept(new File(dir), file)) {
                    if (!new File(dir + file).exists()) {
                        OKDialog.createOKDialog(dir + file + " not found!");
                    } else {
                        try {
                            this.target.loadFromFile(dir + file);
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }
                return true;
            }
            if (evt.target == this.saveButton) {
                FixedFileDialog ffd = new FixedFileDialog((Frame)this.fs, "Speichere Transduktor-Datei", 1);
                FilenameExtensionFilter fef = new FilenameExtensionFilter(".trd", true);
                ffd.setFile("*.trd");
                ffd.setVisible(true);
                String dir = ffd.getDirectory();
                String file = ffd.getFile();
                if (dir != null && file != null && fef.accept(new File(dir), file)) {
                    try {
                        this.target.saveToFile(dir + file);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                return true;
            }
            if (evt.target == this.clearButton) {
                this.target.clear();
                return true;
            }
            if (evt.target == this.quitButton) {
                this.fs.dispose();
                return true;
            }
            if (evt.target == this.ucButtonIn) {
                int i = 32;
                do {
                    if (this.edgeLabelIn.isSelected(i)) continue;
                    this.edgeLabelIn.select(i);
                    try {
                        this.target.setSelectedEdgeSymbol(i, true);
                    }
                    catch (NoEdgeSelectedException nese) {
                        nese.printStackTrace();
                    }
                } while (++i <= 57);
            } else if (evt.target == this.lcButtonIn) {
                int i = 64;
                do {
                    if (this.edgeLabelIn.isSelected(i)) continue;
                    this.edgeLabelIn.select(i);
                    try {
                        this.target.setSelectedEdgeSymbol(i, true);
                    }
                    catch (NoEdgeSelectedException nese) {
                        nese.printStackTrace();
                    }
                } while (++i <= 89);
            } else if (evt.target == this.digitButtonIn) {
                int i = 15;
                do {
                    if (this.edgeLabelIn.isSelected(i)) continue;
                    this.edgeLabelIn.select(i);
                    try {
                        this.target.setSelectedEdgeSymbol(i, true);
                    }
                    catch (NoEdgeSelectedException nese) {
                        nese.printStackTrace();
                    }
                } while (++i <= 24);
            }
        }
        return super.action(evt, what);
    }

    public void fsaEnteredEditState() {
        this.cl.show(this, "File Panel");
    }

    public void fsaSelectedNodeInitialChanged(boolean flag1) {
    }

    public FsaEditPanel(FSA pFSA) {
        this.fs = pFSA;
        JifPanel p = null;
        this.cl = new CardLayout();
        this.setLayout(this.cl);
        this.target = null;
        p = new JifPanel(96, "Datei/Editieren");
        this.add("Blank Panel", p);
        p = new JifPanel(96, "Datei");
        RuleBasedLayout r = new RuleBasedLayout();
        this.loadButton = new Button("Laden");
        p.add(this.loadButton);
        this.saveButton = new Button("Speichern");
        p.add(this.saveButton);
        this.clearButton = new Button("Neu");
        p.add(this.clearButton);
        this.quitButton = new Button("Beenden");
        p.add(this.quitButton);
        r.move(r.top(this.loadButton), r.top(p));
        r.hcenter(r.part(this.loadButton), r.part(p));
        r.hcenter(r.part(this.saveButton), r.part(p));
        r.move(r.top(this.saveButton), r.bottom(this.loadButton));
        r.hcenter(r.part(this.clearButton), r.part(p));
        r.move(r.top(this.clearButton), r.bottom(this.saveButton));
        r.hcenter(r.part(this.quitButton), r.part(p));
        r.move(r.top(this.quitButton), r.bottom(this.clearButton));
        p.setLayout(r);
        this.add("File Panel", p);
        p = new JifPanel(96, "Editiere Zustand");
        r = new RuleBasedLayout();
        this.initialState = new Checkbox("Anfangszustand", null, false);
        p.add(this.initialState);
        FlexibleLabel nLabel = new FlexibleLabel("\\bZustandszeichen:");
        p.add(nLabel);
        this.nodeLabel = new List(5, false);
        for (char i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            this.nodeLabel.addItem(i + "");
        }
        p.add(this.nodeLabel);
        this.deleteNodeButton = new Button("Entferne Zustand");
        p.add(this.deleteNodeButton);
        r.hcenter(r.part(this.initialState), r.part(p));
        r.move(r.top(this.initialState), r.top(p));
        r.move(r.left(nLabel), r.left(this.nodeLabel));
        r.move(r.top(nLabel), r.bottom(this.initialState));
        r.hcenter(r.part(this.nodeLabel), r.part(p));
        r.move(r.top(this.nodeLabel), r.bottom(nLabel));
        r.move(r.bottom(this.deleteNodeButton), r.bottom(p));
        r.hcenter(r.part(this.deleteNodeButton), r.part(p));
        p.setLayout(r);
        this.add("Node Panel", p);
        p = new JifPanel(96, "Editiere Uebergang");
        r = new RuleBasedLayout();
        FlexibleLabel labelIn = new FlexibleLabel("\\bEingabezeichen:");
        p.add(labelIn);
        this.edgeLabelIn = new List(4, true);
        for (char i = '!'; i < '\u007f'; i = (char)(i + '\u0001')) {
            this.edgeLabelIn.addItem(i + "");
        }
        p.add(this.edgeLabelIn);
        this.lcButtonIn = new Button("a-z");
        p.add(this.lcButtonIn);
        this.ucButtonIn = new Button("A-Z");
        p.add(this.ucButtonIn);
        this.digitButtonIn = new Button("0-9");
        p.add(this.digitButtonIn);
        FlexibleLabel labelOut = new FlexibleLabel("\\bAusgabestring:");
        p.add(labelOut);
        this.stringField = new TextField("");
        p.add(this.stringField);
        this.deleteEdgeButton = new Button("Entferne Uebergang");
        p.add(this.deleteEdgeButton);
        r.move(r.left(labelIn), r.left(p));
        r.move(r.top(labelIn), r.top(p));
        r.hcenter(r.part(this.edgeLabelIn), r.part(p));
        r.move(r.top(this.edgeLabelIn), r.bottom(labelIn));
        r.move(r.top(this.lcButtonIn), r.bottom(this.edgeLabelIn));
        r.move(r.right(this.lcButtonIn), r.left(this.ucButtonIn));
        r.stretch(r.width(this.lcButtonIn), r.width(this.ucButtonIn));
        r.move(r.top(this.ucButtonIn), r.bottom(this.edgeLabelIn));
        r.hcenter(r.part(this.ucButtonIn), r.part(p));
        r.move(r.top(this.digitButtonIn), r.bottom(this.edgeLabelIn));
        r.move(r.left(this.digitButtonIn), r.right(this.ucButtonIn));
        r.stretch(r.width(this.digitButtonIn), r.width(this.ucButtonIn));
        r.move(r.top(labelOut), r.bottom(this.digitButtonIn));
        r.move(r.top(this.stringField), r.bottom(labelOut));
        r.move(r.left(this.stringField), r.left(p));
        r.stretch(r.right(this.stringField), r.right(p));
        r.move(r.bottom(this.deleteEdgeButton), r.bottom(p));
        r.hcenter(r.part(this.deleteEdgeButton), r.part(p));
        p.setLayout(r);
        this.add("Edge Panel", p);
        ((CardLayout)this.getLayout()).show(this, "File Panel");
    }

    public void removeTargetFSA() {
        this.target = null;
    }

    public boolean handleEvent(Event evt) {
        if (evt.target == this.stringField) {
            try {
                this.target.setSelectedEdgeTextOut(this.stringField.getText());
            }
            catch (NoEdgeSelectedException nese) {
                nese.printStackTrace();
            }
        } else if (evt.target == this.edgeLabelIn) {
            if (evt.id == 701) {
                try {
                    this.target.setSelectedEdgeSymbol((Integer)evt.arg, true);
                }
                catch (NoEdgeSelectedException nese) {
                    nese.printStackTrace();
                }
                return true;
            }
            if (evt.id == 702) {
                try {
                    this.target.setSelectedEdgeSymbol((Integer)evt.arg, false);
                }
                catch (NoEdgeSelectedException nese) {
                    nese.printStackTrace();
                }
                return true;
            }
        } else if (evt.target == this.nodeLabel && evt.id == 701) {
            try {
                this.target.setSelectedNodeSymbol((Integer)evt.arg);
            }
            catch (NoNodeSelectedException nnse) {
                nnse.printStackTrace();
            }
            return true;
        }
        return super.handleEvent(evt);
    }

    public void blank() {
        this.cl.show(this, "Blank Panel");
    }
}

