/*
 * Decompiled with CFR 0.152.
 */
package sum.akzeptor;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Event;
import java.awt.TextField;
import sum.akzeptor.ExecutionControl;
import sum.akzeptor.FiniteStateAutomaton;
import sum.akzeptor.FlexibleLabel;
import sum.akzeptor.JifPanel;
import sum.akzeptor.RuleBasedLayout;
import sum.akzeptor.StatusBar;

public class FsaControlPanel
extends JifPanel
implements ExecutionControl {
    RuleBasedLayout r;
    FiniteStateAutomaton fsa;
    StatusBar statusBar;
    Button startButton;
    Button suspendButton;
    Button resetButton;
    Checkbox stepping;
    Checkbox editMode;
    Checkbox runMode;
    CheckboxGroup modes;
    TextField stringField;
    boolean suspended;

    public void inputAccepted() {
        this.suspendButton.disable();
        this.resetButton.enable();
        if (this.statusBar != null) {
            this.statusBar.setText("Der String wurde akzeptiert.");
        }
    }

    public void inputNotAccepted() {
        this.suspendButton.disable();
        this.resetButton.enable();
        if (this.statusBar != null) {
            this.statusBar.setText("Der String wurde nicht akzeptiert.");
        }
    }

    public boolean action(Event evt, Object what) {
        if (evt.target instanceof Button) {
            if (evt.target == this.startButton) {
                if (!this.fsa.getInitialStates().hasMoreElements()) {
                    if (this.statusBar != null) {
                        this.statusBar.setText("kein Anfangszustand vorhanden");
                    }
                    return true;
                }
                if (this.statusBar != null) {
                    this.statusBar.setText("Arbeitet...");
                }
                if (this.fsa.runState() == 1) {
                    this.resetButton.disable();
                    this.startButton.disable();
                    this.suspendButton.enable();
                    this.fsa.run();
                } else {
                    this.suspended = false;
                    if (this.stepping.getState()) {
                        this.startButton.setLabel("Schritt");
                    }
                    this.startButton.disable();
                    this.fsa.run();
                    this.suspendButton.enable();
                }
                return true;
            }
            if (evt.target == this.suspendButton) {
                if (this.suspended) {
                    this.suspended = false;
                    this.resetButton.disable();
                    this.suspendButton.setLabel("Anhalten");
                    if (this.statusBar != null) {
                        this.statusBar.setText("Arbeitet...");
                    }
                    this.fsa.resumeThread();
                } else {
                    this.suspended = true;
                    this.resetButton.enable();
                    this.suspendButton.setLabel("Fortfahren");
                    if (this.statusBar != null) {
                        this.statusBar.setText("Arbeitet... (Angehalten)");
                    }
                    this.fsa.suspendThread();
                }
            } else if (evt.target == this.resetButton) {
                if (this.suspended) {
                    this.suspended = false;
                    this.suspendButton.setLabel("Anhalten");
                }
                this.suspendButton.disable();
                this.startButton.setLabel("Start");
                this.startButton.enable();
                if (this.statusBar != null) {
                    this.statusBar.setText("Arbeitsmodus");
                }
                this.fsa.setString(this.stringField.getText());
            }
        } else if (evt.target instanceof TextField) {
            if (evt.target == this.stringField && this.runMode.getState()) {
                if (this.suspended) {
                    this.suspended = false;
                    this.suspendButton.setLabel("Anhalten");
                }
                this.suspendButton.disable();
                this.startButton.setLabel("Start");
                this.startButton.enable();
                if (this.statusBar != null) {
                    this.statusBar.setText("Arbeitsmodus");
                }
                this.fsa.setString(this.stringField.getText());
            }
        } else if (evt.target instanceof Checkbox) {
            if (evt.target == this.stepping) {
                this.fsa.setStepping(this.stepping.getState());
                if (this.stepping.getState()) {
                    if (this.fsa.runState() == 0) {
                        this.startButton.setLabel("Schritt");
                    }
                } else if (this.fsa.runState() == 0) {
                    this.startButton.setLabel("Start");
                }
                return true;
            }
            if (evt.target == this.editMode) {
                this.statusBar.setText("Editiermodus");
                this.startButton.disable();
                this.suspendButton.disable();
                this.resetButton.disable();
                this.stepping.disable();
                this.fsa.enterEditState();
            } else if (evt.target == this.runMode) {
                if (!this.fsa.getInitialStates().hasMoreElements()) {
                    if (this.statusBar != null) {
                        this.statusBar.setText("kein Anfangszustand vorhanden");
                    }
                    return true;
                }
                this.startButton.enable();
                this.resetButton.enable();
                this.stepping.enable();
                this.statusBar.setText("Arbeitsmodus");
                this.fsa.enterRunState(this.stringField.getText());
            }
        }
        return super.action(evt, what);
    }

    public void stepCompleted() {
        if (this.stepping.getState()) {
            this.startButton.enable();
        }
        this.suspendButton.disable();
        this.resetButton.enable();
        if (this.statusBar != null) {
            this.statusBar.setText("Warte...");
        }
    }

    public void exitRunMode() {
        this.statusBar.setText("Editiermodus");
        this.startButton.disable();
        this.suspendButton.disable();
        this.resetButton.disable();
        this.stepping.disable();
        this.fsa.enterEditState();
    }

    public FsaControlPanel(FiniteStateAutomaton fsa, StatusBar sb) {
        super(96, "Steuerung");
        FlexibleLabel label = new FlexibleLabel("\\bEingabestring:");
        this.fsa = fsa;
        fsa.setControl(this);
        this.statusBar = sb;
        this.r = new RuleBasedLayout();
        this.modes = new CheckboxGroup();
        this.editMode = new Checkbox("Editieren", this.modes, true);
        this.add(this.editMode);
        this.runMode = new Checkbox("Arbeiten", this.modes, false);
        this.add(this.runMode);
        this.add(label);
        this.stringField = new TextField("");
        this.add(this.stringField);
        this.startButton = new Button("Start");
        this.startButton.disable();
        this.add(this.startButton);
        this.suspendButton = new Button("Anhalten");
        this.suspendButton.disable();
        this.add(this.suspendButton);
        this.resetButton = new Button("Reset");
        this.resetButton.disable();
        this.add(this.resetButton);
        this.stepping = new Checkbox("Einzelschritt", null, true);
        this.stepping.disable();
        fsa.setStepping(true);
        this.add(this.stepping);
        this.r.move(this.r.left(this.editMode), this.r.left(this));
        this.r.move(this.r.top(this.editMode), this.r.top(this));
        this.r.move(this.r.left(this.runMode), this.r.left(this));
        this.r.move(this.r.top(this.runMode), this.r.bottom(this.editMode));
        this.r.move(this.r.left(label), this.r.left(this));
        this.r.move(this.r.top(label), this.r.bottom(this.runMode));
        this.r.move(this.r.top(this.stringField), this.r.bottom(label));
        this.r.move(this.r.left(this.stringField), this.r.left(this));
        this.r.stretch(this.r.right(this.stringField), this.r.right(this));
        this.r.stretch(this.r.width(this.startButton), this.r.width(this.suspendButton));
        this.r.stretch(this.r.width(this.resetButton), this.r.width(this.suspendButton));
        this.r.move(this.r.top(this.startButton), this.r.bottom(this.stringField));
        this.r.move(this.r.left(this.startButton), this.r.left(this));
        this.r.move(this.r.top(this.suspendButton), this.r.bottom(this.startButton));
        this.r.move(this.r.left(this.suspendButton), this.r.left(this));
        this.r.move(this.r.top(this.resetButton), this.r.bottom(this.suspendButton));
        this.r.move(this.r.left(this.resetButton), this.r.left(this));
        this.r.move(this.r.top(this.stepping), this.r.bottom(this.resetButton));
        this.r.move(this.r.left(this.stepping), this.r.left(this));
        this.setLayout(this.r);
        if (this.statusBar != null) {
            this.statusBar.setText("Editiermodus");
        }
    }
}

