/*
 * Decompiled with CFR 0.152.
 */
package sum.transduktor;

import java.awt.Point;
import sum.transduktor.Direction;
import sum.transduktor.Edge;
import sum.transduktor.Guide;
import sum.transduktor.Node;
import sum.transduktor.Tourist;

class StraightGuide
implements Guide {
    Point goal;
    int state;
    double touristX;
    double touristY;
    Tourist tourist;
    Edge edge;
    Node destination;
    Direction dir;
    static final int BEFORE_START = 0;
    static final int ON_EDGE = 1;
    static final int AFTER_END = 2;

    StraightGuide(Tourist t, Edge e) {
        this.tourist = t;
        this.edge = e;
        this.destination = this.edge.getDestination();
        Point tp = t.getPosition();
        this.touristX = tp.x;
        this.touristY = tp.y;
        this.state = 0;
        this.goal = this.edge.getStart();
        this.dir = new Direction(0, 0, 0, 0);
    }

    public Point nextPosition() {
        Point tp = this.tourist.getPosition();
        if (tp.equals(this.goal)) {
            switch (this.state) {
                case 0: {
                    this.state = 1;
                    this.goal = this.edge.getEnd();
                    break;
                }
                case 1: {
                    this.state = 2;
                    this.goal = this.destination.getPosition();
                    break;
                }
                case 2: {
                    this.tourist.setOutput(this.edge.getOutput());
                    this.tourist.guideFinished();
                    this.tourist.setLocation(this.destination);
                    return tp;
                }
            }
        }
        this.dir.set(tp, this.goal);
        do {
            this.touristX += this.dir.x_dir;
            this.touristY += this.dir.y_dir;
        } while ((int)this.touristX == tp.x && (int)this.touristY == tp.y);
        tp.move((int)this.touristX, (int)this.touristY);
        return tp;
    }
}

