/*
 * Decompiled with CFR 0.152.
 */
package sum.transduktor;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;

public class FlexibleLabel
extends Canvas {
    String labelText;
    Font font;
    Dimension dim;
    Toolkit tk;
    Image img;
    int baseline;
    int x;
    int y;

    public void paint(Graphics g) {
        g.drawImage(this.img, 0, 0, this);
    }

    public void addNotify() {
        super.addNotify();
        this.tk = this.getToolkit();
        Font f = this.getFont();
        this.font = new Font(f.getName(), 0, f.getSize());
        FontMetrics fm = this.tk.getFontMetrics(this.font);
        this.dim = new Dimension(0, fm.getHeight());
        this.baseline = fm.getAscent();
        this.setString(this.labelText);
    }

    public void paint(Graphics g, int x, int y) {
        g.drawImage(this.img, x - this.dim.width, y - this.baseline, this);
    }

    void setString(String text) {
        if (this.img != null && text.equals(this.labelText)) {
            return;
        }
        int length = text.length();
        StringBuffer sb = new StringBuffer();
        boolean backslash = false;
        Font curFont = this.font;
        block4: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\\': {
                    if (backslash) {
                        backslash = false;
                        sb.append(c);
                        continue block4;
                    }
                    backslash = true;
                    continue block4;
                }
                case 'b': 
                case 'i': {
                    if (!backslash) {
                        sb.append(c);
                        continue block4;
                    }
                    backslash = false;
                    if (sb.length() > 0) {
                        this.dim.width += this.tk.getFontMetrics(curFont).stringWidth(sb.toString());
                        sb.setLength(0);
                    }
                    if (c == 'i') {
                        curFont = new Font(curFont.getName(), curFont.getStyle() ^ 2, curFont.getSize());
                        continue block4;
                    }
                    curFont = new Font(curFont.getName(), curFont.getStyle() ^ 1, curFont.getSize());
                    continue block4;
                }
                default: {
                    sb.append(c);
                    if (!backslash) continue block4;
                    backslash = false;
                }
            }
        }
        if (sb.length() > 0) {
            this.dim.width += this.tk.getFontMetrics(curFont).stringWidth(sb.toString());
        }
        this.img = super.createImage(this.dim.width, this.dim.height);
        this.drawImage(this.img.getGraphics());
    }

    public Dimension minimumSize() {
        return new Dimension(this.dim);
    }

    int width() {
        return this.dim.width;
    }

    void drawImage(Graphics g) {
        Font curFont = this.font;
        int length = this.labelText.length();
        int curWidth = 0;
        StringBuffer sb = new StringBuffer();
        boolean backslash = false;
        block4: for (int i = 0; i < length; ++i) {
            char c = this.labelText.charAt(i);
            switch (c) {
                case '\\': {
                    if (backslash) {
                        backslash = false;
                        sb.append(c);
                        continue block4;
                    }
                    backslash = true;
                    continue block4;
                }
                case 'b': 
                case 'i': {
                    if (!backslash) {
                        sb.append(c);
                        continue block4;
                    }
                    backslash = false;
                    if (sb.length() > 0) {
                        String temp = sb.toString();
                        g.setFont(curFont);
                        g.drawString(temp, curWidth, this.baseline);
                        curWidth += this.tk.getFontMetrics(curFont).stringWidth(temp);
                        sb.setLength(0);
                    }
                    if (c == 'i') {
                        curFont = new Font(curFont.getName(), curFont.getStyle() ^ 2, curFont.getSize());
                        continue block4;
                    }
                    curFont = new Font(curFont.getName(), curFont.getStyle() ^ 1, curFont.getSize());
                    continue block4;
                }
                default: {
                    sb.append(c);
                    if (!backslash) continue block4;
                    backslash = false;
                }
            }
        }
        if (sb.length() > 0) {
            String temp = sb.toString();
            g.setFont(curFont);
            g.drawString(temp, curWidth, this.baseline);
        }
    }

    public Dimension preferredSize() {
        return new Dimension(this.dim);
    }

    int ascent() {
        return this.baseline;
    }

    FlexibleLabel(String text) {
        this.labelText = text;
    }
}

