/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import io.github.classgraph.ModuleReaderProxy;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.FastPathResolver;
import io.github.classgraph.utils.FileUtils;
import io.github.classgraph.utils.JarUtils;
import io.github.classgraph.utils.JarfileMetadataReader;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.Recycler;
import io.github.classgraph.utils.SingletonMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class NestedJarHandler {
    private final ConcurrentLinkedDeque<File> tempFiles = new ConcurrentLinkedDeque();
    private final SingletonMap<String, Map.Entry<File, Set<String>>> nestedPathToJarfileAndRootRelativePathsMap;
    private final SingletonMap<File, Recycler<ZipFile, IOException>> zipFileToRecyclerMap = new SingletonMap<File, Recycler<ZipFile, IOException>>(){

        @Override
        public Recycler<ZipFile, IOException> newInstance(final File zipFile, LogNode log) throws Exception {
            return new Recycler<ZipFile, IOException>(){

                @Override
                public ZipFile newInstance() throws IOException {
                    return new ZipFile(zipFile.getPath());
                }
            };
        }
    };
    private final ConcurrentHashMap<File, File> innerJarToOuterJarMap;
    private final SingletonMap<File, JarfileMetadataReader> zipFileToJarfileMetadataReaderMap;
    private final SingletonMap<ModuleRef, Recycler<ModuleReaderProxy, IOException>> moduleRefToModuleReaderProxyRecyclerMap;
    private final SingletonMap<File, Boolean> mkDirs;
    public static final String TEMP_FILENAME_LEAF_SEPARATOR = "---";

    public NestedJarHandler(final ScanSpec scanSpec, LogNode log) {
        this.zipFileToJarfileMetadataReaderMap = new SingletonMap<File, JarfileMetadataReader>(){

            @Override
            public JarfileMetadataReader newInstance(File canonicalFile, LogNode log) throws Exception {
                return new JarfileMetadataReader(canonicalFile, scanSpec, log);
            }
        };
        this.innerJarToOuterJarMap = new ConcurrentHashMap();
        this.moduleRefToModuleReaderProxyRecyclerMap = new SingletonMap<ModuleRef, Recycler<ModuleReaderProxy, IOException>>(){

            @Override
            public Recycler<ModuleReaderProxy, IOException> newInstance(final ModuleRef moduleRef, LogNode log) throws Exception {
                return new Recycler<ModuleReaderProxy, IOException>(){

                    @Override
                    public ModuleReaderProxy newInstance() throws IOException {
                        return moduleRef.open();
                    }
                };
            }
        };
        this.nestedPathToJarfileAndRootRelativePathsMap = new SingletonMap<String, Map.Entry<File, Set<String>>>(){

            @Override
            public Map.Entry<File, Set<String>> newInstance(String nestedJarPath, LogNode log) throws Exception {
                int lastPlingIdx = nestedJarPath.lastIndexOf(33);
                if (lastPlingIdx < 0) {
                    File canonicalFile;
                    File pathFile;
                    boolean isRemote = nestedJarPath.startsWith("http://") || nestedJarPath.startsWith("https://");
                    File file = pathFile = isRemote ? NestedJarHandler.this.downloadTempFile(nestedJarPath, log) : new File(nestedJarPath);
                    if (isRemote && pathFile == null) {
                        throw new IOException("Could not download jarfile " + nestedJarPath);
                    }
                    try {
                        canonicalFile = pathFile.getCanonicalFile();
                    }
                    catch (SecurityException e) {
                        throw new IOException("Path component " + nestedJarPath + " could not be canonicalized: " + e);
                    }
                    if (!FileUtils.canRead(canonicalFile)) {
                        throw new IOException("Path component " + nestedJarPath + " does not exist");
                    }
                    if (!canonicalFile.isFile()) {
                        throw new IOException("Path component " + nestedJarPath + "  is not a file (expected a jarfile)");
                    }
                    File bareJarfile = scanSpec.stripSFXHeader ? NestedJarHandler.this.stripSFXHeader(canonicalFile, log) : canonicalFile;
                    HashSet rootRelativePaths = new HashSet();
                    return new AbstractMap.SimpleEntry<File, Set<String>>(bareJarfile, rootRelativePaths);
                }
                String parentPath = nestedJarPath.substring(0, lastPlingIdx);
                String childPath = nestedJarPath.substring(lastPlingIdx + 1);
                while (childPath.startsWith("/")) {
                    childPath = childPath.substring(1);
                }
                Map.Entry parentJarfileAndRootRelativePaths = (Map.Entry)NestedJarHandler.this.nestedPathToJarfileAndRootRelativePathsMap.getOrCreateSingleton(parentPath, log);
                if (parentJarfileAndRootRelativePaths == null) {
                    throw new IOException("Could not find parent jarfile " + parentPath);
                }
                File parentJarFile = (File)parentJarfileAndRootRelativePaths.getKey();
                if (parentJarFile == null) {
                    throw new IOException("Could not find parent jarfile " + parentPath);
                }
                String parentJarFilePath = FastPathResolver.resolve(parentJarFile.getPath());
                if (!parentJarFilePath.equals(parentPath)) {
                    String pathWithinParent = parentJarFilePath + "!" + childPath;
                    Map.Entry nextLevel = (Map.Entry)NestedJarHandler.this.nestedPathToJarfileAndRootRelativePathsMap.getOrCreateSingleton(pathWithinParent, log);
                    if (nextLevel != null) {
                        return nextLevel;
                    }
                    throw new IOException("Could not find jarfile path " + pathWithinParent);
                }
                Recycler parentJarRecycler = (Recycler)NestedJarHandler.this.zipFileToRecyclerMap.getOrCreateSingleton(parentJarFile.getCanonicalFile(), log);
                try (Recycler.Recyclable parentRecyclable = parentJarRecycler.acquire();){
                    Object zipEntries;
                    ZipEntry childZipEntry;
                    ZipFile parentZipFile = (ZipFile)parentRecyclable.get();
                    if (childPath.endsWith("/")) {
                        childZipEntry = parentZipFile.getEntry(childPath);
                    } else {
                        childZipEntry = parentZipFile.getEntry(childPath + "/");
                        if (childZipEntry == null) {
                            childZipEntry = parentZipFile.getEntry(childPath);
                        }
                    }
                    boolean isDirectory = false;
                    if (childZipEntry == null) {
                        String pathPrefix = childPath.endsWith("/") ? childPath : childPath + "/";
                        zipEntries = parentZipFile.entries();
                        while (zipEntries.hasMoreElements()) {
                            ZipEntry zipEntry = zipEntries.nextElement();
                            if (!zipEntry.getName().startsWith(pathPrefix)) continue;
                            isDirectory = true;
                            break;
                        }
                        if (!isDirectory) {
                            throw new IOException("Path " + childPath + " does not exist in jarfile " + parentJarFile);
                        }
                    } else {
                        isDirectory = childZipEntry.isDirectory();
                    }
                    if (isDirectory) {
                        boolean childPathIsLeaf;
                        boolean bl = childPathIsLeaf = childPath.indexOf("!") < 0;
                        if (!childPathIsLeaf) {
                            throw new IOException("Path " + childPath + " in jarfile " + parentJarFile + " is a directory, but this is not the last \"!\"-delimited section of the claspath entry URL -- cannot use as package root");
                        }
                        if (log != null) {
                            log.log("Path " + childPath + " in jarfile " + parentJarFile + " is a directory, not a file -- using as package root");
                        }
                        if (!childPath.isEmpty()) {
                            ((Set)parentJarfileAndRootRelativePaths.getValue()).add(childPath);
                        }
                        zipEntries = parentJarfileAndRootRelativePaths;
                        return zipEntries;
                    }
                    if (!scanSpec.scanNestedJars) {
                        throw new IOException("Nested jar scanning is disabled -- skipping extraction of nested jar " + nestedJarPath);
                    }
                    try {
                        File childJarFile = NestedJarHandler.this.unzipToTempFile(parentZipFile, childZipEntry, log);
                        File noHeaderChildJarFile = scanSpec.stripSFXHeader ? NestedJarHandler.this.stripSFXHeader(childJarFile, log) : childJarFile;
                        NestedJarHandler.this.innerJarToOuterJarMap.put(noHeaderChildJarFile, parentJarFile);
                        HashSet rootRelativePaths = new HashSet();
                        AbstractMap.SimpleEntry<File, Set<String>> simpleEntry = new AbstractMap.SimpleEntry<File, Set<String>>(noHeaderChildJarFile, rootRelativePaths);
                        return simpleEntry;
                    }
                    catch (IOException e) {
                        throw new IOException("File does not appear to be a zipfile: " + childPath);
                    }
                }
            }
        };
        this.mkDirs = new SingletonMap<File, Boolean>(){

            @Override
            public Boolean newInstance(File dir, LogNode log) throws Exception {
                File parentDir;
                boolean dirExists = dir.exists();
                if (!dirExists && ((parentDir = dir.getParentFile()) == null || ((Boolean)NestedJarHandler.this.mkDirs.getOrCreateSingleton(parentDir, log)).booleanValue())) {
                    dirExists = dir.mkdir();
                    if (!dirExists) {
                        dirExists = dir.exists();
                    }
                    if (log != null) {
                        if (!dirExists) {
                            log.log("Cannot create directory: " + dir.toPath());
                        } else if (!dir.isDirectory()) {
                            log.log("Can't overwrite a file with a directory: " + dir.toPath());
                        } else {
                            log.log("Creating directory: " + dir.toPath());
                        }
                    }
                    if (!dir.isDirectory()) {
                        dirExists = false;
                    }
                    if (dirExists) {
                        dir.deleteOnExit();
                        NestedJarHandler.this.tempFiles.add(dir);
                    }
                }
                return dirExists;
            }
        };
    }

    public Recycler<ZipFile, IOException> getZipFileRecycler(File zipFile, LogNode log) throws Exception {
        return this.zipFileToRecyclerMap.getOrCreateSingleton(zipFile, log);
    }

    public JarfileMetadataReader getJarfileMetadataReader(File zipFile, LogNode log) throws Exception {
        JarfileMetadataReader jarfileMetadataReader = this.zipFileToJarfileMetadataReaderMap.getOrCreateSingleton(zipFile, log);
        return jarfileMetadataReader;
    }

    public Recycler<ModuleReaderProxy, IOException> getModuleReaderProxyRecycler(ModuleRef moduleRef, LogNode log) throws Exception {
        return this.moduleRefToModuleReaderProxyRecyclerMap.getOrCreateSingleton(moduleRef, log);
    }

    public Map.Entry<File, Set<String>> getInnermostNestedJar(String nestedJarPath, LogNode log) throws Exception {
        return this.nestedPathToJarfileAndRootRelativePathsMap.getOrCreateSingleton(nestedJarPath, log);
    }

    public File getOutermostJar(File jarFile) {
        File lastValid = jarFile;
        File curr = jarFile;
        while (curr != null) {
            lastValid = curr;
            curr = this.innerJarToOuterJarMap.get(curr);
        }
        return lastValid;
    }

    private String leafname(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private String sanitizeFilename(String filename) {
        return filename.replace('/', '_').replace('\\', '_').replace(':', '_').replace('?', '_').replace('&', '_').replace('=', '_').replace(' ', '_');
    }

    private File downloadTempFile(String jarURL, LogNode log) {
        LogNode subLog = log == null ? null : log.log(jarURL, "Downloading URL " + jarURL);
        File tempFile = null;
        try {
            String suffix = TEMP_FILENAME_LEAF_SEPARATOR + this.sanitizeFilename(this.leafname(jarURL));
            tempFile = File.createTempFile("ClassGraph--", suffix);
            tempFile.deleteOnExit();
            this.tempFiles.add(tempFile);
            URL url = new URL(jarURL);
            try (InputStream inputStream = url.openStream();){
                Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            if (subLog != null) {
                subLog.addElapsedTime();
            }
        }
        catch (Exception e) {
            if (subLog != null) {
                subLog.log("Could not download " + jarURL, e);
            }
            return null;
        }
        if (subLog != null) {
            subLog.log("Downloaded to temporary file " + tempFile);
            subLog.log("***** Note that it is time-consuming to scan jars at http(s) addresses, they must be downloaded for every scan, and the same jars must also be separately downloaded by the ClassLoader *****");
        }
        return tempFile;
    }

    private File unzipToTempFile(ZipFile zipFile, ZipEntry zipEntry, LogNode log) throws IOException {
        String zipEntryPath = zipEntry.getName();
        if (zipEntryPath.startsWith("/")) {
            zipEntryPath = zipEntryPath.substring(1);
        }
        File tempFile = File.createTempFile("ClassGraph--", TEMP_FILENAME_LEAF_SEPARATOR + this.sanitizeFilename(this.leafname(zipEntryPath)));
        tempFile.deleteOnExit();
        this.tempFiles.add(tempFile);
        LogNode subLog = null;
        if (log != null) {
            subLog = log.log("Unzipping " + zipFile.getName() + "!/" + zipEntryPath).log("Extracted to temporary file " + tempFile.getPath());
        }
        try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
            Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if (subLog != null) {
            subLog.addElapsedTime();
        }
        return tempFile;
    }

    private File stripSFXHeader(File zipfile, LogNode log) throws IOException {
        long sfxHeaderBytes = JarUtils.countBytesBeforePKMarker(zipfile);
        if (sfxHeaderBytes == -1L) {
            throw new IOException("Could not find zipfile \"PK\" marker in file " + zipfile);
        }
        if (sfxHeaderBytes == 0L) {
            return zipfile;
        }
        File bareZipfile = File.createTempFile("ClassGraph--", TEMP_FILENAME_LEAF_SEPARATOR + JarUtils.leafName(zipfile.getName()));
        bareZipfile.deleteOnExit();
        this.tempFiles.add(bareZipfile);
        if (log != null) {
            log.log("Zipfile " + zipfile + " contains a self-extracting executable header of " + sfxHeaderBytes + " bytes. Stripping off header to create bare zipfile " + bareZipfile);
        }
        JarUtils.stripSFXHeader(zipfile, sfxHeaderBytes, bareZipfile);
        return bareZipfile;
    }

    public void closeRecyclers() {
        List<Recycler<Closeable, IOException>> recyclers;
        if (this.zipFileToRecyclerMap != null) {
            recyclers = null;
            try {
                recyclers = this.zipFileToRecyclerMap.values();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (recyclers != null) {
                for (Recycler<Closeable, IOException> recycler : recyclers) {
                    recycler.close();
                }
            }
        }
        if (this.moduleRefToModuleReaderProxyRecyclerMap != null) {
            recyclers = null;
            try {
                recyclers = this.moduleRefToModuleReaderProxyRecyclerMap.values();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (recyclers != null) {
                for (Recycler<Closeable, IOException> recycler : recyclers) {
                    recycler.close();
                }
            }
        }
    }

    public void close(LogNode log) {
        this.closeRecyclers();
        if (this.tempFiles != null) {
            LogNode rmLog;
            LogNode logNode = rmLog = this.tempFiles.isEmpty() || log == null ? null : log.log("Removing temporary files");
            while (!this.tempFiles.isEmpty()) {
                File tempFile = this.tempFiles.removeLast();
                String path = tempFile.getPath();
                boolean success = false;
                Throwable e = null;
                try {
                    success = tempFile.delete();
                }
                catch (Throwable t) {
                    e = t;
                }
                if (log == null) continue;
                rmLog.log((success ? "Removed" : "Unable to remove") + " " + path + (e == null ? "" : " : " + e));
            }
        }
    }
}

