/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.FastPathResolver;
import io.github.classgraph.utils.FileUtils;
import io.github.classgraph.utils.LogNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JarUtils {
    private static final String[] UNIX_NON_PATH_SEPARATORS;
    private static final int[] UNIX_NON_PATH_SEPARATOR_COLON_POSITIONS;
    private static final List<String> JRE_JARS;
    private static final Set<String> JRE_JARS_SET;
    private static final Set<String> JRE_LIB_OR_EXT_JARS;
    public static final String[] SYSTEM_PACKAGE_PREFIXES;
    public static final String[] SYSTEM_PACKAGE_PATH_PREFIXES;

    public static String[] smartPathSplit(String pathStr) {
        if (pathStr == null || pathStr.isEmpty()) {
            return new String[0];
        }
        if (File.pathSeparatorChar == ':') {
            HashSet<Integer> splitPoints = new HashSet<Integer>();
            int i = -1;
            do {
                boolean foundNonPathSeparator = false;
                for (int j = 0; j < UNIX_NON_PATH_SEPARATORS.length; ++j) {
                    int startIdx = i - UNIX_NON_PATH_SEPARATOR_COLON_POSITIONS[j];
                    if (!pathStr.regionMatches(true, startIdx, UNIX_NON_PATH_SEPARATORS[j], 0, UNIX_NON_PATH_SEPARATORS[j].length()) || startIdx != 0 && pathStr.charAt(startIdx - 1) != ':') continue;
                    foundNonPathSeparator = true;
                    break;
                }
                if (foundNonPathSeparator) continue;
                splitPoints.add(i);
            } while ((i = pathStr.indexOf(58, i + 1)) >= 0);
            splitPoints.add(pathStr.length());
            ArrayList splitPointsSorted = new ArrayList(splitPoints);
            Collections.sort(splitPointsSorted);
            ArrayList<String> parts = new ArrayList<String>();
            for (int i2 = 1; i2 < splitPointsSorted.size(); ++i2) {
                int idx0 = (Integer)splitPointsSorted.get(i2 - 1);
                int idx1 = (Integer)splitPointsSorted.get(i2);
                String part = pathStr.substring(idx0 + 1, idx1).trim();
                if ((part = part.replaceAll("\\\\:", ":")).isEmpty()) continue;
                parts.add(part);
            }
            return parts.toArray(new String[0]);
        }
        ArrayList<String> partsFiltered = new ArrayList<String>();
        for (String part : pathStr.split(File.pathSeparator)) {
            String partFiltered = part.trim();
            if (partFiltered.isEmpty()) continue;
            partsFiltered.add(partFiltered);
        }
        return partsFiltered.toArray(new String[0]);
    }

    public static ClassLoader createURLClassLoaderFromPathString(String classpathStr) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String pathEltStr : JarUtils.smartPathSplit(classpathStr)) {
            try {
                URL url = new URL(pathEltStr);
                urls.add(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]));
    }

    private static void appendPathElt(Object pathElt, StringBuilder buf) {
        if (buf.length() > 0) {
            buf.append(File.pathSeparatorChar);
        }
        String path = File.separatorChar == '\\' ? pathElt.toString() : pathElt.toString().replaceAll(File.pathSeparator, "\\" + File.pathSeparator);
        buf.append(path);
    }

    public static String pathElementsToPathStr(Object ... pathElts) {
        StringBuilder buf = new StringBuilder();
        for (Object pathElt : pathElts) {
            JarUtils.appendPathElt(pathElt, buf);
        }
        return buf.toString();
    }

    public static String pathElementsToPathStr(Iterable<?> pathElts) {
        StringBuilder buf = new StringBuilder();
        for (Object pathElt : pathElts) {
            JarUtils.appendPathElt(pathElt, buf);
        }
        return buf.toString();
    }

    public static String leafName(String path) {
        int bangIdx = path.indexOf("!");
        int endIdx = bangIdx >= 0 ? bangIdx : path.length();
        int leafStartIdx = 1 + (File.separatorChar == '/' ? path.lastIndexOf(47, endIdx) : Math.max(path.lastIndexOf(47, endIdx), path.lastIndexOf(File.separatorChar, endIdx)));
        int sepIdx = path.indexOf("---");
        if (sepIdx >= 0) {
            sepIdx += "---".length();
        }
        leafStartIdx = Math.max(leafStartIdx, sepIdx);
        leafStartIdx = Math.min(leafStartIdx, endIdx);
        return path.substring(leafStartIdx, endIdx);
    }

    private static String getProperty(String propName) {
        try {
            return System.getProperty(propName);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static void addJRERoot(File jreRoot, Set<File> jreDirsSet, List<File> rtJarFiles) {
        File rtJarFile;
        File libFile;
        if (JarUtils.addJREPath(jreRoot, jreDirsSet) && FileUtils.canRead(libFile = new File(jreRoot, "lib")) && libFile.isDirectory() && JarUtils.addJREPath(libFile, jreDirsSet) && FileUtils.canRead(rtJarFile = new File(libFile, "rt.jar")) && !rtJarFiles.contains(rtJarFile)) {
            rtJarFiles.add(rtJarFile);
        }
    }

    private static boolean addJREPath(File dir, Set<File> jreLibExtDirsSet) {
        if (FileUtils.canRead(dir) && dir.isDirectory()) {
            try {
                File canonicalDir = dir.getCanonicalFile();
                jreLibExtDirsSet.add(canonicalDir);
                return true;
            }
            catch (IOException | SecurityException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static List<String> getJreJarPaths() {
        return JRE_JARS;
    }

    public static Set<String> getJreLibOrExtJars() {
        return JRE_LIB_OR_EXT_JARS;
    }

    public static boolean isJREJar(String filePath, ScanSpec scanSpec, LogNode log) {
        if (JRE_LIB_OR_EXT_JARS.contains(filePath) && scanSpec.libOrExtJarWhiteBlackList.isSpecificallyWhitelistedAndNotBlacklisted(filePath)) {
            return false;
        }
        return JRE_JARS_SET.contains(filePath);
    }

    public static boolean isInSystemPackageOrModule(String packageOrModuleName) {
        for (int i = 0; i < SYSTEM_PACKAGE_PREFIXES.length; ++i) {
            if (!packageOrModuleName.startsWith(SYSTEM_PACKAGE_PREFIXES[i])) continue;
            return true;
        }
        return false;
    }

    public static long countBytesBeforePKMarker(File zipfile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(zipfile));){
            int c;
            boolean readP = false;
            long fileIdx = 0L;
            while ((c = reader.read()) != -1) {
                if (!readP) {
                    if (c == 80) {
                        readP = true;
                    }
                } else {
                    if (c == 75) {
                        long l = fileIdx - 1L;
                        return l;
                    }
                    readP = false;
                }
                ++fileIdx;
            }
            long l = -1L;
            return l;
        }
    }

    public static void stripSFXHeader(File srcZipfile, long sfxHeaderBytes, File destZipfile) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(srcZipfile);
             FileChannel inputChannel = inputStream.getChannel();
             FileOutputStream outputStream = new FileOutputStream(destZipfile);
             FileChannel outputChannel = outputStream.getChannel();){
            inputChannel.position(sfxHeaderBytes);
            outputChannel.transferFrom(inputChannel, 0L, inputChannel.size());
        }
    }

    public static void logJavaInfo(LogNode log) {
        if (log != null) {
            log.log("Operating system: " + JarUtils.getProperty("os.name") + " " + JarUtils.getProperty("os.version") + " " + JarUtils.getProperty("os.arch"));
            log.log("Java version: " + JarUtils.getProperty("java.version") + " / " + JarUtils.getProperty("java.runtime.version") + " (" + JarUtils.getProperty("java.vendor") + ")");
            log.log("JRE jars:").log(JRE_JARS);
        }
    }

    static {
        String rtJarPath;
        String javaExtDirs;
        UNIX_NON_PATH_SEPARATORS = new String[]{"jar:", "file:", "http://", "https://", "\\:"};
        UNIX_NON_PATH_SEPARATOR_COLON_POSITIONS = new int[UNIX_NON_PATH_SEPARATORS.length];
        for (int i = 0; i < UNIX_NON_PATH_SEPARATORS.length; ++i) {
            JarUtils.UNIX_NON_PATH_SEPARATOR_COLON_POSITIONS[i] = UNIX_NON_PATH_SEPARATORS[i].indexOf(58);
            if (UNIX_NON_PATH_SEPARATOR_COLON_POSITIONS[i] >= 0) continue;
            throw new RuntimeException("Could not find ':' in \"" + UNIX_NON_PATH_SEPARATORS[i] + "\"");
        }
        JRE_JARS = new ArrayList<String>();
        JRE_JARS_SET = new HashSet<String>();
        JRE_LIB_OR_EXT_JARS = new HashSet<String>();
        HashSet<File> jreDirsSet = new HashSet<File>();
        ArrayList<File> jreRtJarFiles = new ArrayList<File>();
        HashSet<File> javaLibExtDirsSet = new HashSet<File>();
        String javaHome = JarUtils.getProperty("java.home");
        if (javaHome != null && !javaHome.isEmpty()) {
            File javaHomeFile = new File(javaHome);
            JarUtils.addJRERoot(javaHomeFile, jreDirsSet, jreRtJarFiles);
            if (javaHomeFile.getName().equals("jre")) {
                JarUtils.addJRERoot(javaHomeFile.getParentFile(), jreDirsSet, jreRtJarFiles);
            } else {
                JarUtils.addJRERoot(new File(javaHomeFile, "jre"), jreDirsSet, jreRtJarFiles);
            }
            JarUtils.addJREPath(new File(javaHomeFile, "lib"), javaLibExtDirsSet);
            JarUtils.addJREPath(new File(javaHomeFile, "lib/ext"), javaLibExtDirsSet);
            JarUtils.addJREPath(new File(javaHomeFile, "jre/lib"), javaLibExtDirsSet);
            JarUtils.addJREPath(new File(javaHomeFile, "jre/lib/ext"), javaLibExtDirsSet);
            JarUtils.addJREPath(new File(javaHomeFile, "packages"), javaLibExtDirsSet);
            JarUtils.addJREPath(new File(javaHomeFile, "packages/lib"), javaLibExtDirsSet);
            JarUtils.addJREPath(new File(javaHomeFile, "packages/lib/ext"), javaLibExtDirsSet);
        }
        if ((javaExtDirs = JarUtils.getProperty("java.ext.dirs")) != null) {
            for (String javaExtDir : JarUtils.smartPathSplit(javaExtDirs)) {
                if (javaExtDir.isEmpty()) continue;
                JarUtils.addJREPath(new File(javaExtDir), javaLibExtDirsSet);
            }
        }
        jreDirsSet.addAll(javaLibExtDirsSet);
        JarUtils.addJRERoot(new File("/System/Library/Java"), jreDirsSet, jreRtJarFiles);
        JarUtils.addJREPath(new File("/System/Library/Java/Libraries"), javaLibExtDirsSet);
        JarUtils.addJREPath(new File("/System/Library/Java/Extensions"), javaLibExtDirsSet);
        JarUtils.addJREPath(new File("/usr/java/packages"), javaLibExtDirsSet);
        JarUtils.addJREPath(new File("/usr/java/packages/lib"), javaLibExtDirsSet);
        JarUtils.addJREPath(new File("/usr/java/packages/lib/ext"), javaLibExtDirsSet);
        JarUtils.addJREPath(new File("/usr/jdk/packages"), javaLibExtDirsSet);
        JarUtils.addJREPath(new File("/usr/jdk/packages/lib"), javaLibExtDirsSet);
        JarUtils.addJREPath(new File("/usr/jdk/packages/lib/ext"), javaLibExtDirsSet);
        try {
            String systemRoot;
            String string = systemRoot = File.separatorChar == '\\' ? System.getenv("SystemRoot") : null;
            if (systemRoot != null) {
                JarUtils.addJRERoot(new File(systemRoot, "Sun\\Java"), jreDirsSet, jreRtJarFiles);
                JarUtils.addJREPath(new File(systemRoot, "Sun\\Java\\lib"), javaLibExtDirsSet);
                JarUtils.addJREPath(new File(systemRoot, "Sun\\Java\\lib\\ext"), javaLibExtDirsSet);
                JarUtils.addJRERoot(new File(systemRoot, "Oracle\\Java"), jreDirsSet, jreRtJarFiles);
                JarUtils.addJREPath(new File(systemRoot, "Oracle\\Java\\lib"), javaLibExtDirsSet);
                JarUtils.addJREPath(new File(systemRoot, "Oracle\\Java\\lib\\ext"), javaLibExtDirsSet);
            }
        }
        catch (Exception systemRoot) {
            // empty catch block
        }
        ArrayList<String> libExtJarPaths = new ArrayList<String>();
        for (File jreLibExtDir : javaLibExtDirsSet) {
            for (File file : jreLibExtDir.listFiles()) {
                if (!file.getPath().endsWith(".jar") || jreRtJarFiles.contains(file)) continue;
                libExtJarPaths.add(FastPathResolver.resolve(file.getPath()));
            }
        }
        Collections.sort(libExtJarPaths);
        JRE_LIB_OR_EXT_JARS.addAll(libExtJarPaths);
        String string = rtJarPath = jreRtJarFiles.size() > 0 ? FastPathResolver.resolve(((File)jreRtJarFiles.get(0)).getPath()) : null;
        if (rtJarPath != null) {
            JRE_JARS.add(rtJarPath);
        }
        JRE_JARS.addAll(libExtJarPaths);
        JRE_JARS_SET.addAll(JRE_JARS);
        SYSTEM_PACKAGE_PREFIXES = new String[]{"java.", "javax.", "javafx.", "jdk.", "oracle.", "sun."};
        SYSTEM_PACKAGE_PATH_PREFIXES = new String[SYSTEM_PACKAGE_PREFIXES.length];
        for (int i = 0; i < SYSTEM_PACKAGE_PREFIXES.length; ++i) {
            JarUtils.SYSTEM_PACKAGE_PATH_PREFIXES[i] = SYSTEM_PACKAGE_PREFIXES[i].replace('.', '/');
        }
    }
}

