/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.editor.moe.MoeEditorPane;
import bluej.utility.javafx.FXPlatformRunnable;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.util.UndoUtils;
import org.fxmisc.undo.UndoManager;

public class MoeUndoManager {
    private UndoManager undoManager;
    private BooleanProperty canUndo;
    private BooleanProperty canRedo;

    public MoeUndoManager(MoeEditorPane editorPane) {
        this.undoManager = UndoUtils.plainTextUndoManager((GenericStyledArea)editorPane);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void compoundEdit(FXPlatformRunnable edit) {
        this.breakEdit();
        edit.run();
        this.breakEdit();
    }

    public BooleanExpression canUndo() {
        if (this.canUndo == null) {
            this.canUndo = new SimpleBooleanProperty();
            this.canUndo.bind((ObservableValue)this.undoManager.undoAvailableProperty());
        }
        return this.canUndo;
    }

    public BooleanExpression canRedo() {
        if (this.canRedo == null) {
            this.canRedo = new SimpleBooleanProperty();
            this.canRedo.bind((ObservableValue)this.undoManager.redoAvailableProperty());
        }
        return this.canRedo;
    }

    public void undo() {
        this.undoManager.undo();
    }

    public void redo() {
        this.undoManager.redo();
    }

    public void forgetHistory() {
        this.undoManager.forgetHistory();
    }

    public void breakEdit() {
        this.undoManager.preventMerge();
    }
}

