/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.editor.moe.MoeSyntaxDocument;
import bluej.parser.nodes.NodeStructureListener;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class MoeSyntaxEvent
implements NodeStructureListener {
    private final int offset;
    private final int length;
    private final MoeSyntaxDocument document;
    private final List<NodeTree.NodeAndPosition<ParsedNode>> removedNodes = new ArrayList<NodeTree.NodeAndPosition<ParsedNode>>();
    private final Map<ParsedNode, NodeChangeRecord> changedNodes = new HashMap<ParsedNode, NodeChangeRecord>();
    private final boolean insert;
    private final boolean remove;

    public MoeSyntaxEvent(MoeSyntaxDocument document, int offset, int length, boolean isInsert, boolean isRemove) {
        this.document = document;
        this.offset = offset;
        this.length = length;
        this.insert = isInsert;
        this.remove = isRemove;
    }

    public List<NodeTree.NodeAndPosition<ParsedNode>> getRemovedNodes() {
        return this.removedNodes;
    }

    public Collection<NodeChangeRecord> getChangedNodes() {
        return this.changedNodes.values();
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void nodeRemoved(NodeTree.NodeAndPosition<ParsedNode> node) {
        this.removedNodes.add(node);
        this.changedNodes.remove(node.getNode());
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void nodeChangedLength(NodeTree.NodeAndPosition<ParsedNode> nap, int oldPos, int oldSize) {
        NodeChangeRecord r = this.changedNodes.get(nap.getNode());
        if (r == null) {
            if (nap.getPosition() != oldPos || nap.getSize() != oldSize) {
                r = new NodeChangeRecord();
                r.nap = nap;
                r.originalPos = oldPos;
                r.originalSize = oldSize;
                this.changedNodes.put((ParsedNode)nap.getNode(), r);
            }
        } else if (nap.getPosition() == r.originalPos && nap.getSize() == r.originalSize) {
            this.changedNodes.remove(nap.getNode());
        } else {
            r.nap = nap;
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isInsert() {
        return this.insert;
    }

    public boolean isRemove() {
        return this.remove;
    }

    @OnThread(value=Tag.Any)
    public class NodeChangeRecord {
        public int originalPos;
        public int originalSize;
        public NodeTree.NodeAndPosition<ParsedNode> nap;
    }
}

