/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.BlueJSyntaxView;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeEditorPane;
import bluej.editor.moe.MoeSyntaxEvent;
import bluej.editor.moe.ReparseRecord;
import bluej.editor.moe.ScopeColors;
import bluej.editor.moe.Token;
import bluej.parser.entity.EntityResolver;
import bluej.parser.nodes.NodeStructureListener;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedCUNode;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.RBTreeNode;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.binding.BooleanExpression;
import javax.swing.text.Segment;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.PlainTextChange;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.SimpleEditableStyledDocument;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TextOps;
import org.fxmisc.richtext.model.TwoDimensional;
import org.reactfx.Subscription;
import org.reactfx.collection.LiveList;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class MoeSyntaxDocument {
    public static final String MOE_FIND_RESULT = "moe-find-result";
    public static final String MOE_BRACKET_HIGHLIGHT = "moe-bracket-highlight";
    private final SimpleEditableStyledDocument<BlueJSyntaxView.ScopeInfo, ImmutableSet<String>> document;
    private static final int MAX_PARSE_PIECE = 8000;
    private final int tabSize;
    private ParsedCUNode parsedNode;
    private EntityResolver parentResolver;
    private NodeTree<ReparseRecord> reparseRecordTree;
    private final Map<Integer, BlueJSyntaxView.ScopeInfo> pendingScopeBackgrounds = new HashMap<Integer, BlueJSyntaxView.ScopeInfo>();
    private final Set<Integer> pendingStyleUpdates = new HashSet<Integer>();
    private boolean applyingScopeBackgrounds = false;
    private final BlueJSyntaxView syntaxView;
    private boolean hasFindHighlights = false;
    private String cachedContent = null;
    private int[] lineStarts = null;
    boolean notYetShown = true;
    private boolean thisDocIsForPrinting = false;
    private static int EDIT_INSERT = 0;
    private static int EDIT_DELETE = 1;
    private List<EditEvent> recentEdits = new LinkedList<EditEvent>();

    @OnThread(value=Tag.FXPlatform)
    public MoeSyntaxDocument(ScopeColors scopeColors) {
        this.tabSize = Config.getPropInteger((String)"bluej.editor.tabsize", (int)4);
        this.document = new SimpleEditableStyledDocument(null, (Object)ImmutableSet.of());
        this.syntaxView = scopeColors != null ? new BlueJSyntaxView(this, scopeColors) : null;
        this.document.plainChanges().subscribe(c -> {
            this.invalidateCache();
            if (!((String)c.getRemoved()).isEmpty()) {
                this.fireRemoveUpdate(c.getPosition(), c.getRemovalEnd() - c.getPosition());
            }
            if (!((String)c.getInserted()).isEmpty()) {
                this.fireInsertUpdate(c.getPosition(), c.getInsertionEnd() - c.getPosition());
            }
            if (!this.thisDocIsForPrinting) {
                JavaFXUtil.runAfterCurrent(() -> {
                    this.invalidateCache();
                    this.applyPendingScopeBackgrounds();
                });
            }
        });
    }

    @OnThread(value=Tag.FXPlatform)
    public MoeSyntaxDocument(EntityResolver parentResolver, ScopeColors scopeColors) {
        this(scopeColors);
        this.parentResolver = parentResolver;
        if (parentResolver != null) {
            this.reparseRecordTree = new NodeTree();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public MoeSyntaxDocument(EntityResolver parentResolver) {
        this((ScopeColors)null);
        this.parentResolver = parentResolver;
        if (parentResolver != null) {
            this.reparseRecordTree = new NodeTree();
        }
    }

    public Position createPosition(int initialPos) {
        return new Position(initialPos);
    }

    public void markFindResult(int start, int end) {
        this.hasFindHighlights = true;
        this.document.setStyleSpans(start, this.document.getStyleSpans(start, end).mapStyles(ss -> Utility.setAdd((ImmutableSet)ss, (Object)MOE_FIND_RESULT)));
    }

    public void removeSearchHighlights() {
        if (this.hasFindHighlights) {
            this.removeStyleThroughout(MOE_FIND_RESULT);
            this.hasFindHighlights = false;
        }
    }

    public void removeStyleThroughout(String spanStyle) {
        LiveList paragraphs = this.document.getParagraphs();
        for (int i = 0; i < paragraphs.size(); ++i) {
            Paragraph para = (Paragraph)paragraphs.get(i);
            StyleSpans styleSpans = para.getStyleSpans();
            boolean present = styleSpans.stream().anyMatch(s -> ((ImmutableSet)s.getStyle()).contains((Object)spanStyle));
            if (!present) continue;
            this.document.setStyleSpans(i, 0, styleSpans.mapStyles(ss -> Utility.setMinus((ImmutableSet)ss, (Object)spanStyle)));
        }
    }

    public void addStyle(int start, int end, String style) {
        this.document.setStyleSpans(start, this.document.getStyleSpans(start, end).mapStyles(ss -> Utility.setAdd((ImmutableSet)ss, (Object)style)));
    }

    public void copyFrom(MoeSyntaxDocument from) {
        this.document.replace(0, this.document.getLength(), from.document);
    }

    public TwoDimensional.Position offsetToPosition(final int startOffset) {
        int line;
        if (this.lineStarts == null) {
            return this.document.offsetToPosition(startOffset, TwoDimensional.Bias.Forward);
        }
        for (line = 1; line < this.lineStarts.length && startOffset >= this.lineStarts[line]; ++line) {
        }
        final int lineFinal = --line;
        final int column = startOffset - this.lineStarts[lineFinal];
        return new TwoDimensional.Position(){

            public TwoDimensional getTargetObject() {
                return MoeSyntaxDocument.this.document;
            }

            public int getMajor() {
                return lineFinal;
            }

            public int getMinor() {
                return column;
            }

            public boolean sameAs(TwoDimensional.Position other) {
                return this.getTargetObject() == other.getTargetObject() && this.getMajor() == other.getMajor() && this.getMinor() == other.getMinor();
            }

            public TwoDimensional.Position clamp() {
                return this;
            }

            public TwoDimensional.Position offsetBy(int offset, TwoDimensional.Bias bias) {
                return MoeSyntaxDocument.this.document.offsetToPosition(startOffset + offset, TwoDimensional.Bias.Forward);
            }

            public int toOffset() {
                return startOffset;
            }
        };
    }

    private int getAbsolutePosition(int lineIndex, int columnIndex) {
        if (this.lineStarts == null || lineIndex >= this.lineStarts.length) {
            return this.document.getAbsolutePosition(lineIndex, columnIndex);
        }
        return this.lineStarts[lineIndex] + columnIndex;
    }

    public void markAsForPrinting() {
        this.thisDocIsForPrinting = true;
    }

    public boolean isPrinting() {
        return this.thisDocIsForPrinting;
    }

    private void recordEvent(MoeSyntaxEvent event) {
        int type;
        if (event.isInsert()) {
            type = EDIT_INSERT;
        } else if (event.isRemove()) {
            type = EDIT_DELETE;
        } else {
            return;
        }
        EditEvent eevent = new EditEvent();
        eevent.type = type;
        eevent.offset = event.getOffset();
        eevent.length = event.getLength();
        this.recentEdits.add(eevent);
        if (this.recentEdits.size() > 10) {
            this.recentEdits.remove(0);
        }
    }

    private void invalidateCache() {
        this.cachedContent = null;
        this.lineStarts = null;
    }

    private void cacheContent() {
        if (this.cachedContent == null) {
            this.cachedContent = this.document.getText();
        }
        if (this.lineStarts == null) {
            this.lineStarts = new int[this.document.getParagraphs().size()];
            this.lineStarts[0] = 0;
            int curLine = 0;
            for (int character = 0; character < this.cachedContent.length(); ++character) {
                if (this.cachedContent.charAt(character) != '\n') continue;
                this.lineStarts[++curLine] = character + 1;
            }
        }
    }

    public ParsedCUNode getParser() {
        this.flushReparseQueue();
        return this.parsedNode;
    }

    public ParsedCUNode getParsedNode() {
        return this.parsedNode;
    }

    @OnThread(value=Tag.FXPlatform)
    public void enableParser(boolean force) {
        if (this.parentResolver != null || force) {
            this.parsedNode = new ParsedCUNode(this);
            this.parsedNode.setParentResolver(this.parentResolver);
            this.reparseRecordTree = new NodeTree();
            this.parsedNode.textInserted(this, 0, 0, this.getLength(), (NodeStructureListener)new MoeSyntaxEvent(this, 0, this.getLength(), true, false));
        }
    }

    public boolean pollReparseQueue() {
        return this.pollReparseQueue(8000);
    }

    @OnThread(value=Tag.FXPlatform)
    private boolean pollReparseQueue(int maxParse) {
        try {
            if (this.reparseRecordTree == null) {
                return false;
            }
            NodeTree.NodeAndPosition nap = this.reparseRecordTree.findNodeAtOrAfter(0);
            if (nap != null) {
                int pos = nap.getPosition();
                ParsedCUNode pn = this.parsedNode;
                int ppos = 0;
                if (pn != null) {
                    NodeTree.NodeAndPosition cn;
                    for (cn = pn.findNodeAt(pos, ppos); cn != null && cn.getEnd() == pos; cn = cn.nextSibling()) {
                    }
                    while (cn != null && cn.getPosition() <= pos) {
                        ppos = cn.getPosition();
                        pn = (ParsedNode)cn.getNode();
                        for (cn = pn.findNodeAt(nap.getPosition(), ppos); cn != null && cn.getEnd() == pos; cn = cn.nextSibling()) {
                        }
                    }
                    MoeSyntaxEvent mse = new MoeSyntaxEvent(this, -1, -1, false, false);
                    pn.reparse(this, ppos, pos, maxParse, (NodeStructureListener)mse);
                    this.fireChangedUpdate(mse);
                    return true;
                }
            }
            return false;
        }
        catch (RuntimeException e) {
            Debug.message((String)"Exception during incremental parsing. Recent edits:");
            for (EditEvent event : this.recentEdits) {
                Object eventStr = event.type == EDIT_INSERT ? "insert " : "delete ";
                eventStr = (String)eventStr + "offset=" + event.offset + " length=" + event.length;
                Debug.message((String)eventStr);
            }
            Debug.message((String)"--- Source code ---");
            Debug.message((String)this.getText(0, this.getLength()));
            Debug.message((String)"--- Source ends ---");
            throw e;
        }
    }

    private void dumpTree(Iterator<NodeTree.NodeAndPosition<ParsedNode>> iterator, String indent) {
        for (NodeTree.NodeAndPosition nap2 : () -> iterator) {
            Debug.message((String)(indent + "Node: " + nap2.getPosition() + " -> " + nap2.getEnd()));
            this.dumpTree(((ParsedNode)nap2.getNode()).getChildren(nap2.getPosition()), indent + "  ");
        }
    }

    public void showStepLine(int lineNumber) {
        for (int i = 0; i < this.document.getParagraphs().size(); ++i) {
            this.setParagraphAttributesForLineNumber(i + 1, Collections.singletonMap(BlueJSyntaxView.ParagraphAttribute.STEP_MARK, i + 1 == lineNumber));
        }
    }

    public void fireChangedUpdate(MoeSyntaxEvent mse) {
        if (this.syntaxView != null) {
            this.syntaxView.updateDamage(mse);
        }
        if (mse == null) {
            this.applyPendingScopeBackgrounds();
        }
    }

    public void recalculateAllScopes() {
        if (this.notYetShown) {
            return;
        }
        this.syntaxView.resetColors();
        this.recalculateScopesForLinesInRange(0, this.document.getParagraphs().size() - 1);
        this.applyPendingScopeBackgrounds();
    }

    public void recalculateScopesForLinesInRange(int firstLineIncl, int lastLineIncl) {
        if (this.syntaxView == null) {
            return;
        }
        this.cacheContent();
        this.syntaxView.recalculateScopes(this.pendingScopeBackgrounds, firstLineIncl, lastLineIncl);
    }

    public void applyPendingScopeBackgrounds() {
        MoeEditorPane editorPane;
        if (this.parsedNode == null) {
            return;
        }
        if (this.applyingScopeBackgrounds) {
            return;
        }
        MoeEditorPane moeEditorPane = editorPane = this.syntaxView != null ? this.syntaxView.getEditorPane() : null;
        if (editorPane == null) {
            return;
        }
        this.applyingScopeBackgrounds = true;
        double scrollY = editorPane.getEstimatedScrollY();
        Set<Map.Entry<Integer, BlueJSyntaxView.ScopeInfo>> pendingBackgrounds = new HashMap<Integer, BlueJSyntaxView.ScopeInfo>(this.pendingScopeBackgrounds).entrySet();
        this.pendingScopeBackgrounds.clear();
        for (Map.Entry<Integer, BlueJSyntaxView.ScopeInfo> entry : pendingBackgrounds) {
            if (entry.getKey() >= this.document.getParagraphs().size()) continue;
            BlueJSyntaxView.ScopeInfo newStyle = entry.getValue();
            this.setParagraphStyle(entry.getKey(), newStyle);
        }
        for (Integer n : this.pendingStyleUpdates) {
            StyleSpans<ImmutableSet<String>> styleSpans = this.syntaxView.getTokenStylesFor(n, this);
            if (styleSpans == null || styleSpans.equals((Object)this.document.getStyleSpans(n.intValue()))) continue;
            this.document.setStyleSpans(n.intValue(), 0, this.document.getStyleSpans(n.intValue()).overlay(styleSpans, MoeSyntaxDocument::setTokenStyles));
        }
        this.pendingStyleUpdates.clear();
        editorPane.layout();
        editorPane.estimatedScrollYProperty().setValue((Object)scrollY);
        editorPane.layout();
        this.applyingScopeBackgrounds = false;
    }

    private static ImmutableSet<String> setTokenStyles(ImmutableSet<String> allStyles, ImmutableSet<String> newTokenStyle) {
        return Utility.setUnion((ImmutableSet)Utility.setMinus(allStyles, Token.TokenType.allCSSClasses()), newTokenStyle);
    }

    private void setParagraphStyle(int i, BlueJSyntaxView.ScopeInfo newStyle) {
        this.document.setParagraphStyle(i, (Object)newStyle);
    }

    public void flushReparseQueue() {
        while (this.pollReparseQueue(this.getLength())) {
        }
        this.applyPendingScopeBackgrounds();
    }

    public void scheduleReparse(int pos, int size) {
        NodeTree.NodeAndPosition existing = this.reparseRecordTree.findNodeAtOrAfter(pos);
        if (existing != null) {
            if (existing.getPosition() > pos && existing.getPosition() <= pos + size) {
                ((ReparseRecord)existing.getNode()).slideStart(pos - existing.getPosition());
                return;
            }
            if (existing.getPosition() <= pos) {
                int nsize = pos + size - existing.getPosition();
                if (nsize > existing.getSize()) {
                    NodeTree.NodeAndPosition next = existing.nextSibling();
                    while (next != null && next.getPosition() <= pos + size) {
                        nsize = Math.max(nsize, next.getEnd() - pos);
                        NodeTree.NodeAndPosition nnext = next.nextSibling();
                        ((ReparseRecord)next.getNode()).remove();
                        next = nnext;
                    }
                    ((ReparseRecord)existing.getNode()).setSize(nsize);
                }
                return;
            }
        }
        ReparseRecord rr = new ReparseRecord();
        this.reparseRecordTree.insertNode((RBTreeNode)rr, pos, size);
    }

    public void markSectionParsed(int pos, int size) {
        this.repaintLines(pos, size, true);
        NodeTree.NodeAndPosition existing = this.reparseRecordTree.findNodeAtOrAfter(pos);
        while (existing != null && existing.getPosition() <= pos) {
            NodeTree.NodeAndPosition next = existing.nextSibling();
            int rsize = existing.getEnd() - pos;
            if ((rsize = Math.min(rsize, size)) == existing.getSize()) {
                ((ReparseRecord)existing.getNode()).remove();
            } else {
                if (existing.getPosition() == pos) {
                    existing.slideStart(rsize);
                    existing = next;
                    break;
                }
                int existingEnd = existing.getEnd();
                existing.setSize(pos - existing.getPosition());
                if (existingEnd > pos + size) {
                    this.scheduleReparse(pos + size, existingEnd - (pos + size));
                    return;
                }
            }
            existing = next;
        }
        while (existing != null && existing.getPosition() < pos + size) {
            int rsize = pos + size - existing.getPosition();
            if (rsize < existing.getSize()) {
                existing.slideStart(rsize);
                return;
            }
            NodeTree.NodeAndPosition next = existing.nextSibling();
            ((ReparseRecord)existing.getNode()).remove();
            existing = next;
        }
    }

    public void parseError(int position, int size, String message) {
    }

    public void setParagraphAttributesForLineNumber(int lineNumber, Map<BlueJSyntaxView.ParagraphAttribute, Boolean> alterAttr) {
        if (this.syntaxView == null) {
            return;
        }
        Map<Integer, EnumSet<BlueJSyntaxView.ParagraphAttribute>> changedLines = this.syntaxView.setParagraphAttributes(lineNumber, alterAttr);
        this.updateScopesAfterParaAttrChange(changedLines);
    }

    private void updateScopesAfterParaAttrChange(Map<Integer, EnumSet<BlueJSyntaxView.ParagraphAttribute>> changedLines) {
        for (Map.Entry<Integer, EnumSet<BlueJSyntaxView.ParagraphAttribute>> changedLine : changedLines.entrySet()) {
            BlueJSyntaxView.ScopeInfo prevStyle;
            if (changedLine.getKey() - 1 >= this.document.getParagraphs().size() || (prevStyle = (BlueJSyntaxView.ScopeInfo)this.document.getParagraphStyle(changedLine.getKey() - 1)) == null) continue;
            this.setParagraphStyle(changedLine.getKey() - 1, prevStyle.withAttributes(changedLine.getValue()));
        }
    }

    public void setParagraphAttributes(Map<BlueJSyntaxView.ParagraphAttribute, Boolean> alterAttr) {
        if (this.syntaxView == null) {
            return;
        }
        Map<Integer, EnumSet<BlueJSyntaxView.ParagraphAttribute>> changedLines = this.syntaxView.setParagraphAttributes(alterAttr);
        this.updateScopesAfterParaAttrChange(changedLines);
    }

    public Token getTokensForLine(int line) {
        Element lineEl = this.getDefaultRootElement().getElement(line);
        int pos = lineEl.getStartOffset();
        int length = lineEl.getEndOffset() - pos - 1;
        return this.parsedNode.getMarkTokensFor(pos, length, 0, this);
    }

    protected void fireInsertUpdate(int offset, int length) {
        NodeTree.NodeAndPosition napRr;
        if (this.syntaxView != null) {
            this.syntaxView.setDuringUpdate(true);
        }
        if (this.reparseRecordTree != null && (napRr = this.reparseRecordTree.findNodeAtOrAfter(offset)) != null) {
            if (napRr.getPosition() <= offset) {
                ((ReparseRecord)napRr.getNode()).resize(napRr.getSize() + length);
            } else {
                ((ReparseRecord)napRr.getNode()).slide(length);
            }
        }
        int firstLine = this.offsetToPosition(offset).getMajor();
        int lastLine = this.offsetToPosition(offset + length).getMajor();
        for (int i = firstLine; i <= lastLine; ++i) {
            this.pendingStyleUpdates.add(i);
        }
        MoeSyntaxEvent mse = new MoeSyntaxEvent(this, offset, length, true, false);
        if (this.parsedNode != null) {
            this.parsedNode.textInserted(this, 0, offset, length, (NodeStructureListener)mse);
        }
        this.fireChangedUpdate(mse);
        this.recordEvent(mse);
        if (this.syntaxView != null) {
            this.syntaxView.setDuringUpdate(false);
        }
    }

    protected void fireRemoveUpdate(int offset, int length) {
        if (this.syntaxView != null) {
            this.syntaxView.setDuringUpdate(true);
        }
        NodeTree.NodeAndPosition napRr = this.reparseRecordTree != null ? this.reparseRecordTree.findNodeAtOrAfter(offset) : null;
        int rpos = offset;
        int rlen = length;
        if (napRr != null && napRr.getEnd() == rpos) {
            napRr = napRr.nextSibling();
        }
        while (napRr != null && rlen > 0) {
            if (napRr.getPosition() < rpos) {
                if (napRr.getEnd() >= rpos + rlen) {
                    ((ReparseRecord)napRr.getNode()).resize(napRr.getSize() - rlen);
                    break;
                }
                int reduction = napRr.getEnd() - rpos;
                ((ReparseRecord)napRr.getNode()).resize(napRr.getSize() - reduction);
                rlen -= reduction;
                napRr = napRr.nextSibling();
                continue;
            }
            if (napRr.getPosition() == rpos) {
                if (napRr.getEnd() > rpos + rlen) {
                    ((ReparseRecord)napRr.getNode()).resize(napRr.getSize() - rlen);
                    break;
                }
                ((ReparseRecord)napRr.getNode()).remove();
                napRr = this.reparseRecordTree.findNodeAtOrAfter(offset);
                continue;
            }
            if (napRr.getPosition() >= rpos + rlen) {
                napRr.slide(-rlen);
                break;
            }
            if (napRr.getEnd() <= rpos + rlen) {
                NodeTree.NodeAndPosition nextRr = napRr.nextSibling();
                ((ReparseRecord)napRr.getNode()).remove();
                napRr = nextRr;
                continue;
            }
            int ramount = rpos + rlen - napRr.getPosition();
            napRr.slideStart(ramount);
            napRr.slide(-rlen);
            break;
        }
        this.pendingStyleUpdates.add(this.offsetToPosition(offset).getMajor());
        MoeSyntaxEvent mse = new MoeSyntaxEvent(this, offset, length, false, true);
        if (this.parsedNode != null) {
            this.parsedNode.textRemoved(this, 0, offset, length, (NodeStructureListener)mse);
        }
        this.fireChangedUpdate(mse);
        this.recordEvent(mse);
        if (this.syntaxView != null) {
            this.syntaxView.setDuringUpdate(false);
        }
    }

    public SimpleEditableStyledDocument<?, ?> getDocument() {
        return this.document;
    }

    @OnThread(value=Tag.FXPlatform)
    public MoeEditorPane makeEditorPane(MoeEditor editor, BooleanExpression compiledStatus) {
        return new MoeEditorPane(editor, (EditableStyledDocument<BlueJSyntaxView.ScopeInfo, String, ImmutableSet<String>>)this.document, this.syntaxView, compiledStatus);
    }

    public void repaintLines(int offset, int length) {
        this.repaintLines(offset, length, false);
    }

    public void repaintLines(int offset, int length, boolean reStyle) {
        int startLine = this.offsetToPosition(offset).getMajor();
        int endLine = this.offsetToPosition(offset + length).getMajor();
        this.recalculateScopesForLinesInRange(startLine, endLine);
        this.restyleLines(startLine, endLine);
    }

    public void restyleLines(int start, int end) {
        for (int i = start; i <= end; ++i) {
            this.pendingStyleUpdates.add(i);
        }
    }

    public int getLength() {
        return this.document.getLength();
    }

    public String getText(int start, int length) {
        if (this.cachedContent == null) {
            return this.document.getText(start, start + length);
        }
        return this.cachedContent.substring(start, start + length);
    }

    public void getText(int startOffset, int length, Segment segment) {
        String s = this.getText(startOffset, length);
        segment.array = s.toCharArray();
        segment.offset = 0;
        segment.count = s.length();
    }

    public void insertString(int start, String text) {
        this.replace(start, 0, text);
    }

    public void replace(int start, int length, String text) {
        this.document.replace(start, start + length, (StyledDocument)ReadOnlyStyledDocument.fromString((String)text, null, (Object)ImmutableSet.of(), (TextOps)SegmentOps.styledTextOps()));
    }

    public void remove(int start, int length) {
        if (length != 0) {
            this.document.replace(start, start + length, (StyledDocument)new SimpleEditableStyledDocument(null, (Object)ImmutableSet.of()));
        }
    }

    public EnumSet<BlueJSyntaxView.ParagraphAttribute> getParagraphAttributes(int lineNo) {
        if (this.syntaxView != null) {
            return this.syntaxView.getParagraphAttributes(lineNo);
        }
        return EnumSet.noneOf(BlueJSyntaxView.ParagraphAttribute.class);
    }

    public Element getDefaultRootElement() {
        return new Element(){

            @Override
            public Element getElement(int index) {
                boolean lastPara;
                if (index >= (MoeSyntaxDocument.this.lineStarts != null ? MoeSyntaxDocument.this.lineStarts.length : MoeSyntaxDocument.this.document.getParagraphs().size())) {
                    return null;
                }
                boolean bl = MoeSyntaxDocument.this.lineStarts != null ? index == MoeSyntaxDocument.this.lineStarts.length - 1 : (lastPara = index == MoeSyntaxDocument.this.document.getParagraphs().size() - 1);
                final int paraLength = MoeSyntaxDocument.this.lineStarts == null ? MoeSyntaxDocument.this.document.getParagraph(index).length() + (lastPara ? 0 : 1) : (lastPara ? MoeSyntaxDocument.this.document.getLength() - MoeSyntaxDocument.this.lineStarts[index] : MoeSyntaxDocument.this.lineStarts[index + 1] - MoeSyntaxDocument.this.lineStarts[index]);
                final int pos = MoeSyntaxDocument.this.getAbsolutePosition(index, 0);
                return new Element(){

                    @Override
                    public Element getElement(int index) {
                        return null;
                    }

                    @Override
                    public int getStartOffset() {
                        return pos;
                    }

                    @Override
                    public int getEndOffset() {
                        return pos + paraLength;
                    }

                    @Override
                    public int getElementIndex(int offset) {
                        return -1;
                    }

                    @Override
                    public int getElementCount() {
                        return 0;
                    }
                };
            }

            @Override
            public int getStartOffset() {
                return 0;
            }

            @Override
            public int getEndOffset() {
                return MoeSyntaxDocument.this.document.getLength();
            }

            @Override
            public int getElementIndex(int offset) {
                return MoeSyntaxDocument.this.offsetToPosition(offset).getMajor();
            }

            @Override
            public int getElementCount() {
                if (MoeSyntaxDocument.this.lineStarts != null) {
                    return MoeSyntaxDocument.this.lineStarts.length;
                }
                return MoeSyntaxDocument.this.document.getParagraphs().size();
            }
        };
    }

    @OnThread(value=Tag.Any)
    public class Position {
        private final Subscription subscription;
        private int position;

        public Position(int initial) {
            this.position = initial;
            this.subscription = MoeSyntaxDocument.this.document.plainChanges().subscribe(this::changed);
        }

        private void changed(PlainTextChange c) {
            if (c.getPosition() <= this.position) {
                this.position -= Math.min(c.getRemovalEnd() - c.getPosition(), this.position - c.getPosition());
                this.position += c.getInsertionEnd() - c.getPosition();
            }
        }

        public void dispose() {
            this.subscription.unsubscribe();
        }

        public int getOffset() {
            return this.position;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static interface Element {
        public Element getElement(int var1);

        public int getStartOffset();

        public int getEndOffset();

        public int getElementIndex(int var1);

        public int getElementCount();
    }

    @OnThread(value=Tag.Any)
    private static class EditEvent {
        int type;
        int offset;
        int length;

        private EditEvent() {
        }
    }
}

