/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.RBTreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MoeIndent {
    private static final Pattern WHITESPACE_TABS = Pattern.compile("^[ \\t]*");
    private static final Pattern WHITESPACE_TABS_STAR = Pattern.compile("^[ \\t*]*(/\\*)?");

    public static AutoIndentInformation calculateIndentsAndApply(MoeSyntaxDocument doc, int caretPos) {
        return MoeIndent.calculateIndentsAndApply(doc, 0, doc.getLength(), caretPos);
    }

    public static AutoIndentInformation calculateIndentsAndApply(MoeSyntaxDocument doc, int startPos, int endPos, int prevCaretPos) {
        boolean thisLineBlank;
        int i;
        int caretPos = prevCaretPos;
        MoeSyntaxDocument.Element rootElement = doc.getDefaultRootElement();
        LinkedList<DocumentAction> methodUpdates = new LinkedList<DocumentAction>();
        ArrayList<DocumentIndentAction> updates = new ArrayList<DocumentIndentAction>(rootElement.getElementCount());
        RootIndentCalculator ii = new RootIndentCalculator();
        boolean lastLineWasBlank = false;
        boolean perfect = true;
        NodeTree.NodeAndPosition root = new NodeTree.NodeAndPosition((RBTreeNode)doc.getParser(), 0, doc.getParser().getSize());
        MoeSyntaxDocument.Position startp = doc.createPosition(startPos);
        MoeSyntaxDocument.Position endp = doc.createPosition(endPos);
        MoeIndent.checkMethodSpacing((NodeTree.NodeAndPosition<ParsedNode>)root, rootElement, methodUpdates, startPos, endPos);
        for (DocumentAction documentAction : methodUpdates) {
            caretPos = documentAction.apply(doc, caretPos);
        }
        methodUpdates = null;
        for (i = 0; i < rootElement.getElementCount(); ++i) {
            MoeSyntaxDocument.Element element = rootElement.getElement(i);
            if (element.getEndOffset() <= startp.getOffset() || element.getStartOffset() >= endp.getOffset()) continue;
            thisLineBlank = MoeIndent.isWhiteSpaceOnly(MoeIndent.getElementContents(doc, element));
            if (thisLineBlank) {
                if (caretPos >= element.getStartOffset() && caretPos < element.getEndOffset()) {
                    caretPos = element.getStartOffset();
                }
                if (lastLineWasBlank) {
                    if (element.getEndOffset() <= doc.getLength()) {
                        doc.remove(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                        perfect = false;
                    }
                } else {
                    int rmlen = element.getEndOffset() - element.getStartOffset() - 1;
                    if (rmlen > 0) {
                        doc.remove(element.getStartOffset(), rmlen);
                    }
                }
            }
            lastLineWasBlank = thisLineBlank;
        }
        doc.flushReparseQueue();
        for (i = 0; i < rootElement.getElementCount(); ++i) {
            MoeSyntaxDocument.Element element = rootElement.getElement(i);
            if (element.getEndOffset() <= startp.getOffset() || element.getStartOffset() >= endp.getOffset()) continue;
            thisLineBlank = MoeIndent.isWhiteSpaceOnly(MoeIndent.getElementContents(doc, element));
            DocumentIndentAction update = null;
            if (!thisLineBlank) {
                String indent = MoeIndent.calculateIndent(element, (NodeTree.NodeAndPosition<ParsedNode>)root, ii, doc);
                update = new DocumentIndentAction(i, indent);
                boolean bl = perfect = perfect && MoeIndent.getElementContents(doc, element).startsWith(indent) && !MoeIndent.isWhiteSpaceOnly(MoeIndent.getElementContents(doc, element).substring(indent.length(), indent.length() + 1));
            }
            if (update != null) {
                updates.add(update);
            }
            lastLineWasBlank = thisLineBlank;
        }
        for (DocumentAction documentAction : updates) {
            caretPos = documentAction.apply(doc, caretPos);
        }
        startp.dispose();
        endp.dispose();
        return new AutoIndentInformation(perfect, caretPos);
    }

    private static String calculateIndent(MoeSyntaxDocument.Element el, NodeTree.NodeAndPosition<ParsedNode> start, IndentCalculator startIC, MoeSyntaxDocument doc) {
        int pos = el.getStartOffset() + MoeIndent.findFirstNonIndentChar(MoeIndent.getElementContents(doc, el), true);
        if (pos >= start.getPosition() && pos < start.getEnd()) {
            Iterator i = ((ParsedNode)start.getNode()).getChildren(start.getPosition());
            while (i.hasNext()) {
                NodeTree.NodeAndPosition nap = (NodeTree.NodeAndPosition)i.next();
                String inner = MoeIndent.calculateIndent(el, (NodeTree.NodeAndPosition<ParsedNode>)nap, startIC.getForChild((ParsedNode)nap.getNode()), doc);
                if (inner == null) continue;
                return inner;
            }
            return startIC.getCurIndent(doc.getText(pos, 1).charAt(0));
        }
        return null;
    }

    private static void checkMethodSpacing(NodeTree.NodeAndPosition<ParsedNode> root, MoeSyntaxDocument.Element map, List<DocumentAction> updates, int startPos, int endPos) {
        NodeTree.NodeAndPosition current = null;
        NodeTree.NodeAndPosition next = null;
        Iterator i = ((ParsedNode)root.getNode()).getChildren(root.getPosition());
        while (i.hasNext()) {
            next = (NodeTree.NodeAndPosition)i.next();
            if (current != null && ((ParsedNode)current.getNode()).getNodeType() == 2 && ((ParsedNode)current.getNode()).getNodeType() == ((ParsedNode)next.getNode()).getNodeType()) {
                int currentLine = map.getElementIndex(current.getEnd() - 1);
                int nextLine = map.getElementIndex(next.getPosition());
                if (next.getPosition() >= startPos && next.getPosition() <= endPos) {
                    if (currentLine + 1 == nextLine) {
                        updates.add(0, new DocumentAddLineAction(next.getPosition()));
                    } else if (currentLine == nextLine) {
                        updates.add(0, new DocumentAddLineAction(next.getPosition(), true));
                    }
                } else if (current.getEnd() >= startPos && current.getEnd() <= endPos) {
                    if (currentLine + 1 == nextLine) {
                        updates.add(0, new DocumentAddLineAction(current.getEnd()));
                    } else if (currentLine == nextLine) {
                        updates.add(0, new DocumentAddLineAction(current.getEnd(), true));
                    }
                }
            }
            if ((current = next).getPosition() > endPos) {
                return;
            }
            MoeIndent.checkMethodSpacing((NodeTree.NodeAndPosition<ParsedNode>)current, map, updates, startPos, endPos);
        }
    }

    private static String getElementContents(MoeSyntaxDocument doc, MoeSyntaxDocument.Element el) {
        return doc.getText(el.getStartOffset(), el.getEndOffset() - el.getStartOffset());
    }

    public static boolean isWhiteSpaceOnly(String s) {
        return s.trim().length() == 0;
    }

    public static int findFirstNonIndentChar(String line, boolean whitespaceOnly) {
        Matcher m = whitespaceOnly ? WHITESPACE_TABS.matcher(line) : WHITESPACE_TABS_STAR.matcher(line);
        return m.find() ? m.end() : 0;
    }

    private static class DocumentAddLineAction
    implements DocumentAction {
        private int position;
        private boolean twoSeparators;

        public DocumentAddLineAction(int position) {
            this(position, false);
        }

        public DocumentAddLineAction(int position, boolean twoSeparators) {
            this.position = position;
            this.twoSeparators = twoSeparators;
        }

        @Override
        public int apply(MoeSyntaxDocument doc, int prevCaretPos) {
            String lineSeparator = System.getProperty("line.separator");
            if (this.twoSeparators) {
                doc.insertString(this.position, lineSeparator + lineSeparator);
            } else {
                doc.insertString(this.position, lineSeparator);
            }
            if (this.position > prevCaretPos) {
                return prevCaretPos;
            }
            if (this.twoSeparators) {
                return prevCaretPos + lineSeparator.length() * 2;
            }
            return prevCaretPos + lineSeparator.length();
        }
    }

    private static class DocumentIndentAction
    implements DocumentAction {
        private final int lineIndex;
        private final String indent;

        public DocumentIndentAction(int lineIndex, String indent) {
            this.lineIndex = lineIndex;
            this.indent = indent;
        }

        @Override
        public int apply(MoeSyntaxDocument doc, int caretPos) {
            int lengthPrevWhitespace;
            boolean anyTabs;
            MoeSyntaxDocument.Element el = doc.getDefaultRootElement().getElement(this.lineIndex);
            String line = MoeIndent.getElementContents(doc, el);
            boolean bl = anyTabs = line.substring(0, lengthPrevWhitespace = MoeIndent.findFirstNonIndentChar(line, true)).indexOf("\t") != -1;
            if (this.indent != null && (anyTabs || this.indent.length() != lengthPrevWhitespace)) {
                int origStartOffset = el.getStartOffset();
                doc.replace(el.getStartOffset(), lengthPrevWhitespace, this.indent);
                if (caretPos < origStartOffset) {
                    return caretPos;
                }
                if (caretPos >= origStartOffset + lengthPrevWhitespace) {
                    int changeLength = this.indent.length() - lengthPrevWhitespace;
                    return caretPos + changeLength;
                }
                return origStartOffset + this.indent.length();
            }
            return caretPos;
        }
    }

    private static interface DocumentAction {
        public int apply(MoeSyntaxDocument var1, int var2);
    }

    private static class NodeIndentCalculator
    implements IndentCalculator {
        private final String existingIndent;
        private final ParsedNode parent;
        private static final int tabSize = Config.getPropInteger((String)"bluej.editor.tabsize", (int)4);
        private static final String spaces = "                                                                                   ";
        private static final String STANDARD_INDENT;
        private static final String CONTINUATION_INDENT;
        private static final String COMMENT_ASTERISK_INDENT = " ";

        public NodeIndentCalculator(String existingIndent, ParsedNode parent) {
            this.existingIndent = existingIndent;
            this.parent = parent;
        }

        @Override
        public IndentCalculator getForChild(ParsedNode child) {
            Object newIndent = this.existingIndent;
            if (child.isInner()) {
                newIndent = (String)newIndent + STANDARD_INDENT;
            } else if (!(child.isContainer() || this.parent.isContainer() || this.parent.isInner())) {
                newIndent = (String)newIndent + CONTINUATION_INDENT;
            }
            return new NodeIndentCalculator((String)newIndent, child);
        }

        @Override
        public String getCurIndent(char beginsWith) {
            if (this.parent.getNodeType() == 7 && beginsWith == '*') {
                return this.existingIndent + COMMENT_ASTERISK_INDENT;
            }
            return this.existingIndent;
        }

        static {
            CONTINUATION_INDENT = STANDARD_INDENT = spaces.substring(0, tabSize);
        }
    }

    private static class RootIndentCalculator
    implements IndentCalculator {
        private RootIndentCalculator() {
        }

        @Override
        public IndentCalculator getForChild(ParsedNode n) {
            return new NodeIndentCalculator("", n);
        }

        @Override
        public String getCurIndent(char beginsWith) {
            return "";
        }
    }

    private static interface IndentCalculator {
        public IndentCalculator getForChild(ParsedNode var1);

        public String getCurIndent(char var1);
    }

    public static class AutoIndentInformation {
        private boolean perfect;
        private int newCaretPos;

        public AutoIndentInformation(boolean perfect, int newCaretPos) {
            this.perfect = perfect;
            this.newCaretPos = newCaretPos;
        }

        public boolean isPerfect() {
            return this.perfect;
        }

        public int getNewCaretPosition() {
            return this.newCaretPos;
        }
    }
}

