/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.Editor;
import bluej.editor.EditorManager;
import bluej.editor.EditorWatcher;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeEditorParameters;
import bluej.editor.stride.FXTabbedEditor;
import bluej.parser.entity.EntityResolver;
import bluej.pkgmgr.JavadocResolver;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXSupplier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public final class MoeEditorManager
extends EditorManager {
    private final Properties resources;
    private final List<MoeEditor> editors = new ArrayList<MoeEditor>(4);
    private final boolean showLineNum;
    private final boolean showToolBar;

    public MoeEditorManager() {
        this.showToolBar = true;
        this.showLineNum = false;
        this.resources = Config.moeUserProps;
    }

    @Override
    public Editor openClass(String filename, String docFilename, Charset charset, String windowTitle, FXSupplier<FXTabbedEditor> fxTabbedEditor, EditorWatcher watcher, boolean compiled, EntityResolver projectResolver, JavadocResolver javadocResolver, FXPlatformRunnable callbackOnOpen) {
        return this.openEditor(filename, docFilename, charset, true, windowTitle, fxTabbedEditor, watcher, compiled, projectResolver, javadocResolver, callbackOnOpen);
    }

    @Override
    public Editor openText(String filename, Charset charset, String windowTitle, FXSupplier<FXTabbedEditor> fxTabbedEditor) {
        return this.openEditor(filename, null, charset, false, windowTitle, fxTabbedEditor, null, false, null, null, null);
    }

    @Override
    public void refreshAll() {
        for (Editor editor : this.editors) {
            if (!editor.isOpen()) continue;
            editor.refresh();
        }
    }

    @Override
    public void discardEditor(Editor ed) {
        ed.close();
        this.editors.remove(ed);
    }

    private Editor openEditor(String filename, String docFilename, Charset charset, boolean isCode, String windowTitle, FXSupplier<FXTabbedEditor> fxTabbedEditor, EditorWatcher watcher, boolean compiled, EntityResolver projectResolver, JavadocResolver javadocResolver, FXPlatformRunnable callbackOnOpen) {
        MoeEditorParameters mep = new MoeEditorParameters(windowTitle, watcher, this.resources, projectResolver, javadocResolver);
        mep.setCode(isCode);
        mep.setShowToolbar(this.showToolBar);
        mep.setShowLineNum(this.showLineNum);
        mep.setCallbackOnOpen(callbackOnOpen);
        mep.setCompiled(compiled);
        MoeEditor editor = new MoeEditor(mep, fxTabbedEditor);
        this.editors.add(editor);
        if (editor.showFile(filename, charset, compiled, docFilename)) {
            return editor;
        }
        editor.doClose();
        return null;
    }
}

