/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.Config;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.compiler.Diagnostic;
import bluej.debugger.DebuggerThread;
import bluej.editor.EditorWatcher;
import bluej.editor.TextEditor;
import bluej.editor.moe.BlueJSyntaxView;
import bluej.editor.moe.FindPanel;
import bluej.editor.moe.GoToLineDialog;
import bluej.editor.moe.Info;
import bluej.editor.moe.MoeActions;
import bluej.editor.moe.MoeEditorPane;
import bluej.editor.moe.MoeEditorParameters;
import bluej.editor.moe.MoeErrorManager;
import bluej.editor.moe.MoeIndent;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.editor.moe.MoeUndoManager;
import bluej.editor.moe.ParserMessageHandler;
import bluej.editor.moe.PrintDialog;
import bluej.editor.moe.ReparseRunner;
import bluej.editor.moe.ScopeColors;
import bluej.editor.moe.ScopeColorsBorderPane;
import bluej.editor.moe.StatusLabel;
import bluej.editor.moe.TextUtilities;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.FrameEditor;
import bluej.editor.stride.MoeFXTab;
import bluej.parser.AssistContent;
import bluej.parser.ExpressionTypeInfo;
import bluej.parser.ImportsCollection;
import bluej.parser.ParseUtils;
import bluej.parser.SourceLocation;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.lexer.LocatableToken;
import bluej.parser.nodes.MethodNode;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedCUNode;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.RBTreeNode;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Selection;
import bluej.pkgmgr.JavadocResolver;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.slots.ExpressionCompletionCalculator;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.slots.SuggestionList;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.Utility;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.FXSupplier;
import bluej.utility.javafx.JavaFXUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.css.Styleable;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PopupControl;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Skin;
import javafx.scene.control.Skinnable;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.scene.web.WebView;
import javafx.stage.PopupWindow;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.event.MouseOverTextEvent;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventTarget;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public final class MoeEditor
extends ScopeColorsBorderPane
implements TextEditor,
BlueJEventListener {
    static final int version = 400;
    static final String versionString = "3.3.0";
    static final String LabelSuffix = "Label";
    static final String ActionSuffix = "Action";
    static final String TooltipSuffix = "Tooltip";
    static final String AcceleratorSuffix = "Accelerator";
    static final String COMPILED = "compiled";
    private static final String CRASHFILE_SUFFIX = "#";
    private static boolean matchBrackets = false;
    private static ArrayList<String> readMeActions;
    private final String interfaceString = Config.getString((String)"editor.interfaceLabel");
    private final String implementationString = Config.getString((String)"editor.implementationLabel");
    private final FXSupplier<FXTabbedEditor> defaultFXTabbedEditor;
    private @OnThread(value=Tag.Any) FXTabbedEditor fxTabbedEditor;
    private @OnThread(value=Tag.FX) MoeFXTab fxTab;
    public MoeUndoManager undoManager;
    private boolean showingChangedOnDiskDialog = false;
    private final EditorWatcher watcher;
    private final Properties resources;
    private MoeSyntaxDocument sourceDocument;
    private MoeActions actions;
    private MoeEditorPane sourcePane;
    private WebView htmlPane;
    private Info info;
    private StatusLabel saveState;
    private ComboBox<String> interfaceToggle;
    private FindPanel finder;
    private final ObjectProperty<FindNavigator> currentSearchResult = new SimpleObjectProperty(null);
    private MenuBar menubar;
    private String filename;
    private long lastModified;
    private String windowTitle;
    private String docFilename;
    private Charset characterSet;
    private final boolean sourceIsCode;
    private final BooleanProperty viewingHTML;
    private int currentStepLineNumber;
    private boolean mayHaveBreakpoints;
    private boolean ignoreChanges = false;
    private boolean tabsAreExpanded = false;
    private final JavadocResolver javadocResolver;
    private ReparseRunner reparseRunner;
    private final HashMap<String, Object> propertyMap = new HashMap();
    private int oldCaretLineNumber = -1;
    private ErrorDisplay errorDisplay;
    private boolean compilationQueued = false;
    private boolean compilationQueuedExplicit = false;
    private boolean compilationStarted = false;
    private boolean requeueForCompilation = false;
    private CompileReason requeueReason;
    private CompileType requeueType;
    private final MoeErrorManager errorManager = new MoeErrorManager(this, enable -> {});
    private int mouseCaretPos = -1;
    private final FXPlatformRunnable callbackOnOpen;
    private final @OnThread(value=Tag.FX) List<Menu> fxMenus = new ArrayList<Menu>();
    private final BooleanProperty compiledProperty = new SimpleBooleanProperty(true);
    private @OnThread(value=Tag.FXPlatform) boolean respondingToChange;
    private String lastSearchString = "";

    public MoeEditor(MoeEditorParameters parameters, FXSupplier<FXTabbedEditor> getDefaultEditor) {
        this.defaultFXTabbedEditor = getDefaultEditor;
        String fxWindowTitle = parameters.getTitle();
        this.watcher = parameters.getWatcher();
        this.resources = parameters.getResources();
        this.javadocResolver = parameters.getJavadocResolver();
        this.filename = null;
        this.windowTitle = parameters.getTitle();
        this.sourceIsCode = parameters.isCode();
        this.viewingHTML = new SimpleBooleanProperty(false);
        this.currentStepLineNumber = -1;
        this.mayHaveBreakpoints = false;
        matchBrackets = PrefMgr.getFlag((String)"bluej.editor.matchBrackets");
        this.initWindow(parameters.getProjectResolver());
        this.callbackOnOpen = parameters.getCallbackOnOpen();
        this.fxTabbedEditor = (FXTabbedEditor)getDefaultEditor.get();
        this.fxTab = new MoeFXTab(this, fxWindowTitle);
    }

    private static int findSubstring(String text, String sub, boolean ignoreCase, boolean backwards, int foundPos) {
        boolean itsOver;
        int strlen = text.length();
        int sublen = sub.length();
        if (sublen == 0) {
            return -1;
        }
        boolean found = false;
        int pos = foundPos;
        boolean bl = backwards ? pos < 0 : (itsOver = pos + sublen > strlen);
        while (!found && !itsOver) {
            found = text.regionMatches(ignoreCase, pos, sub, 0, sublen);
            if (found) {
                return pos;
            }
            if (found) continue;
            int n = pos = backwards ? pos - 1 : pos + 1;
            itsOver = backwards ? pos < 0 : pos + sublen > strlen;
        }
        return -1;
    }

    private static boolean isNonReadmeAction(String actionName) {
        ArrayList<String> flaggedActions = MoeEditor.getNonReadmeActions();
        return flaggedActions.contains(actionName);
    }

    private static ArrayList<String> getNonReadmeActions() {
        if (readMeActions == null) {
            readMeActions = new ArrayList();
            readMeActions.add("compile");
            readMeActions.add("autoindent");
            readMeActions.add("insert-method");
            readMeActions.add("add-javadoc");
            readMeActions.add("toggle-interface-view");
        }
        return readMeActions;
    }

    private void checkForChangeOnDisk() {
        if (this.filename == null) {
            return;
        }
        File file = new File(this.filename);
        long modified = file.lastModified();
        if (modified > this.lastModified + 1000L && !this.showingChangedOnDiskDialog) {
            Debug.message((String)("File " + this.filename + " changed on disk; our record is " + this.lastModified + " but file was " + modified));
            if (this.saveState.isChanged()) {
                this.showingChangedOnDiskDialog = true;
                int answer = DialogManager.askQuestionFX((Window)this.getWindow(), (String)"changed-on-disk");
                if (answer == 0) {
                    this.doReload();
                } else {
                    this.setLastModified(modified);
                }
                this.showingChangedOnDiskDialog = false;
            } else {
                this.doReload();
            }
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean showFile(String filename, Charset charset, boolean compiled, String docFilename) {
        this.filename = filename;
        this.docFilename = docFilename;
        this.characterSet = charset;
        boolean loaded = false;
        if (filename != null) {
            this.setupJavadocMangler();
            try {
                String crashFilename = filename + CRASHFILE_SUFFIX;
                String backupFilename = crashFilename + "backup";
                File crashFile = new File(crashFilename);
                if (crashFile.exists()) {
                    File backupFile = new File(backupFilename);
                    backupFile.delete();
                    crashFile.renameTo(backupFile);
                    DialogManager.showMessageFX((Window)this.fxTabbedEditor.getWindow(), (String)"editor-crashed", (String[])new String[0]);
                }
                FileInputStream inputStream = new FileInputStream(filename);
                InputStreamReader reader = new InputStreamReader((InputStream)inputStream, charset);
                this.ignoreChanges = true;
                this.sourcePane.read(reader);
                this.ignoreChanges = false;
                try {
                    ((Reader)reader).close();
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                File file = new File(filename);
                this.setLastModified(file.lastModified());
                this.listenToChanges(this.sourceDocument);
                this.sourceDocument.enableParser(false);
                loaded = true;
                this.scheduleReparseRunner();
            }
            catch (IOException ex) {
                Debug.reportError((String)"Couldn't open file", (Throwable)ex);
            }
        } else if (docFilename != null && new File(docFilename).exists()) {
            this.showInterface(true);
            loaded = true;
            this.interfaceToggle.setDisable(true);
        }
        if (!loaded) {
            return false;
        }
        this.setCompileStatus(compiled);
        return true;
    }

    @Override
    public void reloadFile() {
        this.doReload();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void clear() {
        this.ignoreChanges = true;
        this.sourcePane.setText("");
        this.ignoreChanges = false;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void insertText(String text, boolean caretBack) {
        this.sourcePane.replaceSelection(text);
        if (caretBack) {
            this.sourcePane.setCaretPosition(this.sourcePane.getCaretPosition() - text.length());
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setEditorVisible(boolean vis, boolean openInNewWindow) {
        if (vis) {
            this.checkBracketStatus();
            if (this.sourceIsCode && !this.compiledProperty.get() && this.sourceDocument.notYetShown) {
                this.scheduleCompilation(CompileReason.LOADED, CompileType.ERROR_CHECK_ONLY);
            }
        }
        if (this.fxTabbedEditor == null) {
            this.fxTabbedEditor = openInNewWindow ? ((FXTabbedEditor)this.defaultFXTabbedEditor.get()).getProject().createNewFXTabbedEditor() : (FXTabbedEditor)this.defaultFXTabbedEditor.get();
        } else if (openInNewWindow && !this.fxTabbedEditor.containsTab(this.fxTab)) {
            this.fxTabbedEditor = ((FXTabbedEditor)this.defaultFXTabbedEditor.get()).getProject().createNewFXTabbedEditor();
        }
        if (vis) {
            this.fxTabbedEditor.addTab(this.fxTab, vis, true);
        }
        this.fxTabbedEditor.setWindowVisible(vis, this.fxTab);
        if (vis) {
            this.fxTabbedEditor.bringToFront(this.fxTab);
            if (this.callbackOnOpen != null) {
                this.callbackOnOpen.run();
            }
            this.sourceDocument.notYetShown = false;
            this.sourcePane.requestFollowCaret();
            this.sourcePane.layout();
        }
    }

    @Override
    public void refresh() {
        this.checkBracketStatus();
        this.scheduleReparseRunner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.FXPlatform)
    public void save() throws IOException {
        Throwable failureException = null;
        if (this.saveState.isChanged()) {
            this.recordEdit(true);
            this.checkForChangeOnDisk();
            if (!this.saveState.isChanged()) {
                return;
            }
            Writer writer = null;
            try {
                String crashFilename = this.filename + CRASHFILE_SUFFIX;
                FileUtility.copyFile((String)this.filename, (String)crashFilename);
                BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(this.filename));
                writer = new OutputStreamWriter((OutputStream)ostream, this.characterSet);
                this.sourcePane.write(writer);
                writer.close();
                writer = null;
                this.setLastModified(new File(this.filename).lastModified());
                File crashFile = new File(crashFilename);
                crashFile.delete();
                this.setSaved();
            }
            catch (IOException ex) {
                failureException = ex;
                this.info.message(Config.getString((String)"editor.info.errorSaving") + " - " + ex.getLocalizedMessage());
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException ex) {
                    failureException = ex;
                }
            }
        }
        if (failureException != null) {
            this.info.message(Config.getString((String)"editor.info.errorSaving") + " - " + failureException.getLocalizedMessage());
            throw failureException;
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void close() {
        this.cancelFreshState();
        try {
            this.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.doClose();
    }

    @Override
    public void displayMessage(String message, int lineNumber, int column) {
        this.switchToSourceView();
        MoeSyntaxDocument.Element line = this.getSourceLine(lineNumber);
        int pos = line.getStartOffset();
        this.sourcePane.setCaretPosition(pos);
        this.sourcePane.moveCaretPosition(line.getEndOffset() - 1);
        this.sourcePane.requestFollowCaret();
        this.info.messageImportant(message);
    }

    @Override
    public boolean displayDiagnostic(Diagnostic diagnostic, int errorIndex, CompileType compileType) {
        if (compileType.showEditorOnError()) {
            this.setEditorVisible(true, false);
        }
        this.switchToSourceView();
        MoeSyntaxDocument.Element line = this.getSourceLine((int)diagnostic.getStartLine());
        if (line != null) {
            int startPos = this.getPosFromColumn(line, (int)diagnostic.getStartColumn());
            int endPos = diagnostic.getStartLine() != diagnostic.getEndLine() ? line.getEndOffset() - 1 : this.getPosFromColumn(line, (int)diagnostic.getEndColumn());
            if (endPos == startPos) {
                if (endPos < this.getTextLength() - 1 && !this.sourceDocument.getText(endPos, 1).equals("\n")) {
                    ++endPos;
                } else if (startPos > 0 && !this.sourceDocument.getText(startPos - 1, 1).equals("\n")) {
                    --startPos;
                }
            }
            this.errorManager.addErrorHighlight(startPos, endPos, diagnostic.getMessage(), diagnostic.getIdentifier());
            this.repaint();
        }
        return true;
    }

    @Override
    public boolean setStepMark(int lineNumber, String message, boolean isBreak, DebuggerThread thread) {
        this.switchToSourceView();
        if (isBreak) {
            this.setStepMark(lineNumber);
        }
        this.sourceDocument.showStepLine(lineNumber);
        this.sourcePane.setCaretPosition(this.getOffsetFromLineColumn(new SourceLocation(lineNumber, 1)));
        this.sourcePane.requestFollowCaret();
        if (message != null) {
            this.info.messageImportant(message);
        }
        return false;
    }

    private int getPosFromColumn(MoeSyntaxDocument.Element line, int column) {
        int spos = line.getStartOffset();
        int epos = line.getEndOffset();
        int testPos = Math.min(epos - spos - 1, column - 1);
        if (testPos <= 0) {
            return spos;
        }
        int tpos = 0;
        String lineText = this.sourceDocument.getText(spos, testPos);
        for (int cpos = 0; cpos < column - 1; cpos -= cpos % 8) {
            int tabPos = lineText.indexOf(9, tpos);
            if (tabPos == -1) {
                return Math.min(spos + (tpos += column - cpos - 1), epos - 1);
            }
            int newcpos = cpos + (tabPos - tpos);
            if (newcpos >= column) {
                return spos + (tpos += column - cpos - 1);
            }
            cpos = newcpos;
            cpos += 8;
            tpos = tabPos + 1;
        }
        return spos;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setSelection(int lineNumber, int columnNumber, int len) {
        MoeSyntaxDocument.Element line = this.getSourceLine(lineNumber);
        this.sourcePane.select(line.getStartOffset() + columnNumber - 1, line.getStartOffset() + columnNumber + len - 1);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setSelection(int lineNumber1, int columnNumber1, int lineNumber2, int columnNumber2) {
        MoeSyntaxDocument.Element line1 = this.getSourceLine(lineNumber1);
        MoeSyntaxDocument.Element line2 = this.getSourceLine(lineNumber2);
        this.sourcePane.select(line1.getStartOffset() + columnNumber1 - 1, line2.getStartOffset() + columnNumber2 - 1);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void removeStepMark() {
        if (this.currentStepLineNumber != -1) {
            this.sourceDocument.setParagraphAttributesForLineNumber(this.currentStepLineNumber, Collections.singletonMap(BlueJSyntaxView.ParagraphAttribute.STEP_MARK, false));
            this.currentStepLineNumber = -1;
            this.sourcePane.setCaretPosition(this.sourcePane.getCaretPosition());
            this.repaint();
        }
    }

    @Override
    public void changeName(String title, String filename, String javaFilename, String docFilename) {
        this.filename = filename;
        this.docFilename = docFilename;
        this.windowTitle = title;
        this.setWindowTitle();
    }

    @Override
    public void setCompiled(boolean compiled) {
        this.setCompileStatus(compiled);
        if (compiled) {
            this.errorManager.removeAllErrorHighlights();
        }
    }

    private void scheduleCompilation(CompileReason reason, CompileType ctype) {
        if (this.watcher != null) {
            if (!this.compilationQueued) {
                this.watcher.scheduleCompilation(true, reason, ctype);
                this.compilationQueued = true;
            } else if (!(!this.compilationStarted && (ctype == CompileType.ERROR_CHECK_ONLY || this.compilationQueuedExplicit) || this.requeueForCompilation && ctype != CompileType.ERROR_CHECK_ONLY)) {
                this.requeueForCompilation = true;
                this.requeueReason = reason;
                this.requeueType = ctype;
            }
        }
    }

    @Override
    public void compileFinished(boolean successful, boolean classesKept) {
        this.compilationStarted = false;
        if (this.requeueForCompilation) {
            this.requeueForCompilation = false;
            if (classesKept) {
                this.compilationQueued = false;
            } else {
                this.compilationQueuedExplicit = this.requeueType != CompileType.ERROR_CHECK_ONLY;
                this.watcher.scheduleCompilation(true, this.requeueReason, this.requeueType);
            }
        } else {
            this.compilationQueued = false;
        }
        if (this.isVisible() && classesKept) {
            if (successful) {
                this.info.messageImportant(Config.getString((String)"editor.info.compiled"));
            } else {
                this.info.messageImportant(this.getCompileErrorLabel());
            }
        }
    }

    private String getCompileErrorLabel() {
        return Config.getString((String)"editor.info.compileError").replace("$", this.actions.getKeyStrokesForAction("compile").stream().map(KeyCodeCombination::getDisplayText).collect(Collectors.joining(" " + Config.getString((String)"or") + " ")));
    }

    @Override
    public void removeBreakpoints() {
        JavaFXUtil.runAfterCurrent(() -> this.clearAllBreakpoints());
    }

    @Override
    public void reInitBreakpoints() {
        if (this.mayHaveBreakpoints) {
            this.mayHaveBreakpoints = false;
            for (int i = 1; i <= this.numberOfLines(); ++i) {
                if (!this.lineHasBreakpoint(i)) continue;
                if (this.watcher != null) {
                    this.watcher.breakpointToggleEvent(i, true);
                }
                this.mayHaveBreakpoints = true;
            }
        }
    }

    @Override
    public boolean isModified() {
        return this.saveState.isChanged();
    }

    @Override
    public boolean isReadOnly() {
        return !this.sourcePane.isEditable();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.saveState.setState(StatusLabel.Status.READONLY);
        }
        this.sourcePane.setEditable(!readOnly);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void showInterface(boolean interfaceStatus) {
        this.interfaceToggle.getSelectionModel().select(interfaceStatus ? 1 : 0);
    }

    public boolean isShowingInterface() {
        return this.viewingHTML.get();
    }

    @Override
    public SourceLocation getCaretLocation() {
        int caretOffset = this.sourcePane.getCaretPosition();
        return this.getLineColumnFromOffset(caretOffset);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setCaretLocation(SourceLocation location) {
        this.sourcePane.setCaretPosition(this.getOffsetFromLineColumn(location));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public SourceLocation getLineColumnFromOffset(int offset) {
        int lineNumber;
        if (offset < 0) {
            return null;
        }
        MoeSyntaxDocument.Element map = this.sourceDocument.getDefaultRootElement();
        MoeSyntaxDocument.Element lineElement = map.getElement(lineNumber = map.getElementIndex(offset));
        if (offset > lineElement.getEndOffset()) {
            return null;
        }
        int column = offset - lineElement.getStartOffset();
        return new SourceLocation(lineNumber + 1, column + 1);
    }

    @Override
    public SourceLocation getSelectionBegin() {
        if (this.sourcePane.getCaretDot() == this.sourcePane.getCaretMark()) {
            return null;
        }
        int beginOffset = Math.min(this.sourcePane.getCaretDot(), this.sourcePane.getCaretMark());
        return this.getLineColumnFromOffset(beginOffset);
    }

    @Override
    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public @OnThread(value=Tag.FXPlatform, ignoreParent=true) SourceLocation getSelectionEnd() {
        if (this.sourcePane.getCaretDot() == this.sourcePane.getCaretMark()) {
            return null;
        }
        int endOffset = Math.max(this.sourcePane.getCaretDot(), this.sourcePane.getCaretMark());
        return this.getLineColumnFromOffset(endOffset);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public String getText(SourceLocation begin, SourceLocation end) {
        int first = this.getOffsetFromLineColumn(begin);
        int last = this.getOffsetFromLineColumn(end);
        int beginOffset = Math.min(first, last);
        int endOffset = Math.max(first, last);
        return this.sourceDocument.getText(beginOffset, endOffset - beginOffset);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setText(SourceLocation begin, SourceLocation end, String newText) {
        int endOffset;
        int finish;
        int start = this.getOffsetFromLineColumn(begin);
        int beginOffset = Math.min(start, finish = this.getOffsetFromLineColumn(end));
        if (beginOffset != (endOffset = Math.max(start, finish))) {
            this.sourceDocument.remove(beginOffset, endOffset - beginOffset);
        }
        this.sourceDocument.insertString(beginOffset, newText);
    }

    @Override
    public void setSelection(SourceLocation begin, SourceLocation end) {
        int start = this.getOffsetFromLineColumn(begin);
        int finish = this.getOffsetFromLineColumn(end);
        int selectionStart = Math.min(start, finish);
        int selectionEnd = Math.max(start, finish);
        this.sourcePane.setCaretPosition(selectionStart);
        this.sourcePane.moveCaretPosition(selectionEnd);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public int getOffsetFromLineColumn(SourceLocation location) {
        int col = location.getColumn() - 1;
        int line = location.getLine() - 1;
        if (line < 0 || col < 0) {
            throw new IllegalArgumentException("line or column < 1");
        }
        MoeSyntaxDocument.Element map = this.sourceDocument.getDefaultRootElement();
        if (line >= map.getElementCount()) {
            throw new IllegalArgumentException("line=" + location.getLine() + " is out of bound");
        }
        MoeSyntaxDocument.Element lineElement = this.sourceDocument.getDefaultRootElement().getElement(line);
        int lineOffset = lineElement.getStartOffset();
        int lineLen = lineElement.getEndOffset() - lineOffset;
        if (col > lineLen) {
            throw new IllegalArgumentException("column=" + location.getColumn() + " greater than line len=" + lineLen);
        }
        return lineOffset + col;
    }

    @Override
    public Object getProperty(String propertyKey) {
        return this.propertyMap.get(propertyKey);
    }

    @Override
    public void setProperty(String propertyKey, Object value) {
        if (propertyKey == null) {
            return;
        }
        this.propertyMap.put(propertyKey, value);
    }

    @Override
    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public @OnThread(value=Tag.FXPlatform, ignoreParent=true) int getLineLength(int line) {
        if (line < 0) {
            return -1;
        }
        MoeSyntaxDocument.Element lineElement = this.sourceDocument.getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        int startOffset = lineElement.getStartOffset();
        return lineElement.getEndOffset() - startOffset;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public int getTextLength() {
        return this.sourceDocument.getLength();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public int numberOfLines() {
        return this.sourceDocument.getDefaultRootElement().getElementCount();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public ParsedCUNode getParsedNode() {
        return this.sourceDocument.getParser();
    }

    private void scheduleReparseRunner() {
        if (this.reparseRunner == null) {
            this.reparseRunner = new ReparseRunner(this);
            JavaFXUtil.runPlatformLater((FXPlatformRunnable)this.reparseRunner);
        }
    }

    public void reparseRunnerFinished() {
        this.reparseRunner = null;
    }

    public void blueJEvent(int eventId, Object arg, Project prj) {
        switch (eventId) {
            case 7: {
                BlueJEvent.removeListener((BlueJEventListener)this);
                this.refreshHtmlDisplay();
                break;
            }
            case 8: {
                BlueJEvent.removeListener((BlueJEventListener)this);
                this.info.message(Config.getString((String)"editor.info.docAborted"));
            }
        }
    }

    private void listenToChanges(MoeSyntaxDocument msd) {
        msd.getDocument().plainChanges().subscribe(c -> {
            if (!this.ignoreChanges) {
                boolean singleLineChange = !((String)c.getInserted()).contains("\n") && !((String)c.getRemoved()).contains("\n");
                boolean inserted = !((String)c.getInserted()).isEmpty();
                this.documentContentChanged(singleLineChange, inserted, c.getPosition(), c.getInsertionEnd() - c.getPosition(), (String)c.getInserted());
            }
        });
    }

    private void documentContentChanged(boolean singleLineChange, boolean inserted, int offset, int insertionLength, String insertedContent) {
        if (this.respondingToChange) {
            return;
        }
        this.respondingToChange = true;
        if (!this.saveState.isChanged()) {
            this.saveState.setState(StatusLabel.Status.CHANGED);
            this.setChanged();
        }
        if (!singleLineChange) {
            this.saveState.setState(StatusLabel.Status.CHANGED);
            this.setChanged();
            if (this.sourceIsCode && this.watcher != null) {
                this.scheduleCompilation(CompileReason.MODIFIED, CompileType.ERROR_CHECK_ONLY);
            }
        }
        this.clearMessage();
        JavaFXUtil.runAfterCurrent(() -> {
            this.removeSearchHighlights();
            this.currentSearchResult.setValue(null);
            this.errorManager.removeAllErrorHighlights();
            this.errorManager.documentContentChanged();
            this.showErrorOverlay(null, 0);
        });
        this.actions.userAction();
        if (inserted && "}".equals(insertedContent) && PrefMgr.getFlag((String)"bluej.editor.autoIndent")) {
            JavaFXUtil.runAfterCurrent(() -> {
                if (offset + insertionLength <= this.getSourcePane().getLength() && this.sourcePane.getText(offset, offset + insertionLength).equals("}")) {
                    this.actions.closingBrace(offset);
                }
            });
        }
        this.recordEdit(false);
        this.scheduleReparseRunner();
        this.respondingToChange = false;
    }

    public void clearMessage() {
        this.info.clear();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void writeMessage(String msg) {
        this.info.message(msg);
    }

    public void writeWarningMessage(String msg) {
        this.info.message(msg);
    }

    public void userSave() {
        if (this.saveState.isSaved()) {
            this.info.message(Config.getString((String)"editor.info.noChanges"));
        } else {
            try {
                this.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public FXRunnable printTo(PrinterJob printerJob, PrefMgr.PrintSize printSize, boolean printLineNumbers, boolean printBackground) {
        ScopeColorsBorderPane scopeColorsPane = new ScopeColorsBorderPane();
        MoeSyntaxDocument doc = new MoeSyntaxDocument(scopeColorsPane);
        doc.markAsForPrinting();
        doc.copyFrom(this.sourceDocument);
        MoeEditorPane editorPane = doc.makeEditorPane(null, null);
        Label pageNumberLabel = new Label("");
        String timestamp = new SimpleDateFormat("yyyy-MMM-dd HH:mm").format(new Date());
        BorderPane header = new BorderPane((Node)new Label(timestamp), null, (Node)pageNumberLabel, null, (Node)new Label(this.getTitle()));
        for (Node node : header.getChildren()) {
            node.setStyle(PrefMgr.getEditorFontFamilyCSS());
        }
        header.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.LIGHTGRAY, null, null)}));
        header.setPadding(new Insets(5.0));
        BorderPane rootPane = new BorderPane((Node)editorPane, (Node)header, null, (Node)scopeColorsPane, null);
        scopeColorsPane.setManaged(false);
        scopeColorsPane.setVisible(false);
        rootPane.setBackground(null);
        double pixelWidth = printerJob.getJobSettings().getPageLayout().getPrintableWidth();
        double pixelHeight = printerJob.getJobSettings().getPageLayout().getPrintableHeight();
        Scene scene = new Scene((Parent)rootPane, pixelWidth, pixelHeight, (Paint)Color.GRAY);
        Config.addEditorStylesheets((Scene)scene);
        editorPane.setPrinting(true, printSize, printLineNumbers);
        editorPane.setWrapText(true);
        editorPane.applyCss();
        for (Node node : editorPane.lookupAll(".scroll-bar")) {
            node.setVisible(false);
            node.setManaged(false);
        }
        rootPane.requestLayout();
        rootPane.layout();
        rootPane.applyCss();
        if (!printBackground) {
            for (int i = 0; i < doc.getDocument().getParagraphs().size(); ++i) {
                doc.getDocument().setParagraphStyle(i, null);
            }
        } else {
            doc.notYetShown = false;
            doc.enableParser(true);
            doc.getParser();
            doc.recalculateAllScopes();
        }
        VirtualFlow virtualFlow = (VirtualFlow)editorPane.lookup(".virtual-flow");
        FXConsumer updatePageNumber = n -> {
            pageNumberLabel.setText("Page " + n);
            rootPane.requestLayout();
            rootPane.layout();
            rootPane.applyCss();
        };
        return () -> MoeEditor.printPages(printerJob, (Node)rootPane, (FXConsumer<Integer>)updatePageNumber, editorPane, virtualFlow);
    }

    @OnThread(value=Tag.FX)
    public static <T, C extends Cell<T, ?>> void printPages(PrinterJob printerJob, Node printNode, FXConsumer<Integer> updatePageNumber, GenericStyledArea<?, ?, ?> editorPane, VirtualFlow<T, C> virtualFlow) {
        virtualFlow.scrollXToPixel(0.0);
        int topLine = 0;
        boolean lastPage = false;
        int editorLines = editorPane.getParagraphs().size();
        int pageNumber = 1;
        while (topLine < editorLines && !lastPage) {
            virtualFlow.showAsFirst(topLine);
            virtualFlow.requestLayout();
            virtualFlow.layout();
            virtualFlow.applyCss();
            ArrayList visibleCells = new ArrayList(virtualFlow.visibleCells());
            if (visibleCells.isEmpty()) {
                return;
            }
            Cell lastCell = (Cell)visibleCells.get(visibleCells.size() - 1);
            lastPage = virtualFlow.getCellIfVisible(editorLines - 1).isPresent();
            if (!lastPage) {
                double limitY = virtualFlow.cellToViewport(lastCell, 0.0, 0.0).getY();
                editorPane.setClip((Node)new Rectangle(editorPane.getWidth(), limitY));
                topLine += visibleCells.size() - 1;
            } else {
                editorPane.setClip((Node)new Rectangle(editorPane.getWidth(), editorPane.getHeight()));
                editorPane.setTranslateY(-virtualFlow.cellToViewport(virtualFlow.getCell(topLine), 0.0, 0.0).getY());
            }
            updatePageNumber.accept((Object)pageNumber);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            printerJob.printPage(printNode);
            ++pageNumber;
        }
    }

    public void print() {
        Optional choices = new PrintDialog(this.getWindow(), null).showAndWait();
        if (!choices.isPresent()) {
            return;
        }
        final PrinterJob job = JavaFXUtil.createPrinterJob();
        if (job == null) {
            DialogManager.showErrorFX((Window)this.getWindow(), (String)"print-no-printers");
        } else if (job.showPrintDialog(this.getWindow())) {
            final FXRunnable printAction = this.printTo(job, ((PrintDialog.PrintChoices)choices.get()).printSize, ((PrintDialog.PrintChoices)choices.get()).printLineNumbers, ((PrintDialog.PrintChoices)choices.get()).printHighlighting);
            new Thread("PRINT"){

                @Override
                @OnThread(value=Tag.FX, ignoreParent=true)
                public void run() {
                    printAction.run();
                    job.endJob();
                }
            }.start();
        }
    }

    public void doClose() {
        this.setEditorVisible(false, false);
        if (this.watcher != null) {
            this.watcher.closeEvent(this);
        }
    }

    public boolean checkExpandTabs() {
        if (this.tabsAreExpanded) {
            return false;
        }
        this.tabsAreExpanded = true;
        return true;
    }

    protected void showReplacePanel() {
        if (!this.finder.isVisible()) {
            this.finder.setVisible(true);
        }
        this.finder.requestFindfieldFocus();
        this.finder.setReplaceEnabled(true);
    }

    public void findNext(boolean backwards) {
        if (this.currentSearchResult.get() == null || !((FindNavigator)this.currentSearchResult.get()).validProperty().get()) {
            String search = this.sourcePane.getSelectedText();
            if (search.isEmpty()) {
                search = this.lastSearchString;
            }
            this.doFind(search, true);
        }
        if (this.currentSearchResult.get() != null) {
            if (backwards) {
                ((FindNavigator)this.currentSearchResult.get()).selectPrev();
            } else {
                ((FindNavigator)this.currentSearchResult.get()).selectNext(false);
            }
        }
    }

    boolean findString(String s, boolean backward, boolean ignoreCase, boolean wrap) {
        boolean found;
        if (s.length() == 0) {
            this.info.message(" ");
            return false;
        }
        if (backward) {
            found = this.doFind(s, ignoreCase) != null;
        } else {
            this.setCaretPositionForward(1);
            found = this.doFind(s, ignoreCase) != null;
        }
        StringBuilder msg = new StringBuilder(Config.getString((String)"editor.find.find.label") + " ");
        msg.append(backward ? Config.getString((String)"editor.find.backward") : Config.getString((String)"editor.find.forward"));
        if (ignoreCase || wrap) {
            msg.append(" (");
        }
        if (ignoreCase) {
            msg.append(Config.getString((String)"editor.find.ignoreCase").toLowerCase()).append(", ");
        }
        if (wrap) {
            msg.append(Config.getString((String)"editor.find.wrapAround").toLowerCase()).append(", ");
        }
        if (ignoreCase || wrap) {
            msg.replace(msg.length() - 2, msg.length(), "): ");
        } else {
            msg.append(": ");
        }
        msg.append(s);
        if (found) {
            this.info.message(msg.toString());
        } else {
            this.info.message(msg.toString(), Config.getString((String)"editor.info.notFound"));
        }
        return found;
    }

    public void showPreferences(int paneIndex) {
        this.watcher.showPreferences(paneIndex);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    FindNavigator doFind(final String searchFor, final boolean ignoreCase) {
        this.removeSearchHighlights();
        this.sourcePane.moveTo(Math.min(this.sourcePane.getAnchor(), this.sourcePane.getCaretPosition()));
        this.lastSearchString = searchFor;
        String content = this.sourcePane.getText();
        int curPosition = 0;
        boolean finished = false;
        final ArrayList<Integer> foundStarts = new ArrayList<Integer>();
        while (!finished) {
            int foundPos = MoeEditor.findSubstring(content, searchFor, ignoreCase, false, curPosition);
            if (foundPos != -1) {
                foundStarts.add(foundPos);
                curPosition = foundPos + searchFor.length();
                continue;
            }
            finished = true;
        }
        this.currentSearchResult.set((Object)(foundStarts.isEmpty() ? null : new FindNavigator(){

            @Override
            public void highlightAll() {
                for (Integer foundPos : foundStarts) {
                    MoeEditor.this.sourceDocument.markFindResult(foundPos, foundPos + searchFor.length());
                }
            }

            @Override
            public FindNavigator replaceCurrent(String replacement) {
                if (!MoeEditor.this.sourcePane.getSelectedText().equals(searchFor)) {
                    this.selectNext(true);
                }
                int pos = MoeEditor.this.sourcePane.getSelection().getStart();
                MoeEditor.this.sourceDocument.replace(pos, searchFor.length(), replacement);
                MoeEditor.this.sourcePane.setCaretPosition(pos + searchFor.length());
                JavaFXUtil.runAfter((Duration)Duration.millis((double)200.0), () -> MoeEditor.this.sourcePane.requestFollowCaret());
                return MoeEditor.this.doFind(searchFor, ignoreCase);
            }

            @Override
            public void replaceAll(String replacement) {
                foundStarts.stream().sorted(Comparator.reverseOrder()).forEach(pos -> MoeEditor.this.sourceDocument.replace((int)pos, searchFor.length(), replacement));
            }

            @Override
            public void selectNext(boolean canBeAtCurrentPos) {
                if (this.validProperty().get()) {
                    int selStart = MoeEditor.this.sourcePane.getSelection().getStart();
                    int position = foundStarts.stream().filter(pos -> pos > selStart || canBeAtCurrentPos && pos == selStart).findFirst().orElse((Integer)foundStarts.get(0));
                    this.select(position);
                }
            }

            private void select(int position) {
                MoeEditor.this.sourcePane.select(position, position + searchFor.length());
                MoeEditor.this.sourcePane.requestFollowCaret();
            }

            @Override
            public void selectPrev() {
                if (this.validProperty().get()) {
                    int selStart = MoeEditor.this.sourcePane.getSelection().getStart();
                    int position = Utility.streamReversed((List)foundStarts).filter(pos -> pos < selStart).findFirst().orElse((Integer)foundStarts.get(foundStarts.size() - 1));
                    this.select(position);
                }
            }

            @Override
            public BooleanExpression validProperty() {
                return MoeEditor.this.currentSearchResult.isEqualTo((Object)this);
            }
        }));
        return (FindNavigator)this.currentSearchResult.get();
    }

    public void goToLine() {
        int numberOfLines = this.numberOfLines();
        GoToLineDialog goToLineDialog = new GoToLineDialog(this.fxTabbedEditor.getWindow());
        goToLineDialog.setRangeMax(numberOfLines);
        Optional o = goToLineDialog.showAndWait();
        o.ifPresent(n -> {
            this.setSelection((int)n, 1, 0);
            this.ensureCaretVisible();
        });
    }

    private void ensureCaretVisible() {
        this.sourcePane.requestFollowCaret();
    }

    public void toggleInterface() {
        if (this.isShowingInterface()) {
            this.switchToSourceView();
        } else {
            this.switchToInterfaceView();
        }
    }

    private void switchToSourceView() {
        if (!this.viewingHTML.get()) {
            return;
        }
        this.resetMenuToolbar(true);
        this.viewingHTML.set(false);
        this.interfaceToggle.getSelectionModel().selectFirst();
        this.watcher.showingInterface(false);
        this.clearMessage();
    }

    private void switchToInterfaceView() {
        if (this.viewingHTML.get()) {
            return;
        }
        this.resetMenuToolbar(false);
        try {
            boolean generateDoc;
            this.save();
            this.info.message(Config.getString((String)"editor.info.loadingDoc"));
            boolean bl = generateDoc = !this.docUpToDate();
            if (generateDoc) {
                this.info.message(Config.getString((String)"editor.info.generatingDoc"));
                BlueJEvent.addListener((BlueJEventListener)this);
                if (this.watcher != null) {
                    this.watcher.generateDoc();
                }
            } else {
                this.refreshHtmlDisplay();
            }
            this.interfaceToggle.getSelectionModel().selectLast();
            this.viewingHTML.set(true);
            this.watcher.showingInterface(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static org.w3c.dom.Node findHTMLNode(org.w3c.dom.Node start, UnaryOperator<org.w3c.dom.Node> next, Predicate<org.w3c.dom.Node> stopWhen) {
        org.w3c.dom.Node n = start;
        while (n != null) {
            if ((n = (org.w3c.dom.Node)next.apply(n)) == null || !stopWhen.test(n)) continue;
            return n;
        }
        return null;
    }

    private void refreshHtmlDisplay() {
        try {
            File urlFile = new File(this.getDocPath());
            if (!urlFile.exists()) {
                return;
            }
            URL myURL = urlFile.toURI().toURL();
            String location = this.htmlPane.getEngine().getLocation();
            if (Objects.equals(location == null ? null : new URL(location), myURL)) {
                this.htmlPane.getEngine().reload();
            } else {
                this.htmlPane.getEngine().load(myURL.toString());
            }
            this.info.message(Config.getString((String)"editor.info.docLoaded"));
        }
        catch (IOException exc) {
            this.info.message(Config.getString((String)"editor.info.docDisappeared"), this.getDocPath());
            Debug.reportError((String)("loading class interface failed: " + exc));
        }
    }

    private void setupJavadocMangler() {
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.htmlPane.getEngine().documentProperty(), doc -> {
            if (doc != null) {
                NodeList anchors = doc.getElementsByTagName("a");
                for (int i = 0; i < anchors.getLength(); ++i) {
                    org.w3c.dom.Node headerNode;
                    org.w3c.dom.Node liNode;
                    org.w3c.dom.Node ulNode;
                    org.w3c.dom.Node anchorItem = anchors.item(i);
                    org.w3c.dom.Node anchorName = anchorItem.getAttributes().getNamedItem("id");
                    if (anchorName == null || anchorName.getNodeValue() == null || !anchorName.getNodeValue().endsWith(")") || (ulNode = MoeEditor.findHTMLNode(anchorItem, org.w3c.dom.Node::getNextSibling, n -> "ul".equals(n.getLocalName()))) == null || (liNode = MoeEditor.findHTMLNode(ulNode.getFirstChild(), org.w3c.dom.Node::getNextSibling, n -> "li".equals(n.getLocalName()))) == null || (headerNode = MoeEditor.findHTMLNode(liNode.getFirstChild(), org.w3c.dom.Node::getNextSibling, n -> "h4".equals(n.getLocalName()))) == null) continue;
                    Element newLink = doc.createElement("a");
                    newLink.setAttribute("style", "padding-left: 2em;cursor:pointer;");
                    newLink.insertBefore(doc.createTextNode("[Show source in BlueJ]"), null);
                    headerNode.insertBefore(newLink, null);
                    ((EventTarget)((Object)newLink)).addEventListener("click", e -> {
                        String[] tokens = anchorName.getNodeValue().split("[(,)]");
                        ArrayList<String> paramTypes = new ArrayList<String>();
                        for (int t = 1; t < tokens.length; ++t) {
                            paramTypes.add(tokens[t]);
                        }
                        this.focusMethod(tokens[0].equals("<init>") ? this.windowTitle : tokens[0], paramTypes);
                    }, false);
                }
            }
        });
    }

    private boolean docUpToDate() {
        if (this.filename == null) {
            return true;
        }
        try {
            File src = new File(this.filename);
            File doc = new File(this.docFilename);
            if (!doc.exists() || src.exists() && src.lastModified() > doc.lastModified()) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void resetMenuToolbar(boolean sourceView) {
        if (sourceView) {
            this.actions.makeAllAvailable();
        } else {
            this.actions.makeAllUnavailableExcept("close", "toggle-interface-view");
        }
    }

    public void toggleBreakpoint() {
        if (!this.viewingCode()) {
            this.info.message(" ");
            return;
        }
        this.toggleBreakpoint(this.sourcePane.getCaretPosition());
    }

    public void toggleBreakpoint(int pos) {
        if (this.positionHasBreakpoint(pos)) {
            this.setUnsetBreakpoint(pos, false);
        } else {
            this.setUnsetBreakpoint(pos, true);
        }
    }

    private void clearAllBreakpoints() {
        if (this.mayHaveBreakpoints) {
            for (int i = 1; i <= this.numberOfLines(); ++i) {
                if (!this.lineHasBreakpoint(i)) continue;
                this.doRemoveBreakpoint(i);
            }
            this.mayHaveBreakpoints = false;
        }
    }

    private boolean positionHasBreakpoint(int pos) {
        return this.lineHasBreakpoint(this.getLineNumberAt(pos));
    }

    private boolean lineHasBreakpoint(int lineNo) {
        return this.sourceDocument.getParagraphAttributes(lineNo).contains((Object)BlueJSyntaxView.ParagraphAttribute.BREAKPOINT);
    }

    private void setUnsetBreakpoint(int pos, boolean set) {
        if (this.watcher != null) {
            int line = this.getLineNumberAt(pos);
            String result = this.watcher.breakpointToggleEvent(line, set);
            if (result == null) {
                if (set) {
                    this.mayHaveBreakpoints = true;
                }
                this.sourceDocument.setParagraphAttributesForLineNumber(line, Collections.singletonMap(BlueJSyntaxView.ParagraphAttribute.BREAKPOINT, set));
            } else {
                this.info.message(result);
            }
            this.repaint();
        } else {
            this.info.message(Config.getString((String)"editor.info.cannotSetBreak"));
        }
    }

    private void doRemoveBreakpoint(int lineNumber) {
        this.sourceDocument.setParagraphAttributesForLineNumber(lineNumber, Collections.singletonMap(BlueJSyntaxView.ParagraphAttribute.BREAKPOINT, false));
        this.repaint();
    }

    private void setStepMark(int lineNumber) {
        this.removeStepMark();
        this.sourceDocument.setParagraphAttributesForLineNumber(lineNumber, Collections.singletonMap(BlueJSyntaxView.ParagraphAttribute.STEP_MARK, true));
        this.currentStepLineNumber = lineNumber;
        this.repaint();
    }

    private void repaint() {
    }

    private boolean viewingCode() {
        return this.sourceIsCode && !this.viewingHTML.get();
    }

    private MoeSyntaxDocument.Element getSourceLine(int lineNo) {
        MoeSyntaxDocument.Element map = this.sourceDocument.getDefaultRootElement();
        if (map.getElementCount() >= lineNo) {
            return this.sourceDocument.getDefaultRootElement().getElement(lineNo - 1);
        }
        return null;
    }

    private int getLineNumberAt(int pos) {
        return this.sourceDocument.getDefaultRootElement().getElementIndex(pos) + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReload() {
        this.removeSearchHighlights();
        Reader reader = null;
        try {
            FileInputStream inputStream = new FileInputStream(this.filename);
            reader = new InputStreamReader((InputStream)inputStream, this.characterSet);
            this.sourcePane.read(reader);
            try {
                reader.close();
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            File file = new File(this.filename);
            this.setLastModified(file.lastModified());
            this.sourceDocument.enableParser(false);
            this.listenToChanges(this.sourceDocument);
            this.saveState.setState(StatusLabel.Status.SAVED);
            this.setChanged();
            this.setSaved();
            this.scheduleReparseRunner();
            this.scheduleCompilation(CompileReason.LOADED, CompileType.ERROR_CHECK_ONLY);
        }
        catch (FileNotFoundException ex) {
            this.info.message(Config.getString((String)"editor.info.fileDisappeared"));
        }
        catch (IOException ex) {
            this.info.message(Config.getString((String)"editor.info.fileReadError"));
            this.setChanged();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {}
            if (this.finder != null && this.finder.isVisible()) {
                this.findNext(false);
            }
        }
    }

    private void checkBracketStatus() {
        matchBrackets = PrefMgr.getFlag((String)"bluej.editor.matchBrackets");
        if (matchBrackets) {
            this.doBracketMatch();
        } else {
            this.removeBracketHighlight();
        }
    }

    private void setCompileStatus(boolean compiled) {
        this.actions.getActionByName("toggle-breakpoint").setEnabled(compiled && this.viewingCode());
        this.compiledProperty.set(compiled);
    }

    private void setSaved() {
        this.saveState.setState(StatusLabel.Status.SAVED);
        if (this.watcher != null) {
            this.watcher.saveEvent(this);
        }
    }

    private void setChanged() {
        if (this.ignoreChanges) {
            return;
        }
        this.setCompileStatus(false);
        if (this.watcher != null) {
            this.watcher.modificationEvent(this);
        }
    }

    public void caretMoved() {
        int caretPos = this.sourcePane.getCaretPosition();
        this.showErrorPopupForCaretPos(caretPos, false);
        if (matchBrackets) {
            this.doBracketMatch();
        }
        this.actions.userAction();
        if (this.oldCaretLineNumber != this.getLineNumberAt(caretPos) && this.isOpen()) {
            this.recordEdit(true);
            this.cancelFreshState();
            JavaFXUtil.runAfterCurrent(() -> {
                this.ensureCaretVisible();
                this.layout();
            });
        }
        this.oldCaretLineNumber = this.getLineNumberAt(caretPos);
    }

    private void showErrorPopupForCaretPos(int caretPos, boolean mousePosition) {
        MoeErrorManager.ErrorDetails err;
        MoeErrorManager.ErrorDetails errorDetails = err = caretPos == -1 ? null : this.errorManager.getErrorAtPosition(caretPos);
        if (err != null) {
            this.showErrorOverlay(err, caretPos);
        } else if (!(this.errorDisplay == null || mousePosition && this.errorDisplay.details.containsPosition(this.sourcePane.getCaretPosition()))) {
            this.showErrorOverlay(null, caretPos);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void cancelFreshState() {
        if (this.sourceIsCode && this.saveState.isChanged()) {
            this.scheduleCompilation(CompileReason.MODIFIED, CompileType.ERROR_CHECK_ONLY);
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void focusMethod(String methodName, List<String> paramTypes) {
        this.focusMethod(methodName, paramTypes, (NodeTree.NodeAndPosition<ParsedNode>)new NodeTree.NodeAndPosition((RBTreeNode)this.getParsedNode(), 0, 0), 0);
    }

    private boolean focusMethod(String methodName, List<String> paramTypes, NodeTree.NodeAndPosition<ParsedNode> tree, int offset) {
        if (((ParsedNode)tree.getNode()).getNodeType() == 2 && methodName.equals(((ParsedNode)tree.getNode()).getName()) && this.paramsMatch((ParsedNode)tree.getNode(), paramTypes)) {
            this.switchToSourceView();
            this.sourcePane.setCaretPosition(offset);
            this.sourcePane.requestFollowCaret();
            return true;
        }
        for (NodeTree.NodeAndPosition child : () -> ((ParsedNode)tree.getNode()).getChildren(0)) {
            if (!this.focusMethod(methodName, paramTypes, (NodeTree.NodeAndPosition<ParsedNode>)child, offset + child.getPosition())) continue;
            return true;
        }
        return false;
    }

    private boolean paramsMatch(ParsedNode node, List<String> paramTypes) {
        if (paramTypes == null) {
            return true;
        }
        if (node instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)node;
            if (methodNode.getParamTypes().size() != paramTypes.size()) {
                return false;
            }
            for (int i = 0; i < paramTypes.size(); ++i) {
                JavaEntity paramType = (JavaEntity)methodNode.getParamTypes().get(i);
                if (paramType.getName().equals(paramTypes.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void showErrorOverlay(MoeErrorManager.ErrorDetails details, int displayPosition) {
        if (details != null) {
            if (this.errorDisplay == null || this.errorDisplay.details != details) {
                if (this.errorDisplay != null) {
                    ErrorDisplay old = this.errorDisplay;
                    old.popup.hide();
                }
                Bounds pos = null;
                boolean before = false;
                try {
                    pos = this.sourcePane.getCharacterBoundsOnScreen(displayPosition, displayPosition + 1).orElse(null);
                    if (pos == null) {
                        pos = this.sourcePane.getCharacterBoundsOnScreen(displayPosition - 1, displayPosition).orElse(null);
                        before = true;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (pos == null) {
                    return;
                }
                int xpos = (int)(before ? pos.getMaxX() : pos.getMinX());
                int ypos = (int)(pos.getMinY() + 4.0 * pos.getHeight() / 3.0);
                ErrorDisplay newDisplay = this.errorDisplay = new ErrorDisplay(details);
                newDisplay.createPopup();
                newDisplay.popup.setAnchorLocation(PopupWindow.AnchorLocation.WINDOW_TOP_LEFT);
                newDisplay.popup.setAnchorX((double)xpos);
                newDisplay.popup.setAnchorY((double)ypos);
                newDisplay.popup.show(this.getWindow());
                if (this.watcher != null) {
                    this.watcher.recordShowErrorMessage(details.identifier, Collections.emptyList());
                }
            }
        } else if (this.errorDisplay != null) {
            ErrorDisplay old = this.errorDisplay;
            old.popup.hide();
            this.errorDisplay = null;
        }
    }

    public int getBracketMatch() {
        int pos = -1;
        int caretPos = this.sourcePane.getCaretPosition();
        if (caretPos != 0) {
            --caretPos;
        }
        pos = TextUtilities.findMatchingBracket(this.sourceDocument, caretPos);
        return pos;
    }

    private void doBracketMatch() {
        int originalPos = this.getSourcePane().getCaretPosition();
        int matchBracket = this.getBracketMatch();
        JavaFXUtil.runPlatformLater(() -> {
            this.removeBracketHighlight();
            if (matchBracket != -1 && originalPos > 0 && originalPos == this.getSourcePane().getCaretPosition()) {
                this.sourceDocument.addStyle(originalPos - 1, originalPos, "moe-bracket-highlight");
                this.sourceDocument.addStyle(matchBracket, matchBracket + 1, "moe-bracket-highlight");
            }
        });
    }

    private void removeBracketHighlight() {
        this.sourceDocument.removeStyleThroughout("moe-bracket-highlight");
    }

    private void setWindowTitle() {
        Object title = this.windowTitle;
        if (title == null) {
            title = this.filename == null ? "Moe:  <no name>" : "Moe:  " + this.filename;
        }
        this.fxTab.setWindowTitle((String)title);
    }

    private String getDocPath() {
        return this.docFilename;
    }

    private String getResource(String name) {
        return Config.getPropString((String)name, null, (Properties)this.resources);
    }

    private void initWindow(EntityResolver projectResolver) {
        BorderPane bottomArea = new BorderPane();
        JavaFXUtil.addStyleClass((Styleable)bottomArea, (String[])new String[]{"moe-bottom-bar"});
        this.finder = new FindPanel(this);
        this.finder.setVisible(false);
        this.saveState = new StatusLabel(StatusLabel.Status.SAVED, this, this.errorManager);
        this.info = new Info();
        BorderPane commentsPanel = new BorderPane();
        commentsPanel.setCenter((Node)this.info);
        commentsPanel.setRight((Node)this.saveState);
        BorderPane.setAlignment((Node)this.info, (Pos)Pos.TOP_LEFT);
        BorderPane.setAlignment((Node)this.saveState, (Pos)Pos.CENTER_RIGHT);
        JavaFXUtil.addStyleClass((Styleable)commentsPanel, (String[])new String[]{"moe-bottom-status-row"});
        commentsPanel.styleProperty().bind((ObservableValue)PrefMgr.getEditorFontCSS((boolean)false));
        bottomArea.setBottom((Node)commentsPanel);
        bottomArea.setTop((Node)this.finder);
        this.setBottom((Node)bottomArea);
        this.sourceDocument = projectResolver != null ? new MoeSyntaxDocument(projectResolver, this) : new MoeSyntaxDocument((ScopeColors)null);
        this.listenToChanges(this.sourceDocument);
        this.sourcePane = this.sourceDocument.makeEditorPane(this, (BooleanExpression)this.compiledProperty);
        this.sourcePane.setCaretPosition(0);
        this.undoManager = new MoeUndoManager(this.sourcePane);
        this.sourcePane.setUndoManager(this.undoManager.getUndoManager());
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.sourcePane.caretPositionProperty(), e -> this.caretMoved());
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.sourcePane.estimatedScrollYProperty(), d -> JavaFXUtil.runAfterCurrent(() -> this.showErrorPopupForCaretPos(this.sourcePane.getCaretPosition(), false)));
        this.sourcePane.setMouseOverTextDelay(java.time.Duration.ofMillis(400L));
        this.sourcePane.addEventHandler(MouseOverTextEvent.ANY, this::mouseOverText);
        Nodes.addInputMap((Node)this.sourcePane, (InputMap)InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.ESCAPE, (KeyCombination.Modifier[])new KeyCombination.Modifier[0]), e -> {
            if (this.finder != null && this.finder.isVisible()) {
                this.finder.close();
            }
        }));
        HBox editorPane = new HBox();
        this.htmlPane = new WebView();
        this.htmlPane.visibleProperty().bind((ObservableValue)this.viewingHTML);
        editorPane.setFillHeight(true);
        BorderPane background = new BorderPane();
        JavaFXUtil.addStyleClass((Styleable)background, (String[])new String[]{"moe-background"});
        this.setCenter((Node)new StackPane(new Node[]{background, new VirtualizedScrollPane((Node)this.sourcePane), this.htmlPane}));
        this.actions = MoeActions.getActions(this);
        this.menubar = this.createMenuBar();
        this.actions.updateKeymap();
        this.fxMenus.clear();
        this.menubar.getMenus().forEach(this.fxMenus::add);
        ComboBox<String> interfaceSelector = this.createInterfaceSelector();
        interfaceSelector.setDisable(!this.sourceIsCode);
        Region toolbar = this.createToolbar((DoubleExpression)interfaceSelector.heightProperty());
        BorderPane topBar = new BorderPane(null, null, interfaceSelector, null, (Node)toolbar);
        topBar.getStyleClass().add((Object)"moe-top-bar");
        this.setTop((Node)topBar);
        this.sourcePane.setContextMenu(this.createPopupMenu());
    }

    private MenuBar createMenuBar() {
        return new MenuBar(new Menu[]{this.createMenu("class", "save - print - close"), this.createMenu("edit", "undo redo - cut-to-clipboard copy-to-clipboard paste-from-clipboard - indent-block deindent-block comment-block uncomment-block autoindent - insert-method add-javadoc"), this.createMenu("tools", "find find-next find-next-backward replace go-to-line - compile toggle-breakpoint - toggle-interface-view"), this.createMenu("option", "increase-font decrease-font reset-font - key-bindings preferences")});
    }

    private ContextMenu createPopupMenu() {
        String[] popupKeys;
        ContextMenu popup = new ContextMenu();
        for (String popupKey : popupKeys = "cut copy paste".split(" ")) {
            String label = Config.getString((String)("editor." + popupKey + LabelSuffix));
            String actionName = this.getResource(popupKey + ActionSuffix);
            MoeActions.MoeAbstractAction action = this.actions.getActionByName(actionName);
            if (action == null) {
                Debug.message((String)("Moe: cannot find action " + popupKey));
                continue;
            }
            MenuItem menuItem = action.makeContextMenuItem();
            menuItem.setText(label);
            popup.getItems().add((Object)menuItem);
        }
        return popup;
    }

    private Menu createMenu(String titleKey, String itemList) {
        String[] itemKeys;
        Menu menu = new Menu(Config.getString((String)("editor." + titleKey + LabelSuffix)));
        for (String itemKey : itemKeys = itemList.split(" ")) {
            if (itemKey.equals("-")) {
                menu.getItems().add((Object)new SeparatorMenuItem());
                continue;
            }
            MoeActions.MoeAbstractAction action = this.actions.getActionByName(itemKey);
            if (action == null) {
                Debug.message((String)("Moe: cannot find action " + itemKey));
                continue;
            }
            if (Config.isMacOS() && titleKey.toLowerCase().equals("option") && itemKey.toLowerCase().equals("preferences")) continue;
            MenuItem item = action.makeMenuItem();
            menu.getItems().add((Object)item);
            String label = Config.getString((String)("editor." + itemKey + LabelSuffix));
            item.setText(label);
        }
        return menu;
    }

    private Region createToolbar(DoubleExpression buttonHeight) {
        TilePane tilePane = new TilePane(Orientation.HORIZONTAL, new Node[]{this.createToolbarButton("compile", buttonHeight), this.createToolbarButton("undo", buttonHeight), this.createToolbarButton("cut", buttonHeight), this.createToolbarButton("copy", buttonHeight), this.createToolbarButton("paste", buttonHeight), this.createToolbarButton("find", buttonHeight), this.createToolbarButton("close", buttonHeight)});
        tilePane.setPrefColumns(tilePane.getChildren().size());
        return (Region)JavaFXUtil.withStyleClass((Styleable)tilePane, (String[])new String[]{"moe-top-bar-buttons"});
    }

    private ButtonBase createToolbarButton(String key, DoubleExpression buttonHeight) {
        Button button;
        MoeActions.MoeAbstractAction action;
        String label = Config.getString((String)("editor." + key + LabelSuffix));
        String actionName = this.getResource(key + ActionSuffix);
        if (actionName == null) {
            actionName = key;
        }
        if ((action = this.actions.getActionByName(actionName)) != null) {
            button = action.makeButton();
            button.setText(label);
        } else {
            button = new Button("Unknown");
        }
        if (action == null) {
            button.setDisable(true);
            Debug.message((String)("Moe: action not found for button " + label));
        }
        if (MoeEditor.isNonReadmeAction(actionName) && !this.sourceIsCode) {
            action.setEnabled(false);
        }
        button.setFocusTraversable(false);
        button.setMaxWidth(Double.MAX_VALUE);
        button.prefHeightProperty().bind((ObservableValue)buttonHeight);
        button.setMaxHeight(Double.MAX_VALUE);
        button.getStyleClass().add((Object)("toolbar-" + key + "-button"));
        return button;
    }

    private ComboBox<String> createInterfaceSelector() {
        Object[] choiceStrings = new String[]{this.implementationString, this.interfaceString};
        this.interfaceToggle = new ComboBox(FXCollections.observableArrayList((Object[])choiceStrings));
        this.interfaceToggle.setFocusTraversable(false);
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.interfaceToggle.valueProperty(), v -> {
            if (v.equals(this.interfaceString)) {
                this.switchToInterfaceView();
            } else {
                this.switchToSourceView();
            }
        });
        return this.interfaceToggle;
    }

    public void initFindPanel() {
        this.finder.displayFindPanel(this.sourcePane.getSelectedText());
    }

    public void setCaretPositionForward(int caretPos) {
        int docLength = this.sourcePane.getLength();
        if (this.sourcePane.getCaretPosition() + caretPos <= docLength) {
            this.sourcePane.setCaretPosition(this.sourcePane.getCaretPosition() + caretPos);
        } else {
            this.sourcePane.setCaretPosition(docLength);
        }
    }

    public MoeEditorPane getSourcePane() {
        return this.sourcePane;
    }

    public WebView getHTMLPane() {
        return this.htmlPane;
    }

    public MoeEditorPane getCurrentTextPane() {
        return this.sourcePane;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public MoeSyntaxDocument getSourceDocument() {
        return this.sourceDocument;
    }

    public void removeSearchHighlights() {
        this.sourceDocument.removeSearchHighlights();
    }

    protected void createContentAssist() {
        ExpressionTypeInfo suggests;
        ParsedCUNode parser = this.sourceDocument.getParser();
        ExpressionTypeInfo expressionTypeInfo = suggests = parser == null ? null : parser.getExpressionType(this.sourcePane.getCaretPosition(), this.sourceDocument);
        if (suggests != null) {
            Bounds screenPos;
            int originalPosition;
            LocatableToken suggestToken = suggests.getSuggestionToken();
            final AssistContent[] possibleCompletions = ParseUtils.getPossibleCompletions((ExpressionTypeInfo)suggests, (JavadocResolver)this.javadocResolver, null);
            Arrays.sort(possibleCompletions, AssistContent.getComparator());
            List suggestionDetails = Arrays.stream(possibleCompletions).map(AssistContentThreadSafe::new).map(ac -> new SuggestionList.SuggestionDetailsWithHTMLDoc(ac.getName(), ExpressionCompletionCalculator.getParamsCompletionDisplay((AssistContentThreadSafe)ac), ac.getType(), SuggestionList.SuggestionShown.COMMON, ac.getDocHTML())).collect(Collectors.toList());
            int n = originalPosition = suggestToken == null ? this.sourcePane.getCaretPosition() : suggestToken.getPosition();
            if (suggestToken == null) {
                screenPos = this.sourcePane.getCaretBounds().orElse(null);
            } else {
                screenPos = this.sourcePane.getCharacterBoundsOnScreen(originalPosition, originalPosition + 1).orElse(null);
                if (screenPos == null) {
                    screenPos = this.sourcePane.getCharacterBoundsOnScreen(originalPosition - 1, originalPosition).orElse(null);
                    screenPos = new BoundingBox(screenPos.getMaxX(), screenPos.getMinY(), 0.0, screenPos.getHeight());
                }
            }
            if (screenPos == null) {
                return;
            }
            Bounds spLoc = this.sourcePane.screenToLocal(screenPos);
            final StringExpression editorFontCSS = PrefMgr.getEditorFontCSS((boolean)true);
            SuggestionList suggestionList = new SuggestionList(new SuggestionList.SuggestionListParent(){

                @OnThread(value=Tag.FX)
                public StringExpression getFontCSS() {
                    return editorFontCSS;
                }

                public double getFontSize() {
                    return PrefMgr.getEditorFontSize().get();
                }

                public void setupSuggestionWindow(Stage window) {
                    MoeEditor.this.sourcePane.setFakeCaret(true);
                }
            }, suggestionDetails, null, SuggestionList.SuggestionShown.RARE, i -> {}, new SuggestionList.SuggestionListListener(){

                @OnThread(value=Tag.FXPlatform)
                public void suggestionListChoiceClicked(SuggestionList suggestionList, int highlighted) {
                    if (highlighted != -1) {
                        MoeEditor.this.codeComplete(possibleCompletions[highlighted], originalPosition, MoeEditor.this.sourcePane.getCaretPosition(), suggestionList);
                    }
                }

                public SuggestionList.SuggestionListListener.Response suggestionListKeyTyped(SuggestionList suggestionList, KeyEvent event, int highlighted) {
                    if (!event.getCharacter().equals("\b") && !event.getCharacter().equals("\u007f")) {
                        if (event.getCharacter().equals("\n")) {
                            this.suggestionListChoiceClicked(suggestionList, highlighted);
                            return SuggestionList.SuggestionListListener.Response.DISMISS;
                        }
                        MoeEditor.this.sourcePane.insertText(MoeEditor.this.sourcePane.getCaretPosition(), event.getCharacter());
                    }
                    String prefix = MoeEditor.this.sourcePane.getText(originalPosition, MoeEditor.this.sourcePane.getCaretPosition());
                    suggestionList.calculateEligible(prefix, true, false);
                    suggestionList.updateVisual(prefix);
                    return SuggestionList.SuggestionListListener.Response.CONTINUE;
                }

                @OnThread(value=Tag.FXPlatform)
                public SuggestionList.SuggestionListListener.Response suggestionListKeyPressed(SuggestionList suggestionList, KeyEvent event, int highlighted) {
                    switch (event.getCode()) {
                        case ESCAPE: {
                            return SuggestionList.SuggestionListListener.Response.DISMISS;
                        }
                        case ENTER: 
                        case TAB: {
                            this.suggestionListChoiceClicked(suggestionList, highlighted);
                            return SuggestionList.SuggestionListListener.Response.DISMISS;
                        }
                        case BACK_SPACE: {
                            MoeEditor.this.sourcePane.deletePreviousChar();
                            break;
                        }
                        case DELETE: {
                            MoeEditor.this.sourcePane.deleteNextChar();
                        }
                    }
                    if (MoeEditor.this.sourcePane.getCaretPosition() < originalPosition) {
                        return SuggestionList.SuggestionListListener.Response.DISMISS;
                    }
                    return SuggestionList.SuggestionListListener.Response.CONTINUE;
                }

                @OnThread(value=Tag.FXPlatform)
                public void hidden() {
                    MoeEditor.this.sourcePane.setFakeCaret(false);
                }
            });
            String prefix = this.sourcePane.getText(originalPosition, this.sourcePane.getCaretPosition());
            suggestionList.calculateEligible(prefix, true, false);
            suggestionList.updateVisual(prefix);
            suggestionList.highlightFirstEligible();
            suggestionList.show((Node)this.sourcePane, spLoc);
            TwoDimensional.Position pos = this.sourcePane.offsetToPosition(originalPosition, TwoDimensional.Bias.Forward);
            this.watcher.recordCodeCompletionStarted(pos.getMajor() + 1, pos.getMinor() + 1, null, null, prefix, suggestionList.getRecordingId());
        }
    }

    private void codeComplete(AssistContent selected, int prefixBegin, int prefixEnd, SuggestionList suggestionList) {
        Object start = selected.getName();
        List params = selected.getParams();
        if (params != null) {
            start = (String)start + "(";
        }
        this.sourcePane.select(prefixBegin, prefixEnd);
        String prefix = this.sourcePane.getSelectedText();
        this.insertText((String)start, false);
        Object inserted = start;
        if (params != null) {
            int selLoc = this.sourcePane.getCaretPosition();
            if (!params.isEmpty()) {
                String joinedParams = params.stream().map(AssistContent.ParamInfo::getDummyName).collect(Collectors.joining(", "));
                this.insertText(joinedParams, false);
                inserted = (String)inserted + joinedParams;
            }
            this.insertText(")", false);
            inserted = (String)inserted + ")";
            if (params.size() > 0) {
                this.sourcePane.select(selLoc, selLoc + ((AssistContent.ParamInfo)params.get(0)).getDummyName().length());
            }
        }
        TwoDimensional.Position prefixBeginPos = this.sourcePane.offsetToPosition(prefixBegin, TwoDimensional.Bias.Forward);
        this.watcher.recordCodeCompletionEnded(prefixBeginPos.getMajor() + 1, prefixBeginPos.getMinor() + 1, null, null, prefix, (String)inserted, suggestionList.getRecordingId());
        try {
            this.save();
        }
        catch (IOException e) {
            Debug.reportError((Throwable)e);
        }
    }

    public void setFindPanelVisible() {
        this.finder.setVisible(true);
    }

    public void mouseOverText(MouseOverTextEvent e) {
        int caretPos = e.getCharacterIndex();
        if (caretPos != this.mouseCaretPos) {
            this.showErrorPopupForCaretPos(caretPos, true);
        }
    }

    public void setFindTextfield(String text) {
        this.finder.populateFindTextfield(text);
    }

    protected boolean getNaviviewExpandedProperty() {
        if (this.watcher != null && this.watcher.getProperty("naviviewExpandedProperty") != null) {
            return Boolean.parseBoolean(this.watcher.getProperty("naviviewExpandedProperty"));
        }
        return PrefMgr.getNaviviewExpanded();
    }

    protected boolean containsSourceCode() {
        return this.sourceIsCode;
    }

    private void recordEdit(boolean includeOneLineEdits) {
        if (this.watcher != null) {
            this.watcher.recordJavaEdit(this.sourceDocument.getText(0, this.sourceDocument.getLength()), includeOneLineEdits);
        }
    }

    @Override
    public TextEditor assumeText() {
        return this;
    }

    @Override
    public void insertAppendMethod(NormalMethodElement method, FXPlatformConsumer<Boolean> after) {
        NodeTree.NodeAndPosition<ParsedNode> classNode = this.findClassNode();
        if (classNode != null) {
            NodeTree.NodeAndPosition<ParsedNode> existingMethodNode = this.findMethodNode(method.getName(), classNode);
            if (existingMethodNode != null) {
                Object text = "";
                for (CodeElement codeElement : method.getContents()) {
                    text = (String)text + codeElement.toJavaSource().toTemporaryJavaCodeString();
                }
                this.appendTextToNode(existingMethodNode, (String)text);
                after.accept((Object)false);
                return;
            }
            this.appendTextToNode(classNode, method.toJavaSource().toTemporaryJavaCodeString());
            after.accept((Object)true);
        }
        after.accept((Object)false);
    }

    @Override
    public void insertMethodCallInConstructor(String className, CallElement callElement, FXPlatformConsumer<Boolean> after) {
        NodeTree.NodeAndPosition<ParsedNode> classNode = this.findClassNode();
        if (classNode != null) {
            NodeTree.NodeAndPosition<ParsedNode> constructor = this.findMethodNode(className, classNode);
            if (constructor == null) {
                this.addDefaultConstructor(className, callElement);
            } else {
                String methodName = callElement.toJavaSource().toTemporaryJavaCodeString();
                if (!this.hasMethodCall(methodName = methodName.substring(0, methodName.indexOf(40)), constructor, true)) {
                    this.appendTextToNode(constructor, callElement.toJavaSource().toTemporaryJavaCodeString());
                    after.accept((Object)true);
                    return;
                }
            }
        }
        after.accept((Object)false);
    }

    private void addDefaultConstructor(String className, CallElement callElement) {
        NodeTree.NodeAndPosition<ParsedNode> classNode = this.findClassNode();
        if (classNode != null) {
            this.appendTextToNode(classNode, "public " + className + "()\n{\n" + callElement.toJavaSource().toTemporaryJavaCodeString() + "}\n");
        }
    }

    private void appendTextToNode(NodeTree.NodeAndPosition<ParsedNode> node, String text) {
        for (int pos = node.getEnd() - 1; pos >= 0; --pos) {
            if (!"}".equals(this.getText(this.getLineColumnFromOffset(pos), this.getLineColumnFromOffset(pos + 1)))) continue;
            int posFinal = pos;
            this.undoManager.compoundEdit(() -> {
                int originalLength = node.getSize();
                this.setText(this.getLineColumnFromOffset(posFinal), this.getLineColumnFromOffset(posFinal), text);
                int oldPos = this.getSourcePane().getCaretPosition();
                MoeIndent.calculateIndentsAndApply(this.sourceDocument, node.getPosition(), node.getPosition() + originalLength + text.length(), oldPos);
            });
            this.setCaretLocation(this.getLineColumnFromOffset(pos));
            return;
        }
        Debug.message((String)("Could not find end of node to append to: \"" + this.getText(this.getLineColumnFromOffset(node.getPosition()), this.getLineColumnFromOffset(node.getEnd())) + "\""));
    }

    private NodeTree.NodeAndPosition<ParsedNode> findClassNode() {
        NodeTree.NodeAndPosition root = new NodeTree.NodeAndPosition((RBTreeNode)this.sourceDocument.getParser(), 0, this.sourceDocument.getParser().getSize());
        for (NodeTree.NodeAndPosition<ParsedNode> nap : this.iterable((NodeTree.NodeAndPosition<ParsedNode>)root)) {
            if (((ParsedNode)nap.getNode()).getNodeType() != 1) continue;
            return nap;
        }
        return null;
    }

    private NodeTree.NodeAndPosition<ParsedNode> findMethodNode(String methodName, NodeTree.NodeAndPosition<ParsedNode> start) {
        for (NodeTree.NodeAndPosition<ParsedNode> nap : this.iterable(start)) {
            NodeTree.NodeAndPosition<ParsedNode> r;
            if (((ParsedNode)nap.getNode()).getNodeType() == 0 && (r = this.findMethodNode(methodName, nap)) != null) {
                return r;
            }
            if (((ParsedNode)nap.getNode()).getNodeType() != 2 || !((ParsedNode)nap.getNode()).getName().equals(methodName)) continue;
            return nap;
        }
        return null;
    }

    private boolean hasMethodCall(String methodName, NodeTree.NodeAndPosition<ParsedNode> methodNode, boolean root) {
        for (NodeTree.NodeAndPosition<ParsedNode> nap : this.iterable(methodNode)) {
            if (((ParsedNode)nap.getNode()).getNodeType() == 0 && root) {
                return this.hasMethodCall(methodName, nap, false);
            }
            if (((ParsedNode)nap.getNode()).getNodeType() != 6 || !this.sourceDocument.getText(nap.getPosition(), nap.getSize()).startsWith(methodName)) continue;
            return true;
        }
        return false;
    }

    private Iterable<NodeTree.NodeAndPosition<ParsedNode>> iterable(NodeTree.NodeAndPosition<ParsedNode> parent) {
        return () -> ((ParsedNode)parent.getNode()).getChildren(parent.getPosition());
    }

    @Override
    @OnThread(value=Tag.FX)
    public FrameEditor assumeFrame() {
        return null;
    }

    @Override
    public boolean compileStarted(int compilationSequence) {
        this.compilationStarted = true;
        this.errorManager.removeAllErrorHighlights();
        return false;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isOpen() {
        return this.fxTabbedEditor != null && this.fxTabbedEditor.isWindowVisible();
    }

    public String getTitle() {
        return this.windowTitle;
    }

    public void compileOrShowNextError() {
        if (this.watcher != null) {
            if (this.saveState.isChanged() || !this.errorManager.hasErrorHighlights()) {
                if (!this.saveState.isChanged() && PrefMgr.getFlag((String)"bluej.accessibility.support")) {
                    DialogManager.showTextWithCopyButtonFX((Window)this.getWindow(), (String)Config.getString((String)"pkgmgr.accessibility.compileDone"), (String)"BlueJ");
                }
                this.scheduleCompilation(CompileReason.USER, CompileType.EXPLICIT_USER_COMPILE);
            } else {
                MoeErrorManager.ErrorDetails err = this.errorManager.getNextErrorPos(this.sourcePane.getCaretPosition());
                if (err != null) {
                    this.sourcePane.setCaretPosition(err.startPos);
                    this.ensureCaretVisible();
                    if (PrefMgr.getFlag((String)"bluej.accessibility.support")) {
                        DialogManager.showTextWithCopyButtonFX((Window)this.getWindow(), (String)err.message, (String)"BlueJ");
                    }
                }
            }
        }
    }

    public void notifyVisibleTab(boolean visible) {
        if (visible) {
            if (this.watcher != null) {
                this.watcher.recordSelected();
            }
            this.checkForChangeOnDisk();
        } else {
            this.showErrorOverlay(null, 0);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void setParent(FXTabbedEditor parent, boolean partOfMove) {
        if (this.watcher != null) {
            if (!partOfMove && parent != null) {
                this.watcher.recordOpen();
            } else if (!partOfMove && parent == null) {
                this.watcher.recordClose();
            }
            if (parent == null && this.saveState.isChanged()) {
                this.scheduleCompilation(CompileReason.MODIFIED, CompileType.ERROR_CHECK_ONLY);
            }
        }
        this.fxTabbedEditor = parent;
    }

    void updateHeaderHasErrors(boolean hasErrors) {
        this.fxTab.setErrorStatus(hasErrors);
    }

    @OnThread(value=Tag.FX)
    public List<Menu> getFXMenu() {
        return this.fxMenus;
    }

    @OnThread(value=Tag.FXPlatform)
    public EditorWatcher getWatcher() {
        return this.watcher;
    }

    @OnThread(value=Tag.FXPlatform)
    public void requestEditorFocus() {
        this.sourcePane.requestFocus();
    }

    @Override
    public void setExtendsClass(String className, ClassInfo info) {
        try {
            this.save();
            if (info != null) {
                if (info.getSuperclass() == null) {
                    Selection s1 = info.getExtendsInsertSelection();
                    this.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    this.insertText(" extends " + className, false);
                } else {
                    Selection s1 = info.getSuperReplaceSelection();
                    this.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    this.insertText(className, false);
                }
                this.save();
            }
        }
        catch (IOException ioe) {
            DialogManager.showMessageWithTextFX((Window)this.getWindow(), (String)"generic-file-save-error", (String)ioe.getLocalizedMessage());
        }
    }

    @Override
    public void removeExtendsClass(ClassInfo info) {
        try {
            this.save();
            if (info != null) {
                Selection s1 = info.getExtendsReplaceSelection();
                s1.combineWith(info.getSuperReplaceSelection());
                if (s1 != null) {
                    this.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    this.insertText("", false);
                }
                this.save();
            }
        }
        catch (IOException ioe) {
            DialogManager.showMessageWithTextFX((Window)this.getWindow(), (String)"generic-file-save-error", (String)ioe.getLocalizedMessage());
        }
    }

    @Override
    public void addImplements(String interfaceName, ClassInfo info) {
        try {
            this.save();
            if (info != null) {
                Selection s1 = info.getImplementsInsertSelection();
                this.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                if (info.hasInterfaceSelections()) {
                    List<String> exists = this.getInterfaceTexts(info.getInterfaceSelections());
                    if (!exists.contains(interfaceName)) {
                        this.insertText(", " + interfaceName, false);
                    }
                } else {
                    this.insertText(" implements " + interfaceName, false);
                }
                this.save();
            }
        }
        catch (IOException ioe) {
            DialogManager.showMessageWithTextFX((Window)this.getWindow(), (String)"generic-file-save-error", (String)ioe.getLocalizedMessage());
        }
    }

    @Override
    public void addExtendsInterface(String interfaceName, ClassInfo info) {
        try {
            this.save();
            if (info != null) {
                Selection s1 = info.getExtendsInsertSelection();
                this.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                if (info.hasInterfaceSelections()) {
                    List<String> exists = this.getInterfaceTexts(info.getInterfaceSelections());
                    if (!exists.contains(interfaceName)) {
                        this.insertText(", " + interfaceName, false);
                    }
                } else {
                    this.insertText(" extends " + interfaceName, false);
                }
                this.save();
            }
        }
        catch (IOException ioe) {
            DialogManager.showMessageWithTextFX((Window)this.getWindow(), (String)"generic-file-save-error", (String)ioe.getLocalizedMessage());
        }
    }

    @Override
    public void removeExtendsOrImplementsInterface(String interfaceName, ClassInfo info) {
        try {
            this.save();
            if (info != null) {
                Selection s1 = null;
                List vsels = info.getInterfaceSelections();
                List<String> vtexts = this.getInterfaceTexts(vsels);
                int where = vtexts.indexOf(interfaceName);
                if (where == 1 && vsels.size() > 2) {
                    where = 2;
                }
                if (where > 0) {
                    s1 = (Selection)vsels.get(where - 1);
                    s1.combineWith((Selection)vsels.get(where));
                }
                if (s1 != null) {
                    this.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    this.insertText("", false);
                }
                this.save();
            }
        }
        catch (IOException ioe) {
            DialogManager.showMessageWithTextFX((Window)this.getWindow(), (String)"generic-file-save-error", (String)ioe.getLocalizedMessage());
        }
    }

    @Override
    public void removeImports(List<String> importTargets) {
        ArrayList<ImportsCollection.LocatableImport> toRemove = new ArrayList<ImportsCollection.LocatableImport>();
        for (String importTarget : importTargets) {
            ImportsCollection.LocatableImport details = this.getParsedNode().getImports().getImportInfo(importTarget);
            if (details == null) continue;
            toRemove.add(details);
        }
        Collections.sort(toRemove, Comparator.comparingInt(t -> -t.getStart()));
        for (ImportsCollection.LocatableImport locatableImport : toRemove) {
            if (locatableImport.getStart() == -1) continue;
            this.getSourcePane().replaceText(locatableImport.getStart(), locatableImport.getStart() + locatableImport.getLength(), "");
        }
    }

    private List<String> getInterfaceTexts(List<Selection> selections) {
        ArrayList<String> r = new ArrayList<String>(selections.size());
        for (Selection sel : selections) {
            String text = this.getText(new SourceLocation(sel.getLine(), sel.getColumn()), new SourceLocation(sel.getEndLine(), sel.getEndColumn()));
            int taIndex = text.indexOf(60);
            if (taIndex != -1) {
                text = text.substring(0, taIndex);
            }
            text = text.trim();
            r.add(text);
        }
        return r;
    }

    @Override
    public void setHeaderImage(Image image) {
        this.fxTab.setHeaderImage(image);
    }

    @OnThread(value=Tag.FXPlatform)
    public Window getWindow() {
        return this.fxTabbedEditor.getWindow();
    }

    private static class ErrorDisplay {
        private final @OnThread(value=Tag.Swing) MoeErrorManager.ErrorDetails details;
        private PopupControl popup;

        public ErrorDisplay(MoeErrorManager.ErrorDetails details) {
            this.details = details;
        }

        @OnThread(value=Tag.FXPlatform)
        public void createPopup() {
            this.popup = new PopupControl();
            Text text = new Text(ParserMessageHandler.getMessageForCode(this.details.message));
            TextFlow flow = new TextFlow(new Node[]{text});
            flow.setMaxWidth(600.0);
            JavaFXUtil.addStyleClass((Styleable)text, (String[])new String[]{"java-error"});
            text.styleProperty().bind((ObservableValue)PrefMgr.getEditorFontCSS((boolean)true));
            BorderPane p = new BorderPane((Node)flow);
            this.popup.setSkin((Skin)new Skin<Skinnable>((Pane)p){
                final /* synthetic */ Pane val$p;
                {
                    this.val$p = pane;
                }

                @OnThread(value=Tag.FX)
                public Skinnable getSkinnable() {
                    return popup;
                }

                @OnThread(value=Tag.FX)
                public Node getNode() {
                    return this.val$p;
                }

                @OnThread(value=Tag.FX)
                public void dispose() {
                }
            });
            p.getStyleClass().add((Object)"java-error-popup");
            Config.addPopupStylesheets((Parent)p);
        }
    }

    public static interface FindNavigator {
        public void highlightAll();

        public void selectNext(boolean var1);

        public void selectPrev();

        public BooleanExpression validProperty();

        public FindNavigator replaceCurrent(String var1);

        public void replaceAll(String var1);
    }
}

