/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.debugger.gentype.JavaType;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeEditorPane;
import bluej.editor.moe.MoeIndent;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.parser.entity.JavaEntity;
import bluej.parser.nodes.CommentNode;
import bluej.parser.nodes.MethodNode;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedNode;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.FXAbstractAction;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javax.swing.KeyStroke;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import threadchecker.OnThread;
import threadchecker.Tag;

public final class MoeActions {
    private static final String KEYS_FILE = "editor.keys";
    private static final String KEYS_FILE_FX = "editor_fx.keys";
    private static final int tabSize = Config.getPropInteger((String)"bluej.editor.tabsize", (int)4);
    private static final String spaces = "                                        ";
    private static final char TAB_CHAR = '\t';
    private static KeyCombination.Modifier SHORTCUT_MASK = KeyCombination.SHORTCUT_DOWN;
    private static KeyCombination.Modifier[] SHIFT_SHORTCUT_MASK = new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN};
    private static final IdentityHashMap<MoeEditor, MoeActions> moeActions = new IdentityHashMap();
    private final MoeEditor editor;
    public MoeAbstractAction compileOrNextErrorAction;
    public MoeAbstractAction contentAssistAction;
    private HashMap<String, MoeAbstractAction> actions;
    private final ObservableMap<KeyCodeCombination, MoeAbstractAction> builtInKeymap = FXCollections.observableHashMap();
    private final ObservableMap<KeyCodeCombination, MoeAbstractAction> keymap = FXCollections.observableMap(new LinkedHashMap());
    private InputMap<KeyEvent> curKeymap;
    private boolean lastActionWasCut;
    private MoeAbstractAction[] overrideActions;

    private MoeActions(MoeEditor editor) {
        this.editor = editor;
        this.createActionTable();
        if (!this.load()) {
            this.setDefaultKeyBindings();
        }
        this.lastActionWasCut = false;
        if (Config.isMacOS()) {
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), (Object)this.actions.get("caret-previous-word"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), (Object)this.actions.get("caret-next-word"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN, KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-previous-word"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN, KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-next-word"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}), (Object)this.actions.get("caret-begin-line"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}), (Object)this.actions.get("caret-end-line"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[]{KeyCombination.META_DOWN, KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-begin-line"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[]{KeyCombination.META_DOWN, KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-end-line"));
        } else {
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}), (Object)this.actions.get("caret-previous-word"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}), (Object)this.actions.get("caret-next-word"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN, KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-previous-word"));
            this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN, KeyCombination.SHIFT_DOWN}), (Object)this.actions.get("selection-next-word"));
        }
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), null);
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), null);
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), null);
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), null);
        this.builtInKeymap.put((Object)new KeyCodeCombination(KeyCode.Y, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), null);
        this.updateKeymap();
    }

    void updateKeymap() {
        if (this.getTextComponent() != null) {
            if (this.curKeymap != null) {
                Nodes.removeInputMap((Node)this.getTextComponent(), this.curKeymap);
            }
            Stream joinedKeyMapStream = Stream.concat(this.builtInKeymap.entrySet().stream(), this.keymap.entrySet().stream().filter(e -> !((MoeAbstractAction)((Object)((Object)e.getValue()))).hasMenuItemWithAccelerator((KeyCombination)e.getKey())));
            HashMap all = new HashMap();
            joinedKeyMapStream.forEach(kv -> all.put((KeyCodeCombination)kv.getKey(), (MoeAbstractAction)((Object)((Object)kv.getValue()))));
            joinedKeyMapStream = all.entrySet().stream();
            this.curKeymap = InputMap.sequence((InputMap[])((InputMap[])joinedKeyMapStream.map(e -> {
                if (e.getValue() == null) {
                    return InputMap.ignore((EventPattern)EventPattern.keyPressed((KeyCombination)((KeyCombination)e.getKey())));
                }
                return InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)((KeyCombination)e.getKey())), ev -> ((MoeAbstractAction)((Object)((Object)((Object)e.getValue())))).actionPerformed(false));
            }).toArray(InputMap[]::new)));
            Nodes.addInputMap((Node)this.getTextComponent(), this.curKeymap);
        }
    }

    public static MoeActions getActions(MoeEditor editor) {
        return moeActions.computeIfAbsent(editor, MoeActions::new);
    }

    private static int findWordLimit(MoeEditorPane c, int pos, boolean forwards) {
        int maxLen = c.getDocument().length();
        if (forwards && pos >= maxLen) {
            return maxLen;
        }
        if (!forwards && pos <= 0) {
            return 0;
        }
        char curChar = c.getText(pos, pos + 1).charAt(0);
        if (Character.isWhitespace(curChar)) {
            while (Character.isWhitespace(curChar)) {
                pos = forwards ? ++pos : --pos;
                if (pos == maxLen) {
                    return pos;
                }
                if (pos == 0) {
                    return 0;
                }
                curChar = c.getText(pos, pos + 1).charAt(0);
            }
            return forwards ? pos : pos + 1;
        }
        if (Character.isJavaIdentifierPart(curChar)) {
            while (Character.isJavaIdentifierPart(curChar)) {
                pos = forwards ? ++pos : --pos;
                if (pos == maxLen) {
                    return pos;
                }
                if (pos == 0) {
                    return 0;
                }
                curChar = c.getText(pos, pos + 1).charAt(0);
            }
            return forwards ? pos : pos + 1;
        }
        return forwards ? pos + 1 : pos;
    }

    private static boolean haveSelection(MoeEditor ed) {
        MoeEditorPane textPane = ed.getSourcePane();
        return textPane.getCaretMark() != textPane.getCaretDot();
    }

    private int getCurrentColumn() {
        int pos = Math.min(this.editor.getSourcePane().getCaretMark(), this.editor.getSourcePane().getCaretDot());
        return this.editor.getSourcePane().offsetToPosition(pos, TwoDimensional.Bias.Forward).getMinor();
    }

    private MoeSyntaxDocument.Element getLine(int lineNo) {
        return this.editor.getSourceDocument().getDefaultRootElement().getElement(lineNo);
    }

    private int getCurrentLineIndex() {
        MoeSyntaxDocument document = this.editor.getSourceDocument();
        return document.getDefaultRootElement().getElementIndex(this.editor.getSourcePane().getCaretPosition());
    }

    private static boolean isNewCommentStart(String s, MoeSyntaxDocument doc, int lineStart) {
        if ((s = s.trim()).endsWith("/**") || s.endsWith("/*")) {
            NodeTree.NodeAndPosition curNode = doc.getParser().findNodeAt(lineStart, 0);
            while (curNode != null && !(curNode.getNode() instanceof CommentNode)) {
                curNode = ((ParsedNode)curNode.getNode()).findNodeAt(lineStart, curNode.getPosition());
            }
            if (curNode == null) {
                return true;
            }
            String comment = MoeActions.getNodeContents(doc, (NodeTree.NodeAndPosition<ParsedNode>)curNode);
            comment = comment.substring(2);
            return comment.contains("/*");
        }
        return false;
    }

    private static void completeNewCommentBlock(MoeEditorPane textPane, String indentString) {
        String nextIndent = indentString.substring(0, indentString.length() - 2);
        textPane.replaceSelection(nextIndent + " * ");
        int pos = textPane.getCaretPosition();
        textPane.replaceSelection("\n");
        textPane.replaceSelection(nextIndent + " */");
        textPane.setCaretPosition(pos);
    }

    private static boolean isOpenBrace(String s) {
        int index = s.lastIndexOf(123);
        if (index == -1) {
            return false;
        }
        return s.indexOf(125, index + 1) == -1;
    }

    private static String nextIndent(String s, boolean openBrace, boolean commentEndOnly) {
        if (openBrace) {
            return s + spaces.substring(0, tabSize);
        }
        if (commentEndOnly) {
            return s.substring(0, s.length() - 1);
        }
        if (s.endsWith("/*")) {
            return s.substring(0, s.length() - 2) + " * ";
        }
        return s;
    }

    private void insertSpacedTab() {
        int numSpaces = tabSize - this.getCurrentColumn() % tabSize;
        this.editor.getSourcePane().replaceSelection(spaces.substring(0, numSpaces));
    }

    private void removeTab() {
        int col = this.getCurrentColumn();
        if (col > 0) {
            int remove = col % tabSize;
            if (remove == 0) {
                remove = tabSize;
            }
            int pos = this.editor.getSourcePane().getCaretPosition();
            this.editor.getSourcePane().replaceText(pos - remove, pos, "");
            this.editor.getSourcePane().setCaretPosition(pos - remove);
        }
    }

    private static String expandTab(String s, int idx) {
        int numSpaces = tabSize - idx % tabSize;
        return s.substring(0, idx) + spaces.substring(0, numSpaces) + s.substring(idx + 1);
    }

    private void insertTemplate(String templateName) {
        try {
            MoeEditorPane textPane = this.getTextComponent();
            File template = Config.getTemplateFile((String)templateName);
            FileInputStream fileStream = new FileInputStream(template);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fileStream, "UTF-8"));
            int addedTextLength = 0;
            String line = in.readLine();
            while (line != null) {
                while (line.length() > 0 && line.charAt(0) == '\t') {
                    line = line.substring(1);
                }
                addedTextLength += line.length() + 1;
                textPane.replaceSelection(line);
                textPane.replaceSelection("\n");
                line = in.readLine();
            }
            int caretPos = this.editor.getSourcePane().getCaretPosition();
            MoeIndent.AutoIndentInformation info = MoeIndent.calculateIndentsAndApply(this.editor.getSourceDocument(), caretPos - addedTextLength, caretPos + 2, caretPos);
            this.editor.setCaretPositionForward(info.getNewCaretPosition() - this.editor.getSourcePane().getCaretPosition());
            in.close();
        }
        catch (IOException exc) {
            Debug.reportError((String)"Could not read method template.");
            Debug.reportError((String)("Exception: " + exc));
        }
    }

    private static void blockAction(MoeEditor editor, LineAction lineAction) {
        int selectionEnd;
        int selectionStart = editor.getSourcePane().getCaretMark();
        if (selectionStart > (selectionEnd = editor.getSourcePane().getCaretDot())) {
            int tmp = selectionStart;
            selectionStart = selectionEnd;
            selectionEnd = tmp;
        }
        if (selectionStart != selectionEnd) {
            --selectionEnd;
        }
        MoeSyntaxDocument doc = editor.getSourceDocument();
        MoeSyntaxDocument.Element text = doc.getDefaultRootElement();
        int firstLineIndex = editor.getLineColumnFromOffset(selectionStart).getLine() - 1;
        int lastLineIndex = editor.getLineColumnFromOffset(selectionEnd).getLine();
        for (int i = firstLineIndex; i < lastLineIndex; ++i) {
            MoeSyntaxDocument.Element line = text.getElement(i);
            lineAction.apply(line, doc);
        }
        if (selectionStart == selectionEnd) {
            MoeSyntaxDocument.Element line = text.getElement(selectionStart);
            editor.getSourcePane().deselect();
        }
    }

    private static String getNodeContents(MoeSyntaxDocument doc, NodeTree.NodeAndPosition<ParsedNode> nap) {
        return doc.getText(nap.getPosition(), nap.getSize());
    }

    public static void addKeyCombinationForActionToAllEditors(KeyCodeCombination key, String actionName) {
        moeActions.values().forEach(moeAction -> moeAction.addKeyCombinationForAction(key, actionName));
    }

    private void addKeyCombinationForAction(KeyCodeCombination key, String actionName) {
        MoeAbstractAction action = this.actions.get(actionName);
        if (action != null) {
            this.keymap.put((Object)key, (Object)action);
            this.updateKeymap();
        }
    }

    public MoeAbstractAction getActionByName(String name) {
        return this.actions.get(name);
    }

    public void removeKeyStrokeBinding(KeyCombination key) {
        this.keymap.remove((Object)key);
    }

    public boolean save() {
        try {
            File file = Config.getUserConfigFile((String)KEYS_FILE_FX);
            ArrayList<Object> lines = new ArrayList<Object>();
            lines.add("version 400");
            lines.add("# ALT CTRL META SHIFT SHORT KEYCODE ACTION");
            for (Map.Entry binding : this.keymap.entrySet()) {
                KeyCodeCombination k = (KeyCodeCombination)binding.getKey();
                lines.add(k.getAlt().name() + " " + k.getControl().name() + " " + k.getMeta() + " " + k.getShift() + " " + k.getShortcut() + " " + k.getCode().name() + " " + ((MoeAbstractAction)((Object)binding.getValue())).getName());
            }
            Files.write(file.toPath(), lines, Charset.forName("UTF-8"), new OpenOption[0]);
            return true;
        }
        catch (Exception exc) {
            Debug.message((String)("Cannot save key bindings: " + exc));
            return false;
        }
    }

    public boolean load() {
        try {
            File file = Config.getUserConfigFile((String)KEYS_FILE_FX);
            if (file.exists()) {
                List lines = Files.readAllLines(file.toPath(), Charset.forName("UTF-8")).stream().filter(l -> !l.startsWith("#") && !l.trim().isEmpty()).collect(Collectors.toList());
                if (lines.isEmpty() || !((String)lines.get(0)).startsWith("version")) {
                    return false;
                }
                try {
                    for (int i = 1; i < lines.size(); ++i) {
                        String line = (String)lines.get(i);
                        String[] split = line.split(" +");
                        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.valueOf((String)split[5]), KeyCombination.ModifierValue.valueOf((String)split[3]), KeyCombination.ModifierValue.valueOf((String)split[1]), KeyCombination.ModifierValue.valueOf((String)split[0]), KeyCombination.ModifierValue.valueOf((String)split[2]), KeyCombination.ModifierValue.valueOf((String)split[4])), split[6]);
                    }
                    return true;
                }
                catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
                    Debug.reportError((Throwable)e);
                    return false;
                }
            }
            file = Config.getUserConfigFile((String)KEYS_FILE);
            FileInputStream istream = new FileInputStream(file);
            ObjectInputStream stream = new ObjectInputStream(istream);
            int version = 0;
            int count = stream.readInt();
            if (count > 100) {
                version = count;
                count = stream.readInt();
            }
            if (Config.isMacOS() && version < 140) {
                istream.close();
                return false;
            }
            for (int i = 0; i < count; ++i) {
                String actionName;
                Object keyBinding = stream.readObject();
                KeyCodeCombination keyCombination = null;
                if (keyBinding instanceof KeyStroke) {
                    keyCombination = MoeActions.convertSwingBindingToFX((KeyStroke)keyBinding);
                }
                if ((actionName = (String)stream.readObject()) == null || keyCombination == null) continue;
                this.addKeyCombinationForAction(keyCombination, actionName);
            }
            istream.close();
            if (version < 252) {
                this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.EQUALS, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), "increase-font");
                this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.MINUS, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), "decrease-font");
            }
            if (version < 300) {
                this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.SPACE, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}), "code-completion");
                this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}), "autoindent");
            }
            if (version < 320) {
                this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.K, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), "compile");
            }
            if (version < 330) {
                this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.COMMA, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), "preferences");
            }
            if (version < 400) {
                this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.DIGIT0, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), "reset-font");
            }
            return true;
        }
        catch (IOException | ClassNotFoundException exc) {
            return false;
        }
    }

    private static KeyCodeCombination convertSwingBindingToFX(KeyStroke swing) {
        KeyCode code;
        ArrayList<KeyCombination.Modifier> modifiers = new ArrayList<KeyCombination.Modifier>();
        if ((swing.getModifiers() & 2) != 0) {
            modifiers.add(KeyCombination.CONTROL_DOWN);
        }
        if ((swing.getModifiers() & 1) != 0) {
            modifiers.add(KeyCombination.SHIFT_DOWN);
        }
        if ((swing.getModifiers() & 4) != 0) {
            modifiers.add(KeyCombination.META_DOWN);
        }
        if ((swing.getModifiers() & 8) != 0) {
            modifiers.add(KeyCombination.ALT_DOWN);
        }
        if ((code = JavaFXUtil.awtKeyCodeToFX((int)swing.getKeyCode())) != null) {
            return new KeyCodeCombination(code, modifiers.toArray(new KeyCombination.Modifier[0]));
        }
        return null;
    }

    public void userAction() {
        this.lastActionWasCut = false;
    }

    public void closingBrace(int offset) {
        int lineIndex = this.getCurrentLineIndex();
        MoeSyntaxDocument.Element line = this.getLine(lineIndex);
        int lineStart = line.getStartOffset();
        String prefix = this.editor.getSourcePane().getText(lineStart, offset);
        if (prefix.trim().length() == 0) {
            this.editor.getSourcePane().setCaretPosition(lineStart);
            this.doIndent(true);
            this.editor.getSourcePane().setCaretPosition(this.editor.getSourcePane().getCaretPosition() + 1);
        }
    }

    public static void addSelectionToClipboard(MoeEditor ed) {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        String clipContent = clipboard.getString();
        if (clipContent == null) {
            clipContent = "";
        }
        clipboard.setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, clipContent + ed.getSourcePane().getSelectedText()));
    }

    private void doIndent(boolean isNewLine) {
        int caretColumn;
        MoeEditorPane textPane = this.editor.getSourcePane();
        int lineIndex = this.getCurrentLineIndex();
        if (lineIndex == 0) {
            if (!isNewLine) {
                this.insertSpacedTab();
            }
            return;
        }
        MoeSyntaxDocument doc = this.editor.getSourceDocument();
        MoeSyntaxDocument.Element line = this.getLine(lineIndex);
        int lineStart = line.getStartOffset();
        int pos = textPane.getCaretPosition();
        boolean isOpenBrace = false;
        boolean isCommentEnd = false;
        boolean isCommentEndOnly = false;
        String prefix = doc.getText(lineStart, pos - lineStart);
        if (prefix.trim().length() > 0) {
            this.insertSpacedTab();
            return;
        }
        boolean foundLine = false;
        int lineOffset = 1;
        String prevLineText = "";
        while (lineIndex - lineOffset >= 0 && !foundLine) {
            int prevLineEnd;
            MoeSyntaxDocument.Element prevline = this.getLine(lineIndex - lineOffset);
            int prevLineStart = prevline.getStartOffset();
            prevLineText = doc.getText(prevLineStart, (prevLineEnd = prevline.getEndOffset()) - prevLineStart);
            if (!MoeIndent.isWhiteSpaceOnly(prevLineText)) {
                foundLine = true;
                continue;
            }
            ++lineOffset;
        }
        if (!foundLine) {
            if (!isNewLine) {
                this.insertSpacedTab();
            }
            return;
        }
        if (MoeActions.isOpenBrace(prevLineText)) {
            isOpenBrace = true;
        } else {
            isCommentEnd = prevLineText.trim().endsWith("*/");
            isCommentEndOnly = prevLineText.trim().equals("*/");
        }
        int indentPos = MoeIndent.findFirstNonIndentChar(prevLineText, isCommentEnd);
        String indent = prevLineText.substring(0, indentPos);
        if (isOpenBrace) {
            indentPos += tabSize;
        }
        if ((caretColumn = this.getCurrentColumn()) >= indentPos) {
            if (!isNewLine) {
                this.insertSpacedTab();
            }
            return;
        }
        if (isNewLine && MoeActions.isNewCommentStart(indent, doc, lineStart)) {
            MoeActions.completeNewCommentBlock(textPane, indent);
            return;
        }
        int lineEnd = line.getEndOffset();
        String lineText = doc.getText(lineStart, lineEnd - lineStart);
        indentPos = MoeIndent.findFirstNonIndentChar(lineText, true);
        char firstChar = lineText.isEmpty() ? (char)'\u0000' : lineText.charAt(indentPos);
        doc.remove(lineStart, indentPos);
        String newIndent = MoeActions.nextIndent(indent, isOpenBrace, isCommentEndOnly);
        if (firstChar == '*') {
            newIndent = newIndent.replace('*', ' ');
        }
        textPane.replaceText(lineStart, lineStart, newIndent);
        if (firstChar == '}') {
            this.removeTab();
        }
    }

    private void doDeIndent(MoeEditorPane textPane) {
        int prevLineEnd;
        int lineIndex = this.getCurrentLineIndex();
        MoeSyntaxDocument doc = this.editor.getSourceDocument();
        MoeSyntaxDocument.Element line = this.getLine(lineIndex);
        int lineStart = line.getStartOffset();
        int lineEnd = line.getEndOffset();
        String lineText = doc.getText(lineStart, lineEnd - lineStart);
        int currentIndentPos = MoeIndent.findFirstNonIndentChar(lineText, true);
        char firstChar = lineText.charAt(currentIndentPos);
        textPane.setCaretPosition(lineStart + currentIndentPos);
        if (lineIndex == 0) {
            this.removeTab();
            return;
        }
        MoeSyntaxDocument.Element prevline = this.getLine(lineIndex - 1);
        int prevLineStart = prevline.getStartOffset();
        String prevLineText = doc.getText(prevLineStart, (prevLineEnd = prevline.getEndOffset()) - prevLineStart);
        int targetIndentPos = MoeIndent.findFirstNonIndentChar(prevLineText, true);
        if (currentIndentPos > targetIndentPos) {
            String indent = prevLineText.substring(0, targetIndentPos);
            doc.remove(lineStart, currentIndentPos);
            doc.insertString(lineStart, indent);
            if (firstChar == '}') {
                this.removeTab();
            }
        } else {
            this.removeTab();
        }
    }

    private void doBlockIndent(MoeEditor editor) {
        editor.undoManager.compoundEdit(() -> MoeActions.blockAction(editor, new IndentLineAction()));
    }

    private void doBlockDeIndent(MoeEditor editor) {
        editor.undoManager.compoundEdit(() -> MoeActions.blockAction(editor, new DeindentLineAction()));
    }

    private static int convertTabsToSpaces(MoeEditor editor) {
        int count = 0;
        int lineNo = 0;
        MoeSyntaxDocument doc = editor.getSourceDocument();
        MoeSyntaxDocument.Element root = doc.getDefaultRootElement();
        MoeSyntaxDocument.Element line = root.getElement(lineNo);
        while (line != null) {
            int start = line.getStartOffset();
            int length = line.getEndOffset() - start;
            String text = doc.getText(start, length);
            int startCount = count;
            int tabIndex = text.indexOf(9);
            while (tabIndex != -1) {
                text = MoeActions.expandTab(text, tabIndex);
                ++count;
                tabIndex = text.indexOf(9);
            }
            if (count != startCount) {
                doc.remove(start, length);
                doc.insertString(start, text);
            }
            line = root.getElement(++lineNo);
        }
        return count;
    }

    private void createActionTable() {
        this.compileOrNextErrorAction = this.compileOrNextErrorAction();
        this.overrideActions = new MoeAbstractAction[]{new NextWordAction(false), new NextWordAction(true), new PrevWordAction(false), new PrevWordAction(true), new EndWordAction(false), new EndWordAction(true), new BeginWordAction(false), new BeginWordAction(true), new EndLineAction(false), new EndLineAction(true), new BeginLineAction(false), new BeginLineAction(true), this.deleteWordAction(), this.selectWordAction()};
        MoeAbstractAction[] myActions = new MoeAbstractAction[]{this.saveAction(), this.printAction(), this.closeAction(), this.undoAction(), this.redoAction(), this.commentBlockAction(), this.uncommentBlockAction(), this.autoIndentAction(), this.indentBlockAction(), this.deindentBlockAction(), this.insertMethodAction(), this.addJavadocAction(), this.indentAction(), this.deIndentAction(), this.newLineAction(), this.cutAction(), this.copyAction(), this.pasteAction(), this.copyLineAction(), this.cutLineAction(), this.cutEndOfLineAction(), this.cutWordAction(), this.cutEndOfWordAction(), this.findAction(), this.findNextAction(), this.findPrevAction(), this.replaceAction(), this.compileOrNextErrorAction, this.goToLineAction(), this.toggleInterfaceAction(), this.toggleBreakPointAction(), this.keyBindingsAction(), this.preferencesAction(), this.increaseFontAction(), this.decreaseFontAction(), this.resetFontAction(), this.contentAssistAction()};
        this.actions = new LinkedHashMap<String, MoeAbstractAction>();
        for (MoeAbstractAction action : this.overrideActions) {
            this.actions.put(action.getName(), action);
        }
        for (MoeAbstractAction action : myActions) {
            this.actions.put(action.getName(), action);
        }
    }

    public List<MoeAbstractAction> getAllActions() {
        return new ArrayList<MoeAbstractAction>(this.actions.values());
    }

    public List<KeyCodeCombination> getKeyStrokesForAction(String actionName) {
        return this.keymap.entrySet().stream().filter(e -> Objects.equals(((MoeAbstractAction)((Object)((Object)e.getValue()))).getName(), actionName)).map(e -> (KeyCodeCombination)e.getKey()).collect(Collectors.toList());
    }

    public void makeAllUnavailableExcept(String ... actionNames) {
        HashSet<String> keepEnabled = new HashSet<String>(Arrays.asList(actionNames));
        for (Map.Entry<String, MoeAbstractAction> action : this.actions.entrySet()) {
            action.getValue().setAvailable(keepEnabled.contains(action.getKey()));
        }
    }

    public void makeAllAvailable() {
        for (Map.Entry<String, MoeAbstractAction> action : this.actions.entrySet()) {
            action.getValue().setAvailable(true);
        }
    }

    public void setDefaultKeyBindings() {
        this.keymap.clear();
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "save");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "print");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "close");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "undo");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.Y, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "redo");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.F8, new KeyCombination.Modifier[0]), "comment-block");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.F7, new KeyCombination.Modifier[0]), "uncomment-block");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.F6, new KeyCombination.Modifier[0]), "indent-block");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.F5, new KeyCombination.Modifier[0]), "deindent-block");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.M, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "insert-method");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.TAB, new KeyCombination.Modifier[0]), "indent");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.TAB, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN}), "de-indent");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "insert-tab");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[0]), "new-line");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN}), "insert-break");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "find");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.G, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "find-next");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.G, new KeyCombination.Modifier[]{SHORTCUT_MASK, KeyCombination.SHIFT_DOWN}), "find-next-backward");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "replace");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.L, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "go-to-line");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.K, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "compile");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.J, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "toggle-interface-view");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.B, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "toggle-breakpoint");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.COMMA, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "preferences");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.D, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "describe-key");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "copy-to-clipboard");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "cut-to-clipboard");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "paste-from-clipboard");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.F2, new KeyCombination.Modifier[0]), "copy-line");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.F3, new KeyCombination.Modifier[0]), "paste-from-clipboard");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.F4, new KeyCombination.Modifier[0]), "cut-line");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.EQUALS, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "increase-font");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.MINUS, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "decrease-font");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.DIGIT0, new KeyCombination.Modifier[]{SHORTCUT_MASK}), "reset-font");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.SPACE, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}), "code-completion");
        this.addKeyCombinationForAction(new KeyCodeCombination(KeyCode.I, SHIFT_SHORTCUT_MASK), "autoindent");
    }

    private MoeAbstractAction action(String name, Category category, final FXPlatformRunnable action) {
        return new MoeAbstractAction(name, category){

            @OnThread(value=Tag.FXPlatform)
            public void actionPerformed(boolean viaContextMenu) {
                action.run();
            }
        };
    }

    private MoeAbstractAction contextSensitiveAction(String name, Category category, final FXPlatformConsumer<Boolean> action) {
        return new MoeAbstractAction(name, category){

            @OnThread(value=Tag.FXPlatform)
            public void actionPerformed(boolean viaContextMenu) {
                action.accept((Object)viaContextMenu);
            }
        };
    }

    private final MoeEditor getEditor() {
        this.editor.clearMessage();
        return this.editor;
    }

    private MoeAbstractAction saveAction() {
        return this.action("save", Category.CLASS, () -> this.getEditor().userSave());
    }

    private MoeAbstractAction printAction() {
        return this.action("print", Category.CLASS, () -> this.getEditor().print());
    }

    private MoeAbstractAction closeAction() {
        return this.action("close", Category.CLASS, () -> this.getEditor().close());
    }

    private MoeAbstractAction undoAction() {
        MoeAbstractAction action = this.action("undo", Category.MISC, () -> {
            MoeEditor editor = this.getEditor();
            editor.undoManager.undo();
        });
        action.bindEnabled(this.editor == null ? null : this.editor.undoManager.canUndo());
        return action;
    }

    private MoeAbstractAction redoAction() {
        MoeAbstractAction action = this.action("redo", Category.MISC, () -> {
            MoeEditor editor = this.getEditor();
            editor.undoManager.redo();
        });
        action.bindEnabled(this.editor == null ? null : this.editor.undoManager.canRedo());
        return action;
    }

    private MoeAbstractAction commentBlockAction() {
        return this.action("comment-block", Category.EDIT, () -> {
            MoeEditor editor = this.getEditor();
            editor.undoManager.compoundEdit(() -> MoeActions.blockAction(editor, new CommentLineAction()));
        });
    }

    private MoeAbstractAction uncommentBlockAction() {
        return this.action("uncomment-block", Category.EDIT, () -> {
            MoeEditor editor = this.getEditor();
            editor.undoManager.compoundEdit(() -> MoeActions.blockAction(editor, new UncommentLineAction()));
        });
    }

    private MoeAbstractAction indentBlockAction() {
        return this.action("indent-block", Category.EDIT, () -> this.doBlockIndent(this.getEditor()));
    }

    private MoeAbstractAction deindentBlockAction() {
        return this.action("deindent-block", Category.EDIT, () -> this.doBlockDeIndent(this.getEditor()));
    }

    private MoeAbstractAction autoIndentAction() {
        return this.action("autoindent", Category.EDIT, () -> {
            MoeEditor editor = this.getEditor();
            MoeSyntaxDocument doc = editor.getSourceDocument();
            if (doc.getParsedNode() == null) {
                return;
            }
            int prevCaretPos = editor.getSourcePane().getCaretPosition();
            editor.undoManager.compoundEdit(() -> {
                MoeIndent.AutoIndentInformation info = MoeIndent.calculateIndentsAndApply(doc, prevCaretPos);
                editor.setCaretPositionForward(info.getNewCaretPosition() - prevCaretPos);
                if (info.isPerfect()) {
                    editor.writeMessage(Config.getString((String)"editor.info.perfectIndent"));
                }
            });
        });
    }

    private MoeAbstractAction insertMethodAction() {
        return this.action("insert-method", Category.EDIT, () -> {
            MoeEditor editor = this.getEditor();
            if (!editor.containsSourceCode()) {
                return;
            }
            editor.undoManager.compoundEdit(() -> this.insertTemplate("method"));
        });
    }

    private MoeAbstractAction addJavadocAction() {
        return this.action("add-javadoc", Category.EDIT, () -> {
            MoeEditor editor = this.getEditor();
            if (!editor.containsSourceCode()) {
                return;
            }
            int caretPos = editor.getCurrentTextPane().getCaretPosition();
            NodeTree.NodeAndPosition node = editor.getParsedNode().findNodeAt(caretPos, 0);
            while (node != null && ((ParsedNode)node.getNode()).getNodeType() != 2) {
                node = ((ParsedNode)node.getNode()).findNodeAt(caretPos, node.getPosition());
            }
            if (node == null || !(node.getNode() instanceof MethodNode)) {
                editor.writeMessage(Config.getString((String)"editor.addjavadoc.notAMethod"));
            } else {
                MethodNode methodNode = (MethodNode)node.getNode();
                boolean hasJavadocComment = false;
                Iterator it = methodNode.getChildren(node.getPosition());
                while (it.hasNext()) {
                    ParsedNode subNode = (ParsedNode)((NodeTree.NodeAndPosition)it.next()).getNode();
                    if (!(subNode instanceof CommentNode)) continue;
                    hasJavadocComment = hasJavadocComment || ((CommentNode)subNode).isJavadocComment();
                }
                if (hasJavadocComment) {
                    editor.writeMessage(Config.getString((String)"editor.addjavadoc.hasJavadoc"));
                } else {
                    JavaType retType;
                    StringBuilder indent = new StringBuilder();
                    int column = editor.getLineColumnFromOffset(node.getPosition()).getColumn();
                    for (int i = 0; i < column - 1; ++i) {
                        indent.append(' ');
                    }
                    StringBuilder newComment = new StringBuilder();
                    newComment.append("/**\n");
                    JavaEntity retTypeEntity = methodNode.getReturnType();
                    if (retTypeEntity == null) {
                        newComment.append((CharSequence)indent).append(" * ").append(methodNode.getName()).append(" ");
                        newComment.append(Config.getString((String)"editor.addjavadoc.constructor")).append("\n");
                    } else {
                        newComment.append((CharSequence)indent).append(" * ").append(Config.getString((String)"editor.addjavadoc.method"));
                        newComment.append(" ").append(methodNode.getName()).append("\n");
                    }
                    newComment.append((CharSequence)indent).append(" *\n");
                    for (String s : methodNode.getParamNames()) {
                        newComment.append((CharSequence)indent).append(" * @param ").append(s).append(" ");
                        newComment.append(Config.getString((String)"editor.addjavadoc.parameter")).append("\n");
                    }
                    if (retTypeEntity != null && (retType = retTypeEntity.resolveAsType().getType()) != null && !retType.isVoid()) {
                        newComment.append((CharSequence)indent).append(" * @return ");
                        newComment.append(Config.getString((String)"editor.addjavadoc.returnValue")).append("\n");
                    }
                    newComment.append((CharSequence)indent).append(" */\n").append((CharSequence)indent);
                    NodeTree.NodeAndPosition nodeFinal = node;
                    editor.undoManager.compoundEdit(() -> {
                        editor.getCurrentTextPane().setCaretPosition(nodeFinal.getPosition());
                        editor.getCurrentTextPane().replaceSelection(newComment.toString());
                        editor.getCurrentTextPane().setCaretPosition(caretPos + newComment.length());
                    });
                }
            }
        });
    }

    private MoeAbstractAction indentAction() {
        return this.action("indent", Category.EDIT, () -> {
            MoeEditor ed = this.getEditor();
            if (MoeActions.haveSelection(ed)) {
                this.doBlockIndent(ed);
            } else {
                int converted = 0;
                if (ed.checkExpandTabs()) {
                    converted = MoeActions.convertTabsToSpaces(ed);
                }
                if (PrefMgr.getFlag((String)"bluej.editor.autoIndent")) {
                    this.doIndent(false);
                } else {
                    this.insertSpacedTab();
                }
                if (converted > 0) {
                    ed.writeMessage(Config.getString((String)"editor.info.tabsExpanded"));
                }
            }
        });
    }

    private MoeAbstractAction deIndentAction() {
        return this.action("de-indent", Category.EDIT, () -> {
            MoeEditor ed = this.getEditor();
            if (MoeActions.haveSelection(ed)) {
                this.doBlockDeIndent(ed);
            } else {
                int converted;
                if (ed.checkExpandTabs() && (converted = MoeActions.convertTabsToSpaces(ed)) > 0) {
                    ed.writeMessage(Config.getString((String)"editor.info.tabsExpanded"));
                }
                this.doDeIndent(ed.getCurrentTextPane());
            }
        });
    }

    private MoeEditorPane getTextComponent() {
        return this.editor == null ? null : this.editor.getSourcePane();
    }

    private MoeAbstractAction newLineAction() {
        return this.action("new-line", Category.EDIT, () -> {
            this.editor.getSourcePane().replaceSelection("\n");
            this.editor.getSourcePane().requestFollowCaret();
            this.editor.getSourcePane().layout();
            if (PrefMgr.getFlag((String)"bluej.editor.autoIndent")) {
                this.doIndent(true);
            }
            this.editor.undoManager.breakEdit();
        });
    }

    private MoeAbstractAction cutAction() {
        return this.contextSensitiveAction("cut-to-clipboard", Category.EDIT, (FXPlatformConsumer<Boolean>)((FXPlatformConsumer)viaContextMenu -> {
            if (viaContextMenu.booleanValue() || this.editor.getSourcePane().isFocused()) {
                this.editor.getSourcePane().cut();
                if (viaContextMenu.booleanValue()) {
                    this.editor.getSourcePane().requestFocus();
                }
            }
        }));
    }

    private MoeAbstractAction copyAction() {
        return this.contextSensitiveAction("copy-to-clipboard", Category.EDIT, (FXPlatformConsumer<Boolean>)((FXPlatformConsumer)viaContextMenu -> {
            if (viaContextMenu.booleanValue() || this.editor.getSourcePane().isFocused()) {
                this.editor.getSourcePane().copy();
                if (viaContextMenu.booleanValue()) {
                    this.editor.getSourcePane().requestFocus();
                }
            }
        }));
    }

    private MoeAbstractAction pasteAction() {
        return this.contextSensitiveAction("paste-from-clipboard", Category.EDIT, (FXPlatformConsumer<Boolean>)((FXPlatformConsumer)viaContextMenu -> {
            if (viaContextMenu.booleanValue() || this.editor.getSourcePane().isFocused()) {
                this.editor.getSourcePane().paste();
                if (viaContextMenu.booleanValue()) {
                    this.editor.getSourcePane().requestFocus();
                }
                this.editor.getSourcePane().requestFollowCaret();
            }
        }));
    }

    private MoeAbstractAction copyLineAction() {
        return this.action("copy-line", Category.EDIT, () -> {
            boolean addToClipboard = this.lastActionWasCut;
            this.editor.getSourcePane().lineStart(NavigationActions.SelectionPolicy.CLEAR);
            this.editor.getSourcePane().lineEnd(NavigationActions.SelectionPolicy.EXTEND);
            this.editor.getSourcePane().nextChar(NavigationActions.SelectionPolicy.EXTEND);
            if (addToClipboard) {
                MoeActions.addSelectionToClipboard(this.editor);
            } else {
                this.editor.getSourcePane().copy();
            }
            this.editor.getSourcePane().setCaretPosition(this.editor.getSourcePane().getSelection().getEnd());
            this.lastActionWasCut = true;
        });
    }

    private MoeAbstractAction cutLineAction() {
        return this.action("cut-line", Category.EDIT, () -> {
            boolean addToClipboard = this.lastActionWasCut;
            this.editor.getSourcePane().lineStart(NavigationActions.SelectionPolicy.CLEAR);
            this.editor.getSourcePane().lineEnd(NavigationActions.SelectionPolicy.EXTEND);
            this.editor.getSourcePane().nextChar(NavigationActions.SelectionPolicy.EXTEND);
            if (addToClipboard) {
                MoeActions.addSelectionToClipboard(this.editor);
                this.editor.getSourcePane().replaceSelection("");
            } else {
                this.editor.getSourcePane().cut();
            }
            this.lastActionWasCut = true;
        });
    }

    private MoeAbstractAction increaseFontAction() {
        return this.action("increase-font", Category.MISC, () -> Utility.increaseFontSize((IntegerProperty)PrefMgr.getEditorFontSize()));
    }

    private MoeAbstractAction decreaseFontAction() {
        return this.action("decrease-font", Category.MISC, () -> Utility.decreaseFontSize((IntegerProperty)PrefMgr.getEditorFontSize()));
    }

    private MoeAbstractAction resetFontAction() {
        return this.action("reset-font", Category.MISC, () -> PrefMgr.getEditorFontSize().set(10));
    }

    private MoeAbstractAction cutEndOfLineAction() {
        return this.action("cut-end-of-line", Category.EDIT, () -> {
            boolean addToClipboard = this.lastActionWasCut;
            MoeEditorPane textComponent = this.getTextComponent();
            textComponent.paragraphEnd(NavigationActions.SelectionPolicy.ADJUST);
            if (addToClipboard) {
                MoeActions.addSelectionToClipboard(this.editor);
                textComponent.replaceSelection("");
            } else {
                textComponent.cut();
            }
            this.lastActionWasCut = true;
        });
    }

    private MoeAbstractAction cutWordAction() {
        return this.action("cut-word", Category.EDIT, () -> {
            boolean addToClipboard = this.lastActionWasCut;
            this.getActionByName("caret-previous-word").actionPerformed(false);
            this.getActionByName("selection-next-word").actionPerformed(false);
            if (addToClipboard) {
                MoeActions.addSelectionToClipboard(this.editor);
                this.getActionByName("delete-previous").actionPerformed(false);
            } else {
                this.getActionByName("cut-to-clipboard").actionPerformed(false);
            }
            this.lastActionWasCut = true;
        });
    }

    private MoeAbstractAction contentAssistAction() {
        return this.action("code-completion", Category.MISC, () -> {
            MoeEditor editor = this.getEditor();
            if (Config.getPropBoolean((String)"bluej.editor.codecompletion", (boolean)true)) {
                editor.createContentAssist();
            }
        });
    }

    private MoeAbstractAction cutEndOfWordAction() {
        return this.action("cut-end-of-word", Category.EDIT, () -> {
            boolean addToClipboard = this.lastActionWasCut;
            this.getActionByName("selection-next-word").actionPerformed(false);
            if (addToClipboard) {
                MoeActions.addSelectionToClipboard(this.editor);
                this.getActionByName("delete-previous").actionPerformed(false);
            } else {
                this.getActionByName("cut-to-clipboard").actionPerformed(false);
            }
            this.lastActionWasCut = true;
        });
    }

    private MoeAbstractAction deleteWordAction() {
        return this.action("delete-previous-word", Category.EDIT, () -> {
            MoeEditorPane c = this.getTextComponent();
            MoeAbstractAction prevWordAct = this.actions.get("caret-previous-word");
            int end = c.getCaretDot();
            prevWordAct.actionPerformed(false);
            int begin = c.getCaretDot();
            c.replaceText(begin, end, "");
        });
    }

    private MoeAbstractAction selectWordAction() {
        return this.action("select-word", Category.MOVE_SCROLL, () -> {
            MoeEditorPane c = this.getTextComponent();
            int origPos = c.getCaretDot();
            int newStart = MoeActions.findWordLimit(c, origPos, false);
            int newEnd = MoeActions.findWordLimit(c, origPos, true);
            c.setCaretPosition(newStart);
            c.moveCaretPosition(newEnd);
        });
    }

    private MoeAbstractAction findAction() {
        return this.action("find", Category.MISC, () -> {
            MoeEditor editor = this.getEditor();
            editor.initFindPanel();
        });
    }

    private MoeAbstractAction findNextAction() {
        return this.action("find-next", Category.MISC, () -> this.getEditor().findNext(false));
    }

    private MoeAbstractAction findPrevAction() {
        return this.action("find-next-backward", Category.MISC, () -> this.getEditor().findNext(true));
    }

    private MoeAbstractAction replaceAction() {
        return this.action("replace", Category.MISC, () -> {
            MoeEditor editor = this.getEditor();
            editor.setFindPanelVisible();
            editor.showReplacePanel();
            if (editor.getSourcePane().getSelectedText() != null) {
                editor.setFindTextfield(editor.getSourcePane().getSelectedText());
            }
        });
    }

    private MoeAbstractAction compileOrNextErrorAction() {
        return this.action("compile", Category.MISC, () -> this.getEditor().compileOrShowNextError());
    }

    private MoeAbstractAction toggleInterfaceAction() {
        return this.action("toggle-interface-view", Category.MISC, () -> this.getEditor().toggleInterface());
    }

    private MoeAbstractAction toggleBreakPointAction() {
        return this.action("toggle-breakpoint", Category.MISC, () -> this.getEditor().toggleBreakpoint());
    }

    private MoeAbstractAction keyBindingsAction() {
        return this.action("key-bindings", Category.MISC, () -> this.editor.showPreferences(1));
    }

    private MoeAbstractAction preferencesAction() {
        return this.action("preferences", Category.MISC, () -> this.editor.showPreferences(0));
    }

    private MoeAbstractAction goToLineAction() {
        return this.action("go-to-line", Category.MISC, () -> this.getEditor().goToLine());
    }

    class DeindentLineAction
    implements LineAction {
        DeindentLineAction() {
        }

        @Override
        public void apply(MoeSyntaxDocument.Element line, MoeSyntaxDocument doc) {
            int lineStart = line.getStartOffset();
            int lineEnd = line.getEndOffset();
            try {
                String lineText = doc.getText(lineStart, lineEnd - lineStart);
                String spacedTab = MoeActions.spaces.substring(0, tabSize);
                if (lineText.startsWith(spacedTab)) {
                    doc.remove(lineStart, tabSize);
                } else if (lineText.charAt(0) == '\t') {
                    doc.remove(lineStart, 1);
                } else {
                    int cnt = 0;
                    while (lineText.charAt(cnt) == ' ') {
                        ++cnt;
                    }
                    doc.remove(lineStart, cnt);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class IndentLineAction
    implements LineAction {
        IndentLineAction() {
        }

        @Override
        public void apply(MoeSyntaxDocument.Element line, MoeSyntaxDocument doc) {
            int lineStart = line.getStartOffset();
            doc.insertString(lineStart, MoeActions.spaces.substring(0, tabSize));
        }
    }

    class UncommentLineAction
    implements LineAction {
        UncommentLineAction() {
        }

        @Override
        public void apply(MoeSyntaxDocument.Element line, MoeSyntaxDocument doc) {
            int lineStart = line.getStartOffset();
            int lineEnd = line.getEndOffset();
            try {
                String lineText = doc.getText(lineStart, lineEnd - lineStart);
                if (lineText.trim().startsWith("//")) {
                    int cnt = 0;
                    while (lineText.charAt(cnt) != '/') {
                        ++cnt;
                    }
                    if (lineText.charAt(cnt + 2) == ' ') {
                        doc.remove(lineStart + cnt, 3);
                    } else {
                        doc.remove(lineStart + cnt, 2);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class CommentLineAction
    implements LineAction {
        CommentLineAction() {
        }

        @Override
        public void apply(MoeSyntaxDocument.Element line, MoeSyntaxDocument doc) {
            int lineEnd;
            int lineStart = line.getStartOffset();
            String lineText = doc.getText(lineStart, (lineEnd = line.getEndOffset()) - lineStart);
            if (lineText.trim().length() > 0) {
                int textStart = MoeIndent.findFirstNonIndentChar(lineText, true);
                doc.insertString(lineStart + textStart, "// ");
            }
        }
    }

    private class EndLineAction
    extends MoeActionWithOrWithoutSelection {
        public EndLineAction(boolean withSelection) {
            super(withSelection ? "selection-end-line" : "caret-end-line", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            MoeActions.this.getTextComponent().lineEnd(this.withSelection ? NavigationActions.SelectionPolicy.EXTEND : NavigationActions.SelectionPolicy.CLEAR);
        }
    }

    private class BeginLineAction
    extends MoeActionWithOrWithoutSelection {
        public BeginLineAction(boolean withSelection) {
            super(withSelection ? "selection-begin-line" : "caret-begin-line", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            MoeEditorPane ed = MoeActions.this.getTextComponent();
            if (ed.getCaretColumn() > 1) {
                ed.lineStart(this.withSelection ? NavigationActions.SelectionPolicy.EXTEND : NavigationActions.SelectionPolicy.CLEAR);
            } else {
                int line = ed.getCurrentParagraph();
                int oldPos = ed.getCaretPosition();
                ed.wordBreaksForwards(1, this.withSelection ? NavigationActions.SelectionPolicy.EXTEND : NavigationActions.SelectionPolicy.CLEAR);
                if (ed.getCurrentParagraph() != line) {
                    ed.setCaretPosition(oldPos);
                }
            }
        }
    }

    class BeginWordAction
    extends MoeActionWithOrWithoutSelection {
        public BeginWordAction(boolean withSelection) {
            super(withSelection ? "selection-begin-word" : "caret-begin-word", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            MoeEditorPane c = MoeActions.this.getTextComponent();
            int origPos = c.getCaretDot();
            int start = MoeActions.findWordLimit(c, origPos, false);
            this.moveCaret(c, start);
        }
    }

    class EndWordAction
    extends MoeActionWithOrWithoutSelection {
        public EndWordAction(boolean withSelection) {
            super(withSelection ? "selection-end-word" : "caret-end-word", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            MoeEditorPane c = MoeActions.this.getTextComponent();
            int origPos = c.getCaretDot();
            int end = MoeActions.findWordLimit(c, origPos, true);
            this.moveCaret(c, end);
        }
    }

    class PrevWordAction
    extends MoeActionWithOrWithoutSelection {
        public PrevWordAction(boolean withSelection) {
            super(withSelection ? "selection-previous-word" : "caret-previous-word", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            MoeEditorPane c = MoeActions.this.getTextComponent();
            int origPos = c.getCaretDot();
            if (origPos == 0) {
                return;
            }
            if (Character.isWhitespace(c.getText(origPos - 1, origPos).charAt(0))) {
                int startOfWS = MoeActions.findWordLimit(c, origPos - 1, false);
                int startOfPrevWord = MoeActions.findWordLimit(c, startOfWS - 1, false);
                this.moveCaret(c, startOfPrevWord);
            } else {
                int startOfWord = MoeActions.findWordLimit(c, origPos - 1, false);
                this.moveCaret(c, startOfWord);
            }
        }
    }

    class NextWordAction
    extends MoeActionWithOrWithoutSelection {
        public NextWordAction(boolean withSelection) {
            super(withSelection ? "selection-next-word" : "caret-next-word", Category.MOVE_SCROLL, withSelection);
        }

        public void actionPerformed(boolean viaContextMenu) {
            int origPos;
            int end;
            MoeEditorPane c = MoeActions.this.getTextComponent();
            if (Character.isWhitespace(c.getText(end = MoeActions.findWordLimit(c, origPos = c.getCaretDot(), true), end + 1).charAt(0))) {
                int endOfWS = MoeActions.findWordLimit(c, end, true);
                this.moveCaret(c, endOfWS);
            } else {
                this.moveCaret(c, end);
            }
        }
    }

    private abstract class MoeActionWithOrWithoutSelection
    extends MoeAbstractAction {
        protected final boolean withSelection;

        protected MoeActionWithOrWithoutSelection(String actionName, Category category, boolean withSelection) {
            super(actionName, category);
            this.withSelection = withSelection;
        }

        protected void moveCaret(MoeEditorPane c, int pos) {
            if (this.withSelection) {
                c.moveCaretPosition(pos);
            } else {
                c.setCaretPosition(pos);
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    abstract class MoeAbstractAction
    extends FXAbstractAction {
        private final Category category;

        public MoeAbstractAction(String name, Category category) {
            super(name);
            this.accelerator.bind((ObservableValue)Bindings.createObjectBinding(() -> MoeActions.this.keymap.entrySet().stream().filter(e -> ((MoeAbstractAction)((Object)((Object)((Object)e.getValue())))).equals((Object)this)).map(e -> (KeyCodeCombination)e.getKey()).findFirst().orElse(null), (Observable[])new Observable[]{MoeActions.this.keymap}));
            this.category = category;
        }

        public Category getCategory() {
            return this.category;
        }
    }

    static interface LineAction {
        public void apply(MoeSyntaxDocument.Element var1, MoeSyntaxDocument var2);
    }

    public static enum Category {
        EDIT("editor.functions.editFunctions"),
        MOVE_SCROLL("editor.functions.moveScroll"),
        CLASS("editor.functions.classFunctions"),
        MISC("editor.functions.misc");

        private final String label;

        private Category(String labelKey) {
            this.label = Config.getString((String)labelKey);
        }

        @OnThread(value=Tag.Any)
        public String toString() {
            return this.label;
        }
    }
}

