/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeEditor;
import bluej.utility.javafx.JavaFXUtil;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Polygon;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class FindPanel
extends GridPane {
    private final TextField replaceField;
    private final MoeEditor editor;
    private final CheckBox matchCaseCheckBox;
    private final Button previousButton;
    private final Button nextButton;
    private final TextField findField;
    private MoeEditor.FindNavigator currentNavigator;
    private final BooleanProperty findResultsFound = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty showingReplace;

    public FindPanel(MoeEditor ed) {
        this.editor = ed;
        JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"moe-find-panel"});
        this.managedProperty().bind((ObservableValue)this.visibleProperty());
        JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"moe-find-grid"});
        HBox mcBody = new HBox();
        BorderPane closeBody = new BorderPane();
        JavaFXUtil.addStyleClass((Styleable)closeBody, (String[])new String[]{"moe-find-close-wrapper"});
        Label findLabel = new Label(Config.getString((String)"editor.findpanel.findLabel"));
        JavaFXUtil.addStyleClass((Styleable)findLabel, (String[])new String[]{"moe-find-label"});
        Label replaceDummyLabel = new Label(Config.getString((String)"editor.replacePanel.replaceLabel"));
        JavaFXUtil.addStyleClass((Styleable)replaceDummyLabel, (String[])new String[]{"moe-find-label"});
        replaceDummyLabel.setVisible(false);
        StackPane findLabelPane = new StackPane(new Node[]{replaceDummyLabel, findLabel});
        Label replaceFoldOutLabel = new Label(Config.getString((String)"editor.findpanel.replacePanel"));
        StackPane.setAlignment((Node)findLabel, (Pos)Pos.CENTER_RIGHT);
        this.findField = new TextField();
        JavaFXUtil.addStyleClass((Styleable)this.findField, (String[])new String[]{"moe-find-field"});
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.findField.textProperty(), search -> this.updateFindResult());
        this.matchCaseCheckBox = new CheckBox();
        this.matchCaseCheckBox.setText(Config.getString((String)"editor.findpanel.matchCase"));
        this.matchCaseCheckBox.setSelected(false);
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.matchCaseCheckBox.selectedProperty(), cs -> this.updateFindResult());
        Label closeIconLabel = new Label();
        closeIconLabel.setGraphic(FindPanel.makeCloseIcon());
        closeIconLabel.setOnMouseClicked(e -> this.cancelFind());
        this.previousButton = new Button();
        this.previousButton.setOnAction(e -> {
            this.updateFindResult();
            if (this.currentNavigator != null && this.currentNavigator.validProperty().get()) {
                this.currentNavigator.selectPrev();
            }
        });
        Label prevShortcut = new Label("\u21e7\u23ce");
        this.previousButton.setText(Config.getString((String)"editor.findpanel.findPrevious"));
        this.previousButton.setGraphic((Node)prevShortcut);
        this.previousButton.setDisable(true);
        this.nextButton = new Button();
        this.nextButton.setOnAction(e -> {
            this.updateFindResult();
            if (this.currentNavigator != null && this.currentNavigator.validProperty().get()) {
                this.currentNavigator.selectNext(false);
            }
        });
        this.nextButton.setText(Config.getString((String)"editor.findpanel.findNext"));
        Label nextShortcut = new Label("\u23ce");
        this.nextButton.setGraphic((Node)nextShortcut);
        this.nextButton.setDisable(true);
        nextShortcut.visibleProperty().bind((ObservableValue)this.findField.focusedProperty());
        prevShortcut.visibleProperty().bind((ObservableValue)this.findField.focusedProperty());
        Nodes.addInputMap((Node)this.findField, (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.ESCAPE, (KeyCombination.Modifier[])new KeyCombination.Modifier[0]), e -> this.cancelFind()), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.ENTER, (KeyCombination.Modifier[])new KeyCombination.Modifier[0]), e -> this.nextButton.fire()), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.ENTER, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN}), e -> this.previousButton.fire())}));
        this.showingReplace = new SimpleBooleanProperty(false);
        Polygon triangle = new Polygon(new double[]{0.0, 0.0, 8.0, 5.0, 0.0, 10.0});
        triangle.rotateProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.showingReplace).then(90).otherwise(0));
        replaceFoldOutLabel.setGraphic((Node)triangle);
        replaceFoldOutLabel.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
            this.showingReplace.set(!this.showingReplace.get());
            e.consume();
        });
        GridPane.setHalignment((Node)closeBody, (HPos)HPos.RIGHT);
        closeBody.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)closeBody, (Priority)Priority.ALWAYS);
        closeBody.setCenter((Node)closeIconLabel);
        BorderPane.setAlignment((Node)closeIconLabel, (Pos)Pos.CENTER_RIGHT);
        JavaFXUtil.addStyleClass((Styleable)mcBody, (String[])new String[]{"moe-find-options"});
        mcBody.setAlignment(Pos.CENTER);
        this.matchCaseCheckBox.setAlignment(Pos.CENTER);
        replaceFoldOutLabel.setAlignment(Pos.CENTER);
        mcBody.getChildren().add((Object)this.matchCaseCheckBox);
        mcBody.getChildren().add((Object)replaceFoldOutLabel);
        Label replaceLabel = new Label(Config.getString((String)"editor.replacePanel.replaceLabel"));
        JavaFXUtil.addStyleClass((Styleable)replaceLabel, (String[])new String[]{"moe-find-label"});
        this.replaceField = new TextField();
        Nodes.addInputMap((Node)this.replaceField, (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.ESCAPE, (KeyCombination.Modifier[])new KeyCombination.Modifier[0]), e -> this.cancelFind())}));
        Button replaceOne = new Button(Config.getString((String)"editor.replacePanel.replaceOnce"));
        Button replaceAll = new Button(Config.getString((String)"editor.replacePanel.replaceAll"));
        replaceOne.setOnAction(e -> {
            this.updateFindResult();
            if (this.currentNavigator.validProperty().get()) {
                this.setCurrentNavigator(this.currentNavigator.replaceCurrent(this.replaceField.getText()));
            }
        });
        replaceAll.setOnAction(e -> {
            this.updateFindResult();
            if (this.currentNavigator.validProperty().get()) {
                this.currentNavigator.replaceAll(this.replaceField.getText());
            }
        });
        replaceOne.disableProperty().bind((ObservableValue)this.findField.textProperty().isEmpty().or((ObservableBooleanValue)this.findResultsFound.not()));
        replaceAll.disableProperty().bind((ObservableValue)replaceOne.disableProperty());
        this.add((Node)findLabelPane, 0, 0);
        this.add((Node)this.findField, 1, 0);
        this.add((Node)this.replaceField, 1, 1);
        this.add((Node)this.previousButton, 2, 0);
        this.add((Node)this.nextButton, 3, 0);
        this.add((Node)mcBody, 4, 0);
        this.add((Node)closeBody, 5, 0);
        this.add((Node)replaceLabel, 0, 1);
        this.add((Node)replaceOne, 2, 1);
        this.add((Node)replaceAll, 3, 1);
        for (Node node : new Node[]{replaceLabel, this.replaceField, replaceOne, replaceAll}) {
            node.visibleProperty().bind((ObservableValue)this.showingReplace);
            node.managedProperty().bind((ObservableValue)node.visibleProperty());
        }
        mcBody.setFillHeight(true);
        for (Node node : new Button[]{this.previousButton, this.nextButton, replaceOne, replaceAll}) {
            node.setMaxHeight(Double.MAX_VALUE);
            node.setMaxWidth(Double.MAX_VALUE);
        }
    }

    private static Node makeCloseIcon() {
        Circle circle = new Circle(10.0);
        circle.setEffect((Effect)new InnerShadow(BlurType.GAUSSIAN, Color.rgb((int)128, (int)128, (int)128, (double)0.4), 2.0, 0.5, 1.0, 1.0));
        circle.setFill((Paint)Color.rgb((int)190, (int)190, (int)190, (double)1.0));
        Line lineA = new Line(0.0, 0.0, 7.0, 7.0);
        lineA.setStrokeWidth(3.0);
        lineA.setStroke((Paint)Color.rgb((int)240, (int)240, (int)240));
        Line lineB = new Line(0.0, 7.0, 7.0, 0.0);
        lineB.setStrokeWidth(3.0);
        lineB.setStroke((Paint)Color.rgb((int)240, (int)240, (int)240));
        StackPane stackPane = new StackPane(new Node[]{circle, lineA, lineB});
        stackPane.setPickOnBounds(true);
        return stackPane;
    }

    private void cancelFind() {
        this.findField.clear();
        this.replaceField.clear();
        this.setReplaceEnabled(false);
        this.setVisible(false);
    }

    private void updateFindResult() {
        this.setCurrentNavigator(this.editor.doFind(this.getSearchString(), !this.matchCaseCheckBox.isSelected()));
    }

    private void setCurrentNavigator(MoeEditor.FindNavigator navigator) {
        this.currentNavigator = navigator;
        this.previousButton.disableProperty().unbind();
        this.nextButton.disableProperty().unbind();
        if (this.currentNavigator == null) {
            JavaFXUtil.setPseudoclass((String)"bj-no-find-result", (!this.getSearchString().isEmpty() ? 1 : 0) != 0, (Node[])new Node[]{this.findField});
            this.previousButton.setDisable(true);
            this.nextButton.setDisable(true);
            this.findResultsFound.set(false);
        } else {
            JavaFXUtil.setPseudoclass((String)"bj-no-find-result", (boolean)false, (Node[])new Node[]{this.findField});
            this.currentNavigator.highlightAll();
            this.currentNavigator.selectNext(true);
            this.previousButton.disableProperty().bind((ObservableValue)this.findResultsFound.not());
            this.nextButton.disableProperty().bind((ObservableValue)this.findResultsFound.not());
            this.findResultsFound.set(true);
        }
    }

    public void displayFindPanel(String selection) {
        if (selection == null) {
            selection = this.getSearchString();
        }
        this.setVisible(true);
        this.populateFindTextfield(selection);
    }

    public String getSearchString() {
        return this.findField.getText();
    }

    private void writeMessage(boolean emptyMessage, int counter) {
        if (!emptyMessage) {
            this.editor.writeMessage(" ");
            return;
        }
        if (counter > 0) {
            this.editor.writeMessage(Config.getString((String)"editor.highlight.found").trim() + " " + counter + " " + Config.getString((String)"editor.replaceAll.intancesOf").trim() + " " + this.getSearchString());
        } else if (counter < 1 && this.getSearchString().length() > 0) {
            this.editor.writeMessage(Config.getString((String)"editor.replaceAll.string").trim() + " " + this.getSearchString() + " " + Config.getString((String)"editor.highlight.notFound").trim());
        }
    }

    public void close() {
        this.editor.removeSearchHighlights();
        this.setVisible(false);
        this.editor.getCurrentTextPane().requestFocus();
    }

    protected void requestFindfieldFocus() {
        this.findField.requestFocus();
    }

    protected void populateFindTextfield(String selection) {
        this.findField.setText(selection);
        this.findField.selectAll();
        this.findField.requestFocus();
    }

    protected void setReplaceEnabled(boolean isEnabled) {
        this.showingReplace.set(isEnabled);
    }
}

