/*
 * Decompiled with CFR 0.152.
 */
package datenbanken;

import datenbanken.QueryResult;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import linearestrukturen.Queue;

public class DatabaseConnector {
    private Connection connection;
    private QueryResult currentQueryResult = null;
    private String message = null;

    public DatabaseConnector(String pIP, int pPort, String pDatabase, String pUsername, String pPassword) {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            this.connection = DriverManager.getConnection("jdbc:mysql://" + pIP + ":" + pPort + "/" + pDatabase, pUsername, pPassword);
        }
        catch (Exception e) {
            this.message = e.getMessage();
        }
    }

    public void executeStatement(String pSQLStatement) {
        this.currentQueryResult = null;
        this.message = null;
        try {
            Statement statement = this.connection.createStatement();
            if (statement.execute(pSQLStatement)) {
                ResultSet resultset = statement.getResultSet();
                int columnCount = resultset.getMetaData().getColumnCount();
                String[] resultColumnNames = new String[columnCount];
                String[] resultColumnTypes = new String[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    resultColumnNames[i] = resultset.getMetaData().getColumnLabel(i + 1);
                    resultColumnTypes[i] = resultset.getMetaData().getColumnTypeName(i + 1);
                }
                Queue rows = new Queue();
                int rowCount = 0;
                while (resultset.next()) {
                    String[] resultrow = new String[columnCount];
                    for (int s = 0; s < columnCount; ++s) {
                        resultrow[s] = resultset.getString(s + 1);
                    }
                    rows.enqueue((Object)resultrow);
                    ++rowCount;
                }
                String[][] resultData = new String[rowCount][columnCount];
                int j = 0;
                while (!rows.isEmpty()) {
                    resultData[j] = (String[])rows.front();
                    rows.dequeue();
                    ++j;
                }
                statement.close();
                this.currentQueryResult = new QueryResult(resultData, resultColumnNames, resultColumnTypes);
            } else {
                statement.close();
            }
        }
        catch (Exception e) {
            this.message = e.getMessage();
        }
    }

    public QueryResult getCurrentQueryResult() {
        return this.currentQueryResult;
    }

    public String getErrorMessage() {
        return this.message;
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception e) {
            this.message = e.getMessage();
        }
    }
}

