/*
 * Decompiled with CFR 0.152.
 */
package sum.akzeptor;

import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Event;
import java.awt.Frame;
import java.awt.List;
import java.awt.Panel;
import java.io.File;
import java.io.IOException;
import sum.akzeptor.FSA;
import sum.akzeptor.FilenameExtensionFilter;
import sum.akzeptor.FiniteStateAutomaton;
import sum.akzeptor.FixedFileDialog;
import sum.akzeptor.FlexibleLabel;
import sum.akzeptor.FsaEditListener;
import sum.akzeptor.JifPanel;
import sum.akzeptor.NoEdgeSelectedException;
import sum.akzeptor.NoNodeSelectedException;
import sum.akzeptor.OKDialog;
import sum.akzeptor.RuleBasedLayout;

public class FsaEditPanel
extends Panel
implements FsaEditListener {
    FSA fs;
    FiniteStateAutomaton target;
    CardLayout cl;
    List edgeLabel;
    List nodeLabel;
    Button deleteNodeButton;
    Button deleteEdgeButton;
    Button loadButton;
    Button saveButton;
    Button clearButton;
    Button quitButton;
    Button digitButton;
    Button lcButton;
    Button ucButton;
    Checkbox initialState;
    Checkbox finalState;

    public void fsaSelectionChanged() {
        this.cl.show(this, "File Panel");
    }

    public void fsaSelectionChanged(boolean initialValue, boolean finalValue, int name) {
        this.initialState.setState(initialValue);
        this.finalState.setState(finalValue);
        this.nodeLabel.select(name - 65);
        this.cl.show(this, "Node Panel");
    }

    public void fsaSelectionChanged(int[] symbolIndexes) {
        int si = 0;
        int i = 0;
        do {
            if (si < symbolIndexes.length && i == symbolIndexes[si]) {
                this.edgeLabel.select(i);
                ++si;
                continue;
            }
            this.edgeLabel.deselect(i);
        } while (++i < 94);
        this.cl.show(this, "Edge Panel");
    }

    public void fsaSelectedEdgeSymbolsChanged(int[] ai) {
    }

    public void fsaEnteredRunState() {
        this.cl.show(this, "Blank Panel");
    }

    public void fsaSelectedNodeFinalChanged(boolean flag) {
    }

    public void fsaSelectedEdgeSymbolChanged(int i, boolean flag) {
    }

    public void setTargetFSA(FiniteStateAutomaton fsa) {
        this.target = fsa;
    }

    public boolean action(Event evt, Object what) {
        if (evt.target instanceof Checkbox) {
            if (evt.target == this.initialState) {
                try {
                    this.target.setSelectedNodeInitialState(this.initialState.getState());
                }
                catch (NoNodeSelectedException nnse) {
                    nnse.printStackTrace();
                }
                return true;
            }
            if (evt.target == this.finalState) {
                try {
                    this.target.setSelectedNodeFinalState(this.finalState.getState());
                }
                catch (NoNodeSelectedException nnse) {
                    nnse.printStackTrace();
                }
                return true;
            }
        } else if (evt.target instanceof Button) {
            if (evt.target == this.deleteNodeButton) {
                this.target.removeComponent();
                return true;
            }
            if (evt.target == this.deleteEdgeButton) {
                this.target.removeComponent();
                return true;
            }
            if (evt.target == this.loadButton) {
                FixedFileDialog ffd = new FixedFileDialog((Frame)this.fs, "Lade Akzeptor-Datei", 0);
                FilenameExtensionFilter fef = new FilenameExtensionFilter(".akz", true);
                ffd.setFilenameFilter(fef);
                ffd.setFile("*.akz");
                ffd.setVisible(true);
                String dir = ffd.getDirectory();
                String file = ffd.getFile();
                if (dir != null && file != null && fef.accept(new File(dir), file)) {
                    if (!new File(dir + file).exists()) {
                        OKDialog.createOKDialog(dir + file + " not found!");
                    } else {
                        try {
                            this.target.loadFromFile(dir + file);
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }
                return true;
            }
            if (evt.target == this.saveButton) {
                FixedFileDialog ffd = new FixedFileDialog((Frame)this.fs, "Speichere Akzeptor-Datei", 1);
                FilenameExtensionFilter fef = new FilenameExtensionFilter(".akz", true);
                ffd.setFile("*.akz");
                ffd.setVisible(true);
                String dir = ffd.getDirectory();
                String file = ffd.getFile();
                if (dir != null && file != null && fef.accept(new File(dir), file)) {
                    try {
                        this.target.saveToFile(dir + file);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                return true;
            }
            if (evt.target == this.clearButton) {
                this.target.clear();
                return true;
            }
            if (evt.target == this.quitButton) {
                this.fs.dispose();
                return true;
            }
            if (evt.target == this.ucButton) {
                int i = 32;
                do {
                    if (this.edgeLabel.isSelected(i)) continue;
                    this.edgeLabel.select(i);
                    try {
                        this.target.setSelectedEdgeSymbol(i, true);
                    }
                    catch (NoEdgeSelectedException nese) {
                        nese.printStackTrace();
                    }
                } while (++i <= 57);
            } else if (evt.target == this.lcButton) {
                int i = 64;
                do {
                    if (this.edgeLabel.isSelected(i)) continue;
                    this.edgeLabel.select(i);
                    try {
                        this.target.setSelectedEdgeSymbol(i, true);
                    }
                    catch (NoEdgeSelectedException nese) {
                        nese.printStackTrace();
                    }
                } while (++i <= 89);
            } else if (evt.target == this.digitButton) {
                int i = 15;
                do {
                    if (this.edgeLabel.isSelected(i)) continue;
                    this.edgeLabel.select(i);
                    try {
                        this.target.setSelectedEdgeSymbol(i, true);
                    }
                    catch (NoEdgeSelectedException nese) {
                        nese.printStackTrace();
                    }
                } while (++i <= 24);
            }
        }
        return super.action(evt, what);
    }

    public void fsaEnteredEditState() {
        this.cl.show(this, "File Panel");
    }

    public void fsaSelectedNodeInitialChanged(boolean flag) {
    }

    public FsaEditPanel(FSA pFSA) {
        this.fs = pFSA;
        JifPanel p = null;
        this.cl = new CardLayout();
        this.setLayout(this.cl);
        this.target = null;
        p = new JifPanel(96, "Datei/Editieren");
        this.add("Blank Panel", p);
        p = new JifPanel(96, "Datei");
        RuleBasedLayout r = new RuleBasedLayout();
        this.loadButton = new Button("Laden");
        p.add(this.loadButton);
        this.saveButton = new Button("Speichern");
        p.add(this.saveButton);
        this.clearButton = new Button("Neu");
        p.add(this.clearButton);
        this.quitButton = new Button("Beenden");
        p.add(this.quitButton);
        r.move(r.top(this.loadButton), r.top(p));
        r.hcenter(r.part(this.loadButton), r.part(p));
        r.hcenter(r.part(this.saveButton), r.part(p));
        r.move(r.top(this.saveButton), r.bottom(this.loadButton));
        r.hcenter(r.part(this.clearButton), r.part(p));
        r.move(r.top(this.clearButton), r.bottom(this.saveButton));
        r.hcenter(r.part(this.quitButton), r.part(p));
        r.move(r.top(this.quitButton), r.bottom(this.clearButton));
        p.setLayout(r);
        this.add("File Panel", p);
        p = new JifPanel(96, "Editiere Zustand");
        r = new RuleBasedLayout();
        this.initialState = new Checkbox("Anfangszustand", null, false);
        p.add(this.initialState);
        this.finalState = new Checkbox("Endzustand", null, false);
        p.add(this.finalState);
        FlexibleLabel nLabel = new FlexibleLabel("\\bZustandszeichen:");
        p.add(nLabel);
        this.nodeLabel = new List(5, false);
        for (char i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            this.nodeLabel.addItem(i + "");
        }
        p.add(this.nodeLabel);
        this.deleteNodeButton = new Button("Entferne Zustand");
        p.add(this.deleteNodeButton);
        r.hcenter(r.part(this.initialState), r.part(p));
        r.move(r.top(this.initialState), r.top(p));
        r.move(r.left(this.finalState), r.left(this.initialState));
        r.move(r.top(this.finalState), r.bottom(this.initialState));
        r.move(r.left(nLabel), r.left(this.nodeLabel));
        r.move(r.top(nLabel), r.bottom(this.finalState));
        r.hcenter(r.part(this.nodeLabel), r.part(p));
        r.move(r.top(this.nodeLabel), r.bottom(nLabel));
        r.move(r.bottom(this.deleteNodeButton), r.bottom(p));
        r.hcenter(r.part(this.deleteNodeButton), r.part(p));
        p.setLayout(r);
        this.add("Node Panel", p);
        p = new JifPanel(96, "Editiere Uebergang");
        r = new RuleBasedLayout();
        FlexibleLabel label = new FlexibleLabel("\\bEingabezeichen:");
        p.add(label);
        this.edgeLabel = new List(5, true);
        for (char i = '!'; i < '\u007f'; i = (char)(i + '\u0001')) {
            this.edgeLabel.addItem(i + "");
        }
        p.add(this.edgeLabel);
        this.lcButton = new Button("a-z");
        p.add(this.lcButton);
        this.ucButton = new Button("A-Z");
        p.add(this.ucButton);
        this.digitButton = new Button("0-9");
        p.add(this.digitButton);
        this.deleteEdgeButton = new Button("Entferne Uebergang");
        p.add(this.deleteEdgeButton);
        r.move(r.left(label), r.left(this.edgeLabel));
        r.move(r.top(label), r.top(p));
        r.hcenter(r.part(this.edgeLabel), r.part(p));
        r.move(r.top(this.edgeLabel), r.bottom(label));
        r.move(r.top(this.lcButton), r.bottom(this.edgeLabel));
        r.move(r.right(this.lcButton), r.left(this.ucButton));
        r.stretch(r.width(this.lcButton), r.width(this.ucButton));
        r.move(r.top(this.ucButton), r.bottom(this.edgeLabel));
        r.hcenter(r.part(this.ucButton), r.part(p));
        r.move(r.top(this.digitButton), r.bottom(this.edgeLabel));
        r.move(r.left(this.digitButton), r.right(this.ucButton));
        r.stretch(r.width(this.digitButton), r.width(this.ucButton));
        r.move(r.bottom(this.deleteEdgeButton), r.bottom(p));
        r.hcenter(r.part(this.deleteEdgeButton), r.part(p));
        p.setLayout(r);
        this.add("Edge Panel", p);
        ((CardLayout)this.getLayout()).show(this, "File Panel");
    }

    public void removeTargetFSA() {
        this.target = null;
    }

    public boolean handleEvent(Event evt) {
        if (evt.target == this.edgeLabel) {
            if (evt.id == 701) {
                try {
                    this.target.setSelectedEdgeSymbol((Integer)evt.arg, true);
                }
                catch (NoEdgeSelectedException nese) {
                    nese.printStackTrace();
                }
                return true;
            }
            if (evt.id == 702) {
                try {
                    this.target.setSelectedEdgeSymbol((Integer)evt.arg, false);
                }
                catch (NoEdgeSelectedException nese) {
                    nese.printStackTrace();
                }
                return true;
            }
        } else if (evt.target == this.nodeLabel && evt.id == 701) {
            try {
                this.target.setSelectedNodeSymbol((Integer)evt.arg);
            }
            catch (NoNodeSelectedException nnse) {
                nnse.printStackTrace();
            }
            return true;
        }
        return super.handleEvent(evt);
    }

    public void blank() {
        this.cl.show(this, "Blank Panel");
    }
}

