/*
 * Decompiled with CFR 0.152.
 */
package sum.generator;

import bluej.extensions.BlueJ;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import sum.ereignis.Buntstift;
import sum.ereignis.Ereignisanwendung;
import sum.generator.Ereignis;
import sum.generator.KomponentenListe;
import sum.generator.KomponentenModell;
import sum.generator.MagnetLinie;
import sum.generator.Schreiber;
import sum.generator.Warnung;
import sum.komponenten.Auswahl;
import sum.komponenten.Etikett;
import sum.komponenten.Knopf;
import sum.komponenten.Radiogruppe;
import sum.komponenten.Radioknopf;
import sum.komponenten.Schalter;
import sum.komponenten.Textfeld;
import sum.werkzeuge.Textwerkzeug;

public class SuMGeneratorAnwendung
extends Ereignisanwendung {
    public static final int LINKS = 185;
    private int zAltH = 0;
    private int zAltV = 0;
    private int zKleinH = 0;
    private int zKleinV = 0;
    private int zGrossH = 0;
    private int zGrossV = 0;
    private boolean istInitialisiert = false;
    private boolean istKomponenteAktiv = false;
    private String zName = "SuMAnwendung";
    public static KomponentenModell KOMPONENTE = null;
    private KomponentenListe hatKomponentenListe = new KomponentenListe();
    private Vector hatSchalterListe;
    private Textwerkzeug hatTW;
    private Buntstift hatStift = new Buntstift();
    private Schreiber hatSchreiber;
    private MagnetLinie hatMagnetLinieH;
    private MagnetLinie hatMagnetLinieV;
    private MagnetLinie hatRand;
    private Etikett etikettName;
    private Etikett etikettX;
    private Etikett etikettY;
    private Etikett etikettBreite;
    private Etikett etikettHoehe;
    private Etikett etikettBezeichner;
    private Etikett etikettInhalt;
    private Etikett etikettAusrichtung;
    private Etikett etikettKomponenten;
    private Etikett etikettEigenschaften;
    private Etikett etikettEreignisse;
    private Textfeld txtName;
    private Textfeld txtX;
    private Textfeld txtY;
    private Textfeld txtBreite;
    private Textfeld txtHoehe;
    private Textfeld txtBezeichner;
    private Textfeld txtInhalt;
    private Knopf knopfGenerieren;
    private Knopf knopfLesen;
    private Radioknopf knopfLinks;
    private Radioknopf knopfMitte;
    private Radioknopf knopfRechts;
    private Radiogruppe radiogruppe;
    private Auswahl auswahlKomponenten;

    public SuMGeneratorAnwendung(BlueJ pBlueJ) {
        this.hatTW = new Textwerkzeug();
        this.hatSchreiber = new Schreiber(pBlueJ, this);
        this.hatMagnetLinieH = new MagnetLinie(true);
        this.hatMagnetLinieV = new MagnetLinie(false);
        this.hatRand = new MagnetLinie();
        this.initialisiereEigenschaften();
        this.bildschirm().loescheAlles();
        this.fuehreAus();
    }

    private void initialisiereEigenschaften() {
        int i;
        int lHoehe = 25;
        int lOben = 120;
        this.knopfGenerieren = new Knopf(2.0, 5.0, 180.0, 30.0, "Programm generieren", "knopfGenerierenGeklickt");
        this.knopfLesen = new Knopf(2.0, 40.0, 180.0, 30.0, "Komponenten laden", "knopfLesenGeklickt");
        this.etikettName = new Etikett(0.0, 88.0, 180.0, 25.0, "Name der Anwendung:");
        this.etikettName.setzeSchriftStil(1);
        this.etikettName.aktiviere();
        this.txtName = new Textfeld(2.0, 110.0, 180.0, 25.0, this.zName);
        this.txtName.aktiviere();
        this.txtName.setzeBearbeiterInhaltGeaendert("nameGeaendert");
        this.etikettKomponenten = new Etikett(0.0, (double)(lOben += 25), 110.0, 25.0, "Komponenten:");
        this.etikettKomponenten.setzeSchriftgroesse(14);
        this.etikettKomponenten.setzeSchriftStil(1);
        this.etikettKomponenten.aktiviere();
        this.auswahlKomponenten = new Auswahl(0.0, lOben += 24, 180.0, 25.0);
        for (i = 0; i < KomponentenModell.TYP.length; ++i) {
            this.auswahlKomponenten.haengeAn(KomponentenModell.TYP[i]);
        }
        this.etikettEigenschaften = new Etikett(0.0, (double)(lOben += 35), 180.0, 25.0, "Eigenschaften:");
        this.etikettEigenschaften.setzeSchriftStil(1);
        this.etikettEigenschaften.aktiviere();
        this.etikettX = new Etikett(5.0, (double)(lOben += 25), 40.0, 25.0, "H:");
        this.etikettX.setzeSchriftgroesse(10);
        this.etikettX.aktiviere();
        this.etikettY = new Etikett(50.0, (double)lOben, 40.0, 25.0, "V:");
        this.etikettY.setzeSchriftgroesse(10);
        this.etikettY.aktiviere();
        this.txtX = new Textfeld(2.0, lOben += 25, 42.0, 25.0, "");
        this.txtX.deaktiviere();
        this.txtY = new Textfeld(44.0, lOben, 42.0, 25.0, "");
        this.txtY.deaktiviere();
        this.txtX.setzeBearbeiterEingabeBestaetigt("txtPositionEingabe");
        this.txtY.setzeBearbeiterEingabeBestaetigt("txtPositionEingabe");
        this.txtX.setzeBearbeiterFokusVerloren("txtPositionEingabe");
        this.txtY.setzeBearbeiterFokusVerloren("txtPositionEingabe");
        this.txtX.setzeBearbeiterFokusErhalten("eigenschaftenFokusErhalten");
        this.txtY.setzeBearbeiterFokusErhalten("eigenschaftenFokusErhalten");
        this.etikettBreite = new Etikett(95.0, (double)(lOben -= 25), 40.0, 25.0, "Breite:");
        this.etikettBreite.setzeSchriftgroesse(10);
        this.etikettBreite.aktiviere();
        this.etikettHoehe = new Etikett(140.0, (double)lOben, 40.0, 25.0, "Hoehe:");
        this.etikettHoehe.setzeSchriftgroesse(10);
        this.etikettHoehe.aktiviere();
        this.txtBreite = new Textfeld(92.0, lOben += 25, 45.0, 25.0, "");
        this.txtBreite.deaktiviere();
        this.txtHoehe = new Textfeld(137.0, lOben, 45.0, 25.0, "");
        this.txtHoehe.deaktiviere();
        this.txtBreite.setzeBearbeiterEingabeBestaetigt("txtGroesseEingabe");
        this.txtHoehe.setzeBearbeiterEingabeBestaetigt("txtGroesseEingabe");
        this.txtBreite.setzeBearbeiterFokusVerloren("txtGroesseEingabe");
        this.txtHoehe.setzeBearbeiterFokusVerloren("txtGroesseEingabe");
        this.txtBreite.setzeBearbeiterFokusErhalten("eigenschaftenFokusErhalten");
        this.txtHoehe.setzeBearbeiterFokusErhalten("eigenschaftenFokusErhalten");
        this.etikettBezeichner = new Etikett(5.0, (double)(lOben += 27), 175.0, 25.0, "Bezeichner:");
        this.etikettBezeichner.setzeSchriftgroesse(10);
        this.etikettBezeichner.aktiviere();
        this.txtBezeichner = new Textfeld(2.0, lOben += 25, 180.0, 25.0, "");
        this.txtBezeichner.deaktiviere();
        this.txtBezeichner.setzeBearbeiterEingabeBestaetigt("txtBezeichnerEingabe");
        this.txtBezeichner.setzeBearbeiterFokusErhalten("eigenschaftenFokusErhalten");
        this.etikettInhalt = new Etikett(5.0, (double)(lOben += 27), 175.0, 25.0, "Inhalt:");
        this.etikettInhalt.setzeSchriftgroesse(10);
        this.etikettInhalt.aktiviere();
        this.txtInhalt = new Textfeld(2.0, lOben += 25, 180.0, 25.0, "");
        this.txtInhalt.deaktiviere();
        this.etikettAusrichtung = new Etikett(5.0, (double)(lOben += 26), 75.0, 25.0, "Ausrichtung:");
        this.etikettAusrichtung.setzeSchriftgroesse(10);
        this.etikettAusrichtung.aktiviere();
        this.knopfLinks = new Radioknopf(5.0, (double)(lOben += 25), 100.0, 25.0, "Links", "knopfLinksGeklickt");
        this.knopfLinks.deaktiviere();
        this.knopfMitte = new Radioknopf(5.0, (double)(lOben += 25), 100.0, 25.0, "Mitte", "knopfMitteGeklickt");
        this.knopfMitte.deaktiviere();
        this.knopfRechts = new Radioknopf(5.0, (double)(lOben += 25), 100.0, 25.0, "Rechts", "knopfRechtsGeklickt");
        this.knopfRechts.deaktiviere();
        lOben += 25;
        this.radiogruppe = new Radiogruppe();
        this.radiogruppe.fuegeEin(this.knopfLinks);
        this.radiogruppe.fuegeEin(this.knopfMitte);
        this.radiogruppe.fuegeEin(this.knopfRechts);
        this.txtInhalt.setzeBearbeiterInhaltGeaendert("txtInhaltEingabe");
        this.txtInhalt.setzeBearbeiterFokusErhalten("eigenschaftenFokusErhalten");
        this.knopfLinks.setzeBearbeiterFokusErhalten("eigenschaftenFokusErhalten");
        this.knopfMitte.setzeBearbeiterFokusErhalten("eigenschaftenFokusErhalten");
        this.knopfRechts.setzeBearbeiterFokusErhalten("eigenschaftenFokusErhalten");
        this.etikettEreignisse = new Etikett(0.0, (double)lOben, 150.0, 25.0, "Ereignisse:");
        this.etikettEreignisse.aktiviere();
        this.etikettEreignisse.setzeSchriftStil(1);
        lOben += 25;
        this.hatSchalterListe = new Vector();
        for (i = 0; i < Ereignis.TYP.length; ++i) {
            Schalter lSchalter = new Schalter(0.0, lOben + 25 * i, 180.0, 25.0, Ereignis.TYP[i]);
            lSchalter.setzeSchriftgroesse(10);
            lSchalter.setzeBearbeiterGeklickt("schalterGeklickt");
            lSchalter.deaktiviere();
            this.hatSchalterListe.add(lSchalter);
        }
        this.istInitialisiert = true;
    }

    @Override
    public void bearbeiteTaste(char pTaste) {
        if (!(pTaste != '\u0273' && pTaste != '\u01fc' || this.hatKomponentenListe.istLeer())) {
            for (int i = this.hatKomponentenListe.groesse() - 1; i >= 0; --i) {
                KomponentenModell lKomponente = this.hatKomponentenListe.komponenteAn(i);
                if (!lKomponente.besitztFokus()) continue;
                lKomponente.gibFrei();
            }
        }
    }

    @Override
    public void bearbeiteMausDruck(int pWoH, int pWoV) {
        this.setzeFokus();
        if (this.hatKomponentenListe != null) {
            for (int i = 0; i < this.hatKomponentenListe.groesse(); ++i) {
                this.hatKomponentenListe.komponenteAn(i).setzeFokusWert(false);
            }
        }
        this.zAltH = pWoH;
        this.zAltV = pWoV;
    }

    @Override
    public void bearbeiteMausBewegt(int pWoH, int pWoV) {
        if (this.zAltH > 185 && this.zAltV != 0 && pWoH > 185) {
            this.hatStift.radiere();
            this.hatStift.bewegeBis(this.zKleinH, this.zKleinV);
            this.hatStift.zeichneRechteck(this.zGrossH - this.zKleinH, this.zGrossV - this.zKleinV);
            this.hatStift.normal();
            if (pWoH > this.zAltH) {
                this.zKleinH = this.zAltH;
                this.zGrossH = pWoH;
            } else {
                this.zKleinH = pWoH;
                this.zGrossH = this.zAltH;
            }
            if (pWoV > this.zAltV) {
                this.zKleinV = this.zAltV;
                this.zGrossV = pWoV;
            } else {
                this.zKleinV = pWoV;
                this.zGrossV = this.zAltV;
            }
            this.hatStift.bewegeBis(this.zKleinH, this.zKleinV);
            this.hatStift.zeichneRechteck(this.zGrossH - this.zKleinH, this.zGrossV - this.zKleinV);
            if (!this.hatKomponentenListe.istLeer()) {
                for (int i = 0; i < this.hatKomponentenListe.groesse(); ++i) {
                    KomponentenModell lKomponente = this.hatKomponentenListe.komponenteAn(i);
                    if (lKomponente.links() + lKomponente.breite() < this.zGrossH && lKomponente.links() > this.zKleinH && lKomponente.oben() + lKomponente.hoehe() < this.zGrossV && lKomponente.oben() > this.zKleinV) {
                        lKomponente.setzeFokusWert(true);
                        continue;
                    }
                    lKomponente.setzeFokusWert(false);
                }
            }
        }
    }

    @Override
    public void bearbeiteMausLos(int pWoH, int pWoV) {
        this.zAltH = 0;
        this.zAltV = 0;
        this.bildschirm().loescheAlles();
    }

    @Override
    public void bearbeiteDoppelKlick(int pWoH, int pWoV) {
        this.deaktiviereEigenschaften();
        KomponentenModell lKomponente = SuMGeneratorAnwendung.erzeugeKomponentenModellObjekt(this.auswahlKomponenten.text());
        lKomponente.setzePosition(pWoH, pWoV);
        this.hatKomponentenListe.neueKomponente(lKomponente);
        lKomponente.setzeFokusWert(true);
        KOMPONENTE = lKomponente;
        this.komponenteGeklickt();
        this.zAltH = 0;
        this.zAltV = 0;
    }

    @Override
    public void bearbeiteFokusErhalten() {
        if (this.istInitialisiert) {
            this.deaktiviereEigenschaften();
            this.setzeKomponentePassiv();
        }
    }

    @Override
    public void bearbeiteLeerlauf() {
    }

    public void eigenschaftenFokusErhalten() {
        if (KOMPONENTE != null) {
            if (!this.hatKomponentenListe.istLeer()) {
                for (int i = 0; i < this.hatKomponentenListe.groesse(); ++i) {
                    this.hatKomponentenListe.komponenteAn(i).setzeFokusWert(false);
                }
            }
            KOMPONENTE.setzeFokusWert(true);
        }
    }

    public void komponenteGeklickt() {
        this.deaktiviereEigenschaften();
        KOMPONENTE.setzeFokus();
        this.istKomponenteAktiv = true;
        this.auswahlKomponenten.waehle(KOMPONENTE.typ());
        this.zeigeEigenschaften();
        this.txtBezeichner.aktiviere();
        this.txtBezeichner.setzeInhalt(KOMPONENTE.bezeichner());
        this.txtBezeichner.setzeBearbeiterInhaltGeaendert("txtBezeichnerEingabe");
        this.txtInhalt.setzeBearbeiterInhaltGeaendert("");
        if (KOMPONENTE.inhaltAlsText().equals("%kein Inhalt")) {
            this.txtInhalt.setzeInhalt("");
            this.txtInhalt.deaktiviere();
        } else {
            this.txtInhalt.aktiviere();
            this.txtInhalt.setzeInhalt(KOMPONENTE.inhaltAlsText());
        }
        this.txtInhalt.setzeBearbeiterInhaltGeaendert("txtInhaltEingabe");
        if (KOMPONENTE.ausrichtung() != -1) {
            this.knopfLinks.aktiviere();
            this.knopfRechts.aktiviere();
            this.knopfMitte.aktiviere();
            if (KOMPONENTE.ausrichtung() == 0) {
                this.knopfLinks.waehle();
            }
            if (KOMPONENTE.ausrichtung() == 1) {
                this.knopfMitte.waehle();
            }
            if (KOMPONENTE.ausrichtung() == 2) {
                this.knopfRechts.waehle();
            }
        }
        for (int i = 0; i < KOMPONENTE.ereignisListe().size(); ++i) {
            Ereignis lEreignis = (Ereignis)KOMPONENTE.ereignisListe().elementAt(i);
            Schalter lSchalter = (Schalter)this.hatSchalterListe.elementAt(lEreignis.typ());
            lSchalter.aktiviere();
            if (!lEreignis.istAktiv()) continue;
            lSchalter.schalteAn();
        }
    }

    private boolean istJavaIdentifier(String s) {
        if (s.length() == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private String alsJavaIdentifier(String s, boolean istKlasse) {
        for (int i = s.length() - 1; i > 0; --i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            s = this.hatTW.textOhne(s, i + 1, i + 1);
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            s = this.hatTW.textOhne(s, 1, 1);
        }
        if (s.length() == 0) {
            if (istKlasse) {
                return "SuMAnwendung";
            }
            return "bezeichner";
        }
        return s;
    }

    public void txtInhaltEingabe() {
        if (this.istKomponenteAktiv()) {
            KOMPONENTE.setzeInhalt(this.txtInhalt.inhaltAlsText());
            if (this.txtInhalt.inhaltAlsText().equals("")) {
                KOMPONENTE.setzeBezeichner("hat" + KOMPONENTE.typ() + KOMPONENTE.nummer());
            } else {
                String s = this.txtInhalt.inhaltAlsText();
                if (this.hatTW.positionVon(s, KOMPONENTE.typ()) == 1) {
                    s = this.hatTW.textOhne(s, 1, this.hatTW.laenge(KOMPONENTE.typ()));
                }
                while (this.hatTW.laenge(s) > 0 && this.hatTW.zeichenAn(s, 1) == ' ') {
                    s = this.hatTW.textOhne(s, 1, 1);
                }
                s = this.hatTW.kleinschrift(s);
                int i = 1;
                String t = "";
                while (this.hatTW.laenge(this.hatTW.wortAn(s, i)) > 0) {
                    t = t + this.hatTW.grossschrift(this.hatTW.teilzeichenkette(this.hatTW.wortAn(s, i), 1, 1));
                    if (this.hatTW.laenge(this.hatTW.wortAn(s, i)) > 1) {
                        t = t + this.hatTW.teilzeichenkette(this.hatTW.wortAn(s, i), 2, this.hatTW.laenge(this.hatTW.wortAn(s, i)));
                    }
                    ++i;
                }
                s = "";
                block11: for (int j = 1; j <= this.hatTW.laenge(t); ++j) {
                    char ch = this.hatTW.zeichenAn(t, j);
                    switch (ch) {
                        case '\u00c4': {
                            s = s + "Ae";
                            continue block11;
                        }
                        case '\u00d6': {
                            s = s + "Oe";
                            continue block11;
                        }
                        case '\u00dc': {
                            s = s + "Ue";
                            continue block11;
                        }
                        case '\u00e4': {
                            s = s + "ae";
                            continue block11;
                        }
                        case '\u00f6': {
                            s = s + "oe";
                            continue block11;
                        }
                        case '\u00fc': {
                            s = s + "ue";
                            continue block11;
                        }
                        case '\u00df': {
                            s = s + "ss";
                            continue block11;
                        }
                        default: {
                            if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') && (ch < '0' || ch > '9')) continue block11;
                            s = s + ch;
                        }
                    }
                }
                s = this.alsJavaIdentifier(s, false);
                KOMPONENTE.setzeBezeichner("hat" + KOMPONENTE.typ() + s);
            }
            this.txtBezeichner.setzeInhalt(KOMPONENTE.bezeichner());
        }
    }

    public void txtBezeichnerEingabe() {
        if (this.istKomponenteAktiv() && this.istJavaIdentifier(this.txtBezeichner.inhaltAlsText())) {
            KOMPONENTE.setzeBezeichner(this.txtBezeichner.inhaltAlsText());
        }
    }

    public void txtGroesseEingabe() {
        if (this.istKomponenteAktiv() && this.txtBreite.inhaltIstZahl() && this.txtHoehe.inhaltIstZahl()) {
            KOMPONENTE.setzeGroesse(this.txtBreite.inhaltAlsZahl(), this.txtHoehe.inhaltAlsZahl());
        }
    }

    public void txtPositionEingabe() {
        if (this.istKomponenteAktiv() && this.txtX.inhaltIstZahl() && this.txtY.inhaltIstZahl()) {
            KOMPONENTE.setzePosition(this.txtX.inhaltAlsZahl() + 185.0, this.txtY.inhaltAlsZahl());
        }
    }

    public void knopfLinksGeklickt() {
        if (this.istKomponenteAktiv()) {
            KOMPONENTE.setzeAusrichtung(0);
        }
    }

    public void knopfMitteGeklickt() {
        if (this.istKomponenteAktiv()) {
            KOMPONENTE.setzeAusrichtung(1);
        }
    }

    public void knopfRechtsGeklickt() {
        if (this.istKomponenteAktiv()) {
            KOMPONENTE.setzeAusrichtung(2);
        }
    }

    public void schalterGeklickt() {
        for (int i = 0; i < this.hatSchalterListe.size(); ++i) {
            Schalter lSchalter = (Schalter)this.hatSchalterListe.elementAt(i);
            if (!lSchalter.besitztFokus()) continue;
            KOMPONENTE.setzeFokus();
            KOMPONENTE.aktiviereEreignis(i, lSchalter.angeschaltet());
        }
        KOMPONENTE.aktiviereEreignis(KOMPONENTE.standardEreignis(), true);
    }

    public void knopfGenerierenGeklickt() {
        String lDoppelt = "";
        if (this.istInitialisiert && !this.hatKomponentenListe.istLeer()) {
            Hashtable<String, String> lBezeichnermenge = new Hashtable<String, String>();
            for (int i = 0; i < this.hatKomponentenListe.size(); ++i) {
                KomponentenModell lKomponente = (KomponentenModell)this.hatKomponentenListe.elementAt(i);
                if (lBezeichnermenge.get(lKomponente.bezeichner()) != null) {
                    lDoppelt = lKomponente.bezeichner();
                    continue;
                }
                lBezeichnermenge.put(lKomponente.bezeichner(), lKomponente.bezeichner());
            }
            if (lDoppelt != "") {
                Warnung lWarnung = new Warnung(this.bildschirm(), "Bezeichner: " + lDoppelt + " ist doppelt.");
            } else {
                JFileChooser speichernDialog = new JFileChooser();
                speichernDialog.setDialogTitle("Name des neuen Projekts");
                if (speichernDialog.showSaveDialog(this.bildschirm()) == 0) {
                    File file = speichernDialog.getSelectedFile();
                    this.hatSchreiber.schreibe(this.hatKomponentenListe, file);
                }
            }
        }
    }

    public void knopfLesenGeklickt() {
        if (this.istInitialisiert) {
            JFileChooser lesenDialog = new JFileChooser();
            lesenDialog.setDialogTitle("Komponenten laden von");
            FileNameExtensionFilter lFilter = new FileNameExtensionFilter("ser-Dateien", "ser");
            lesenDialog.setFileFilter(lFilter);
            if (lesenDialog.showOpenDialog(this.bildschirm()) == 0) {
                File file = lesenDialog.getSelectedFile();
                this.hatSchreiber.lese(this.hatKomponentenListe, file);
            }
        }
    }

    private void zeigeEigenschaften() {
        if (!this.txtX.besitztFokus() && this.istKomponenteAktiv()) {
            this.txtX.aktiviere();
            this.txtX.setzeInhalt(KOMPONENTE.links() - 185);
        }
        if (!this.txtY.besitztFokus() && this.istKomponenteAktiv()) {
            this.txtY.aktiviere();
            this.txtY.setzeInhalt(KOMPONENTE.oben());
        }
        if (!this.txtBreite.besitztFokus() && this.istKomponenteAktiv()) {
            this.txtBreite.aktiviere();
            this.txtBreite.setzeInhalt(KOMPONENTE.breite());
        }
        if (!this.txtHoehe.besitztFokus() && this.istKomponenteAktiv()) {
            this.txtHoehe.aktiviere();
            this.txtHoehe.setzeInhalt(KOMPONENTE.hoehe());
        }
    }

    private void deaktiviereEigenschaften() {
        if (this.istInitialisiert) {
            this.txtX.deaktiviere();
            this.txtY.deaktiviere();
            this.txtBreite.deaktiviere();
            this.txtHoehe.deaktiviere();
            this.txtBezeichner.deaktiviere();
            this.txtInhalt.deaktiviere();
            this.knopfLinks.deaktiviere();
            this.knopfMitte.deaktiviere();
            this.knopfRechts.deaktiviere();
            this.txtX.setzeInhalt("");
            this.txtY.setzeInhalt("");
            this.txtBreite.setzeInhalt("");
            this.txtHoehe.setzeInhalt("");
            this.txtBezeichner.setzeInhalt("");
            this.txtInhalt.setzeBearbeiterInhaltGeaendert("");
            this.txtInhalt.setzeInhalt("");
            this.txtInhalt.setzeBearbeiterInhaltGeaendert("txtInhaltEingabe");
            for (int i = 0; i < this.hatSchalterListe.size(); ++i) {
                Schalter s = (Schalter)this.hatSchalterListe.elementAt(i);
                s.deaktiviere();
                s.schalteAus();
            }
        }
    }

    private void setzeKomponentePassiv() {
        this.istKomponenteAktiv = false;
    }

    private boolean istKomponenteAktiv() {
        return this.istKomponenteAktiv;
    }

    protected String name() {
        return this.zName;
    }

    protected void setzeName(String pName) {
        this.zName = pName;
        this.txtName.setzeInhalt(pName);
    }

    public void nameGeaendert() {
        if (this.istJavaIdentifier(this.txtName.inhaltAlsText())) {
            this.zName = this.txtName.inhaltAlsText();
        }
    }

    static KomponentenModell erzeugeKomponentenModellObjekt(String pKomponenteTyp) {
        Class[] lParameterKlasse = new Class[3];
        Object lObjekt = null;
        lParameterKlasse[0] = Double.class;
        lParameterKlasse[1] = Double.class;
        lParameterKlasse[2] = String.class;
        try {
            Class<?> lKlasse = Class.forName("sum.generator." + pKomponenteTyp + "Modell");
            Constructor<?> lKonstruktor = lKlasse.getConstructor(lParameterKlasse);
            Object[] lParameterObjekt = new Object[]{new Double(0.0), new Double(0.0), "komponenteGeklickt"};
            lObjekt = lKonstruktor.newInstance(lParameterObjekt);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        if (lObjekt != null) {
            return lObjekt;
        }
        return null;
    }
}

