/*
 * Decompiled with CFR 0.152.
 */
package sum.generator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.border.Border;
import sum.ereignis.Bildschirm;
import sum.ereignis.Ereignisanwendung;
import sum.generator.Ereignis;
import sum.generator.KomponentenListe;
import sum.generator.MagnetLinie;
import sum.generator.Schreiber;
import sum.generator.SuMGeneratorAnwendung;
import sum.werkzeuge.Rechner;

public abstract class KomponentenModell
extends JComponent
implements Serializable {
    public static final String[] TYP = new String[]{"Etikett", "Knopf", "Textfeld", "Zeichenbereich", "Zeilenbereich", "Kennwortfeld", "Schalter", "Auswahl", "Regler", "Fortschrittsbalken", "Tabelle"};
    private Vector hatEreignisListe;
    private KomponentenListe kenntKomponentenListe;
    private JComponent hatComponent;
    private Rechner hatRechner;
    private Point zMinimalGroesse = new Point(25, 25);
    private String zGeklicktBearbeiter = "";
    private boolean zBewegbar = true;
    private boolean zHatFokus = false;
    private String zInhalt = "";
    private String zTyp = "";
    private String zBezeichner = "";
    private int zIntTyp;
    private int zAusrichtung = -1;
    private int zStandardEreignis = -1;
    protected int altHoehe;
    protected int altBreite;
    protected int altH;
    protected int altV;
    private int zNummer;

    public KomponentenModell(String pAufschrift) {
        Bildschirm.hatPrivatschirm.privatPanel().add((Component)this, new Integer(1));
        this.addMouseListener(new KomponentModellMausReaktor());
        this.addMouseMotionListener(new KomponentModellBewegungReaktor());
        this.addKeyListener(new KomponentModellTastenReaktor());
        this.addFocusListener(new KomponentModellFokusReaktor());
        this.setzeRahmen(new Rahmen());
        this.hatRechner = new Rechner();
        this.hatEreignisListe = new Vector();
    }

    public KomponentenModell(String pAufschrift, String pGeklicktBearbeiter) {
        this(pAufschrift);
        this.zGeklicktBearbeiter = pGeklicktBearbeiter;
    }

    protected void lerneKomponenteKennen(JComponent pKomponente) {
        this.hatComponent = pKomponente;
        this.hatComponent.setFocusable(false);
        Bildschirm.hatPrivatschirm.privatPanel().add((Component)this.hatComponent, new Integer(1));
    }

    public void setzeBearbeiterGeklickt(String pBearbeiter) {
        this.zGeklicktBearbeiter = pBearbeiter;
    }

    public String geklicktBearbeiter() {
        return this.zGeklicktBearbeiter;
    }

    public void komponentenModellGeklickt() {
        Class[] formparas = new Class[1];
        Object[] meinKomponentModell = new KomponentenModell[1];
        if (this.zGeklicktBearbeiter.length() > 0) {
            try {
                Class<?> sumEreignis = Ereignisanwendung.hatSuMPrivateAnwendung.getClass();
                try {
                    Method methode = sumEreignis.getMethod(this.zGeklicktBearbeiter, null);
                    methode.invoke((Object)Ereignisanwendung.hatSuMPrivateAnwendung, null);
                }
                catch (InvocationTargetException e0) {
                    System.out.println("Fehler in Methode \"" + this.zGeklicktBearbeiter + "\" von KomponentenModell \"" + this.inhaltAlsText() + "\": " + e0.getTargetException().toString());
                }
                catch (Exception e1) {
                    try {
                        formparas[0] = KomponentenModell.class;
                        Method methode = sumEreignis.getMethod(this.geklicktBearbeiter(), formparas);
                        meinKomponentModell[0] = this;
                        methode.invoke((Object)Ereignisanwendung.hatSuMPrivateAnwendung, meinKomponentModell);
                    }
                    catch (InvocationTargetException e2) {
                        System.out.println("Fehler in Methode \"" + this.zGeklicktBearbeiter + "\" von KomponentenModell \"" + this.inhaltAlsText() + "\": " + e2.getTargetException().toString());
                    }
                    catch (Exception e3) {
                        System.out.println("Fehler: Methode \"" + this.zGeklicktBearbeiter + "\" von KomponentenModell \"" + this.inhaltAlsText() + "\" nicht gefunden.");
                    }
                }
            }
            catch (Exception e4) {
                System.out.println("KomponentenModell: " + e4.toString());
            }
        }
    }

    private boolean istMausRechtsUnten(int pWoH, int pWoV) {
        return pWoH > this.breite() - 15 && pWoV > this.hoehe() - 15;
    }

    public void bearbeiteMausDruck(int pWoH, int pWoV) {
        SuMGeneratorAnwendung.KOMPONENTE = this;
        this.altH = pWoH;
        this.altV = pWoV;
        this.altHoehe = this.hoehe();
        this.altBreite = this.breite();
        for (int i = 0; i < this.kenntKomponentenListe.groesse(); ++i) {
            KomponentenModell lKomponente = this.kenntKomponentenListe.komponenteAn(i);
            if (!lKomponente.besitztFokus()) continue;
            lKomponente.altHoehe = lKomponente.hoehe();
            lKomponente.altBreite = lKomponente.breite();
        }
        if (this.istMausRechtsUnten(pWoH, pWoV)) {
            this.setzeBewegbar(false);
        } else {
            this.setzeBewegbar(true);
        }
    }

    public void bearbeiteMausLos(int pWoH, int pWoV) {
        this.altH = 0;
        this.altV = 0;
        this.altHoehe = 0;
        this.altBreite = 0;
        this.setzeBewegbar(true);
        if (this.oben() < 0) {
            this.setzePosition(this.links(), 0.0);
        }
        if (this.links() < 0) {
            this.setzePosition(0.0, this.oben());
        }
        for (int i = 0; i < this.kenntKomponentenListe.groesse(); ++i) {
            KomponentenModell lKomponente = this.kenntKomponentenListe.komponenteAn(i);
            if (!lKomponente.besitztFokus()) continue;
            if (this.hatRechner.betrag(lKomponente.links() - MagnetLinie.POSITION_H) < 15) {
                lKomponente.setzePosition(MagnetLinie.POSITION_H + 1, lKomponente.oben());
            }
            if (this.hatRechner.betrag(lKomponente.oben() - MagnetLinie.POSITION_V) < 15) {
                lKomponente.setzePosition(lKomponente.links(), MagnetLinie.POSITION_V + 1);
            }
            if (this.hatRechner.betrag(lKomponente.links() + lKomponente.breite() - MagnetLinie.POSITION_H) < 15) {
                lKomponente.setzePosition(MagnetLinie.POSITION_H - lKomponente.breite() + 2, lKomponente.oben());
            }
            if (this.hatRechner.betrag(lKomponente.oben() + lKomponente.hoehe() - MagnetLinie.POSITION_V) < 15) {
                lKomponente.setzePosition(lKomponente.links(), MagnetLinie.POSITION_V - lKomponente.hoehe() + 2);
            }
            lKomponente.altHoehe = lKomponente.hoehe();
            lKomponente.altBreite = lKomponente.breite();
        }
    }

    public void bearbeiteMausBewegt(int pWoH, int pWoV) {
        if (this.istMausRechtsUnten(pWoH, pWoV)) {
            this.setzeMauszeiger(new Cursor(5));
        } else {
            this.setzeMauszeiger(new Cursor(12));
        }
    }

    public void bearbeiteMausDruckBewegt(int pWoH, int pWoV) {
        if (!this.istBewegbar()) {
            this.setzeMauszeiger(new Cursor(5));
            if (!this.kenntKomponentenListe.istLeer()) {
                for (int i = 0; i < this.kenntKomponentenListe.groesse(); ++i) {
                    KomponentenModell komponente = this.kenntKomponentenListe.komponenteAn(i);
                    if (!komponente.besitztFokus()) continue;
                    komponente.setzeGroesse(komponente.altBreite + pWoH - this.altH, pWoV - this.altV + komponente.altHoehe);
                }
            }
            this.hatComponent.repaint();
        } else {
            this.setzeMauszeiger(new Cursor(12));
            if (!this.kenntKomponentenListe.istLeer()) {
                for (int i = 0; i < this.kenntKomponentenListe.groesse(); ++i) {
                    KomponentenModell komponente = this.kenntKomponentenListe.komponenteAn(i);
                    if (!komponente.besitztFokus()) continue;
                    int lH = pWoH - this.altH + komponente.links();
                    int lV = pWoV - this.altV + komponente.oben();
                    if (lH < 185) {
                        lH = 185;
                    }
                    if (lV < 0) {
                        lV = 0;
                    }
                    komponente.setzePosition(lH, lV);
                }
            }
        }
    }

    public void bearbeiteTaste(char pTaste) {
        if (pTaste == '\u0273' || pTaste == '\u01fc') {
            this.gibFrei();
        }
    }

    public void setzeFokus() {
        this.requestFocus();
        SuMGeneratorAnwendung.KOMPONENTE = this;
    }

    protected void setzeFokusWert(boolean pFokus) {
        this.zHatFokus = pFokus;
        this.setzeRahmen(new Rahmen());
    }

    public boolean besitztFokus() {
        return this.zHatFokus;
    }

    public void setzeBewegbar(boolean pBewegbar) {
        this.zBewegbar = pBewegbar;
    }

    public boolean istBewegbar() {
        return this.zBewegbar;
    }

    public void setzePosition(double pWohinH, double pWohinV) {
        if (pWohinH < 0.0) {
            pWohinH = 0.0;
        }
        if (pWohinV < -3.0) {
            pWohinV = -3.0;
        }
        this.setLocation((int)pWohinH, (int)pWohinV);
        this.hatComponent.setLocation((int)pWohinH + 1, (int)pWohinV + 1);
    }

    public int links() {
        return this.getLocation().x;
    }

    public int oben() {
        return this.getLocation().y;
    }

    public void setzeGroesse(double pBreite, double pHoehe) {
        if (pBreite < this.minimalGroesse().getX()) {
            pBreite = this.minimalGroesse().getX();
        }
        if (pHoehe < this.minimalGroesse().getY()) {
            pHoehe = this.minimalGroesse().getY();
        }
        this.setSize((int)pBreite, (int)pHoehe);
        this.hatComponent.setSize((int)pBreite - 2, (int)pHoehe - 2);
    }

    public int breite() {
        return this.getSize().width;
    }

    public int hoehe() {
        return this.getSize().height;
    }

    public void setzeMinimalGroesse(Point pMinimalGroesse) {
        this.zMinimalGroesse = pMinimalGroesse;
    }

    public Point minimalGroesse() {
        return this.zMinimalGroesse;
    }

    public void zeichneRahmenOhneFokus(Graphics pKontext) {
        pKontext.setColor(Color.blue);
        pKontext.drawRect(0, 0, this.breite() - 1, this.hoehe() - 1);
    }

    public void zeichneRahmenMitFokus(Graphics pKontext) {
        pKontext.setColor(Color.red);
        pKontext.drawRect(0, 0, this.breite() - 1, this.hoehe() - 1);
        pKontext.drawLine(this.breite() - 1, this.hoehe() - 16, this.breite() - 16, this.hoehe() - 1);
        pKontext.drawLine(this.breite() - 1, this.hoehe() - 14, this.breite() - 14, this.hoehe() - 1);
    }

    public void setzeRahmen(Border pRahmen) {
        this.setBorder(pRahmen);
    }

    public Border rahmen() {
        return this.getBorder();
    }

    public void setzeMauszeiger(Cursor pZeiger) {
        this.setCursor(pZeiger);
    }

    public Cursor mauszeiger() {
        return this.getCursor();
    }

    public void setzeInhalt(String pText) {
        this.zInhalt = pText;
    }

    public String inhaltAlsText() {
        return this.zInhalt;
    }

    public void setzeAusrichtung(int pAusrichtung) {
    }

    protected void setzeAusrichtungwert(int pAusrichtung) {
        this.zAusrichtung = pAusrichtung;
    }

    public int ausrichtung() {
        return this.zAusrichtung;
    }

    public void setzeTyp(int pTyp) {
        if (pTyp <= TYP.length) {
            this.zTyp = TYP[pTyp];
            this.zIntTyp = pTyp;
        }
    }

    public String typ() {
        return this.zTyp;
    }

    public int ityp() {
        return this.zIntTyp;
    }

    public void setzeBezeichner(String pBezeichner) {
        this.zBezeichner = pBezeichner;
    }

    public String bezeichner() {
        return this.zBezeichner;
    }

    public void setzeEreignis(int pEreignisTyp) {
        Ereignis lEreignis = new Ereignis(pEreignisTyp);
        this.ereignisListe().add(lEreignis);
    }

    public void aktiviereEreignis(int pEreignisTyp, boolean pAktiv) {
        for (int i = 0; i < this.ereignisListe().size(); ++i) {
            Ereignis lEreignis = (Ereignis)this.ereignisListe().elementAt(i);
            if (lEreignis.typ() != pEreignisTyp) continue;
            lEreignis.setzeAktiv(pAktiv);
        }
    }

    public void setzeStandardEreignis(int pEreignisTyp) {
        this.zStandardEreignis = pEreignisTyp;
        this.aktiviereEreignis(this.zStandardEreignis, true);
    }

    public int standardEreignis() {
        return this.zStandardEreignis;
    }

    public Vector ereignisListe() {
        return this.hatEreignisListe;
    }

    public String ausrichtungstext(int pAusrichtung) {
        switch (pAusrichtung) {
            case 0: {
                return "Ausrichtung.LINKS";
            }
            case 1: {
                return "Ausrichtung.MITTE";
            }
            case 2: {
                return "Ausrichtung.RECHTS";
            }
        }
        return "";
    }

    public void lerneKomponentenListe(KomponentenListe pKomponentenListe) {
        this.kenntKomponentenListe = pKomponentenListe;
    }

    public void gibFrei() {
        this.kenntKomponentenListe.loescheKomponente(this);
        Bildschirm.hatPrivatschirm.privatPanel().remove(this);
        Bildschirm.hatPrivatschirm.privatPanel().remove(this.hatComponent);
        Bildschirm.hatPrivatschirm.repaint();
        Bildschirm.hatPrivatschirm.setzeFokus();
    }

    public String objektText() {
        String lText = "    private " + this.typ() + " " + this.bezeichner() + ";" + '\n';
        return lText;
    }

    public String initText() {
        String lInhalt = ", \"" + this.inhaltAlsText() + '\"';
        String lAusrichtung = "";
        if (this.inhaltAlsText().equals("%kein Inhalt")) {
            lInhalt = "";
        }
        if (this.ausrichtung() != -1) {
            lAusrichtung = "        // Ausrichtung\n        " + this.bezeichner() + ".setzeAusrichtung(" + this.ausrichtungstext(this.ausrichtung()) + ");" + '\n';
        }
        String lText = "        " + this.bezeichner() + " = new " + this.typ() + "(" + (this.links() - 185) + ", " + this.oben() + ", " + this.breite() + ", " + this.hoehe();
        if (this.typ().equals("Etikett") || this.typ().equals("Knopf") || this.typ().equals("Schalter") || this.typ().equals("Textfeld") || this.typ().equals("Zeichenbereich") || this.typ().equals("Zeilenbereich")) {
            lText = lText + lInhalt + ");" + '\n';
        } else if (this.typ().equals("Auswahl")) {
            lText = lText + ");\n";
        } else if (this.typ().equals("Fortschrittsbalken")) {
            lText = lText + ", 0, 100);\n";
        } else if (this.typ().equals("Kennwortfeld")) {
            lText = lText + ", '*');\n";
        } else if (this.typ().equals("Regler")) {
            lText = lText + ", 0, 0, 100);\n";
        } else if (this.typ().equals("Tabelle")) {
            lText = lText + ", 3, 3);\n";
        }
        lText = lText + lAusrichtung;
        for (int i = 0; i < this.ereignisListe().size(); ++i) {
            if (!((Ereignis)this.ereignisListe().elementAt(i)).istAktiv()) continue;
            lText = lText + "        " + this.bezeichner() + ".setzeBearbeiter" + Ereignis.TYP[((Ereignis)this.ereignisListe().elementAt(i)).typ()] + "(" + '\"' + this.bezeichner() + Ereignis.TYP[((Ereignis)this.ereignisListe().elementAt(i)).typ()] + '\"' + ");" + '\n';
        }
        return lText;
    }

    public String ereignisText() {
        String lText = "";
        for (int i = 0; i < this.hatEreignisListe.size(); ++i) {
            if (!((Ereignis)this.ereignisListe().elementAt(i)).istAktiv()) continue;
            String ereignisName = Ereignis.TYP[((Ereignis)this.ereignisListe().elementAt(i)).typ()];
            lText = lText + Schreiber.kommentarText("Vorher: Ereignis " + ereignisName + "von" + this.bezeichner() + " fand statt." + '\n' + " * " + "Nachher: (schreiben Sie, was in dieser Methode ausgefuehrt wird)") + Schreiber.methodenText(this.bezeichner() + ereignisName + "()");
        }
        return lText;
    }

    public void setzeNummer(int pNummer) {
        this.zNummer = pNummer;
    }

    public int nummer() {
        return this.zNummer;
    }

    private class KomponentModellFokusReaktor
    implements FocusListener {
        private KomponentModellFokusReaktor() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            KomponentenModell.this.setzeFokusWert(true);
            KomponentenModell.this.setzeRahmen(new Rahmen());
        }

        @Override
        public void focusLost(FocusEvent e) {
            KomponentenModell.this.setzeFokusWert(false);
            KomponentenModell.this.setzeRahmen(new Rahmen());
        }
    }

    private class KomponentModellTastenReaktor
    implements KeyListener {
        private KomponentModellTastenReaktor() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isActionKey() || e.getKeyCode() < 32 || e.getKeyCode() == 127) {
                KomponentenModell.this.bearbeiteTaste((char)(e.getKeyCode() + 500));
            } else {
                KomponentenModell.this.bearbeiteTaste(e.getKeyChar());
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private class KomponentModellBewegungReaktor
    extends MouseMotionAdapter {
        private KomponentModellBewegungReaktor() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            KomponentenModell.this.bearbeiteMausDruckBewegt(e.getX(), e.getY());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            KomponentenModell.this.bearbeiteMausBewegt(e.getX(), e.getY());
        }
    }

    private class KomponentModellMausReaktor
    implements MouseListener {
        private KomponentModellMausReaktor() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            KomponentenModell.this.hatComponent.requestFocus();
            KomponentenModell.this.bearbeiteMausDruck(e.getX(), e.getY());
            KomponentenModell.this.komponentenModellGeklickt();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            KomponentenModell.this.bearbeiteMausBewegt(e.getX(), e.getY());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            KomponentenModell.this.bearbeiteMausLos(e.getX(), e.getY());
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }

    protected class Rahmen
    implements Border,
    Serializable {
        protected Rahmen() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 2, 2);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component pKomponente, Graphics pKontext, int pWoH, int pWoV, int pBreite, int pHoehe) {
            if (KomponentenModell.this.besitztFokus()) {
                KomponentenModell.this.zeichneRahmenMitFokus(pKontext);
            } else {
                KomponentenModell.this.zeichneRahmenOhneFokus(pKontext);
            }
        }
    }
}

