/*
 * Decompiled with CFR 0.152.
 */
package sum.generator;

import java.io.Serializable;
import java.util.Vector;
import sum.generator.AuswahlModell;
import sum.generator.Ereignis;
import sum.generator.EtikettModell;
import sum.generator.FortschrittsbalkenModell;
import sum.generator.KennwortfeldModell;
import sum.generator.KnopfModell;
import sum.generator.KomponentenModell;
import sum.generator.ReglerModell;
import sum.generator.SchalterModell;
import sum.generator.TabelleModell;
import sum.generator.TextfeldModell;
import sum.generator.ZeichenbereichModell;
import sum.generator.ZeilenbereichModell;

public class KomponentenBeschreibung
implements Serializable {
    Vector hatEreignisListe = new Vector();
    private int zTyp;
    private String zInhalt;
    private String zBezeichner;
    private String zGeklicktBearbeiter;
    private int zAusrichtung;
    private int zStandardEreignis;
    private int zLinks;
    private int zOben;
    private int zBreite;
    private int zHoehe;

    public KomponentenBeschreibung(KomponentenModell pKomponente) {
        this.zTyp = pKomponente.ityp();
        this.zInhalt = pKomponente.inhaltAlsText();
        this.zBezeichner = pKomponente.bezeichner();
        this.zGeklicktBearbeiter = pKomponente.geklicktBearbeiter();
        this.zAusrichtung = pKomponente.ausrichtung();
        this.zStandardEreignis = pKomponente.standardEreignis();
        this.zLinks = pKomponente.links();
        this.zOben = pKomponente.oben();
        this.zBreite = pKomponente.breite();
        this.zHoehe = pKomponente.hoehe();
        for (int i = 0; i < pKomponente.ereignisListe().size(); ++i) {
            this.hatEreignisListe.addElement(new Integer(((Ereignis)pKomponente.ereignisListe().elementAt(i)).typ()));
        }
    }

    public KomponentenModell komponente() {
        KomponentenModell lKomponente = null;
        switch (this.zTyp) {
            case 0: {
                lKomponente = new EtikettModell(this.zLinks, this.zOben, this.zGeklicktBearbeiter);
                break;
            }
            case 1: {
                lKomponente = new KnopfModell(this.zLinks, this.zOben, this.zGeklicktBearbeiter);
                break;
            }
            case 2: {
                lKomponente = new TextfeldModell(this.zLinks, this.zOben, this.zGeklicktBearbeiter);
                break;
            }
            case 3: {
                lKomponente = new ZeichenbereichModell(this.zLinks, this.zOben, this.zGeklicktBearbeiter);
                break;
            }
            case 4: {
                lKomponente = new ZeilenbereichModell(this.zLinks, this.zOben, this.zGeklicktBearbeiter);
                break;
            }
            case 5: {
                lKomponente = new KennwortfeldModell(this.zLinks, this.zOben, this.zGeklicktBearbeiter);
                break;
            }
            case 6: {
                lKomponente = new SchalterModell(this.zLinks, this.zOben, this.zGeklicktBearbeiter);
                break;
            }
            case 7: {
                lKomponente = new AuswahlModell(this.zLinks, this.zOben, this.zGeklicktBearbeiter);
                break;
            }
            case 8: {
                lKomponente = new ReglerModell(this.zLinks, this.zOben, this.zGeklicktBearbeiter);
                break;
            }
            case 9: {
                lKomponente = new FortschrittsbalkenModell(this.zLinks, this.zOben, this.zGeklicktBearbeiter);
                break;
            }
            case 10: {
                lKomponente = new TabelleModell(this.zLinks, this.zOben, this.zGeklicktBearbeiter);
            }
        }
        lKomponente.setzeInhalt(this.zInhalt);
        lKomponente.setzeBezeichner(this.zBezeichner);
        lKomponente.setzeAusrichtungwert(this.zAusrichtung);
        lKomponente.setzeGroesse(this.zBreite, this.zHoehe);
        for (int i = 0; i < this.hatEreignisListe.size(); ++i) {
            lKomponente.setzeEreignis((Integer)this.hatEreignisListe.elementAt(i));
        }
        return lKomponente;
    }
}

