/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.platform;

import com.pi4j.platform.Platform;
import com.pi4j.platform.PlatformAlreadyAssignedException;

public class PlatformManager {
    private static Platform platform = null;

    public static Platform getPlatform() {
        if (platform == null) {
            try {
                PlatformManager.setPlatform(PlatformManager.getDefaultPlatform());
            }
            catch (PlatformAlreadyAssignedException e) {
                e.printStackTrace();
                return null;
            }
        }
        return platform;
    }

    public static void setPlatform(Platform platform) throws PlatformAlreadyAssignedException {
        if (PlatformManager.platform != null) {
            throw new PlatformAlreadyAssignedException(PlatformManager.platform);
        }
        PlatformManager.platform = platform;
        System.setProperty("pi4j.platform", platform.id());
    }

    protected static Platform getDefaultPlatform() {
        Platform pltfrm;
        String envPlatformId = System.getenv("PI4J_PLATFORM");
        String platformId = System.getProperty("pi4j.platform", envPlatformId);
        if (platformId != null && !platformId.isEmpty() && (pltfrm = Platform.fromId(platformId)) != null) {
            return pltfrm;
        }
        return Platform.RASPBERRYPI;
    }
}

