/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.trigger;

import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.IFTTTMakerChannelTriggerEvent;
import com.pi4j.io.gpio.event.IFTTTMakerChannelTriggerListener;
import com.pi4j.io.gpio.trigger.GpioTriggerBase;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;

public class IFTTTMakerChannelTrigger
extends GpioTriggerBase {
    private final String apikey;
    private final String eventName;
    private IFTTTMakerChannelTriggerListener listener = null;
    protected static final String IFTTT_MAKER_CHANNEL_URL = "https://maker.ifttt.com/trigger/%s/with/key/%s";

    public IFTTTMakerChannelTrigger(String apikey, String eventName) {
        this.apikey = apikey;
        this.eventName = eventName;
    }

    public IFTTTMakerChannelTrigger(String apikey, String eventName, PinState state) {
        super(state);
        this.apikey = apikey;
        this.eventName = eventName;
    }

    public IFTTTMakerChannelTrigger(String apikey, String eventName, PinState[] states) {
        super(states);
        this.apikey = apikey;
        this.eventName = eventName;
    }

    public IFTTTMakerChannelTrigger(String apikey, String eventName, List<PinState> states) {
        super(states);
        this.apikey = apikey;
        this.eventName = eventName;
    }

    public IFTTTMakerChannelTrigger(String apikey, String eventName, IFTTTMakerChannelTriggerListener listener) {
        this.apikey = apikey;
        this.eventName = eventName;
        this.listener = listener;
    }

    public IFTTTMakerChannelTrigger(String apikey, String eventName, PinState state, IFTTTMakerChannelTriggerListener listener) {
        super(state);
        this.apikey = apikey;
        this.eventName = eventName;
        this.listener = listener;
    }

    public IFTTTMakerChannelTrigger(String apikey, String eventName, PinState[] states, IFTTTMakerChannelTriggerListener listener) {
        super(states);
        this.apikey = apikey;
        this.eventName = eventName;
        this.listener = listener;
    }

    public IFTTTMakerChannelTrigger(String apikey, String eventName, List<PinState> states, IFTTTMakerChannelTriggerListener listener) {
        super(states);
        this.apikey = apikey;
        this.eventName = eventName;
        this.listener = listener;
    }

    public void setTriggerListener(IFTTTMakerChannelTriggerListener listener) {
        this.listener = listener;
    }

    @Override
    public void invoke(GpioPin pin, PinState state) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            String json = "{\"pin\":{\"name\":\"" + pin.getName() + "\",\"address\":\"" + pin.getPin().getAddress() + "\",\"provider\":\"" + pin.getPin().getProvider() + "\",\"mode\":\"" + pin.getMode().getName() + "\",\"direction\":\"" + (Object)((Object)pin.getMode().getDirection()) + "\",\"pull\":\"" + pin.getPullResistance().getName() + "\"},\"state\":{" + "\"name\":\"" + state.getName() + "\",\"value\":\"" + state.getValue() + "\",\"is-high\":\"" + state.isHigh() + "\",\"is-low\":\"" + state.isLow() + "\"},\"timestamp\":\"" + df.format(new Date()) + "\"}";
            IFTTTMakerChannelTriggerEvent event = new IFTTTMakerChannelTriggerEvent(this, pin, state, this.eventName, pin.getName(), Integer.toString(state.getValue()), json);
            if (this.listener != null && !this.listener.onTriggered(event)) {
                return;
            }
            String value1 = URLEncoder.encode(event.getValue1(), StandardCharsets.UTF_8.name());
            String value2 = URLEncoder.encode(event.getValue2(), StandardCharsets.UTF_8.name());
            String value3 = URLEncoder.encode(event.getValue3(), StandardCharsets.UTF_8.name());
            String urlParameters = "value1=" + value1 + "&value2=" + value2 + "&value3=" + value3;
            byte[] postData = urlParameters.getBytes(StandardCharsets.UTF_8);
            URL url = new URL(String.format(IFTTT_MAKER_CHANNEL_URL, this.eventName, this.apikey));
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("charset", "utf-8");
            connection.setRequestProperty("Content-Length", Integer.toString(postData.length));
            connection.setUseCaches(false);
            try (DataOutputStream stream = new DataOutputStream(connection.getOutputStream());){
                stream.write(postData);
            }
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                String inputLine;
                System.err.println("IFTTT MakerChannel ERROR Response Code: " + responseCode);
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                throw new RuntimeException(response.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

