/*
 * Decompiled with CFR 0.152.
 */
package linearestrukturen;

import java.io.Serializable;

public class Stack<ContentType>
implements Serializable {
    static final long serialVersionUID = 10120L;
    private StackNode head = null;
    private int lCount = 0;

    public boolean isEmpty() {
        return this.head == null;
    }

    public void push(ContentType pContent) {
        if (pContent != null) {
            StackNode node = new StackNode(pContent);
            node.setNext(this.head);
            this.head = node;
            ++this.lCount;
        }
    }

    public void pop() {
        if (!this.isEmpty()) {
            this.head = this.head.getNext();
            --this.lCount;
        }
    }

    public ContentType top() {
        if (!this.isEmpty()) {
            return this.head.getContent();
        }
        return null;
    }

    public int length() {
        return this.lCount;
    }

    private class StackNode
    implements Serializable {
        static final long serialVersionUID = 10121L;
        private ContentType content = null;
        private StackNode nextNode = null;

        public StackNode(ContentType pContent) {
            this.content = pContent;
            this.nextNode = null;
        }

        public void setNext(StackNode pNext) {
            this.nextNode = pNext;
        }

        public StackNode getNext() {
            return this.nextNode;
        }

        public ContentType getContent() {
            return this.content;
        }
    }
}

