/*
 * Decompiled with CFR 0.152.
 */
package linearestrukturen;

import java.io.Serializable;

public class List<ContentType>
implements Serializable {
    static final long serialVersionUID = 10132L;
    private Knoten hatBug = new Knoten(null, null, null);
    private Knoten kenntAktuelles;
    private Knoten hatHeck = new Knoten(null, this.hatBug, null);
    private int zLaenge;

    public List() {
        this.kenntAktuelles = this.hatBug;
        this.hatBug.setzeNachfolger(this.hatHeck);
        this.zLaenge = 0;
    }

    public boolean isEmpty() {
        return this.hatBug.nachfolger() == this.hatHeck;
    }

    public boolean hasAccess() {
        return this.kenntAktuelles != this.hatHeck;
    }

    public void next() {
        if (this.hasAccess()) {
            this.kenntAktuelles = this.kenntAktuelles.nachfolger();
        }
    }

    public void toFirst() {
        this.kenntAktuelles = this.hatBug.nachfolger();
    }

    public void toLast() {
        this.kenntAktuelles = this.hatHeck.vorgaenger();
    }

    public ContentType getContent() {
        if (this.hasAccess()) {
            return this.kenntAktuelles.inhalt();
        }
        return null;
    }

    public void setContent(ContentType pContent) {
        if (pContent != null && this.hasAccess()) {
            this.kenntAktuelles.setzeInhalt(pContent);
        }
    }

    public void insert(ContentType pContent) {
        if (pContent != null) {
            if (this.kenntAktuelles == this.hatBug) {
                this.next();
            }
            Knoten lNeuknoten = new Knoten(pContent, this.kenntAktuelles.vorgaenger(), this.kenntAktuelles);
            this.kenntAktuelles.vorgaenger().setzeNachfolger(lNeuknoten);
            this.kenntAktuelles.setzeVorgaenger(lNeuknoten);
            ++this.zLaenge;
        }
    }

    public void append(ContentType pContent) {
        if (pContent != null) {
            Knoten lNeuknoten = new Knoten(pContent, this.hatHeck.vorgaenger(), this.hatHeck);
            this.hatHeck.vorgaenger().setzeNachfolger(lNeuknoten);
            this.hatHeck.setzeVorgaenger(lNeuknoten);
            ++this.zLaenge;
        }
    }

    public void concat(List<ContentType> pListe2) {
        if (pListe2 != null && !pListe2.isEmpty()) {
            this.verketteKnoten(this.hatHeck.vorgaenger(), pListe2.hatBug.nachfolger());
            this.verketteKnoten(pListe2.hatHeck.vorgaenger(), this.hatHeck);
            this.zLaenge += pListe2.length();
            this.verketteKnoten(pListe2.hatBug, pListe2.hatHeck);
            pListe2.zLaenge = 0;
            pListe2.toLast();
        }
    }

    public void remove() {
        if (this.hasAccess() && this.kenntAktuelles != this.hatBug) {
            this.verketteKnoten(this.kenntAktuelles.vorgaenger(), this.kenntAktuelles.nachfolger());
            this.kenntAktuelles = this.kenntAktuelles.nachfolger();
            --this.zLaenge;
        }
    }

    public int length() {
        return this.zLaenge;
    }

    private void verketteKnoten(Knoten pLinksknoten, Knoten pRechtsknoten) {
        pLinksknoten.setzeNachfolger(pRechtsknoten);
        pRechtsknoten.setzeVorgaenger(pLinksknoten);
    }

    public class Knoten
    implements Serializable {
        static final long serialVersionUID = 10133L;
        private ContentType kenntInhalt;
        private Knoten kenntVorgaenger;
        private Knoten kenntNachfolger;

        public Knoten(ContentType pInhalt, Knoten pVorgaenger, Knoten pNachfolger) {
            this.kenntInhalt = pInhalt;
            this.kenntVorgaenger = pVorgaenger;
            this.kenntNachfolger = pNachfolger;
        }

        public void setzeInhalt(ContentType pInhalt) {
            this.kenntInhalt = pInhalt;
        }

        public ContentType inhalt() {
            return this.kenntInhalt;
        }

        public void setzeNachfolger(Knoten pNachfolger) {
            this.kenntNachfolger = pNachfolger;
        }

        public Knoten nachfolger() {
            return this.kenntNachfolger;
        }

        public void setzeVorgaenger(Knoten pVorgaenger) {
            this.kenntVorgaenger = pVorgaenger;
        }

        public Knoten vorgaenger() {
            return this.kenntVorgaenger;
        }
    }
}

