/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.utility.javafx.JavaFXUtil;
import bluej.views.FormattedPrintWriter;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX, ignoreParent=true)
public class FXFormattedPrintWriter
extends FormattedPrintWriter {
    private final TextFlow flow = new TextFlow();
    private boolean bold = false;
    private boolean italic = false;

    public FXFormattedPrintWriter() {
        super(System.out);
        JavaFXUtil.addStyleClass((Styleable)this.flow, "formatted-print-flow");
    }

    @Override
    public void setBold(boolean bold) {
        this.bold = bold;
    }

    @Override
    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    @Override
    protected void indentLine() {
        this.flow.getChildren().add((Object)new Text("    "));
    }

    @Override
    public void println(String line) {
        Text t = new Text((this.flow.getChildren().isEmpty() ? "" : "\n") + line);
        JavaFXUtil.addStyleClass((Styleable)t, "formatted-print-line");
        JavaFXUtil.setPseudoclass("bj-bold", this.bold, new Node[]{t});
        JavaFXUtil.setPseudoclass("bj-italic", this.italic, new Node[]{t});
        this.flow.getChildren().add((Object)t);
    }

    public Node getNode() {
        return this.flow;
    }
}

