/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.BlueJFileReader;
import bluej.utility.Debug;
import bluej.utility.Utility;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.Modality;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class DialogManager {
    private static final String DLG_FILE_NAME = "dialogues";
    private static final String GREENFOOT_DLG_FILE_NAME = "greenfoot/dialogues";

    public static void showMessageFX(Window parent, String msgID, String ... subs) {
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            for (String sub : subs) {
                message = message.replace("$", sub);
            }
            Alert alert = new Alert(Alert.AlertType.INFORMATION, "", new ButtonType[]{ButtonType.OK});
            alert.setHeaderText(message);
            alert.setTitle(Config.getApplicationName() + ":  " + Config.getString("dialogmgr.message"));
            alert.initOwner(parent);
            alert.initModality(Modality.WINDOW_MODAL);
            alert.showAndWait();
        }
    }

    public static void showMessageWithTextFX(Window parent, String msgID, String text) {
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION, text, new ButtonType[]{ButtonType.OK});
            alert.setHeaderText(message);
            alert.setTitle(Config.getApplicationName() + ":  " + Config.getString("dialogmgr.message"));
            alert.initOwner(parent);
            alert.initModality(Modality.WINDOW_MODAL);
            alert.showAndWait();
        }
    }

    public static void showMessageWithPrefixTextFX(Window parent, String msgID, String text, String innerText) {
        String message = DialogManager.getMessage(msgID, new String[0]);
        String messageDialog = Utility.mergeStrings(message, innerText);
        if (message != null) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION, "", new ButtonType[]{ButtonType.OK});
            alert.setHeaderText("");
            alert.setTitle(Config.getApplicationName() + ":  " + Config.getString("dialogmgr.message"));
            alert.initOwner(parent);
            alert.initModality(Modality.WINDOW_MODAL);
            alert.setContentText(messageDialog);
            alert.showAndWait();
        }
    }

    public static void showTextWithCopyButtonFX(Window parent, String text, String title) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION, text, new ButtonType[]{ButtonType.OK, ButtonType.APPLY});
        ((Button)alert.getDialogPane().lookupButton(ButtonType.APPLY)).setText(Config.getString("editor.copy-to-clipboardLabel"));
        alert.setTitle(title);
        alert.initOwner(parent);
        alert.setHeaderText("");
        alert.initModality(Modality.WINDOW_MODAL);
        if (alert.showAndWait().orElse(ButtonType.OK) == ButtonType.APPLY) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
        }
    }

    public static void showTextFX(Window parent, String text) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION, text, new ButtonType[]{ButtonType.OK});
        alert.initOwner(parent);
        alert.initModality(Modality.WINDOW_MODAL);
        alert.setHeaderText("");
        alert.showAndWait();
    }

    public static int showInfoTextFX(Window parent, String title, String message, boolean cancelButton) {
        ButtonType CONTINUE = new ButtonType(BlueJTheme.getContinueLabel(), ButtonBar.ButtonData.OK_DONE);
        Dialog dialog = new Dialog();
        DialogPane dialogPane = new DialogPane(){

            protected Node createButtonBar() {
                ButtonBar buttonBar = (ButtonBar)super.createButtonBar();
                buttonBar.setButtonOrder("");
                return buttonBar;
            }
        };
        dialog.setDialogPane(dialogPane);
        dialog.setTitle(title);
        if (cancelButton) {
            dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, CONTINUE});
        } else {
            dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{CONTINUE});
        }
        dialogPane.setContentText(message);
        Region spacer = new Region();
        ButtonBar.setButtonData((Node)spacer, (ButtonBar.ButtonData)ButtonBar.ButtonData.BIG_GAP);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        dialogPane.applyCss();
        HBox hbox = (HBox)dialogPane.lookup(".container");
        hbox.getChildren().add((Object)spacer);
        return dialog.showAndWait().map(arg_0 -> dialogPane.getButtonTypes().indexOf(arg_0)).orElse(dialogPane.getButtonTypes().size() - 1);
    }

    public static void showErrorFX(Window parent, String msgID) {
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            DialogManager.showErrorTextFX(parent, message);
        }
    }

    public static void showErrorTextFX(Window parent, String message) {
        Alert alert = new Alert(Alert.AlertType.ERROR, message, new ButtonType[]{ButtonType.OK});
        alert.setTitle(Config.getApplicationName() + ":  " + Config.getString("dialogmgr.error"));
        alert.initOwner(parent);
        Label label = new Label(message);
        alert.getDialogPane().setContent((Node)label);
        alert.initModality(Modality.WINDOW_MODAL);
        alert.setHeaderText("");
        alert.showAndWait();
    }

    public static void showErrorWithTextFX(Window parent, String msgID, String text) {
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            DialogManager.showErrorTextFX(parent, message + "\n" + text);
        }
    }

    public static int askQuestionFX(Window parent, String msgID) {
        MessageAndButtons messageAndButtons = new MessageAndButtons(DialogManager.getMessage(msgID, new String[0]));
        if (messageAndButtons.getMessage() != null) {
            ArrayList<ButtonType> buttons = new ArrayList<ButtonType>();
            for (int i = 0; i < messageAndButtons.getOptions().size(); ++i) {
                buttons.add(new ButtonType(messageAndButtons.getOptions().get(i), i == messageAndButtons.getOptions().size() - 1 ? ButtonBar.ButtonData.NO : ButtonBar.ButtonData.YES));
            }
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, messageAndButtons.getMessage(), buttons.toArray(new ButtonType[0]));
            alert.setHeaderText("");
            alert.initOwner(parent);
            alert.initModality(parent == null ? Modality.APPLICATION_MODAL : Modality.WINDOW_MODAL);
            alert.setTitle(Config.getApplicationName() + ":  " + Config.getString("dialogmgr.question"));
            return alert.showAndWait().map(buttons::indexOf).orElse(buttons.size() - 1);
        }
        return 0;
    }

    public static int askQuestionFX(Window parent, String msgID, String[] subs) {
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            int button3Index = message.lastIndexOf("\n");
            int button2Index = message.lastIndexOf("\n", button3Index - 1);
            int button1Index = message.lastIndexOf("\n", button2Index - 1);
            String button3 = message.substring(button3Index + 1);
            String button2 = message.substring(button2Index + 1, button3Index);
            String button1 = message.substring(button1Index + 1, button2Index);
            message = message.substring(0, button1Index);
            message = Utility.mergeStrings(message, subs);
            ArrayList<ButtonType> buttons = new ArrayList<ButtonType>();
            boolean hasThirdButton = !"null".equals(button3);
            buttons.add(new ButtonType(button1));
            buttons.add(new ButtonType(button2));
            if (hasThirdButton) {
                buttons.add(new ButtonType(button3));
            }
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, message, buttons.toArray(new ButtonType[0]));
            alert.initOwner(parent);
            alert.initModality(Modality.WINDOW_MODAL);
            alert.setHeaderText("");
            alert.setTitle(Config.getApplicationName() + ":  " + Config.getString("dialogmgr.question"));
            return alert.showAndWait().map(buttons::indexOf).orElse(buttons.size() - 1);
        }
        return 0;
    }

    public static int askQuestionFX(Window parent, String msgID, String infoText) {
        Object message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            int button3Index = ((String)message).lastIndexOf("\n");
            int button2Index = ((String)message).lastIndexOf("\n", button3Index - 1);
            int button1Index = ((String)message).lastIndexOf("\n", button2Index - 1);
            String button3 = ((String)message).substring(button3Index + 1);
            String button2 = ((String)message).substring(button2Index + 1, button3Index);
            String button1 = ((String)message).substring(button1Index + 1, button2Index);
            message = ((String)message).substring(0, button1Index);
            message = infoText + (String)message;
            ArrayList<ButtonType> buttons = new ArrayList<ButtonType>();
            boolean hasThirdButton = !"null".equals(button3);
            buttons.add(new ButtonType(button1, ButtonBar.ButtonData.YES));
            buttons.add(new ButtonType(button2, hasThirdButton ? ButtonBar.ButtonData.NO : ButtonBar.ButtonData.CANCEL_CLOSE));
            if (hasThirdButton) {
                buttons.add(new ButtonType(button3, ButtonBar.ButtonData.CANCEL_CLOSE));
            }
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, (String)message, buttons.toArray(new ButtonType[0]));
            alert.initOwner(parent);
            alert.initModality(Modality.WINDOW_MODAL);
            alert.setHeaderText("");
            alert.setTitle(Config.getApplicationName() + ":  " + Config.getString("dialogmgr.question"));
            return alert.showAndWait().map(buttons::indexOf).orElse(buttons.size() - 1);
        }
        return 0;
    }

    public static String askStringFX(Window parent, String msgID) {
        String response = "";
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            int defaultTextIndex = message.lastIndexOf("\n");
            int titleIndex = message.lastIndexOf("\n", defaultTextIndex - 1);
            String defaultText = message.substring(defaultTextIndex + 1);
            String title = message.substring(titleIndex + 1, defaultTextIndex);
            message = message.substring(0, titleIndex);
            if ("null".equals(defaultText)) {
                defaultText = null;
            }
            TextInputDialog dialog = new TextInputDialog(defaultText);
            dialog.initModality(Modality.WINDOW_MODAL);
            dialog.initOwner(parent);
            dialog.setTitle(title);
            dialog.setHeaderText(message);
            return dialog.showAndWait().orElse(null);
        }
        return response;
    }

    public static String askStringFX(Window parent, String msgID, String defaultText) {
        String response = "";
        String message = DialogManager.getMessage(msgID, new String[0]);
        if (message != null) {
            int defaultTextIndex = message.lastIndexOf("\n");
            int titleIndex = message.lastIndexOf("\n", defaultTextIndex - 1);
            String title = message.substring(titleIndex + 1, defaultTextIndex);
            message = message.substring(0, titleIndex);
            TextInputDialog dialog = new TextInputDialog(defaultText);
            dialog.initModality(Modality.WINDOW_MODAL);
            dialog.initOwner(parent);
            dialog.setTitle(title);
            dialog.setHeaderText(message);
            return dialog.showAndWait().orElse(null);
        }
        return response;
    }

    @OnThread(value=Tag.Any)
    public static String getMessage(String msgID, String ... subs) {
        File filename;
        Object message = null;
        if (Config.isGreenfoot() && (message = BlueJFileReader.readHelpText(filename = Config.getLanguageFile(GREENFOOT_DLG_FILE_NAME), msgID, true)) == null) {
            filename = Config.getDefaultLanguageFile(GREENFOOT_DLG_FILE_NAME);
            message = BlueJFileReader.readHelpText(filename, msgID, true);
        }
        if (message == null) {
            filename = Config.getLanguageFile(DLG_FILE_NAME);
            message = BlueJFileReader.readHelpText(filename, msgID, true);
        }
        if (message == null && !Config.language.equals("english")) {
            filename = Config.getDefaultLanguageFile(DLG_FILE_NAME);
            message = BlueJFileReader.readHelpText(filename, msgID, true);
        }
        if (message == null) {
            message = "BlueJ configuration problem:\ntext not found for message ID\n" + msgID;
            Debug.message((String)message);
        } else {
            message = ((String)message).replace("\n:\n", "\n\n");
            message = ((String)message).replace("\r\n:\r\n", "\r\n\r\n");
            for (String sub : subs) {
                message = ((String)message).replace("$", sub);
            }
        }
        return message;
    }

    public static void centreDialog(Dialog<?> dialog) {
        dialog.setOnShown(event -> DialogManager.centreWindow(dialog, dialog.getOwner()));
    }

    private static void centreWindow(Dialog<?> dialog, Window owner) {
        if (owner != null) {
            dialog.setX(owner.getX() + owner.getWidth() / 2.0 - dialog.getWidth() / 2.0);
            dialog.setY(owner.getY() + owner.getHeight() / 2.0 - dialog.getHeight() / 2.0);
        }
    }

    private static class MessageAndButtons {
        private final String message;
        private final List<String> options;

        public MessageAndButtons(String message) {
            if (message == null) {
                this.message = null;
                this.options = null;
                return;
            }
            int button3Index = message.lastIndexOf("\n");
            int button2Index = message.lastIndexOf("\n", button3Index - 1);
            int button1Index = message.lastIndexOf("\n", button2Index - 1);
            String button3 = message.substring(button3Index + 1);
            String button2 = message.substring(button2Index + 1, button3Index);
            String button1 = message.substring(button1Index + 1, button2Index);
            this.message = message.substring(0, button1Index);
            this.options = "null".equals(button3) ? Arrays.asList(button1, button2) : Arrays.asList(button1, button2, button3);
        }

        public String getMessage() {
            return this.message;
        }

        public List<String> getOptions() {
            return this.options;
        }
    }
}

