/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.editor.stride.CodeOverlayPane;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.links.PossibleLink;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.FrameHelper;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.StructuredSlot;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SuggestedFollowUpDisplay;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.SlotValueListener;
import bluej.stride.slots.TextSlot;
import bluej.utility.Utility;
import bluej.utility.javafx.FXSupplier;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.collections.FXCollections;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import threadchecker.OnThread;
import threadchecker.Tag;

public class VariableNameDefTextSlot
extends TextSlot<NameDefSlotFragment> {
    private FXSupplier<Boolean> shouldRename;
    private Canvas allUsesCanvas;
    private Button hideAllUsesButton;
    private SlotValueListener spaceCharactersListener = (slot, oldValue, newValue, parent) -> newValue.chars().noneMatch(Character::isSpaceChar);

    public <T extends Frame> VariableNameDefTextSlot(InteractionManager editor, T frameParent, FrameContentRow row, String stylePrefix) {
        super(editor, frameParent, (CodeFrame)((Object)frameParent), row, null, stylePrefix, Collections.emptyList());
        this.shouldRename = () -> true;
        this.addValueListener(this.spaceCharactersListener);
    }

    public <T extends Frame> VariableNameDefTextSlot(InteractionManager editor, T frameParent, FrameContentRow row, FXSupplier<Boolean> shouldRename, String stylePrefix) {
        super(editor, frameParent, (CodeFrame)((Object)frameParent), row, null, stylePrefix, Collections.emptyList());
        this.shouldRename = shouldRename;
        this.addValueListener(this.spaceCharactersListener);
    }

    public VariableNameDefTextSlot(InteractionManager editor, Frame frameParent, CodeFrame<? extends CodeElement> codeFrameParent, FrameContentRow row, String stylePrefix) {
        super(editor, frameParent, codeFrameParent, row, null, stylePrefix, Collections.emptyList());
        this.shouldRename = () -> true;
        this.addValueListener(this.spaceCharactersListener);
    }

    @Override
    public NameDefSlotFragment createFragment(String content) {
        return new NameDefSlotFragment(content, this);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void valueChangedLostFocus(String oldVal, String newVal) {
        if (!(oldVal.equals(newVal) || oldVal.isEmpty() || newVal.isEmpty() || this.shouldRename.get().booleanValue())) {
            VariableRefFinder renamer = this.findVarReferences(oldVal);
            if (!renamer.refs.isEmpty()) {
                SuggestedFollowUpDisplay disp = new SuggestedFollowUpDisplay(this.editor, "Do you want to rename all uses of old variable \"" + oldVal + "\" to use \"" + newVal + "\" instead?", () -> renamer.refs.forEach(r -> r.rename.accept(newVal)));
                disp.showBefore((Node)this.getNode());
            }
        }
    }

    private VariableRefFinder findVarReferences(String name) {
        VariableRefFinder renamer = new VariableRefFinder(name);
        FrameHelper.processVarScopesAfter(this.frameParent.getParentCanvas(), this.frameParent, renamer);
        return renamer;
    }

    @Override
    protected Map<EditableSlot.TopLevelMenu, EditableSlot.MenuItems> getExtraContextMenuItems() {
        return Collections.singletonMap(EditableSlot.TopLevelMenu.VIEW, new EditableSlot.MenuItems(FXCollections.observableArrayList()){

            @Override
            public void onShowing() {
                if (VariableNameDefTextSlot.this.allUsesCanvas != null) {
                    this.items.setAll((Object[])new EditableSlot.SortedMenuItem[]{EditableSlot.MenuItemOrder.SHOW_HIDE_USES.item(JavaFXUtil.makeMenuItem("Hide uses of \"" + VariableNameDefTextSlot.this.getText() + "\"", () -> VariableNameDefTextSlot.this.hideUsesOverlay(), null))});
                } else {
                    VariableRefFinder refFinder = VariableNameDefTextSlot.this.findVarReferences(VariableNameDefTextSlot.this.getText());
                    if (!refFinder.refs.isEmpty()) {
                        this.items.setAll((Object[])new EditableSlot.SortedMenuItem[]{EditableSlot.MenuItemOrder.SHOW_HIDE_USES.item(JavaFXUtil.makeMenuItem("See uses of \"" + VariableNameDefTextSlot.this.getText() + "\"", () -> VariableNameDefTextSlot.this.showUsesOverlay(refFinder.refs), null))});
                    } else {
                        this.items.clear();
                    }
                }
            }
        });
    }

    @OnThread(value=Tag.FXPlatform)
    private void showUsesOverlay(List<StructuredSlot.PlainVarReference> refs) {
        this.hideUsesOverlay();
        CodeOverlayPane overlay = this.editor.getCodeOverlayPane();
        this.allUsesCanvas = overlay.addFullSizeCanvas();
        GraphicsContext g = this.allUsesCanvas.getGraphicsContext2D();
        g.setStroke((Paint)Color.BLUE);
        g.setLineWidth(2.0);
        double LEFT = 10.0;
        List<Bounds> boundsList = Utility.mapList(refs, ref -> ref.refNode.localToScene(ref.refNode.getBoundsInLocal()));
        Bounds ourSceneBounds = this.getNode().localToScene(this.getNode().getBoundsInLocal());
        boundsList.add(ourSceneBounds);
        boundsList.sort((a, b) -> Double.compare(b.getMinX(), a.getMinX()));
        List<Double> yCoords = Utility.mapList(boundsList, sceneBounds -> {
            double y = overlay.sceneYToCodeOverlayY(sceneBounds.getMinY());
            g.clearRect(sceneBounds.getMinX(), y, sceneBounds.getWidth(), sceneBounds.getHeight());
            g.strokeRect(sceneBounds.getMinX(), y, sceneBounds.getWidth(), sceneBounds.getHeight());
            double midY = y + sceneBounds.getHeight() / 2.0;
            g.strokeLine(10.0, midY, sceneBounds.getMinX(), midY);
            return midY;
        });
        g.strokeLine(10.0, ((Double)yCoords.stream().min(Double::compare).get()).doubleValue(), 10.0, ((Double)yCoords.stream().max(Double::compare).get()).doubleValue());
        Canvas hide = new Canvas(10.0, 10.0);
        GraphicsContext g2 = hide.getGraphicsContext2D();
        g2.setStroke((Paint)Color.RED);
        g2.strokeLine(1.0, 1.0, hide.getWidth() - 2.0, hide.getHeight() - 2.0);
        g2.strokeLine(hide.getWidth() - 2.0, 1.0, 1.0, hide.getHeight() - 2.0);
        this.hideAllUsesButton = new Button("", (Node)hide);
        JavaFXUtil.addStyleClass((Styleable)this.hideAllUsesButton, "hide-all-uses-button");
        this.hideAllUsesButton.setOnAction(e -> this.hideUsesOverlay());
        overlay.addOverlay((Node)this.hideAllUsesButton, (Node)this.getNode(), (DoubleExpression)new ReadOnlyDoubleWrapper(-ourSceneBounds.getMinX() + 10.0 - hide.getWidth() / 2.0), null);
    }

    @OnThread(value=Tag.FXPlatform)
    private void hideUsesOverlay() {
        if (this.allUsesCanvas != null) {
            CodeOverlayPane overlayPane = this.editor.getCodeOverlayPane();
            overlayPane.removeOverlay((Node)this.allUsesCanvas);
            overlayPane.removeOverlay((Node)this.hideAllUsesButton);
            this.allUsesCanvas = null;
            this.hideAllUsesButton = null;
        }
    }

    @Override
    public List<? extends PossibleLink> findLinks() {
        return Collections.emptyList();
    }

    private class VariableRefFinder
    implements BiConsumer<Map<String, List<Frame>>, Frame> {
        private final String name;
        private final ArrayList<StructuredSlot.PlainVarReference> refs = new ArrayList();

        VariableRefFinder(String name) {
            this.name = name;
        }

        @Override
        @OnThread(value=Tag.FX, ignoreParent=true)
        public void accept(Map<String, List<Frame>> scopes, Frame f) {
            for (ExpressionSlot e : Utility.iterableStream(f.getEditableSlotsDirect().map(EditableSlot::asExpressionSlot).filter(x -> x != null))) {
                List<Frame> oldScope = scopes.get(this.name);
                if (oldScope != null && oldScope.size() != 0) continue;
                this.refs.addAll(e.findPlainVarReferences(this.name));
            }
        }
    }
}

