/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.HeaderItem;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

public class TriangleLabel
extends HBox
implements HeaderItem {
    private final SimpleBooleanProperty expanded;
    private final Canvas canvas = new Canvas(8.0, 10.0);
    private final SimpleStyleableObjectProperty<Color> cssColorProperty = new SimpleStyleableObjectProperty(COLOR_META_DATA);
    private static final CssMetaData<TriangleLabel, Color> COLOR_META_DATA = JavaFXUtil.cssColor("-bj-fill-color", TriangleLabel::cssColorProperty);
    private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList = JavaFXUtil.extendCss(HBox.getClassCssMetaData()).add(COLOR_META_DATA).build();

    public final SimpleStyleableObjectProperty<Color> cssColorProperty() {
        return this.cssColorProperty;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return cssMetaDataList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TriangleLabel.getClassCssMetaData();
    }

    public TriangleLabel(final InteractionManager editor, final FXConsumer<SharedTransition> expand, final FXConsumer<SharedTransition> shrink, SimpleBooleanProperty showing) {
        this.expanded = showing;
        JavaFXUtil.addChangeListener(this.cssColorProperty, c -> {
            GraphicsContext g = this.canvas.getGraphicsContext2D();
            g.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
            g.setFill((Paint)c);
            g.fillPolygon(new double[]{1.0, 7.0, 1.0}, new double[]{1.0, 5.0, 9.0}, 3);
        });
        JavaFXUtil.addStyleClass((Styleable)this, "triangle-label");
        this.getChildren().add((Object)this.canvas);
        this.setAlignment(Pos.BASELINE_LEFT);
        this.setFillHeight(false);
        this.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
            this.expanded.set(!this.expanded.get());
            e.consume();
        });
        JavaFXUtil.addChangeListener(this.expanded, new FXConsumer<Boolean>(){
            private SharedTransition transition = null;

            @Override
            public void accept(Boolean nowExpanded) {
                if (nowExpanded.booleanValue()) {
                    JavaFXUtil.runNowOrLater(() -> this.animate(true));
                } else {
                    JavaFXUtil.runNowOrLater(() -> {
                        this.animate(false);
                        editor.getSelection().clear();
                    });
                }
            }

            @OnThread(value=Tag.FXPlatform)
            private void animate(boolean expandAnim) {
                if (this.transition != null) {
                    this.transition.stop();
                    this.transition = null;
                }
                this.transition = new SharedTransition();
                if (expandAnim) {
                    expand.accept(this.transition);
                } else {
                    shrink.accept(this.transition);
                }
                TriangleLabel.this.canvas.rotateProperty().bind((ObservableValue)(expandAnim ? this.transition.getProgress() : this.transition.getOppositeProgress()).multiply(90.0));
                this.transition.addOnStopped(() -> ((DoubleProperty)TriangleLabel.this.canvas.rotateProperty()).unbind());
                this.transition.animateOver(Duration.millis((double)200.0));
            }
        });
    }

    public ObservableList<Node> getComponents() {
        return FXCollections.observableArrayList((Object[])new Node[]{this});
    }

    @Override
    public EditableSlot asEditable() {
        return null;
    }

    public SimpleBooleanProperty expandedProperty() {
        return this.expanded;
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
    }
}

