/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.ErrorShower;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.UnderlineContainer;
import bluej.stride.generic.Frame;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.slots.Focus;
import bluej.stride.slots.HeaderItem;
import bluej.utility.Utility;
import bluej.utility.javafx.ErrorUnderlineCanvas;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.binding.ConcatListBinding;
import bluej.utility.javafx.binding.DeepListBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import threadchecker.OnThread;
import threadchecker.Tag;

public interface EditableSlot
extends HeaderItem,
RecallableFocus,
ErrorUnderlineCanvas.UnderlineInfo,
ErrorShower,
UnderlineContainer {
    default public void requestFocus() {
        this.requestFocus(Focus.LEFT);
    }

    public void requestFocus(Focus var1);

    @OnThread(value=Tag.FXPlatform)
    public void lostFocus();

    public ObservableBooleanValue effectivelyFocusedProperty();

    public void cleanup();

    @OnThread(value=Tag.FXPlatform)
    public void saved();

    @Override
    default public EditableSlot asEditable() {
        return this;
    }

    public Frame getParentFrame();

    default public ExpressionSlot asExpressionSlot() {
        return null;
    }

    public boolean isAlmostBlank();

    public int calculateEffort();

    default public Map<TopLevelMenu, MenuItems> getMenuItems(boolean contextMenu) {
        return Collections.emptyMap();
    }

    @Override
    default public Node getRelevantNodeForError(CodeError err) {
        return this.getComponents().stream().findFirst().orElse(null);
    }

    @OnThread(value=Tag.FXPlatform)
    public void addError(CodeError var1);

    @OnThread(value=Tag.FXPlatform)
    public void removeOldErrors();

    @OnThread(value=Tag.FXPlatform)
    public void flagErrorsAsOld();

    @OnThread(value=Tag.FXPlatform)
    public Stream<CodeError> getCurrentErrors();

    public JavaFragment getSlotElement();

    public void setEditable(boolean var1);

    public boolean isEditable();

    public static class MenuItems {
        protected final ObservableList<SortedMenuItem> items;

        public MenuItems(ObservableList<SortedMenuItem> items) {
            this.items = items;
        }

        @OnThread(value=Tag.FXPlatform)
        public void onShowing() {
        }

        @OnThread(value=Tag.FXPlatform)
        public void onHidden() {
        }

        public static MenuItems concat(MenuItems ... src) {
            final List nonNull = Arrays.stream(src).filter(m -> m != null).collect(Collectors.toList());
            ObservableList joinedItems = FXCollections.observableArrayList();
            ConcatListBinding.bind(joinedItems, FXCollections.observableArrayList((Collection)nonNull.stream().map(m -> m.items).collect(Collectors.toList())));
            return new MenuItems(joinedItems){

                @Override
                public void onShowing() {
                    nonNull.forEach(MenuItems::onShowing);
                }

                @Override
                public void onHidden() {
                    nonNull.forEach(MenuItems::onHidden);
                }
            };
        }

        public Menu makeSubMenu() {
            Menu menu = new Menu();
            JavaFXUtil.bindMap(menu.getItems(), this.items, SortedMenuItem::getItem, FXRunnable::run);
            menu.onShowingProperty().set(e -> this.onShowing());
            menu.onHiddenProperty().set(e -> this.onHidden());
            return menu;
        }

        public static ContextMenu makeContextMenu(Map<TopLevelMenu, MenuItems> allItems) {
            return MenuItems.makeContextMenu(allItems.entrySet().stream().sorted((a, b) -> ((TopLevelMenu)((Object)((Object)a.getKey()))).compareTo((TopLevelMenu)((Object)((Object)b.getKey())))).map(e -> (MenuItems)e.getValue()).collect(Collectors.toList()));
        }

        private static ContextMenu makeContextMenu(List<MenuItems> allItems) {
            ContextMenu menu = new ContextMenu();
            ObservableList sorted = FXCollections.observableArrayList();
            ConcatListBinding.bind(sorted, FXCollections.observableArrayList(Utility.mapList(allItems, MenuItems::getItems)));
            JavaFXUtil.bindList(menu.getItems(), SortedMenuItem.sortAndAddDividers((ObservableList<SortedMenuItem>)sorted, Collections.emptyList()));
            menu.onShowingProperty().set(e -> allItems.forEach(MenuItems::onShowing));
            menu.onHiddenProperty().set(e -> allItems.forEach(MenuItems::onHidden));
            return menu;
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }

        public ObservableList<SortedMenuItem> getItems() {
            return this.items;
        }
    }

    public static class SortedMenuItem {
        private final MenuItem item;
        private MenuItemOrder sortOrder;
        private static final Comparator<SortedMenuItem> COMPARATOR = (a, b) -> a.sortOrder.compareTo(b.sortOrder);

        private SortedMenuItem(MenuItem item, MenuItemOrder sortOrder) {
            this.item = item;
            this.sortOrder = sortOrder;
        }

        public MenuItem getItem() {
            return this.item;
        }

        public MenuItemOrder getMenuItemOrder() {
            return this.sortOrder;
        }

        public static ObservableList<MenuItem> sortAndAddDividers(final ObservableList<SortedMenuItem> primaryItems, final List<SortedMenuItem> defaultItems) {
            ObservableList r = FXCollections.observableArrayList();
            new DeepListBinding<MenuItem>(r){

                @Override
                protected Stream<MenuItem> calculateValues() {
                    return SortedMenuItem.calculateList((ObservableList<SortedMenuItem>)primaryItems, defaultItems);
                }

                @Override
                protected Stream<ObservableList<?>> getListenTargets() {
                    return Stream.of(primaryItems);
                }
            }.startListening();
            return r;
        }

        private static Stream<MenuItem> calculateList(ObservableList<SortedMenuItem> primaryItems, List<SortedMenuItem> defaultItems) {
            ArrayList<SortedMenuItem> all = new ArrayList<SortedMenuItem>((Collection<SortedMenuItem>)primaryItems);
            for (SortedMenuItem def : defaultItems) {
                if (all.stream().anyMatch(item -> item.getMenuItemOrder() == def.getMenuItemOrder())) continue;
                all.add(def);
            }
            all.sort(COMPARATOR);
            for (int i = 0; i < all.size() - 1; ++i) {
                if (((SortedMenuItem)all.get((int)i)).getMenuItemOrder().block == ((SortedMenuItem)all.get((int)(i + 1))).getMenuItemOrder().block) continue;
                all.add(i + 1, new SortedMenuItem((MenuItem)new SeparatorMenuItem(), null));
                ++i;
            }
            return all.stream().map(SortedMenuItem::getItem);
        }
    }

    public static enum MenuItemOrder {
        CLOSE(0),
        UNDO(10),
        REDO(10),
        RECENT_VALUES(20),
        CUT(30),
        COPY(30),
        PASTE(30),
        DELETE(40),
        ENABLE_FRAME(40),
        DISABLE_FRAME(40),
        INSERT_FRAME(60),
        TRANSFORM(70),
        TOGGLE_BOOLEAN(70),
        TOGGLE_ABSTRACT(70),
        TOGGLE_EXTENDS(70),
        TOGGLE_IMPLEMENTS(70),
        OVERRIDE(70),
        GOTO_DEFINITION(80),
        GOTO_OVERRIDE(80),
        SHOW_HIDE_USES(80);

        private final int block;

        private MenuItemOrder(int block) {
            this.block = block;
        }

        public SortedMenuItem item(MenuItem fxItem) {
            return new SortedMenuItem(fxItem, this);
        }
    }

    public static enum TopLevelMenu {
        EDIT,
        VIEW;

    }
}

