/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.editor.stride.FrameCatalogue;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.links.PossibleLink;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.slots.TextOverlayPosition;
import bluej.stride.framedjava.slots.UnderlineContainer;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.CopyableHeaderItem;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.Focus;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.SuggestionList;
import bluej.utility.Utility;
import bluej.utility.javafx.ErrorUnderlineCanvas;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.TextField;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ChoiceSlot<T extends Enum<T>>
implements EditableSlot,
CopyableHeaderItem {
    private final InteractionManager editor;
    private final Frame parentFrame;
    private final FrameContentRow row;
    private final ObjectProperty<SuggestionList> dropdown = new SimpleObjectProperty(null);
    private final List<T> choices;
    private T previousSelection;
    private T selection;
    private final StackPane pane;
    private final SlotLabel curDisplay;
    private final Label futureDisplay;
    private final DummyTextField dummyField;
    private final ErrorUnderlineCanvas errorMarker;
    private Function<T, Boolean> isValid;
    private final BooleanBinding effectivelyFocusedProperty;

    public ChoiceSlot(InteractionManager editor, Frame parentFrame, FrameContentRow row, List<T> choices, Function<T, Boolean> isValid, String stylePrefix, Map<T, String> hints) {
        this.editor = editor;
        this.parentFrame = parentFrame;
        this.row = row;
        this.choices = choices;
        this.isValid = isValid;
        this.dummyField = new DummyTextField();
        this.curDisplay = new SlotLabel("", new String[0]);
        this.futureDisplay = new Label();
        this.pane = new StackPane();
        this.errorMarker = new ErrorUnderlineCanvas((Node)this.pane);
        this.pane.getChildren().addAll((Object[])new Node[]{this.futureDisplay, this.curDisplay.getNode(), this.dummyField, this.errorMarker.getNode()});
        StackPane.setAlignment((Node)this.curDisplay.getNode(), (Pos)Pos.CENTER_LEFT);
        StackPane.setAlignment((Node)this.futureDisplay, (Pos)Pos.CENTER_LEFT);
        editor.setupFocusableSlotComponent(this, (Node)this.dummyField, false, row::getExtensions, hints.entrySet().stream().map(e -> new FrameCatalogue.Hint(((Enum)e.getKey()).toString(), (String)e.getValue())).collect(Collectors.toList()));
        this.pane.getStyleClass().addAll((Object[])new String[]{"choice-slot", stylePrefix + "choice-slot"});
        JavaFXUtil.addStyleClass((Styleable)this.curDisplay, "choice-current", stylePrefix + "choice-current");
        JavaFXUtil.addStyleClass((Styleable)this.futureDisplay, "choice-future", stylePrefix + "choice-future");
        JavaFXUtil.addStyleClass((Styleable)this.dummyField, "choice-dummy", stylePrefix + "choice-dummy");
        this.pane.setOnMouseClicked(e -> {
            if (!this.dummyField.isDisabled()) {
                this.dummyField.requestFocus();
                e.consume();
            }
        });
        JavaFXUtil.addFocusListener((Node)this.dummyField, focused -> {
            if (focused.booleanValue()) {
                JavaFXUtil.runAfterCurrent(() -> {
                    if (this.dummyField.isFocused()) {
                        editor.beginRecordingState(this);
                        this.curDisplay.setText("");
                        this.previousSelection = this.selection;
                        this.selection = null;
                        this.showSuggestions(this.previousSelection);
                        JavaFXUtil.setPseudoclass("bj-transparent", false, new Node[]{this.pane});
                    }
                });
            }
        });
        DoubleBinding calcWidth = new DoubleBinding(){
            {
                super.bind(new Observable[]{ChoiceSlot.this.curDisplay.textProperty()});
                super.bind(new Observable[]{ChoiceSlot.this.futureDisplay.fontProperty()});
                super.bind(new Observable[]{ChoiceSlot.this.futureDisplay.textProperty()});
            }

            protected double computeValue() {
                return Math.max(10.0, Math.max(ChoiceSlot.this.curDisplay.measureString(ChoiceSlot.this.curDisplay.getText()), JavaFXUtil.measureString((Labeled)ChoiceSlot.this.futureDisplay, ChoiceSlot.this.futureDisplay.getText())));
            }
        };
        this.curDisplay.prefWidthProperty().bind((ObservableValue)calcWidth);
        this.futureDisplay.prefWidthProperty().bind((ObservableValue)calcWidth);
        this.dummyField.prefWidthProperty().bind((ObservableValue)calcWidth);
        this.dummyField.translateXProperty().bind((ObservableValue)new DoubleBinding(){
            {
                super.bind(new Observable[]{ChoiceSlot.this.curDisplay.textProperty()});
            }

            protected double computeValue() {
                return ChoiceSlot.this.curDisplay.measureString(ChoiceSlot.this.curDisplay.getText());
            }
        });
        this.curDisplay.minWidthProperty().set(Double.NEGATIVE_INFINITY);
        this.futureDisplay.setMinWidth(Double.NEGATIVE_INFINITY);
        this.dummyField.setMinWidth(Double.NEGATIVE_INFINITY);
        this.pane.heightProperty().addListener((a, b, c) -> JavaFXUtil.runNowOrLater(() -> this.refreshError()));
        this.pane.widthProperty().addListener((a, b, c) -> JavaFXUtil.runNowOrLater(() -> this.refreshError()));
        this.effectivelyFocusedProperty = this.dummyField.focusedProperty().or((ObservableBooleanValue)this.dropdown.isNotNull());
        this.setValue(null);
    }

    @OnThread(value=Tag.FXPlatform)
    public void showSuggestions(T curHighlight) {
        this.dropdown.set((Object)new SuggestionList(this.editor, Utility.mapList(this.choices, t -> new SuggestionList.SuggestionDetails(t.toString())), null, SuggestionList.SuggestionShown.RARE, i -> {
            i = i < 0 ? 0 : i;
            this.futureDisplay.setText(((Enum)this.choices.get((int)i)).toString());
        }, new ChoiceSuggestionListener()));
        ((SuggestionList)this.dropdown.get()).show((Node)this.pane, (Bounds)new BoundingBox(0.0, 0.0, 0.0, this.pane.heightProperty().get()));
        ((SuggestionList)this.dropdown.get()).calculateEligible(this.curDisplay.getText(), false, false);
        ((SuggestionList)this.dropdown.get()).setHighlighted(curHighlight == null ? -1 : this.choices.indexOf(curHighlight), true);
        ((SuggestionList)this.dropdown.get()).updateVisual(this.curDisplay.getText());
    }

    public T getValue(T defaultVal) {
        if (this.selection == null) {
            return defaultVal;
        }
        return this.selection;
    }

    public void setValue(T value) {
        this.selection = value;
        this.curDisplay.setText(value == null ? "" : ((Enum)value).toString());
        this.futureDisplay.setText(this.curDisplay.getText());
        JavaFXUtil.runNowOrLater(() -> this.refreshError());
        JavaFXUtil.setPseudoclass("bj-transparent", this.isValid.apply(this.selection) != false && !this.dummyField.isFocused(), new Node[]{this.pane});
        this.editor.modifiedFrame(this.parentFrame, false);
    }

    @OnThread(value=Tag.FXPlatform)
    private void refreshError() {
        if (!this.isValid.apply(this.selection).booleanValue()) {
            if (this.errorMarker.getHeight() > 0.0) {
                this.errorMarker.addErrorMarker(this, 0, Integer.MAX_VALUE, false, b -> {}, (ObservableBooleanValue)new ReadOnlyBooleanWrapper(true));
            }
        } else {
            this.errorMarker.clearErrorMarkers(this);
        }
    }

    public ObservableList<Node> getComponents() {
        return FXCollections.observableArrayList((Object[])new Node[]{this.pane});
    }

    @Override
    public void requestFocus(Focus on) {
        this.dummyField.requestFocus();
    }

    @Override
    public void requestFocus() {
        this.requestFocus(null);
    }

    @Override
    public boolean isFocused() {
        return this.dummyField.isFocused();
    }

    @Override
    public void flagErrorsAsOld() {
    }

    @Override
    public void removeOldErrors() {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public int getFocusInfo() {
        return -1;
    }

    @Override
    public Node recallFocus(int info) {
        this.requestFocus();
        return this.dummyField;
    }

    @Override
    public Stream<CodeError> getCurrentErrors() {
        return Stream.empty();
    }

    public Node getPrimaryFocus() {
        return this.dummyField;
    }

    @Override
    public TextOverlayPosition getOverlayLocation(int caretPos, boolean javaPos) {
        return TextOverlayPosition.nodeToOverlay((Node)this.pane, 0.0, 0.0, ((Font)this.curDisplay.fontProperty().get()).getSize(), this.pane.getHeight());
    }

    @Override
    public void addError(CodeError err) {
    }

    @Override
    public void focusAndPositionAtError(CodeError err) {
    }

    @Override
    public void addUnderline(UnderlineContainer.Underline u) {
    }

    @Override
    public void removeAllUnderlines() {
    }

    @Override
    public void saved() {
    }

    @Override
    public List<? extends PossibleLink> findLinks() {
        return Collections.emptyList();
    }

    @Override
    public void lostFocus() {
    }

    @Override
    public Frame getParentFrame() {
        return this.parentFrame;
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        this.dummyField.setDisable(newView != Frame.View.NORMAL);
        this.curDisplay.setView(oldView, newView, animate);
        if (newView != Frame.View.JAVA_PREVIEW) {
            animate.addOnStopped(() -> {
                this.curDisplay.minWidthProperty().set(Double.NEGATIVE_INFINITY);
                this.futureDisplay.setOpacity(1.0);
            });
        } else {
            this.futureDisplay.setOpacity(0.0);
        }
    }

    @Override
    public JavaFragment getSlotElement() {
        return null;
    }

    @Override
    public boolean isAlmostBlank() {
        return true;
    }

    @Override
    public boolean isEditable() {
        return !this.dummyField.disableProperty().get();
    }

    @Override
    public void setEditable(boolean editable) {
        this.dummyField.setDisable(!editable);
        this.pane.setDisable(!editable);
    }

    @Override
    public Stream<? extends Node> makeDisplayClone(InteractionManager editor) {
        Stream<Label> labelClone = this.curDisplay.makeDisplayClone(editor);
        StackPane clone = new StackPane();
        clone.getChildren().addAll((Collection)labelClone.peek(l -> {
            l.setAlignment(Pos.CENTER_LEFT);
            l.prefWidthProperty().bind((ObservableValue)this.curDisplay.prefWidthProperty());
        }).collect(Collectors.toList()));
        JavaFXUtil.bindList(clone.getStyleClass(), this.pane.getStyleClass());
        JavaFXUtil.bindPseudoclasses((Node)clone, (ObservableSet<PseudoClass>)this.pane.getPseudoClassStates());
        clone.minHeightProperty().bind((ObservableValue)this.pane.heightProperty());
        clone.minWidthProperty().bind((ObservableValue)this.pane.widthProperty());
        clone.prefHeightProperty().bind((ObservableValue)this.pane.heightProperty());
        return Stream.of(clone);
    }

    @Override
    public ObservableBooleanValue effectivelyFocusedProperty() {
        return this.effectivelyFocusedProperty;
    }

    @Override
    public int calculateEffort() {
        return 1;
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    private class DummyTextField
    extends TextField {
        @OnThread(value=Tag.FX)
        public DummyTextField() {
        }

        public void appendText(String s) {
            this.insertText(0, s);
        }

        public void clear() {
            this.update("");
        }

        public void copy() {
            ClipboardContent c = new ClipboardContent();
            c.putString(ChoiceSlot.this.futureDisplay.getText());
            Clipboard.getSystemClipboard().setContent((Map)c);
        }

        public void cut() {
            this.copy();
            ((SuggestionList)ChoiceSlot.this.dropdown.get()).setHighlighted(-1, false);
            this.update("");
        }

        public boolean deletePreviousChar() {
            if (ChoiceSlot.this.curDisplay.getText().length() > 0) {
                this.update(ChoiceSlot.this.curDisplay.getText().substring(0, Math.max(0, ChoiceSlot.this.curDisplay.getText().length() - 1)));
                return true;
            }
            return false;
        }

        public void insertText(int pos, String s) {
            if (pos != 0) {
                throw new IllegalStateException();
            }
            this.update(ChoiceSlot.this.curDisplay.getText() + s);
        }

        public void paste() {
            String clip = Clipboard.getSystemClipboard().getString();
            if (clip != null && !clip.equals("")) {
                this.update(clip);
            }
        }

        public void replaceSelection(String s) {
            this.appendText(s);
        }

        public void replaceText(IndexRange arg0, String s) {
            this.update(ChoiceSlot.this.curDisplay.getText() + s);
        }

        public void replaceText(int arg0, int arg1, String s) {
            this.update(ChoiceSlot.this.curDisplay.getText() + s);
        }

        private void update(String newVal) {
            ((SuggestionList)ChoiceSlot.this.dropdown.get()).calculateEligible(newVal, false, false);
            if (((SuggestionList)ChoiceSlot.this.dropdown.get()).eligibleCount() == 0) {
                ((SuggestionList)ChoiceSlot.this.dropdown.get()).calculateEligible(ChoiceSlot.this.curDisplay.getText(), false, false);
            } else {
                ChoiceSlot.this.curDisplay.setText(newVal);
                ((SuggestionList)ChoiceSlot.this.dropdown.get()).updateVisual(newVal);
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    class ChoiceSuggestionListener
    implements SuggestionList.SuggestionListListener {
        ChoiceSuggestionListener() {
        }

        @Override
        public void suggestionListChoiceClicked(SuggestionList suggestionList, int highlighted) {
            if (highlighted != -1) {
                ChoiceSlot.this.setValue((Enum)ChoiceSlot.this.choices.get(highlighted));
            }
            ChoiceSlot.this.editor.endRecordingState(ChoiceSlot.this);
            ChoiceSlot.this.row.focusRight(ChoiceSlot.this);
        }

        @Override
        public SuggestionList.SuggestionListListener.Response suggestionListKeyTyped(SuggestionList suggestionList, KeyEvent event, int highlighted) {
            if (event.getCharacter().equals(" ")) {
                Optional completion = this.getCompletion(highlighted);
                if (completion.isPresent()) {
                    ChoiceSlot.this.setValue((Enum)completion.get());
                    ChoiceSlot.this.row.focusRight(ChoiceSlot.this);
                    return SuggestionList.SuggestionListListener.Response.DISMISS;
                }
                return SuggestionList.SuggestionListListener.Response.CONTINUE;
            }
            ChoiceSlot.this.dummyField.fireEvent((Event)event.copyFor(null, (EventTarget)ChoiceSlot.this.dummyField));
            return SuggestionList.SuggestionListListener.Response.CONTINUE;
        }

        @Override
        public SuggestionList.SuggestionListListener.Response suggestionListKeyPressed(SuggestionList suggestionList, KeyEvent event, int highlighted) {
            switch (event.getCode()) {
                case ENTER: {
                    ChoiceSlot.this.row.focusRight(ChoiceSlot.this);
                    this.suggestionListFocusStolen(highlighted);
                    return SuggestionList.SuggestionListListener.Response.DISMISS;
                }
                case ESCAPE: {
                    ChoiceSlot.this.setValue(ChoiceSlot.this.previousSelection);
                    ChoiceSlot.this.row.focusRight(ChoiceSlot.this);
                    return SuggestionList.SuggestionListListener.Response.DISMISS;
                }
                case LEFT: {
                    ChoiceSlot.this.row.focusLeft(ChoiceSlot.this);
                    this.suggestionListFocusStolen(highlighted);
                    return SuggestionList.SuggestionListListener.Response.DISMISS;
                }
                case RIGHT: {
                    ChoiceSlot.this.row.focusRight(ChoiceSlot.this);
                    this.suggestionListFocusStolen(highlighted);
                    return SuggestionList.SuggestionListListener.Response.DISMISS;
                }
                case TAB: {
                    if (event.isShiftDown()) {
                        ChoiceSlot.this.row.focusLeft(ChoiceSlot.this);
                    } else {
                        ChoiceSlot.this.row.focusRight(ChoiceSlot.this);
                    }
                    this.suggestionListFocusStolen(highlighted);
                    return SuggestionList.SuggestionListListener.Response.DISMISS;
                }
            }
            return SuggestionList.SuggestionListListener.Response.CONTINUE;
        }

        @Override
        public void hidden() {
            JavaFXUtil.setPseudoclass("bj-transparent", true, new Node[]{ChoiceSlot.this.pane});
            ChoiceSlot.this.editor.endRecordingState(ChoiceSlot.this);
            ChoiceSlot.this.dropdown.set(null);
        }

        private Optional<T> getCompletion(int highlighted) {
            if (highlighted != -1) {
                return Optional.of((Enum)ChoiceSlot.this.choices.get(highlighted));
            }
            if (((SuggestionList)ChoiceSlot.this.dropdown.get()).eligibleCount() == 1 && ChoiceSlot.this.curDisplay.getText().length() > 0) {
                return Optional.of((Enum)ChoiceSlot.this.choices.get(((SuggestionList)ChoiceSlot.this.dropdown.get()).getFirstEligible()));
            }
            return Optional.empty();
        }

        @Override
        public void suggestionListFocusStolen(int highlighted) {
            Optional completion = this.getCompletion(highlighted);
            if (completion.isPresent()) {
                ChoiceSlot.this.setValue((Enum)completion.get());
            } else {
                ChoiceSlot.this.setValue(ChoiceSlot.this.previousSelection);
            }
        }
    }
}

