/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.operations;

import bluej.Config;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.AbstractOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.EditableSlot;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.CustomMenuItem;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ToggleBooleanProperty
extends FrameOperation {
    private String name;
    private SimpleStringProperty label;
    private final char key;

    public ToggleBooleanProperty(InteractionManager editor, String identifier, String name, char key) {
        super(editor, identifier, AbstractOperation.Combine.ALL, null);
        this.name = name;
        this.label = new SimpleStringProperty(Config.getString("frame.operation.toggle").replace("$", name));
        this.key = key;
    }

    @Override
    protected void execute(List<Frame> frames) {
        boolean targetedAllTrue = this.targetedAllTrue(frames);
        frames.forEach(f -> f.setModifier(this.name, !targetedAllTrue));
    }

    @Override
    public List<AbstractOperation.ItemLabel> getLabels() {
        return Arrays.asList(new AbstractOperation.ItemLabel((ObservableValue<String>)this.label, EditableSlot.MenuItemOrder.TOGGLE_BOOLEAN));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void onMenuShowing(CustomMenuItem item) {
        super.onMenuShowing(item);
        this.updateName();
    }

    @OnThread(value=Tag.FXPlatform)
    private void updateName() {
        this.label.set(this.targetedAllTrue(this.editor.getSelection().getSelected()) ? Config.getString("frame.operation.remove").replace("$", this.name) : Config.getString("frame.operation.make").replace("$", this.name));
    }

    private boolean targetedAllTrue(List<Frame> frames) {
        return frames.stream().allMatch(f -> f.getModifier(this.name).get());
    }

    @Override
    public boolean onlyOnContextMenu() {
        return true;
    }

    public String getLabel() {
        return this.label.get();
    }

    public char getKey() {
        return this.key;
    }
}

