/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.operations;

import bluej.Config;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.AbstractOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.EditableSlot;
import java.util.Arrays;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public class PullUpContentsOperation
extends FrameOperation {
    public PullUpContentsOperation(InteractionManager editor) {
        super(editor, "PULL_CONTENTS", AbstractOperation.Combine.ALL);
    }

    @Override
    public List<AbstractOperation.ItemLabel> getLabels() {
        return Arrays.asList(this.l(Config.getString("frame.operation.delete.outer"), EditableSlot.MenuItemOrder.DELETE));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void enablePreview() {
        this.editor.getSelection().setPullUpPreview(true);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void disablePreview() {
        this.editor.getSelection().setPullUpPreview(false);
    }

    @Override
    protected void execute(List<Frame> frames) {
        if (!frames.isEmpty()) {
            FrameCursor cursorBefore = frames.get(0).getCursorBefore();
            frames.forEach(frame -> {
                frame.pullUpContents();
                frame.getParentCanvas().removeBlock((Frame)frame);
            });
            cursorBefore.requestFocus();
        }
    }

    @Override
    public boolean onlyOnContextMenu() {
        return true;
    }
}

