/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.operations;

import bluej.Config;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.AbstractOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.EditableSlot;
import java.util.Arrays;
import java.util.List;
import javafx.scene.control.CustomMenuItem;
import threadchecker.OnThread;
import threadchecker.Tag;

public class EnableFrameOperation
extends FrameOperation {
    public EnableFrameOperation(InteractionManager editor) {
        super(editor, "ENABLE", AbstractOperation.Combine.ANY);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void enablePreview() {
        this.editor.getSelection().getSelected().forEach(frame -> frame.setFrameEnablePreview(Frame.FramePreviewEnabled.PREVIEW_ENABLED));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void disablePreview() {
        this.editor.getSelection().getSelected().forEach(frame -> frame.setFrameEnablePreview(Frame.FramePreviewEnabled.PREVIEW_NONE));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    protected void execute(List<Frame> frames) {
        frames.forEach(frame -> frame.setFrameEnabled(true));
    }

    @Override
    public List<AbstractOperation.ItemLabel> getLabels() {
        return Arrays.asList(this.l(Config.getString("frame.operation.enable"), EditableSlot.MenuItemOrder.ENABLE_FRAME));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void onMenuShowing(CustomMenuItem item) {
        boolean canAllBeEnabled = this.editor.getSelection().getSelected().stream().allMatch(f -> f.canHaveEnabledState(true));
        item.setDisable(!canAllBeEnabled);
    }

    @Override
    public boolean onlyOnContextMenu() {
        return true;
    }
}

