/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.operations;

import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.EditableSlot;
import java.util.List;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;

public abstract class AbstractOperation {
    protected final String identifier;
    protected final Combine combine;
    private boolean wideCustomItem = false;
    protected InteractionManager editor;

    public AbstractOperation(InteractionManager editor, String identifier, Combine combine) {
        this.identifier = identifier;
        this.combine = combine;
        this.editor = editor;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Combine combine() {
        return this.combine;
    }

    public abstract List<ItemLabel> getLabels();

    protected ItemLabel l(String s, EditableSlot.MenuItemOrder order) {
        return new ItemLabel((ObservableValue<String>)new ReadOnlyStringWrapper(s){

            public boolean equals(Object obj) {
                if (!(obj instanceof ObservableValue)) {
                    return false;
                }
                return this.getValue().equals(((ObservableValue)obj).getValue());
            }

            public int hashCode() {
                return this.getValue().hashCode();
            }
        }, order);
    }

    protected CustomMenuItem initializeCustomItem() {
        Label d = new Label();
        d.textProperty().bind(this.getLabels().get((int)(this.getLabels().size() - 1)).label);
        if (!this.wideCustomItem) {
            d.setPrefWidth(150.0);
        } else {
            d.setPrefWidth(300.0);
        }
        CustomMenuItem item = new CustomMenuItem((Node)d);
        item.textProperty().bind((ObservableValue)d.textProperty());
        return item;
    }

    public void setWideCustomItem(boolean wide) {
        this.wideCustomItem = wide;
    }

    protected MenuItem initializeNormalItem() {
        MenuItem item = new MenuItem();
        item.textProperty().bind(this.getLabels().get((int)(this.getLabels().size() - 1)).label);
        return item;
    }

    public static class ItemLabel {
        private ObservableValue<String> label;
        private EditableSlot.MenuItemOrder order;

        public ItemLabel(ObservableValue<String> label, EditableSlot.MenuItemOrder order) {
            this.label = label;
            this.order = order;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemLabel) {
                return ((String)this.label.getValue()).equals(((ItemLabel)obj).label.getValue());
            }
            return false;
        }

        public int hashCode() {
            return ((String)this.label.getValue()).hashCode();
        }

        public ObservableValue<String> getLabel() {
            return this.label;
        }

        public EditableSlot.MenuItemOrder getOrder() {
            return this.order;
        }
    }

    public static enum Combine {
        ANY,
        ALL,
        ONE;

    }
}

