/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.Config;
import bluej.editor.stride.FrameCatalogue;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.ast.links.PossibleTypeLink;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.ReturnFrame;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.InfixType;
import bluej.stride.framedjava.slots.StructuredSlot;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SuggestedFollowUpDisplay;
import bluej.stride.slots.CopyableHeaderItem;
import bluej.stride.slots.TypeCompletionCalculator;
import bluej.utility.Utility;
import bluej.utility.javafx.FXBiConsumer;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.FXSupplier;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.binding.StringExpression;
import javafx.scene.Node;
import threadchecker.OnThread;
import threadchecker.Tag;

public class TypeSlot
extends StructuredSlot<TypeSlotFragment, InfixType, TypeCompletionCalculator>
implements CopyableHeaderItem {
    private final InteractionManager editor;
    private boolean isReturnType = false;
    private final List<FXSupplier<Boolean>> backspaceListeners = new ArrayList<FXSupplier<Boolean>>();
    private final List<FXSupplier<Boolean>> deleteListeners = new ArrayList<FXSupplier<Boolean>>();

    public TypeSlot(InteractionManager editor, Frame parentFrame, CodeFrame<?> parentCodeFrame, FrameContentRow row, Role role, String stylePrefix) {
        super(editor, parentFrame, parentCodeFrame, row, stylePrefix, TypeSlot.calculatorForRole(editor, role), TypeSlot.hintsForRole(role));
        this.editor = editor;
        this.onTextPropertyChangeOld(this::adjustReturnFrames);
    }

    private static TypeCompletionCalculator calculatorForRole(InteractionManager editor, Role role) {
        switch (role) {
            case THROWS_CATCH: {
                return new TypeCompletionCalculator(editor, Throwable.class);
            }
            case INTERFACE: {
                return new TypeCompletionCalculator(editor, InteractionManager.Kind.INTERFACE);
            }
            case EXTENDS: {
                return new TypeCompletionCalculator(editor, InteractionManager.Kind.CLASS_NON_FINAL);
            }
        }
        return new TypeCompletionCalculator(editor);
    }

    private static List<FrameCatalogue.Hint> hintsForRole(Role role) {
        FrameCatalogue.Hint hintInt = new FrameCatalogue.Hint("int", "An integer (whole number)");
        FrameCatalogue.Hint hintDouble = new FrameCatalogue.Hint("double", "A number value");
        FrameCatalogue.Hint hintVoid = new FrameCatalogue.Hint("void", "No return");
        FrameCatalogue.Hint hintString = new FrameCatalogue.Hint("String", "Some text");
        FrameCatalogue.Hint hintActor = new FrameCatalogue.Hint("Actor", "A Greenfoot actor");
        FrameCatalogue.Hint hintList = new FrameCatalogue.Hint("List<String>", "A list of String");
        FrameCatalogue.Hint hintObj = Config.isGreenfoot() ? hintActor : hintList;
        FrameCatalogue.Hint hintIO = new FrameCatalogue.Hint("IOException", "An IO exception");
        switch (role) {
            case DECLARATION: {
                return Arrays.asList(hintInt, hintDouble, hintString, hintObj);
            }
            case RETURN: {
                return Arrays.asList(hintInt, hintDouble, hintString, hintVoid);
            }
            case EXTENDS: {
                if (Config.isGreenfoot()) {
                    return Arrays.asList(hintActor);
                }
                return Collections.emptyList();
            }
            case INTERFACE: {
                return Collections.emptyList();
            }
            case THROWS_CATCH: {
                return Arrays.asList(hintIO);
            }
        }
        return Collections.emptyList();
    }

    @Override
    protected TypeSlotFragment makeSlotFragment(String content, String javaCode) {
        return new TypeSlotFragment(content, javaCode, this);
    }

    @Override
    public ExpressionSlot asExpressionSlot() {
        return null;
    }

    public void setText(TypeSlotFragment rhs) {
        rhs.registerSlot(this);
        this.setText(rhs.getContent());
    }

    @Override
    protected InfixType newInfix(InteractionManager editor, StructuredSlot.ModificationToken token) {
        return new InfixType(editor, this, token);
    }

    public void markReturnType() {
        this.isReturnType = true;
    }

    private void adjustReturnFrames(String oldValue, String newValue) {
        List removeActions;
        if (!this.isReturnType) {
            return;
        }
        if ((oldValue.equals("void") || oldValue.equals("")) && !newValue.equals("void") && !newValue.equals("")) {
            for (Frame f2 : Utility.iterableStream(this.getParentFrame().getAllFrames())) {
                if (!(f2 instanceof ReturnFrame)) continue;
                ReturnFrame rf2 = (ReturnFrame)f2;
                rf2.showValue();
            }
        } else if (!oldValue.equals("void") && newValue.equals("void") && !(removeActions = this.getParentFrame().getAllFrames().filter(f -> f instanceof ReturnFrame).map(f -> (ReturnFrame)f).map(rf -> rf.getRemoveFilledValueAction()).filter(a -> a != null).collect(Collectors.toList())).isEmpty()) {
            JavaFXUtil.runNowOrLater(() -> {
                SuggestedFollowUpDisplay disp = new SuggestedFollowUpDisplay(this.editor, "Return type changed to void.  Would you like to remove return values from all return frames in this method?", () -> removeActions.forEach(FXRunnable::run));
                disp.showBefore((Node)this.getComponents().get(0));
            });
        }
    }

    @Override
    public void saved() {
    }

    @Override
    public boolean canCollapse() {
        return false;
    }

    @Override
    public List<PossibleTypeLink> findLinks() {
        return ((InfixType)this.topLevel).findTypeLinks();
    }

    public StringExpression javaProperty() {
        return this.textMirror;
    }

    public void onTopLevelComma(FXBiConsumer<String, String> listener) {
        this.afterModify.add(() -> ((InfixType)this.topLevel).runIfCommaDirect(listener));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean backspaceAtStart() {
        boolean transferredFocus = Utility.mapList(this.backspaceListeners, FXSupplier::get).stream().reduce(false, (a, b) -> a != false || b != false);
        if (transferredFocus) {
            return true;
        }
        return super.backspaceAtStart();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean deleteAtEnd() {
        boolean transferredFocus = Utility.mapList(this.deleteListeners, FXSupplier::get).stream().reduce(false, (a, b) -> a != false || b != false);
        if (transferredFocus) {
            return true;
        }
        return super.deleteAtEnd();
    }

    public void addBackspaceAtStartListener(FXSupplier<Boolean> listener) {
        this.backspaceListeners.add(listener);
    }

    public void addDeleteAtEndListener(FXSupplier<Boolean> listener) {
        this.deleteListeners.add(listener);
    }

    @Override
    public Stream<? extends Node> makeDisplayClone(InteractionManager editor) {
        return ((InfixType)this.topLevel).makeDisplayClone(editor);
    }

    public static enum Role {
        DECLARATION,
        RETURN,
        EXTENDS,
        INTERFACE,
        THROWS_CATCH;

    }
}

