/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.parser.AssistContent;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.Parser;
import bluej.stride.framedjava.ast.SuperThis;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.StructuredCompletionCalculator;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.SuggestionList;
import bluej.utility.JavaUtils;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformConsumer;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ExpressionCompletionCalculator
implements StructuredCompletionCalculator {
    private final InteractionManager editor;
    private List<AssistContentThreadSafe> completions = Collections.emptyList();
    private SuggestionList suggestionDisplay;

    public ExpressionCompletionCalculator(InteractionManager editor) {
        this.editor = editor;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void withCalculatedSuggestionList(JavaFragment.PosInSourceDoc pos, ExpressionSlot<?> completing, CodeElement codeEl, SuggestionList.SuggestionListListener clickListener, String targetType, boolean completingStartOfSlot, FXPlatformConsumer<SuggestionList> handler) {
        this.editor.withCompletions(pos, completing, codeEl, assists -> {
            this.completions = assists.stream().filter(a -> !Parser.isDummyName(a.getName())).sorted(AssistContentThreadSafe.getComparator(targetType)).collect(Collectors.toList());
            this.suggestionDisplay = new SuggestionList(this.editor, Utility.mapList(this.completions, ac -> new SuggestionList.SuggestionDetailsWithHTMLDoc(ac.getName(), ExpressionCompletionCalculator.getParamsCompletionDisplay(ac), ac.getType(), ExpressionCompletionCalculator.getRarity(ac), ac.getDocHTML())), targetType, SuggestionList.SuggestionShown.COMMON, null, clickListener);
            handler.accept(this.suggestionDisplay);
        });
    }

    public static String getParamsCompletionDisplay(AssistContentThreadSafe a) {
        if (a.getParams() == null) {
            return "";
        }
        return "(" + a.getParams().stream().map(AssistContent.ParamInfo::getUnqualifiedType).collect(Collectors.joining(", ")) + ")";
    }

    @Override
    public String getName(int selected) {
        if (selected == -1) {
            throw new IllegalStateException();
        }
        AssistContentThreadSafe a = this.completions.get(selected);
        return a.getName();
    }

    @Override
    public List<String> getParams(int selected) {
        if (selected == -1) {
            throw new IllegalStateException();
        }
        AssistContentThreadSafe a = this.completions.get(selected);
        return Utility.orNull(a.getParams(), params -> params.stream().map(p -> p.getDummyName()).collect(Collectors.toList()));
    }

    @OnThread(value=Tag.FXPlatform)
    public void withConstructorParamNames(SuperThis constructorKind, FXPlatformConsumer<List<List<String>>> handler) {
        if (constructorKind == SuperThis.THIS) {
            handler.accept(Utility.mapList(this.editor.getThisConstructors(), con -> Utility.mapList(con.getParams(), p -> p.getFormalName())));
        } else {
            this.editor.withSuperConstructors(assists -> handler.accept(assists.stream().filter(a -> a.getParams() != null).map(a -> a.getParams().stream().map(p -> p.getFormalName()).collect(Collectors.toList())).collect(Collectors.toList())));
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void withParamNames(JavaFragment.PosInSourceDoc pos, ExpressionSlot<?> completing, String methodName, CodeElement codeEl, FXPlatformConsumer<List<List<String>>> handler) {
        this.editor.withCompletions(pos, completing, codeEl, assists -> handler.accept(assists.stream().filter(a -> !Parser.isDummyName(a.getName())).filter(a -> a.getName().equals(methodName)).filter(a -> a.getParams() != null).map(a -> a.getParams().stream().map(p -> p.getFormalName()).collect(Collectors.toList())).collect(Collectors.toList())));
    }

    private String makeHint(AssistContent.ParamInfo p) {
        return p.getUnqualifiedType() + " " + p.getFormalName() + "\n\nDescription: " + p.getJavadocDescription();
    }

    @OnThread(value=Tag.FXPlatform)
    public void withParamHints(JavaFragment.PosInSourceDoc pos, ExpressionSlot<?> completing, String methodName, CodeElement codeEl, FXPlatformConsumer<List<List<String>>> handler) {
        this.editor.withCompletions(pos, completing, codeEl, assists -> handler.accept(assists.stream().filter(a -> !Parser.isDummyName(a.getName())).filter(a -> a.getName().equals(methodName)).filter(a -> a.getParams() != null).map(a -> a.getParams().stream().map(this::makeHint).collect(Collectors.toList())).collect(Collectors.toList())));
    }

    @OnThread(value=Tag.FXPlatform)
    public void withConstructorParamHints(SuperThis constructorKind, int totalParams, FXPlatformConsumer<List<List<String>>> handler) {
        Function<List, List> asHints = assists -> assists.stream().filter(a -> a.getParams() != null && a.getParams().size() == totalParams).map(a -> a.getParams().stream().map(this::makeHint).collect(Collectors.toList())).collect(Collectors.toList());
        if (constructorKind == SuperThis.THIS) {
            handler.accept(asHints.apply(this.editor.getThisConstructors()));
        } else {
            this.editor.withSuperConstructors(assists -> handler.accept((List)asHints.apply((List)assists)));
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void withMethodHints(JavaFragment.PosInSourceDoc pos, ExpressionSlot<?> completing, String methodName, CodeElement codeEl, FXPlatformConsumer<List<String>> handler) {
        this.editor.withCompletions(pos, completing, codeEl, assists -> handler.accept(assists.stream().filter(a -> !Parser.isDummyName(a.getName())).filter(a -> a.getName().equals(methodName)).filter(a -> a.getParams() != null).map(a -> a.getName() + "(" + a.getParams().stream().map(p -> p.getUnqualifiedType() + " " + p.getFormalName()).collect(Collectors.joining(", ")) + ")\n\n" + JavaUtils.parseJavadoc(a.getJavadoc()).getHeader().trim()).collect(Collectors.toList())));
    }

    private static SuggestionList.SuggestionShown getRarity(AssistContentThreadSafe ac) {
        switch (ac.getKind()) {
            case METHOD: {
                if (ac.getDeclaringClass().equals("java.lang.Object")) {
                    switch (ac.getName()) {
                        case "equals": 
                        case "toString": {
                            return SuggestionList.SuggestionShown.COMMON;
                        }
                    }
                    return SuggestionList.SuggestionShown.RARE;
                }
                return SuggestionList.SuggestionShown.COMMON;
            }
        }
        return SuggestionList.SuggestionShown.COMMON;
    }

    @Override
    public char getOpening(int selected) {
        return '(';
    }
}

