/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.Config;
import bluej.stride.framedjava.ast.AccessPermission;
import bluej.stride.framedjava.ast.AccessPermissionFragment;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.ParamFragment;
import bluej.stride.framedjava.ast.ThrowsTypeFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.MethodProtoElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.frames.ClassFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.slots.TypeSlot;
import bluej.stride.generic.DocumentedSingleLineFrame;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.CustomFrameOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.FormalParameters;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.MethodNameDefTextSlot;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.SlotTraversalChars;
import bluej.stride.slots.Throws;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import threadchecker.OnThread;
import threadchecker.Tag;

public class MethodProtoFrame
extends DocumentedSingleLineFrame
implements CodeFrame<MethodProtoElement> {
    private final SlotLabel abstractLabel = new SlotLabel("abstract", new String[0]);
    private final BooleanProperty parentIsClass = new SimpleBooleanProperty(false);
    private final TypeSlot returnType;
    private final MethodNameDefTextSlot methodName;
    private final FormalParameters paramsPane;
    private final Throws throwsPane;
    private MethodProtoElement element;

    public MethodProtoFrame(InteractionManager editor) {
        super(editor, "", "method-");
        this.methodName = new MethodNameDefTextSlot(editor, this, this.getHeaderRow(), null, "method-name-");
        this.methodName.setPromptText("name");
        this.methodName.addValueListener(SlotTraversalChars.METHOD_NAME);
        this.returnType = new TypeSlot(editor, this, this, this.getHeaderRow(), TypeSlot.Role.RETURN, "method-return-type-");
        this.returnType.setSimplePromptText("type");
        this.returnType.addClosingChar(' ');
        this.paramsPane = new FormalParameters(editor, this, this, this.getHeaderRow(), "method-param-");
        this.setDocumentationPromptText("Describe your method here...");
        this.throwsPane = new Throws(this, () -> {
            TypeSlot s = new TypeSlot(editor, this, this, this.getHeaderRow(), TypeSlot.Role.THROWS_CATCH, "method-");
            s.setSimplePromptText("thrown type");
            return s;
        }, () -> this.getCursorAfter().requestFocus(), editor);
        this.getHeaderRow().getNode().getStyleClass().add((Object)"method-header");
        this.bindHeader();
    }

    public MethodProtoFrame(InteractionManager editor, TypeSlotFragment returnType, NameDefSlotFragment methodName, List<ParamFragment> params, List<ThrowsTypeFragment> throwsTypes, String documentation, boolean enabled) {
        this(editor);
        this.returnType.setText(returnType);
        this.methodName.setText(methodName);
        params.forEach(item -> this.paramsPane.addFormal(item.getParamType(), item.getParamName()));
        throwsTypes.forEach(t -> this.throwsPane.addTypeSlotAtEnd(t.getType(), false));
        this.setDocumentation(documentation);
        this.frameEnabledProperty.set(enabled);
    }

    private void bindHeader() {
        this.getHeaderRow().bindContentsConcat((ObservableList<ObservableList<? extends HeaderItem>>)FXCollections.observableArrayList((Object[])new ObservableList[]{JavaFXUtil.listBool((BooleanExpression)this.parentIsClass, this.abstractLabel), FXCollections.observableArrayList((Object[])new EditableSlot[]{this.returnType, this.methodName}), this.paramsPane.getSlots(), this.throwsPane.getHeaderItems(), FXCollections.observableArrayList((Object[])new SlotLabel[]{this.previewSemi})}));
    }

    public static FrameFactory<MethodProtoFrame> getFactory() {
        return new FrameFactory<MethodProtoFrame>(){

            @Override
            public MethodProtoFrame createBlock(InteractionManager editor) {
                return new MethodProtoFrame(editor);
            }

            @Override
            public Class<MethodProtoFrame> getBlockClass() {
                return MethodProtoFrame.class;
            }
        };
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<FrameOperation> getContextOperations() {
        ArrayList<FrameOperation> r = new ArrayList<FrameOperation>(super.getContextOperations());
        if (this.parentIsClass.get()) {
            r.add(new CustomFrameOperation(this.getEditor(), "abstract->concrete", Arrays.asList("Change", "to Concrete"), EditableSlot.MenuItemOrder.TRANSFORM, this, () -> {
                FrameCursor c = this.getCursorBefore();
                NormalMethodElement el = new NormalMethodElement(null, new AccessPermissionFragment(AccessPermission.PUBLIC), false, false, (TypeSlotFragment)this.returnType.getSlotElement(), (NameDefSlotFragment)this.methodName.getSlotElement(), this.paramsPane.getSlotElement(), this.throwsPane.getTypes(), new ArrayList<CodeElement>(), new JavadocUnit(this.getDocumentation()), this.frameEnabledProperty.get());
                c.insertBlockAfter(el.createFrame(this.getEditor()));
                c.getParentCanvas().removeBlock(this);
            }));
        }
        return r;
    }

    @Override
    public void regenerateCode() {
        this.element = new MethodProtoElement(this, (TypeSlotFragment)this.returnType.getSlotElement(), (NameDefSlotFragment)this.methodName.getSlotElement(), this.paramsPane.getSlotElement(), this.throwsPane.getTypes(), new JavadocUnit(this.getDocumentation()), this.frameEnabledProperty.get());
    }

    @Override
    public boolean focusWhenJustAdded() {
        this.returnType.requestFocus();
        return true;
    }

    @Override
    public MethodProtoElement getCode() {
        return this.element;
    }

    @Override
    public List<ExtensionDescription> getAvailableExtensions(FrameCanvas innerCanvas, FrameCursor cursorInCanvas) {
        ArrayList<ExtensionDescription> extensions = new ArrayList<ExtensionDescription>(super.getAvailableExtensions(innerCanvas, cursorInCanvas));
        extensions.add(new ExtensionDescription('t', Config.getString("frame.class.add.throw"), () -> this.throwsPane.addTypeSlotAtEnd("", true), true, ExtensionDescription.ExtensionSource.BEFORE, ExtensionDescription.ExtensionSource.AFTER, ExtensionDescription.ExtensionSource.MODIFIER));
        return extensions;
    }

    @Override
    public void updateAppearance(FrameCanvas parentCanvas) {
        super.updateAppearance(parentCanvas);
        this.parentIsClass.set(parentCanvas.getParent().getFrame() instanceof ClassFrame);
    }

    @Override
    public EditableSlot getErrorShowRedirect() {
        return this.methodName;
    }
}

