/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.Config;
import bluej.stride.framedjava.ast.AccessPermission;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.ParamFragment;
import bluej.stride.framedjava.canvases.JavaCanvas;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.MethodWithBodyElement;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.DebuggableFrame;
import bluej.stride.framedjava.slots.TypeSlot;
import bluej.stride.generic.DocumentedSingleCanvasFrame;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.AccessPermissionSlot;
import bluej.stride.slots.ChoiceSlot;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.FormalParameters;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.Throws;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class MethodFrameWithBody<T extends MethodWithBodyElement>
extends DocumentedSingleCanvasFrame
implements DebuggableFrame,
CodeFrame<T> {
    protected final ChoiceSlot<AccessPermission> access;
    protected final Throws throwsPane;
    private final Rectangle dropShadowDummy;
    protected FormalParameters paramsPane;
    private boolean showingBirdseye;
    private FXRunnable headerCleanup;

    public MethodFrameWithBody(final InteractionManager editor) {
        super(editor, "", "method-");
        this.access = new AccessPermissionSlot(editor, this, this.getHeaderRow(), "method-");
        this.access.setValue(AccessPermission.PUBLIC);
        this.throwsPane = new Throws(this, () -> {
            TypeSlot s = new TypeSlot(editor, this, this, this.getHeaderRow(), TypeSlot.Role.THROWS_CATCH, "method-");
            s.setSimplePromptText("thrown type");
            return s;
        }, () -> this.getCanvas().getFirstCursor().requestFocus(), editor);
        this.dropShadowDummy = new Rectangle(0.0, 0.0, 0.0, 0.0);
        final Region headerRow = this.getHeaderRow().getNode();
        headerRow.getStyleClass().add((Object)"method-header");
        this.dropShadowDummy.widthProperty().bind((ObservableValue)headerRow.widthProperty());
        this.dropShadowDummy.heightProperty().bind((ObservableValue)headerRow.heightProperty());
        final Rectangle small = new Rectangle();
        small.widthProperty().bind((ObservableValue)this.canvas.widthProperty().subtract((ObservableNumberValue)this.canvas.leftMargin()).subtract((ObservableNumberValue)this.canvas.rightMargin()));
        small.yProperty().bind((ObservableValue)this.dropShadowDummy.heightProperty().add((ObservableNumberValue)this.dropShadowDummy.yProperty()));
        small.heightProperty().set(15.0);
        this.dropShadowDummy.clipProperty().set((Object)small);
        if (editor != null && editor.getWindowOverlayPane() != null) {
            final DoubleBinding offset = new DoubleBinding(){
                {
                    super.bind(new Observable[]{editor.getObservableScroll()});
                    super.bind(new Observable[]{MethodFrameWithBody.this.getRegion().layoutBoundsProperty()});
                    super.bind(new Observable[]{MethodFrameWithBody.this.getRegion().heightProperty()});
                    super.bind(new Observable[]{MethodFrameWithBody.this.getHeaderRow().getNode().heightProperty()});
                    super.bind(new Observable[]{MethodFrameWithBody.this.getRegion().localToSceneTransformProperty()});
                    super.bind(new Observable[]{editor.getObservableViewportHeight()});
                    super.bind(new Observable[]{MethodFrameWithBody.this.getHeaderRow().getNode().layoutBoundsProperty()});
                }

                protected double computeValue() {
                    if (!MethodFrameWithBody.this.getHeaderItems().findFirst().isPresent()) {
                        return 0.0;
                    }
                    double headerTopSceneY = MethodFrameWithBody.this.getHeaderRow().getNode().localToScene(0.0, 0.0).getY();
                    double headerHeight = MethodFrameWithBody.this.getHeaderRow().getNode().getHeight();
                    double overlayY = editor.getWindowOverlayPane().sceneYToWindowOverlayY(headerTopSceneY);
                    double marginBeneathHeader = 20.0;
                    double maxOffset = MethodFrameWithBody.this.getRegion().localToScene(MethodFrameWithBody.this.getRegion().getBoundsInLocal()).getMaxY() - headerTopSceneY - 20.0 - headerHeight;
                    if (overlayY > 0.0) {
                        return overlayY;
                    }
                    if (overlayY < -maxOffset) {
                        if (overlayY < -(maxOffset + MethodFrameWithBody.this.getHeaderRow().getNode().getHeight())) {
                            return 1.0;
                        }
                        return overlayY + maxOffset;
                    }
                    return 0.0;
                }
            };
            this.dropShadowDummy.effectProperty().bind((ObservableValue)new ObjectBinding<Effect>(){
                DropShadow dropShadow = new DropShadow();
                {
                    super.bind(new Observable[]{offset});
                    this.dropShadow.setRadius(8.0);
                    this.dropShadow.setOffsetX(4.0);
                    this.dropShadow.setOffsetY(4.0);
                    this.dropShadow.setColor(Color.color((double)0.6, (double)0.6, (double)0.6));
                }

                protected Effect computeValue() {
                    return offset.get() <= 0.0 ? this.dropShadow : null;
                }
            });
            offset.addListener((ChangeListener)new ChangeListener<Number>(){
                private Pane imageView;
                private boolean addingImageView = false;
                private SimpleDoubleProperty imageViewY = new SimpleDoubleProperty(0.0);
                {
                    JavaFXUtil.addChangeListener(editor.viewProperty(), v -> {
                        if (v != Frame.View.NORMAL && this.imageView != null) {
                            editor.getWindowOverlayPane().removeOverlay((Node)this.imageView);
                            editor.getWindowOverlayPane().removeOverlay((Node)MethodFrameWithBody.this.dropShadowDummy);
                            this.imageView = null;
                        } else if (v == Frame.View.NORMAL && this.imageView == null) {
                            this.changed((ObservableValue<? extends Number>)offset, offset.get(), offset.get());
                        }
                    });
                    MethodFrameWithBody.this.headerCleanup = () -> {
                        editor.getWindowOverlayPane().removeOverlay((Node)this.imageView);
                        editor.getWindowOverlayPane().removeOverlay((Node)MethodFrameWithBody.this.dropShadowDummy);
                        this.imageView = null;
                    };
                }

                public void changed(ObservableValue<? extends Number> arg0, Number oldVal, Number newVal) {
                    if (editor.getWindowOverlayPane() == null) {
                        return;
                    }
                    if (!MethodFrameWithBody.this.isFrameEnabled() || MethodFrameWithBody.this.getParentCanvas() == null) {
                        return;
                    }
                    if (editor.viewProperty().get() != Frame.View.NORMAL) {
                        return;
                    }
                    if (newVal.doubleValue() > 0.0 && this.imageView != null) {
                        editor.getWindowOverlayPane().removeOverlay((Node)this.imageView);
                        editor.getWindowOverlayPane().removeOverlay((Node)MethodFrameWithBody.this.dropShadowDummy);
                        this.imageView = null;
                    } else if (newVal.doubleValue() <= 0.0) {
                        this.imageViewY.setValue(newVal);
                        if (this.imageView == null && !this.addingImageView) {
                            this.addingImageView = true;
                            this.imageView = MethodFrameWithBody.this.getHeaderRow().makeDisplayClone(editor);
                            this.imageView.getStyleClass().addAll((Object[])new String[]{"method-header", "method-header-row-pinned-clone"});
                            double sceneX = MethodFrameWithBody.this.getHeaderRow().getSceneBounds().getMinX();
                            double windowOverlayX = editor.getWindowOverlayPane().sceneXToWindowOverlayX(sceneX);
                            editor.getWindowOverlayPane().addOverlay((Node)this.imageView, (ObservableDoubleValue)new SimpleDoubleProperty(windowOverlayX), (ObservableDoubleValue)this.imageViewY);
                            this.imageView.applyCss();
                            small.xProperty().set(MethodFrameWithBody.this.canvas.getNode().localToScene(MethodFrameWithBody.this.canvas.getNode().getBoundsInLocal()).getMinX() - sceneX + MethodFrameWithBody.this.canvas.leftMargin().get());
                            editor.getWindowOverlayPane().addOverlay((Node)MethodFrameWithBody.this.dropShadowDummy, (ObservableDoubleValue)new SimpleDoubleProperty(windowOverlayX), (ObservableDoubleValue)this.imageViewY);
                            this.imageView.addEventFilter(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent e) {
                                    editor.scrollTo((Node)headerRow, -2.0);
                                }
                            });
                            this.addingImageView = false;
                        }
                    }
                }
            });
        }
        AnchorPane.setTopAnchor((Node)this.canvas.getNode(), (Double)0.0);
    }

    protected List<ParamFragment> generateParams() {
        return this.paramsPane.getSlotElement();
    }

    @Override
    public FrameCanvas createCanvas(InteractionManager editor, String stylePrefix) {
        return new JavaCanvas(editor, this, stylePrefix, true);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return ((JavaCanvas)this.getCanvas()).showDebugBefore(null, debug);
    }

    protected List<CodeElement> getContents() {
        ArrayList<CodeElement> contents = new ArrayList<CodeElement>();
        this.getMembersFrames().forEach(f -> {
            f.regenerateCode();
            contents.add((CodeElement)f.getCode());
        });
        return contents;
    }

    public List<CodeFrame> getMembersFrames() {
        return this.canvas.getBlocksSubtype(CodeFrame.class);
    }

    @Override
    public void checkForEmptySlot() {
        this.paramsPane.checkForEmptySlot();
    }

    public void setAccess(AccessPermission value) {
        this.access.setValue(value);
    }

    public FormalParameters getParamsPane() {
        return this.paramsPane;
    }

    @Override
    public List<String> getDeclaredVariablesWithin(FrameCanvas c) {
        if (c != this.getCanvas()) {
            throw new IllegalArgumentException("Canvas does not exist in this frame");
        }
        return this.paramsPane.getVars().filter(s -> s != null && !s.isEmpty()).collect(Collectors.toList());
    }

    @Override
    public List<ExtensionDescription> getAvailableExtensions(FrameCanvas canvas, FrameCursor cursorInCanvas) {
        ArrayList<ExtensionDescription> extensions = new ArrayList<ExtensionDescription>(super.getAvailableExtensions(canvas, cursorInCanvas));
        extensions.add(new ExtensionDescription('o', Config.getString("frame.class.add.throw"), () -> this.throwsPane.addTypeSlotAtEnd("", true), true, ExtensionDescription.ExtensionSource.INSIDE_FIRST, ExtensionDescription.ExtensionSource.MODIFIER));
        return extensions;
    }

    public void addThrows(String type) {
        this.throwsPane.addTypeSlotAtEnd(type, true);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        super.setView(oldView, newView, animate);
        this.paramsPane.setView(newView, animate);
        if (newView.isBirdseye() != oldView.isBirdseye()) {
            if (newView.isBirdseye()) {
                this.canvas.shrinkUsing((DoubleExpression)animate.getProgress().negate().add(1.0));
            } else {
                this.canvas.growUsing(animate.getProgress());
            }
            this.showingBirdseye = newView.isBirdseye();
        }
        animate.getProgress().addListener((a, oldVal, newVal) -> {
            if (Math.round(oldVal.doubleValue()) != Math.round(newVal.doubleValue())) {
                JavaFXUtil.setPseudoclass("bj-birdseye", newView.isBirdseye(), this.getNode(), this.canvas.getNode());
                JavaFXUtil.setPseudoclass("bj-birdseye-nodoc", newView == Frame.View.BIRDSEYE_NODOC, this.getNode(), this.canvas.getNode());
                JavaFXUtil.setPseudoclass("bj-birdseye-doc", newView == Frame.View.BIRDSEYE_DOC, this.getNode(), this.canvas.getNode());
            }
        });
        if (this.isFrameEnabled() && (oldView == Frame.View.JAVA_PREVIEW || newView == Frame.View.JAVA_PREVIEW)) {
            this.canvas.previewCurly(newView == Frame.View.JAVA_PREVIEW, this.header.getLeftFirstItem() + this.tweakCurlyX(), this.tweakOpeningCurlyY(), animate);
        }
    }

    protected void restoreDetails(MethodWithBodyElement nme) {
        this.setDocumentation(nme.getDocumentation());
        this.access.setValue(nme.getAccessPermission());
        this.throwsPane.setTypes(nme.getThrowsTypes());
        this.paramsPane.setParams(nme.getParams(), f -> f.getParamType().getContent(), f -> f.getParamName().getContent());
        this.canvas.restore(nme.getContents(), this.getEditor());
    }

    @Override
    protected void cleanupFrame() {
        this.headerCleanup.run();
        super.cleanupFrame();
    }

    @Override
    protected double tweakCurlyX() {
        return 2.0;
    }

    protected abstract class MethodHeaderRow
    extends FrameContentRow {
        public MethodHeaderRow(Frame parentFrame, String stylePrefix) {
            super(parentFrame, stylePrefix);
        }

        protected abstract EditableSlot getSlotBeforeParams();

        protected abstract EditableSlot getSlotAfterParams();

        @Override
        public void focusRight(HeaderItem src) {
            if (src == this.getSlotBeforeParams()) {
                MethodFrameWithBody.this.paramsPane.ensureAtLeastOneParameter();
            }
            super.focusRight(src);
        }

        @Override
        public void focusLeft(HeaderItem src) {
            if (src == this.getSlotAfterParams() && MethodFrameWithBody.this.paramsPane.ensureAtLeastOneParameter()) {
                MethodFrameWithBody.this.paramsPane.focusBeginning();
                return;
            }
            super.focusLeft(src);
        }

        @Override
        public boolean focusRightEndFromNext() {
            if (this.getSlotAfterParams() == null && MethodFrameWithBody.this.paramsPane.ensureAtLeastOneParameter()) {
                MethodFrameWithBody.this.paramsPane.focusBeginning();
                return true;
            }
            return super.focusRightEndFromNext();
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public void escape(HeaderItem src) {
            if (MethodFrameWithBody.this.paramsPane.findFormal(src) != null) {
                MethodFrameWithBody.this.paramsPane.escape(src);
            } else {
                super.escape(src);
            }
        }
    }
}

