/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.Config;
import bluej.stride.framedjava.ast.AccessPermissionFragment;
import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.ParamFragment;
import bluej.stride.framedjava.ast.SuperThis;
import bluej.stride.framedjava.ast.SuperThisFragment;
import bluej.stride.framedjava.ast.SuperThisParamsExpressionFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ConstructorElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.frames.ClassFrame;
import bluej.stride.framedjava.frames.MethodFrameWithBody;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.SuperThisParamsExpressionSlot;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.CustomFrameOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.ChoiceSlot;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.FormalParameters;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotLabel;
import bluej.utility.Utility;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ConstructorFrame
extends MethodFrameWithBody<ConstructorElement> {
    private final SlotLabel headerLabel;
    private ConstructorElement element;
    private FrameContentRow callRow;
    private ChoiceSlot<SuperThis> superThis;
    private SuperThisParamsExpressionSlot superThisParams;

    private ConstructorFrame(InteractionManager editor) {
        super(editor);
        this.setDocumentationPromptText(Config.getString("frame.class.constructor.doc.prompt"));
        this.headerLabel = new SlotLabel("<constructor>", new String[0]);
        JavaFXUtil.addStyleClass((Styleable)this.headerLabel, "constructor-name-caption");
        this.paramsPane = new FormalParameters(editor, this, this, this.getHeaderRow(), "constructor-param-");
        this.headerLabel.textProperty().bind((ObservableValue)editor.nameProperty());
        this.getHeaderRow().bindContentsConcat((ObservableList<ObservableList<? extends HeaderItem>>)FXCollections.observableArrayList((Object[])new ObservableList[]{FXCollections.observableArrayList((Object[])new ChoiceSlot[]{this.access}), FXCollections.observableArrayList((Object[])new SlotLabel[]{this.headerLabel}), this.paramsPane.getSlots(), this.throwsPane.getHeaderItems()}));
    }

    public ConstructorFrame(InteractionManager editor, AccessPermissionFragment access, String documentation, SuperThisFragment delegate, ExpressionSlotFragment delegateParams, boolean enabled) {
        this(editor);
        this.access.setValue(access.getValue());
        access.registerSlot(this.access);
        this.setDocumentation(documentation);
        if (delegate != null || delegateParams != null) {
            this.addSuperThis(delegate, delegateParams);
        }
        this.frameEnabledProperty.set(enabled);
    }

    public static FrameFactory<ConstructorFrame> getFactory() {
        return new FrameFactory<ConstructorFrame>(){

            @Override
            public ConstructorFrame createBlock(InteractionManager editor) {
                return new ConstructorFrame(editor);
            }

            @Override
            public Class<ConstructorFrame> getBlockClass() {
                return ConstructorFrame.class;
            }
        };
    }

    @Override
    public void regenerateCode() {
        List<ParamFragment> params = this.generateParams();
        this.element = new ConstructorElement(this, new AccessPermissionFragment(this, this.access), params, this.throwsPane.getTypes(), Utility.orNull(this.superThis, s -> new SuperThisFragment(this, (ChoiceSlot<SuperThis>)s, this.superThisParams)), this.superThisParams == null ? null : (SuperThisParamsExpressionFragment)this.superThisParams.getSlotElement(), this.getContents(), new JavadocUnit(this.getDocumentation()), this.frameEnabledProperty.get());
    }

    @Override
    public ConstructorElement getCode() {
        return this.element;
    }

    private void addSuperThis(SuperThisFragment st, ExpressionSlotFragment params) {
        if (this.superThis != null) {
            this.superThis.setValue(st.getValue());
        } else {
            this.callRow = new FrameContentRow((Frame)this, "constructor-call-");
            this.callRow.setMargin(new Insets(0.0, 6.0, 0.0, 0.0));
            this.superThis = new ChoiceSlot<SuperThis>(this.getEditor(), this, this.callRow, SuperThis.all(), SuperThis::isValid, "constructor-", Collections.emptyMap());
            this.superThis.setValue(st.getValue());
            this.superThisParams = new SuperThisParamsExpressionSlot(this.getEditor(), this, this, this.callRow, this.superThis, "constructor-param-"){

                @Override
                @OnThread(value=Tag.FXPlatform)
                public boolean backspaceAtStart() {
                    if (this.isAlmostBlank()) {
                        FrameCursor fc = ConstructorFrame.this.getCanvas().getFirstCursor();
                        ConstructorFrame.this.getEditor().beginRecordingState(fc);
                        ConstructorFrame.this.removeSuperThis();
                        fc.requestFocus();
                        ConstructorFrame.this.getEditor().endRecordingState(fc);
                        return true;
                    }
                    return super.backspaceAtStart();
                }
            };
            this.callRow.setHeaderItems(Arrays.asList(this.superThis, ExpressionSlot.makeBracketSlot("(", true, null), this.superThisParams, ExpressionSlot.makeBracketSlot(")", false, null)));
            this.contents.setAll((Object[])new FrameContentItem[]{this.documentationPane, this.getHeaderRow(), this.callRow, this.getCanvas()});
            if (params != null) {
                this.superThisParams.setText(params);
            }
            this.superThisParams.requestFocus();
            this.getEditor().modifiedFrame(this, false);
            JavaFXUtil.setPseudoclass("bj-super-this", true, this.getNode());
        }
        st.registerSlot(this.superThis);
    }

    private void removeSuperThis() {
        if (this.callRow != null) {
            this.callRow = null;
            this.superThis = null;
            this.superThisParams = null;
            this.contents.setAll((Object[])new FrameContentItem[]{this.documentationPane, this.getHeaderRow(), this.getCanvas()});
            this.getCanvas().getFirstCursor().requestFocus();
            this.getEditor().modifiedFrame(this, false);
            JavaFXUtil.setPseudoclass("bj-super-this", false, this.getNode());
        }
    }

    @Override
    public List<ExtensionDescription> getAvailableExtensions(FrameCanvas canvas, FrameCursor cursorInCanvas) {
        if (this.callRow == null) {
            ArrayList<ExtensionDescription> extensions = new ArrayList<ExtensionDescription>(super.getAvailableExtensions(canvas, cursorInCanvas));
            extensions.addAll(Arrays.asList(new ExtensionDescription('u', Config.getString("frame.class.add.super"), () -> this.addSuperThis(new SuperThisFragment(SuperThis.SUPER), null), true, ExtensionDescription.ExtensionSource.INSIDE_FIRST, ExtensionDescription.ExtensionSource.MODIFIER), new ExtensionDescription('t', Config.getString("frame.class.add.this"), () -> this.addSuperThis(new SuperThisFragment(SuperThis.THIS), null), true, ExtensionDescription.ExtensionSource.INSIDE_FIRST, ExtensionDescription.ExtensionSource.MODIFIER)));
            return extensions;
        }
        return Arrays.asList(new ExtensionDescription('\b', Config.getString("frame.class.remove.super"), () -> this.removeSuperThis(), true, ExtensionDescription.ExtensionSource.INSIDE_FIRST, new ExtensionDescription.ExtensionSource[0]));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<FrameOperation> getContextOperations() {
        ArrayList<FrameOperation> r = new ArrayList<FrameOperation>(super.getContextOperations());
        r.add(new CustomFrameOperation(this.getEditor(), "constructor->method", Arrays.asList(Config.getString("frame.operation.change"), Config.getString("frame.operation.change.to.method")), EditableSlot.MenuItemOrder.TRANSFORM, this, () -> {
            Frame parent = this.getParentCanvas().getParent().getFrame();
            if (parent instanceof ClassFrame) {
                FrameCanvas p = ((ClassFrame)parent).getMethodsCanvas();
                FrameCursor c = p.getLastCursor();
                NormalMethodElement el = new NormalMethodElement(null, new AccessPermissionFragment(this, this.access), false, false, new TypeSlotFragment("", ""), new NameDefSlotFragment(""), this.generateParams(), this.throwsPane.getTypes(), this.getContents(), new JavadocUnit(this.getDocumentation()), this.frameEnabledProperty.get());
                c.insertBlockAfter(el.createFrame(this.getEditor()));
                this.getParentCanvas().removeBlock(this);
            }
        }));
        return r;
    }

    @Override
    public EditableSlot getErrorShowRedirect() {
        return null;
    }

    @Override
    protected FrameContentRow makeHeader(String stylePrefix) {
        return new MethodFrameWithBody.MethodHeaderRow((Frame)this, stylePrefix){

            @Override
            protected EditableSlot getSlotAfterParams() {
                return ConstructorFrame.this.throwsPane.getTypeSlots().findFirst().orElse(null);
            }

            @Override
            protected EditableSlot getSlotBeforeParams() {
                return ConstructorFrame.this.access;
            }
        };
    }

    @Override
    public boolean tryRestoreTo(CodeElement codeElement) {
        if (codeElement instanceof ConstructorElement) {
            ConstructorElement ce = (ConstructorElement)codeElement;
            if (this.element.hasDelegate() && !ce.hasDelegate()) {
                this.removeSuperThis();
            }
            if (!this.element.hasDelegate() && ce.hasDelegate()) {
                this.addSuperThis(new SuperThisFragment(ce.getDelegate()), new SuperThisParamsExpressionFragment(ce.getDelegateParams(), ce.getDelegateParamsJava()));
            }
            if (this.element.hasDelegate() && ce.hasDelegate()) {
                this.restoreDelegate(ce);
            }
            this.restoreDetails(ce);
            return true;
        }
        return false;
    }

    private void restoreDelegate(ConstructorElement ce) {
        if (!((SuperThis)this.superThis.getValue(null)).equals((Object)ce.getDelegate())) {
            this.superThis.setValue(ce.getDelegate());
        }
        if (!this.superThisParams.getText().equals(ce.getDelegateParams())) {
            this.superThisParams.setText(ce.getDelegateParams());
        }
    }

    @Override
    public boolean focusWhenJustAdded() {
        this.getCanvas().getFirstCursor().requestFocus();
        return true;
    }

    @Override
    protected DoubleExpression tweakOpeningCurlyY() {
        if (this.callRow == null) {
            return super.tweakOpeningCurlyY();
        }
        return this.callRow.flowPaneHeight().negate();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        super.setView(oldView, newView, animate);
        if (this.callRow != null) {
            if (newView == Frame.View.JAVA_PREVIEW) {
                double maxAmount = this.getCanvas().getCurlyBracketHeight();
                JavaFXUtil.addChangeListener(animate.getProgress(), t -> this.callRow.getNode().setTranslateY(t.doubleValue() * maxAmount));
                this.callRow.applyCss();
                FXRunnable setPad = () -> this.getCanvas().setTopOutsideBorderBackgroundPadding(Optional.of(-2.0 + this.callRow.getSceneBounds().getHeight()));
                setPad.run();
                animate.addOnStopped(setPad);
            } else if (oldView == Frame.View.JAVA_PREVIEW) {
                this.getCanvas().setTopOutsideBorderBackgroundPadding(Optional.empty());
                double orig = this.callRow.getNode().getTranslateY();
                JavaFXUtil.addChangeListener(animate.getOppositeProgress(), t -> this.callRow.getNode().setTranslateY(t.doubleValue() * orig));
            }
            if (newView.isBirdseye() || oldView.isBirdseye()) {
                animate.getProgress().addListener((prop, oldVal, newVal) -> {
                    if (oldVal.doubleValue() < 0.5 && newVal.doubleValue() >= 0.5) {
                        this.callRow.setVisible(!newView.isBirdseye());
                    }
                });
            }
        }
    }
}

