/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.elements.SandwichCanvasesElement;
import bluej.stride.framedjava.frames.TryFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SandwichCanvasesFrame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import nu.xom.Element;
import threadchecker.OnThread;
import threadchecker.Tag;

public class TryElement
extends SandwichCanvasesElement {
    public static final String ELEMENT = "try";
    private static final String CATCH_LABEL = "catch";
    private static final String FINALLY_LABEL = "finally";
    private static final String EXCEPTION_TYPE_LABEL = "type";
    private static final String EXCEPTION_NAME_LABEL = "name";
    private List<TypeSlotFragment> catchTypes = new ArrayList<TypeSlotFragment>();
    private List<NameDefSlotFragment> catchNames = new ArrayList<NameDefSlotFragment>();
    private TryFrame frame;

    public TryElement(TryFrame frame, List<CodeElement> tryContents, List<TypeSlotFragment> catchTypes, List<NameDefSlotFragment> catchNames, List<List<CodeElement>> catchContents, List<CodeElement> finallyContents, boolean enabled) {
        super(frame, ELEMENT, tryContents, CATCH_LABEL, CATCH_LABEL, catchContents, FINALLY_LABEL, finallyContents, enabled);
        this.catchTypes = catchTypes;
        this.catchNames = catchNames;
    }

    public TryElement(Element element) {
        super(ELEMENT, CATCH_LABEL, CATCH_LABEL, FINALLY_LABEL);
        this.loadElement(element);
    }

    @Override
    protected void loadMainAttributes(Element element) {
    }

    @Override
    protected void loadIntermediateAttributes(Element element) {
        this.catchTypes.add(new TypeSlotFragment(element.getAttributeValue(EXCEPTION_TYPE_LABEL), element.getAttributeValue("type-java")));
        this.catchNames.add(new NameDefSlotFragment(element.getAttributeValue(EXCEPTION_NAME_LABEL)));
    }

    @Override
    protected List<JavaFragment> getIntermediateHeaderFragment(int index) {
        List<JavaFragment> headerFragment = super.getIntermediateHeaderFragment(index);
        headerFragment.addAll(Arrays.asList(this.f(this.frame, " ("), this.catchTypes.get(index), this.space(), this.catchNames.get(index), this.f(this.frame, ")")));
        return headerFragment;
    }

    @Override
    protected void addMainAttributes(LocatableElement element) {
    }

    @Override
    protected void addIntermediateAttributes(LocatableElement element, int index) {
        element.addAttributeStructured(EXCEPTION_TYPE_LABEL, this.catchTypes.get(index));
        element.addAttributeCode(EXCEPTION_NAME_LABEL, this.catchNames.get(index));
    }

    @Override
    @OnThread(value=Tag.FX)
    protected SandwichCanvasesFrame buildFrame(InteractionManager editor, List<Frame> firstCanvasFrames, List<List<Frame>> intermediateCanvasFrames, List<Frame> tailCanvasFrames, boolean enable) {
        this.frame = new TryFrame(editor, firstCanvasFrames, this.catchTypes, this.catchNames, intermediateCanvasFrames, tailCanvasFrames, enable);
        return this.frame;
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.empty();
    }

    @Override
    public List<CodeElement.LocalParamInfo> getDeclaredVariablesWithin(CodeElement child) {
        Optional<Integer> subCanvas = this.findDirectIntermediateChild(child);
        return subCanvas.map(i -> Arrays.asList(new CodeElement.LocalParamInfo(this.catchTypes.get((int)i).getContent(), this.catchNames.get((int)i).getContent(), false, this))).orElse(Collections.emptyList());
    }
}

