/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.debugger.gentype.ConstructorReflective;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.parser.ExpressionTypeInfo;
import bluej.parser.entity.EntityResolver;
import bluej.stride.framedjava.ast.FrameFragment;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.StringSlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.DocumentContainerCodeElement;
import bluej.stride.framedjava.elements.ImportElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.elements.TopLevelCodeElement;
import bluej.stride.framedjava.errors.SyntaxCodeError;
import bluej.stride.framedjava.frames.InterfaceFrame;
import bluej.stride.framedjava.frames.TopLevelFrame;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.stream.Stream;
import javafx.application.Platform;
import nu.xom.Element;
import nu.xom.Node;
import threadchecker.OnThread;
import threadchecker.Tag;

public class InterfaceElement
extends DocumentContainerCodeElement
implements TopLevelCodeElement {
    public static final String ELEMENT = "interface";
    private final NameDefSlotFragment interfaceName;
    private final List<TypeSlotFragment> extendsTypes;
    private JavadocUnit documentation;
    private final String packageName;
    private final List<ImportElement> imports;
    private final List<CodeElement> fields;
    private final List<CodeElement> methods;
    private final EntityResolver projectResolver;
    private InterfaceFrame frame;
    private final FrameFragment openingCurly;
    private final FrameFragment closingCurly;
    private JavaFragment interfaceKeyword;
    private DocAndPositions sourceDocument;
    private ExpressionSlot<?> sourceDocumentCompleting;
    private final HashMap<String, DocAndPositions> documentCache;

    public InterfaceElement(InterfaceFrame frame, EntityResolver projectResolver, NameDefSlotFragment interfaceName, List<TypeSlotFragment> extendsTypes, List<CodeElement> fields, List<CodeElement> methods, JavadocUnit documentation, String packageName, List<ImportElement> imports, boolean enabled) {
        this.openingCurly = new FrameFragment(this.frame, this, "{");
        this.closingCurly = new FrameFragment(this.frame, this, "}");
        this.documentCache = new HashMap();
        this.frame = frame;
        this.interfaceName = interfaceName;
        this.extendsTypes = extendsTypes == null ? new ArrayList<TypeSlotFragment>() : new ArrayList<TypeSlotFragment>(extendsTypes);
        this.documentation = documentation != null ? documentation : new JavadocUnit("");
        this.packageName = packageName == null ? "" : packageName;
        this.imports = new ArrayList<ImportElement>(imports);
        this.fields = new ArrayList<CodeElement>(fields);
        this.fields.forEach(field -> field.setParent(this));
        this.methods = new ArrayList<CodeElement>(methods);
        this.methods.forEach(method -> method.setParent(this));
        this.enable = enabled;
        this.projectResolver = projectResolver;
    }

    public InterfaceElement(Element el, EntityResolver projectResolver, String packageName) {
        this.openingCurly = new FrameFragment(this.frame, this, "{");
        this.closingCurly = new FrameFragment(this.frame, this, "}");
        this.documentCache = new HashMap();
        this.projectResolver = projectResolver;
        this.interfaceName = new NameDefSlotFragment(el.getAttributeValue("name"));
        Element javadocEL = el.getFirstChildElement("javadoc");
        this.documentation = javadocEL != null ? new JavadocUnit(javadocEL) : new JavadocUnit("");
        this.extendsTypes = TopLevelCodeElement.xmlToTypeList(el, "extends", "extendstype", "type");
        this.packageName = packageName;
        this.imports = Utility.mapList(TopLevelCodeElement.fillChildrenElements(this, el, "imports"), e -> (ImportElement)e);
        this.fields = TopLevelCodeElement.fillChildrenElements(this, el, "fields");
        this.methods = TopLevelCodeElement.fillChildrenElements(this, el, "methods");
        this.enable = Boolean.valueOf(el.getAttributeValue("enable"));
    }

    public InterfaceElement(EntityResolver entityResolver, String interfaceName, String packageName) {
        this(null, entityResolver, new NameDefSlotFragment(interfaceName), null, Collections.emptyList(), Collections.emptyList(), null, packageName, Collections.emptyList(), true);
    }

    @Override
    public ExpressionTypeInfo getCodeSuggestions(JavaFragment.PosInSourceDoc pos, ExpressionSlot<?> completing) {
        MoeSyntaxDocument doc = this.getSourceDocument(completing);
        return doc.getParser().getExpressionType(pos.offset, this.getSourceDocument(completing));
    }

    @Override
    public LocatableElement toXML() {
        LocatableElement interfaceEl = new LocatableElement(this, ELEMENT);
        interfaceEl.addAttributeCode("name", this.interfaceName);
        if (!this.extendsTypes.isEmpty()) {
            interfaceEl.appendChild((Node)TopLevelCodeElement.typeListToXML(this.extendsTypes, "extends", "extendstype", "type"));
        }
        this.addEnableAttribute(interfaceEl);
        if (this.documentation != null) {
            interfaceEl.appendChild((Node)this.documentation.toXML());
        }
        this.appendCollection(interfaceEl, this.imports, "imports");
        this.appendCollection(interfaceEl, this.fields, "fields");
        this.appendCollection(interfaceEl, this.methods, "methods");
        interfaceEl.addAttribute(TopLevelCodeElement.getStrideVersionAttribute());
        return interfaceEl;
    }

    private void appendCollection(Element topEl, List<? extends CodeElement> collection, String name) {
        Element collectionEl = new Element(name);
        collection.forEach(element -> collectionEl.appendChild((Node)element.toXML()));
        topEl.appendChild((Node)collectionEl);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public JavaSource toJavaSource() {
        return this.getDAP(null).java;
    }

    @OnThread(value=Tag.FXPlatform)
    private JavaSource generateJavaSource() {
        ArrayList<JavaFragment> header = new ArrayList<JavaFragment>();
        header.add(new FrameFragment(this.frame, this, "public "));
        this.interfaceKeyword = new FrameFragment(this.frame, this, "interface ");
        Collections.addAll(header, this.interfaceKeyword, this.interfaceName);
        if (!this.extendsTypes.isEmpty()) {
            Collections.addAll(header, this.space(), this.f(this.frame, "extends"), this.space());
            header.addAll((Collection<JavaFragment>)this.extendsTypes.stream().collect(Utility.intersperse(() -> this.f(this.frame, ", "))));
        }
        JavaSource java = new JavaSource(null, header);
        java.prependJavadoc(this.documentation.getJavaCode());
        java.prependLine(Arrays.asList(this.f(this.frame, "")), null);
        Utility.backwards(CodeElement.toJavaCodes(this.imports)).forEach(imp -> java.prepend((JavaSource)imp));
        java.prependLine(Collections.singletonList(this.f(this.frame, "import lang.stride.*;")), null);
        if (!this.packageName.equals("")) {
            java.prependLine(Arrays.asList(this.f(this.frame, "package " + this.packageName + ";")), null);
        }
        this.openingCurly.setFrame(this.frame);
        java.appendLine(Arrays.asList(this.openingCurly), null);
        this.fields.stream().filter(f -> f.isEnable()).forEach(f -> java.addIndented(f.toJavaSource()));
        this.methods.stream().filter(m -> m.isEnable()).forEach(m -> {
            java.appendLine(Arrays.asList(this.f(this.frame, "")), null);
            java.addIndented(m.toJavaSource());
        });
        this.closingCurly.setFrame(this.frame);
        java.appendLine(Arrays.asList(this.closingCurly), null);
        return java;
    }

    @Override
    public InterfaceFrame createFrame(InteractionManager editor) {
        this.frame = new InterfaceFrame(editor, this.projectResolver, this.packageName, this.imports, this.documentation, this.interfaceName, this.extendsTypes, this.enable);
        this.fields.forEach(member -> this.frame.getfieldsCanvas().insertBlockAfter(member.createFrame(editor), null));
        this.methods.forEach(member -> this.frame.getMethodsCanvas().insertBlockAfter(member.createFrame(editor), null));
        return this.frame;
    }

    public InterfaceFrame createTopLevelFrame(InteractionManager editor) {
        return this.createFrame(editor);
    }

    @Override
    public List<ImportElement> getImports() {
        return Collections.unmodifiableList(this.imports);
    }

    @Override
    public String getName() {
        return this.interfaceName.getContent();
    }

    public List<String> getExtends() {
        return Utility.mapList(this.extendsTypes, StringSlotFragment::getContent);
    }

    public List<? extends CodeElement> getMethods() {
        return this.methods;
    }

    public List<? extends CodeElement> getFields() {
        return this.fields;
    }

    @Override
    public List<CodeElement> childrenUpTo(CodeElement c) {
        ArrayList<CodeElement> joined = new ArrayList<CodeElement>();
        joined.addAll(this.fields);
        joined.addAll(this.methods);
        return joined.subList(0, joined.indexOf(c));
    }

    @Override
    public String getStylePrefix() {
        return "interface-";
    }

    @Override
    public EntityResolver getResolver() {
        return this.getSourceDocument(null).getParser();
    }

    @Override
    public TopLevelFrame getFrame() {
        return this.frame;
    }

    @Override
    public InteractionManager getEditor() {
        return this.frame.getEditor();
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @OnThread(value=Tag.FXPlatform)
    private MoeSyntaxDocument getSourceDocument(ExpressionSlot completing) {
        return this.getDAP(completing).getDocument(this.projectResolver);
    }

    @OnThread(value=Tag.FXPlatform)
    private synchronized DocAndPositions getDAP(ExpressionSlot completing) {
        if (this.sourceDocument == null || this.sourceDocumentCompleting != completing) {
            IdentityHashMap<JavaFragment, Integer> positions = new IdentityHashMap<JavaFragment, Integer>();
            this.sourceDocumentCompleting = completing;
            JavaSource java = this.generateJavaSource();
            String src = java.toMemoryJavaCodeString(positions, completing);
            if (this.documentCache.containsKey(src)) {
                this.sourceDocument = this.documentCache.get(src);
                this.sourceDocument.fragmentPositions.putAll(positions);
            } else {
                this.sourceDocument = new DocAndPositions(src, java, positions);
                this.documentCache.put(src, this.sourceDocument);
            }
        }
        return this.sourceDocument;
    }

    @Override
    public Stream<CodeElement> streamContained() {
        Stream<CodeElement> result = InterfaceElement.streamContained(this.fields);
        return Stream.concat(result, InterfaceElement.streamContained(this.methods));
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.concat(Stream.of(this.interfaceName), this.extendsTypes.stream()).filter(s -> s != null);
    }

    @Override
    public void updateSourcePositions() {
        Platform.runLater(() -> this.getSourceDocument(null));
    }

    @Override
    public List<ConstructorReflective> getSuperConstructors() {
        return Collections.emptyList();
    }

    @Override
    public List<AssistContentThreadSafe> getThisConstructors() {
        return Collections.emptyList();
    }

    @Override
    public Stream<SyntaxCodeError> findEarlyErrors() {
        return this.findEarlyErrors(this.toXML().buildLocationMap());
    }

    private static class DocAndPositions {
        public final JavaSource java;
        public final IdentityHashMap<JavaFragment, Integer> fragmentPositions;
        private String src;
        private MoeSyntaxDocument document;

        public DocAndPositions(String src, JavaSource java, IdentityHashMap<JavaFragment, Integer> fragmentPositions) {
            this.src = src;
            this.java = java;
            this.fragmentPositions = fragmentPositions;
        }

        @OnThread(value=Tag.FXPlatform)
        public MoeSyntaxDocument getDocument(EntityResolver projectResolver) {
            if (this.document == null) {
                this.document = new MoeSyntaxDocument(projectResolver);
                this.document.insertString(0, this.src);
                this.document.enableParser(true);
            }
            return this.document;
        }
    }
}

