/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.debugger.gentype.ConstructorReflective;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.MethodReflective;
import bluej.debugger.gentype.Reflective;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.parser.AssistContent;
import bluej.parser.ExpressionTypeInfo;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.ParsedReflective;
import bluej.parser.nodes.JavaParentNode;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.ParsedTypeNode;
import bluej.stride.framedjava.ast.FrameFragment;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.Parser;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.StringSlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ConstructorElement;
import bluej.stride.framedjava.elements.DocumentContainerCodeElement;
import bluej.stride.framedjava.elements.ImportElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.elements.TopLevelCodeElement;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.ErrorShower;
import bluej.stride.framedjava.errors.SyntaxCodeError;
import bluej.stride.framedjava.frames.ClassFrame;
import bluej.stride.framedjava.frames.ConstructorFrame;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ClassElement
extends DocumentContainerCodeElement
implements TopLevelCodeElement {
    public static final String ELEMENT = "class";
    private final NameDefSlotFragment className;
    private final TypeSlotFragment extendsName;
    private final List<TypeSlotFragment> implementsList;
    private final String packageName;
    private final List<ImportElement> imports;
    private final List<CodeElement> fields;
    private final List<CodeElement> constructors;
    private final List<CodeElement> methods;
    private final EntityResolver projectResolver;
    private boolean abstractModifier = false;
    private JavadocUnit documentation;
    private ClassFrame frame;
    private final FrameFragment openingCurly;
    private final FrameFragment closingCurly;
    private JavaFragment classKeyword;
    private DocAndPositions sourceDocument;
    private ExpressionSlot<?> sourceDocumentCompleting;
    private final HashMap<String, DocAndPositions> documentCache = new HashMap();

    public ClassElement(ClassFrame frame, EntityResolver projectResolver, boolean abstractModifier, NameDefSlotFragment className, TypeSlotFragment extendsName, List<TypeSlotFragment> implementsList, List<? extends CodeElement> fields, List<? extends CodeElement> constructors, List<? extends CodeElement> methods, JavadocUnit documentation, String packageName, List<ImportElement> imports, boolean enabled) {
        this.frame = frame;
        this.openingCurly = new FrameFragment(this.frame, this, "{");
        this.closingCurly = new FrameFragment(this.frame, this, "}");
        this.abstractModifier = abstractModifier;
        this.className = className;
        this.extendsName = extendsName;
        this.documentation = documentation;
        this.packageName = packageName == null ? "" : packageName;
        this.imports = new LinkedList<ImportElement>(imports);
        this.implementsList = new ArrayList<TypeSlotFragment>(implementsList);
        this.fields = new ArrayList<CodeElement>(fields);
        this.fields.forEach(field -> field.setParent(this));
        this.constructors = new ArrayList<CodeElement>(constructors);
        this.constructors.forEach(constructor -> constructor.setParent(this));
        this.methods = new ArrayList<CodeElement>(methods);
        this.methods.forEach(method -> method.setParent(this));
        this.enable = enabled;
        this.documentation = documentation;
        if (this.documentation == null) {
            this.documentation = new JavadocUnit("");
        }
        this.projectResolver = projectResolver;
    }

    public ClassElement(Element el, EntityResolver projectResolver, String packageName) {
        Attribute abstractAttribute = el.getAttribute("abstract");
        this.abstractModifier = abstractAttribute == null ? false : Boolean.valueOf(abstractAttribute.getValue());
        this.className = new NameDefSlotFragment(el.getAttributeValue("name"));
        String extendsAttribute = el.getAttributeValue("extends");
        this.extendsName = extendsAttribute != null ? new TypeSlotFragment(extendsAttribute, el.getAttributeValue("extends-java")) : null;
        this.packageName = packageName;
        Element javadocEL = el.getFirstChildElement("javadoc");
        if (javadocEL != null) {
            this.documentation = new JavadocUnit(javadocEL);
        }
        if (this.documentation == null) {
            this.documentation = new JavadocUnit("");
        }
        this.implementsList = TopLevelCodeElement.xmlToTypeList(el, "implements", "implementstype", "type");
        this.imports = Utility.mapList(TopLevelCodeElement.fillChildrenElements(this, el, "imports"), e -> (ImportElement)e);
        this.fields = TopLevelCodeElement.fillChildrenElements(this, el, "fields");
        this.constructors = TopLevelCodeElement.fillChildrenElements(this, el, "constructors");
        this.methods = TopLevelCodeElement.fillChildrenElements(this, el, "methods");
        this.enable = Boolean.valueOf(el.getAttributeValue("enable"));
        this.projectResolver = projectResolver;
        this.openingCurly = new FrameFragment(null, this, "{");
        this.closingCurly = new FrameFragment(null, this, "}");
    }

    public ClassElement(EntityResolver entityResolver, boolean abstractModifier, String className, String packageName, List<? extends CodeElement> constructors) {
        this(null, entityResolver, abstractModifier, new NameDefSlotFragment(className), null, Collections.emptyList(), Collections.emptyList(), constructors, Collections.emptyList(), null, packageName, Collections.emptyList(), true);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public JavaSource toJavaSource() {
        return this.getDAP(null).java;
    }

    @OnThread(value=Tag.FXPlatform)
    private JavaSource generateJavaSource() {
        ArrayList<JavaFragment> header = new ArrayList<JavaFragment>();
        header.add(new FrameFragment(this.frame, this, "public "));
        if (this.abstractModifier) {
            header.add(this.f(this.frame, "abstract "));
        }
        this.classKeyword = new FrameFragment(this.frame, this, "class ");
        Collections.addAll(header, this.classKeyword, this.className);
        if (this.extendsName != null && !this.extendsName.isEmpty()) {
            Collections.addAll(header, this.space(), this.f(this.frame, "extends"), this.space(), this.extendsName);
        }
        if (!this.implementsList.isEmpty()) {
            header.addAll(Arrays.asList(this.space(), this.f(this.frame, "implements"), this.space()));
            header.addAll((Collection<JavaFragment>)this.implementsList.stream().collect(Utility.intersperse(() -> this.f(null, ", "))));
        }
        JavaSource java = new JavaSource(null, header);
        java.prependJavadoc(this.documentation.getJavaCode());
        java.prependLine(Arrays.asList(this.f(this.frame, "")), null);
        Utility.backwards(CodeElement.toJavaCodes(this.imports)).forEach(imp -> java.prepend((JavaSource)imp));
        java.prependLine(Collections.singletonList(this.f(this.frame, "import lang.stride.*;")), null);
        if (!this.packageName.equals("")) {
            java.prependLine(Arrays.asList(this.f(this.frame, "package " + this.packageName + ";")), null);
        }
        this.openingCurly.setFrame(this.frame);
        java.appendLine(Arrays.asList(this.openingCurly), null);
        this.fields.stream().filter(f -> f.isEnable()).forEach(f -> java.addIndented(f.toJavaSource()));
        this.constructors.stream().filter(c -> c.isEnable()).forEach(c -> {
            java.appendLine(Arrays.asList(this.f(this.frame, "")), null);
            java.addIndented(c.toJavaSource());
        });
        this.methods.stream().filter(m -> m.isEnable()).forEach(m -> {
            java.appendLine(Arrays.asList(this.f(this.frame, "")), null);
            java.addIndented(m.toJavaSource());
        });
        this.closingCurly.setFrame(this.frame);
        java.appendLine(Arrays.asList(this.closingCurly), null);
        return java;
    }

    @Override
    public LocatableElement toXML() {
        LocatableElement classEl = new LocatableElement(this, ELEMENT);
        if (this.abstractModifier) {
            classEl.addAttribute(new Attribute("abstract", String.valueOf(this.abstractModifier)));
        }
        classEl.addAttributeCode("name", this.className);
        if (this.extendsName != null) {
            classEl.addAttributeStructured("extends", this.extendsName);
        }
        this.addEnableAttribute(classEl);
        if (this.documentation != null) {
            classEl.appendChild((Node)this.documentation.toXML());
        }
        this.appendCollection(classEl, this.imports, "imports");
        classEl.appendChild((Node)TopLevelCodeElement.typeListToXML(this.implementsList, "implements", "implementstype", "type"));
        this.appendCollection(classEl, this.fields, "fields");
        this.appendCollection(classEl, this.constructors, "constructors");
        this.appendCollection(classEl, this.methods, "methods");
        classEl.addAttribute(TopLevelCodeElement.getStrideVersionAttribute());
        return classEl;
    }

    private void appendCollection(Element topEl, List<? extends CodeElement> collection, String name) {
        Element collectionEl = new Element(name);
        collection.forEach(element -> collectionEl.appendChild((Node)element.toXML()));
        topEl.appendChild((Node)collectionEl);
    }

    @Override
    public ClassFrame createFrame(InteractionManager editor) {
        this.frame = new ClassFrame(editor, this.projectResolver, this.packageName, this.imports, this.documentation, this.abstractModifier, this.className, this.extendsName, this.implementsList, this.isEnable());
        this.fields.forEach(member -> this.frame.getfieldsCanvas().insertBlockAfter(member.createFrame(editor), null));
        this.constructors.forEach(member -> this.frame.getConstructorsCanvas().insertBlockAfter(member.createFrame(editor), null));
        this.methods.forEach(member -> this.frame.getMethodsCanvas().insertBlockAfter(member.createFrame(editor), null));
        return this.frame;
    }

    public ClassFrame createTopLevelFrame(InteractionManager editor) {
        return this.createFrame(editor);
    }

    @Override
    public String getName() {
        return this.className.getContent();
    }

    @Override
    public List<CodeElement> childrenUpTo(CodeElement c) {
        ArrayList<CodeElement> joined = new ArrayList<CodeElement>();
        joined.addAll(this.fields);
        joined.addAll(this.constructors);
        joined.addAll(this.methods);
        return joined.subList(0, joined.indexOf(c));
    }

    public JavaFragment getNameElement(final ConstructorFrame frame) {
        return new JavaFragment(){

            @Override
            protected String getJavaCode(JavaFragment.Destination dest, ExpressionSlot<?> completing, Parser.DummyNameGenerator dummyNameGenerator) {
                return ClassElement.this.getName();
            }

            @Override
            public ErrorShower getErrorShower() {
                return frame;
            }

            @Override
            protected JavaFragment getCompileErrorRedirect() {
                return null;
            }

            @Override
            public Stream<SyntaxCodeError> findEarlyErrors() {
                return Stream.empty();
            }

            @Override
            public void addError(CodeError codeError) {
                frame.addError(codeError);
            }
        };
    }

    @Override
    public ClassElement getTopLevelElement() {
        return this;
    }

    @Override
    public ClassFrame getFrame() {
        return this.frame;
    }

    public JavaFragment.PosInSourceDoc getPosInsideClass() {
        return this.openingCurly.getPosInSourceDoc(1);
    }

    @Override
    public List<ImportElement> getImports() {
        return Collections.unmodifiableList(this.imports);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public ExpressionTypeInfo getCodeSuggestions(JavaFragment.PosInSourceDoc pos, ExpressionSlot<?> completing) {
        MoeSyntaxDocument doc = this.getSourceDocument(completing);
        Optional<Integer> resolvedPos = this.resolvePos(doc, pos);
        return resolvedPos.map(rpos -> doc.getParser().getExpressionType((int)rpos, this.getSourceDocument(completing))).orElse(null);
    }

    @OnThread(value=Tag.FXPlatform)
    private Optional<Integer> resolvePos(MoeSyntaxDocument doc, JavaFragment.PosInSourceDoc pos) {
        DocAndPositions docAndPositions = this.documentCache.get(doc.getText(0, doc.getLength()));
        Optional<Integer> resolvedPos = Optional.ofNullable(docAndPositions.fragmentPositions.get(pos.getFragment()));
        return resolvedPos.map(p -> p + pos.offset);
    }

    @Override
    public String getStylePrefix() {
        return "class-";
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public EntityResolver getResolver() {
        return this.getSourceDocument(null).getParser();
    }

    @Override
    public InteractionManager getEditor() {
        return this.getFrame().getEditor();
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @OnThread(value=Tag.FXPlatform)
    private MoeSyntaxDocument getSourceDocument(ExpressionSlot completing) {
        return this.getDAP(completing).getDocument(this.projectResolver);
    }

    @OnThread(value=Tag.FXPlatform)
    private synchronized DocAndPositions getDAP(ExpressionSlot completing) {
        if (this.sourceDocument == null || this.sourceDocumentCompleting != completing) {
            IdentityHashMap<JavaFragment, Integer> positions = new IdentityHashMap<JavaFragment, Integer>();
            this.sourceDocumentCompleting = completing;
            JavaSource java = this.generateJavaSource();
            String src = java.toMemoryJavaCodeString(positions, completing);
            if (this.documentCache.containsKey(src)) {
                this.sourceDocument = this.documentCache.get(src);
                this.sourceDocument.fragmentPositions.putAll(positions);
            } else {
                this.sourceDocument = new DocAndPositions(src, java, positions);
                this.documentCache.put(src, this.sourceDocument);
            }
        }
        return this.sourceDocument;
    }

    @Override
    public Stream<CodeElement> streamContained() {
        Stream<CodeElement> result = ClassElement.streamContained(this.fields);
        result = Stream.concat(result, ClassElement.streamContained(this.constructors));
        return Stream.concat(result, ClassElement.streamContained(this.methods));
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.of(this.className, this.extendsName).filter(s -> s != null);
    }

    public Stream<CodeElement> streamMethods() {
        return this.methods.stream();
    }

    @OnThread(value=Tag.FXPlatform)
    public Reflective qualifyType(String name, JavaFragment.PosInSourceDoc pos) {
        JavaParentNode jNode;
        JavaType t;
        MoeSyntaxDocument doc = this.getSourceDocument(null);
        Optional<Integer> rpos = this.resolvePos(doc, pos);
        if (!rpos.isPresent()) {
            return null;
        }
        ParsedNode node = doc.getParser().findNodeAtOrAfter(rpos.get(), 0).getNode();
        if (node instanceof JavaParentNode && (t = (jNode = (JavaParentNode)node).resolvePackageOrClass(name, this.getClassNode()).getType()) instanceof GenTypeClass) {
            return ((GenTypeClass)t).getReflective();
        }
        return null;
    }

    @OnThread(value=Tag.FXPlatform)
    private Reflective getClassNode() {
        MoeSyntaxDocument doc = this.getSourceDocument(null);
        ParsedNode node = doc.getParser().findNodeAtOrAfter(this.resolvePos(doc, this.classKeyword.getPosInSourceDoc()).get(), 0).getNode();
        if (node instanceof ParsedTypeNode) {
            return new ParsedReflective((ParsedTypeNode)node);
        }
        return null;
    }

    @OnThread(value=Tag.FXPlatform)
    public Reflective findSuperMethod(String name, List<String> qualParamTypes) {
        if (this.classKeyword == null) {
            return null;
        }
        String superClass = this.extendsName == null || this.extendsName.getContent().isEmpty() ? "Object" : this.extendsName.getContent();
        this.getSourceDocument(null);
        Reflective qualSuper = this.qualifyType(superClass, this.classKeyword.getPosInSourceDoc());
        while (qualSuper != null) {
            Set<MethodReflective> overloads = qualSuper.getDeclaredMethods().get(name);
            if (overloads != null && overloads.stream().anyMatch(m -> qualParamTypes.equals(Utility.mapList(m.getParamTypes(), t -> t.toString(false))))) {
                return qualSuper;
            }
            qualSuper = qualSuper.getSuperTypesR().stream().filter(r -> !r.isInterface()).findFirst().orElse(null);
        }
        return null;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void updateSourcePositions() {
        this.getSourceDocument(null);
    }

    public boolean isAbstract() {
        return this.abstractModifier;
    }

    public String getExtends() {
        return this.extendsName != null ? this.extendsName.getContent() : null;
    }

    public List<String> getImplements() {
        return Utility.mapList(this.implementsList, StringSlotFragment::getContent);
    }

    public List<? extends CodeElement> getMethods() {
        return this.methods;
    }

    public List<? extends CodeElement> getFields() {
        return this.fields;
    }

    public List<? extends CodeElement> getConstructors() {
        return this.constructors;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<ConstructorReflective> getSuperConstructors() {
        if (this.extendsName == null || this.extendsName.getContent().isEmpty() || this.classKeyword == null) {
            return Collections.emptyList();
        }
        this.getSourceDocument(null);
        Reflective qualSuper = this.qualifyType(this.extendsName.getContent(), this.classKeyword.getPosInSourceDoc());
        if (qualSuper != null) {
            return qualSuper.getDeclaredConstructors();
        }
        return Collections.emptyList();
    }

    @Override
    public List<AssistContentThreadSafe> getThisConstructors() {
        return this.constructors.stream().filter(c -> c instanceof ConstructorElement).map(c -> (ConstructorElement)c).map(c -> {
            List<AssistContent.ParamInfo> paramInfo = Utility.mapList(c.getParams(), p -> new AssistContent.ParamInfo(p.getParamType().getContent(), p.getParamName().getContent(), "", () -> ""));
            return new AssistContentThreadSafe(c.getAccessPermission().asAccess(), this.getName(), c.getDocumentation(), AssistContent.CompletionKind.CONSTRUCTOR, this.getName(), null, paramInfo, null, null, null);
        }).collect(Collectors.toList());
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Stream<SyntaxCodeError> findEarlyErrors() {
        return this.findEarlyErrors(this.toXML().buildLocationMap());
    }

    private static class DocAndPositions {
        public final JavaSource java;
        public final IdentityHashMap<JavaFragment, Integer> fragmentPositions;
        private String src;
        private MoeSyntaxDocument document;

        public DocAndPositions(String src, JavaSource java, IdentityHashMap<JavaFragment, Integer> fragmentPositions) {
            this.src = src;
            this.java = java;
            this.fragmentPositions = fragmentPositions;
        }

        @OnThread(value=Tag.FXPlatform)
        public MoeSyntaxDocument getDocument(EntityResolver projectResolver) {
            if (this.document == null) {
                this.document = new MoeSyntaxDocument(projectResolver);
                this.document.insertString(0, this.src);
                this.document.enableParser(true);
            }
            return this.document;
        }
    }
}

